function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/CopyFileFactory
 */

define(['baja!', 'baja!provisioningNiagara:FileCopyStep,provisioningNiagara:CopyFileFactory', 'lex!provisioningNiagara', 'jquery', 'Promise', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/wb/links/OrdChooser'], function (baja, types, lexs, $, Promise, UxStepFactory, feDialogs, StringEditor, OrdChooser) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];

  /**
   * A 'provisioningNiagara:FileCopyStep' factory implementation
   * @since Niagara 4.14
   * @class
   * @alias module:nmodule/provisioningNiagara/rc/baja/CopyFileFactory
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   */
  return /*#__PURE__*/function (_UxStepFactory) {
    function CopyFileFactory() {
      _classCallCheck(this, CopyFileFactory);
      return _callSuper(this, CopyFileFactory, [{
        module: 'provisioningNiagara',
        lex: 'CopyFileFactory'
      }]);
    }

    /**
     * Resolves to a 'provisioningNiagara:FileCopyStep'
     * @returns {Promise.<baja.Component|undefined>}
     */
    _inherits(CopyFileFactory, _UxStepFactory);
    return _createClass(CopyFileFactory, [{
      key: "makeStep",
      value: function makeStep() {
        var values = {};
        values.isLocalFileCopy = false;
        values.shouldCleanUp = false;
        return this.$makeStep(values);
      }

      /**
       * Edits a 'provisioningNiagara:FileCopyStep' and resolves to a new step value
       * @param {Object} params
       * @param {baja.Component} params.step an instance of 'provisioningNiagara:RemovePlatformUserStep'
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(_ref) {
        var step = _ref.step;
        var values = {
          sourceFileOrd: step.get('sourceFileOrd'),
          destinationDirPathBody: step.get('destinationDirPathBody'),
          isLocalFileCopy: step.get('isLocalFileCopy'),
          shouldCleanUp: step.get('shouldCleanUp')
        };
        return this.$makeStep(values);
      }

      /**
       * Prompts for the username to remove and creates the new step value
       * @private
       * @param {Object} values the values used to create the new steps
       * @param {baja:Ord} values.sourceFileOrd the ord of the file to be copied
       * @param {String} values.destinationDirPathBody the destination directory the file is to be
       * copied to
       * @param {Boolean} values.isLocalCopy is this a local or remote copy
       * @param {Boolean} values.shouldCleanup should the process clean up when done
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "$makeStep",
      value: function $makeStep(values) {
        var _this = this;
        var sourceFileOrd = values.sourceFileOrd,
          destinationDirPathBody = values.destinationDirPathBody,
          isLocalFileCopy = values.isLocalFileCopy,
          shouldCleanUp = values.shouldCleanUp;
        sourceFileOrd = sourceFileOrd || baja.Ord.make();
        var destinationFileName = "";
        var origSource = sourceFileOrd.encodeToString();
        return this.$selectFile(sourceFileOrd).then(function (fileOrd) {
          if (!fileOrd || fileOrd.isNull()) {
            return;
          }
          sourceFileOrd = fileOrd;
          return fileOrd.resolve().then(function (results) {
            var fileObj = results.object;
            var dirPath;
            destinationFileName = fileObj.getFileName();
            if (sourceFileOrd.encodeToString() === origSource) {
              dirPath = destinationDirPathBody;
            } else {
              dirPath = fileObj.getOrdInSession().encodeToString();
              dirPath = dirPath.replace("file:", "");
              dirPath = dirPath.replace(destinationFileName, "");
              dirPath = dirPath.replace(/\/+$/, '');
            }
            return _this.$getDestination(destinationFileName, dirPath).then(function (newDirPath) {
              if (!newDirPath) {
                return;
              }
              destinationDirPathBody = newDirPath.replace(/\/+$/, '');
              var step = baja.$('provisioningNiagara:FileCopyStep');
              step.setFactoryType(baja.$('baja:TypeSpec', 'provisioningNiagara:CopyFileFactory'));
              step.setDestinationDirPathBody(destinationDirPathBody);
              step.setDestinationFileName(destinationFileName);
              step.setIsLocalFileCopy(isLocalFileCopy);
              step.setShouldCleanUp(shouldCleanUp);
              step.setSourceFileOrd(sourceFileOrd);
              return step;
            });
          });
        });
      }

      /**
       * Opens up a dialog to allow the user to select a file
       * @private
       * @param {baja.Ord} sourceFileOrd the starting Ord for the source file
       * @returns {Promise<baja.Ord>}
       */
    }, {
      key: "$selectFile",
      value: function $selectFile(sourceFileOrd) {
        var _this2 = this;
        return feDialogs.showFor({
          title: provisioningNiagaraLex.get('CopyFileFactory.supervisor.title'),
          summary: provisioningNiagaraLex.get('CopyFileFactory.supervisor.dlgText'),
          value: sourceFileOrd,
          type: OrdChooser,
          formFactor: 'compact',
          properties: {
            rootNode: 'file:^',
            hideOrdType: true,
            selectFilter: function selectFilter(selected) {
              return _this2.$selectFilter(selected);
            }
          }
        }).then(function (results) {
          return results;
        });
      }

      /**
       * checks to see if the selected node is the correct type
       * @private
       * @param selected
       * @returns {*}
       */
    }, {
      key: "$selectFilter",
      value: function $selectFilter(selected) {
        if (!selected || selected.isNull()) {
          throw new Error(provisioningNiagaraLex.get('CopyFileFactory.mustSelectFile'));
        }
        return selected.resolve().then(function (selected) {
          if (selected.object.isDirectory()) {
            throw new Error(provisioningNiagaraLex.get('CopyFileFactory.mustSelectFile'));
          }
        });
      }

      /**
       * Prompts the user for a destination path for the file being copied
       * @private
       * @param {String} destinationFileName the file name that is being copied
       * @param {String} destinationDirPathBody the initial value for the destinationDirPathBody
       * @returns {Promise<String>}
       */
    }, {
      key: "$getDestination",
      value: function $getDestination(destinationFileName, destinationDirPathBody) {
        var _this3 = this;
        return feDialogs.showFor({
          title: provisioningNiagaraLex.get('CopyFileFactory.destDir.dlgTitle'),
          summary: provisioningNiagaraLex.get('CopyFileFactory.destDir.dlgMessage', destinationFileName),
          value: destinationDirPathBody,
          formFactor: 'any',
          validate: function validate(pathBody) {
            return _this3.$validateDest(pathBody);
          }
        });
      }

      /**
       * Validates the destinationDirPathBody value
       * @private
       * @param {String} value the current value of the editor
       */
    }, {
      key: "$validateDest",
      value: function $validateDest(value) {
        var firstChr = value.charAt(0);
        if (firstChr !== '^' && firstChr !== "!") {
          throw new Error(provisioningNiagaraLex.get('CopyFileFactory.destDir.error.start'));
        }
        if (value.includes('\\')) {
          throw new Error(provisioningNiagaraLex.get('CopyFileFactory.destDir.error.illegalCharacter', "\\"));
        }
        if (value.includes('//')) {
          throw new Error(provisioningNiagaraLex.get('CopyFileFactory.destDir.error.illegalCharacter', "//"));
        }
      }
    }]);
  }(UxStepFactory);
});
