function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/provisioningNiagara/rc/baja/AbstractTemplateFactory
 */

define(['baja!', 'dialogs', 'jquery', 'Promise', 'lex!provisioningNiagara', 'nmodule/batchJob/rc/baja/UxJobStepFactory', 'nmodule/provisioningNiagara/rc/wb/fe/TemplatePasswordEditor', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/FileInputEditor', 'nmodule/webEditors/rc/wb/links/OrdChooser'], function (baja, dialogs, $, Promise, lexs, UxJobStepFactory, TemplatePasswordEditor, feDialogs, FileInputEditor, OrdChooser) {
  'use strict';

  var Password = require('bajaScript/baja/obj/Password');
  var _lexs = _slicedToArray(lexs, 1),
    provisioningNiagaraLex = _lexs[0];
  var APP_TMPL_TITLE = provisioningNiagaraLex.get('NiagaraNetworkJobBuilder.deployApplicationDialog.title');
  var APP_TMPL_MSG = provisioningNiagaraLex.get('NiagaraNetworkJobBuilder.deployApplicationDialog.message');
  var DEPLOY_TMPL_TITLE = provisioningNiagaraLex.get('NiagaraNetworkJobBuilder.deployTemplateDialog.title');
  var DEPLOY_TMPL_MSG = provisioningNiagaraLex.get('NiagaraNetworkJobBuilder.deployTemplateDialog.message');

  /**
   * Base class for implementing upload or configure templates.
   *
   * @since Niagara 4.14
   * @class
   * @extends module:nmodule/batchJob/rc/baja/UxJobStepFactory
   * @alias module:nmodule/provisioningNiagara/rc/baja/AbstractTemplateFactory
   * @param {Object} [params]
   * @param {String} [params.stepType] the type of step to be created
   * @param {String} [params.factoryType] the factory type of the step
   * @param {Boolean} [params.isApplicationStep] boolean value to check if the step is of type ApplicationStep
   *
   */
  var AbstractTemplateFactory = /*#__PURE__*/function (_UxJobStepFactory) {
    function AbstractTemplateFactory(params) {
      var _this;
      _classCallCheck(this, AbstractTemplateFactory);
      _this = _callSuper(this, AbstractTemplateFactory, [params]);
      _this.$stepType = params.stepType;
      _this.$factoryType = params.factoryType;
      _this.$isApplicationStep = params.isApplicationStep;
      return _this;
    }

    /**
     * @returns {Promise<baja.Component|undefined>}
     */
    _inherits(AbstractTemplateFactory, _UxJobStepFactory);
    return _createClass(AbstractTemplateFactory, [{
      key: "makeStep",
      value: function makeStep(params) {
        return this.$makeStep(params);
      }

      /**
       * @param {Object} params
       * @param {baja.Component} params.step
       * @returns {Promise<baja.Component|undefined>}
       */
    }, {
      key: "editStep",
      value: function editStep(params) {
        return this.$makeStep(params);
      }

      /**
       * Resolves to the step configured
       * @private
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$makeStep",
      value: function $makeStep(_ref) {
        var _this2 = this;
        var step = _ref.step;
        // Select the file
        return this.$selectFile().then(function (fileOrd) {
          if (fileOrd === null) {
            return;
          }
          var password = step && step.getEncodingPassword() || baja.$('baja:Password');
          var isPasswordProtected = step && step.getIsPasswordProtected() || false;
          //Show the password editor
          return _this2.$showPasswordEditor({
            password: password,
            isPasswordProtected: isPasswordProtected
          }).then(function (passwordDetails) {
            if (!passwordDetails) {
              return;
            }
            var password = passwordDetails.password,
              isPasswordProtected = passwordDetails.isPasswordProtected;
            if (_this2.$isApplicationStep) {
              //For application step show the warning
              return _this2.$showWarning().then(function (confirmed) {
                // If the warning is acknowledged by pressing ok create the step
                return confirmed ? _this2.$createStep(fileOrd, password, isPasswordProtected, step) : null;
              });
            } else {
              // if it's not an application template step create the step directly
              return _this2.$createStep(fileOrd, password, isPasswordProtected, step);
            }
          });
        });
      }

      /**
       * Shows warning for application step and returns true for ok and false for cancel
       * @private
       * @returns {Promise.<boolean>}
       */
    }, {
      key: "$showWarning",
      value: function $showWarning() {
        var text = provisioningNiagaraLex.get("DeployApplicationFactory.deployWarning") + "\n\n" + provisioningNiagaraLex.get("DeployApplicationFactory.backupWarning"),
          title = provisioningNiagaraLex.get('DeployApplicationFactory.warningTitle');
        return dialogs.showOkCancel({
          title: title,
          text: text
        }).promise().then(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 2),
            dlg = _ref3[0],
            button = _ref3[1];
          return button === 'ok';
        });
      }

      /**
       * Creates and returns the configured step
       * @private
       * @param {String} fileOrd selected file
       * @param {module:baja/obj/Password} password
       * @param {boolean} isPasswordProtected
       * @param {baja.Component} originalStep
       * @returns {Promise.<baja.Component>}
       */
    }, {
      key: "$createStep",
      value: function $createStep(fileOrd, password, isPasswordProtected, originalStep) {
        var _this3 = this;
        return baja.importTypes([this.$stepType]).then(function () {
          var step = originalStep && originalStep.newCopy() || baja.$(_this3.$stepType);
          step.setIsPasswordProtected(isPasswordProtected);
          if (isPasswordProtected) {
            step.setEncodingPassword(password);
          } else {
            //if isPasswordProtected is set to false, then password should be reset to default
            if (password !== Password.DEFAULT) {
              step.setEncodingPassword(Password.DEFAULT);
            }
          }
          step.setExcelFileOrd(fileOrd);
          step.setFactoryType(baja.$('baja:TypeSpec', _this3.$factoryType));
          return step;
        });
      }

      /**
       * Shows the password editor
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showPasswordEditor",
      value: function $showPasswordEditor(value) {
        var dom = $('<div class="-t-AbstractTemplateFactory-Password-Dialog"></div>');
        return feDialogs.showFor({
          dom: dom,
          title: provisioningNiagaraLex.get('DeployApplicationFactory.dialogTitle'),
          summary: provisioningNiagaraLex.get('DeployApplicationFactory.dialogMessage'),
          value: value,
          type: TemplatePasswordEditor,
          formFactor: 'mini'
        });
      }

      /**
       * @private
       * @return {Promise.<Array>}
       */
    }, {
      key: "$selectFile",
      value: function $selectFile() {
        var isApplicationStep = this.$isApplicationStep;
        var title = isApplicationStep ? APP_TMPL_TITLE : DEPLOY_TMPL_TITLE;
        var message = isApplicationStep ? APP_TMPL_MSG : DEPLOY_TMPL_MSG;
        return feDialogs.showFor({
          title: title,
          summary: message,
          type: OrdChooser,
          formFactor: 'compact',
          value: baja.Ord.make(),
          properties: {
            displayFilter: function displayFilter(parent, child) {
              var navTypeSpec = child.value().getNavTypeSpec();
              if (navTypeSpec === 'baja:FileSystem' || navTypeSpec === 'baja:Directory' || child.value().getNavName().match(/\.(xlsx|xls)$/i)) {
                return true;
              }
            },
            selectFilter: function selectFilter(selected) {
              if (!selected.toString().match(/\.(xlsx|xls)$/i)) {
                throw new Error(provisioningNiagaraLex.get('AbstractTemplateFactory.chooser.errorExcel'));
              }
            },
            rootNode: 'file:^',
            showOrdText: true,
            hideOrdType: true
          }
        });
      }

      /**
       * @returns {Promise.<baja.Icon>}
       */
    }, {
      key: "toIcon",
      value: function toIcon() {
        return Promise.resolve(baja.Icon.make('module://icons/x16/files/ntpl.png'));
      }
    }]);
  }(UxJobStepFactory);
  return AbstractTemplateFactory;
});
