function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/* eslint-disable promise/no-return-wrap,no-undef,promise/catch-or-return,no-cond-assign,no-useless-escape */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by H129264 on 14-Jun-16.
 */
define(['d3', 'jquery', 'underscore', 'Promise', 'baja!', 'bajaux/Widget', 'dialogs', 'moment', 'nmodule/webEditors/rc/fe/baja/util/statusUtils', 'nmodule/webEditors/rc/fe/baja/util/ComplexDiff', 'nmodule/hierarchy/rc/bs/HierarchySpace', 'nmodule/analytics/rc/chart/base/AnalyticTrendRecord', 'nmodule/analytics/rc/report/util/reportConstants', 'niagaraSystemProperties', 'lex!baja,analytics', 'baja!' + 'gx:Color,' + "analytics:Combination," + "analytics:OptionalParam," + 'baja:Status'], function (d3, $, _, Promise, baja, Widget, dialogs, moment, statusUtils, ComplexDiff, HierarchySpace, AnalyticTrendRecord, reportConstants, niagaraSystemProperties, lexs) {
  "use strict";

  /**
   * A set of utility functions for the analytics module.
   * API Status: **Private**
   * @exports nmodule/analytics/rc/util/analyticsUtil
   */
  var analyticsUtil = {},
    logOn = true;
  analyticsUtil.noTrendScheme = ["webAnalyticsRollup:"];
  analyticsUtil.ordSchemeList = ["analyticTrend:", "analytictrend:", "webAnalyticsRollup:", "webanalyticsrollup:", "analyticMultiTrend:", "analyticMultiOrd:", "analyticmultiord:", "analyticmultitrend:", "analyticBaselineTrend:"];
  analyticsUtil.multiNodeTypeList = ["analyticMultiOrd:", "analyticMultiTrend:", "analyticmultiord:", "analyticmultitrend:"];
  analyticsUtil.bajaLex = lexs[0];
  analyticsUtil.twoPowLimit = [1, 2, 4, 8]; // Math.pow(2, 0), Math.pow(2, 1), Math.pow(2, 2)
  analyticsUtil.lex = lexs[1];
  analyticsUtil.hasNoTrendScheme = function (inputOrd) {
    var noTrend = false;
    _.each(analyticsUtil.noTrendScheme, function (trend) {
      if (inputOrd.indexOf(trend) !== -1 || inputOrd.toLowerCase().indexOf(trend.toLowerCase()) !== -1) {
        noTrend = true;
      }
    });
    return noTrend;
  };
  analyticsUtil.returnTrend = function (inputOrd) {
    var outTrend = "analytictrend:";
    _.each(analyticsUtil.ordSchemeList, function (trend) {
      if (inputOrd.indexOf(trend) !== -1) {
        outTrend = trend;
      } else if (inputOrd.toLowerCase().indexOf(trend.toLowerCase()) !== -1) {
        outTrend = trend.toLowerCase();
      }
    });
    return outTrend;
  };

  /**
   *
   * @returns {string[]}
   */
  analyticsUtil.supportedSchemes = function () {
    return {
      "slot": true,
      "hier": true,
      "hierarchy": true
    };
  };

  /**
   * Convert moment to Date
   * @param {moment} m
   * @returns {Date}
   */
  analyticsUtil.getAbsTime = function (m) {
    return baja.AbsTime.make({
      jsDate: m.toDate()
    });
  };

  /**
   * Request an ajax call to the WebChart servlet and use proper error handling.
   * @param {String} uri
   * @param Object [params]
   * @returns {Promise}
   */
  analyticsUtil.ajax = function (uri, params) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      if (!params) {
        params = {};
      }
      if (!params.type) {
        params.type = "GET";
      }
      if (!params.accepts) {
        params.accepts = {
          json: "application/vnd.tridium.webChart-v1+json"
        };
      }
      params.success = function (result, status, jqXHR) {
        resolve(result);
      };
      params.error = function (jqXHR, textStatus, errorThrown) {
        //window.console.log("error1:" + textStatus);
        var errorResult = {};
        errorResult.toString = function () {
          return errorThrown;
        };
        errorResult.textStatus = textStatus;
        errorResult.jqXHR = jqXHR;
        reject(errorResult); //make sure the toString is not just Object
      };
      $.ajax(uri, params);
    });
  };

  /**
   * Returns an URI to the file.
   *
   * @param  {String} ord The ORD used to work out whether
   * this maps to a file or not.
   * @returns {String} the File URI.
   */
  analyticsUtil.getFileUri = function (ord) {
    var path = analyticsUtil.getFilePath(ord);
    return path ? "/file/" + encodeURIComponent(path) : "";
  };

  /**
   *
   * @param comp
   * @param propertyName
   * @param tags
   * @param selected
   */
  analyticsUtil.setEnumChoice = function (comp, propertyName, tags, selected) {
    var dynamicEnum = analyticsUtil.makeRange(tags, selected),
      modified = true;
    if (!comp.has(propertyName)) {
      comp.add({
        slot: propertyName,
        value: dynamicEnum
      });
    } else if (selected !== undefined) {
      if (selected !== analyticsUtil.getChoice(comp, propertyName)) {
        comp.set({
          slot: propertyName,
          value: dynamicEnum
        });
      } else {
        modified = false;
      }
    }
    comp.setFlags({
      slot: propertyName,
      flags: comp.getFlags(propertyName) & ~baja.Flags.HIDDEN
    });
    return modified;
  };

  /**
   * Add or modify integer slot to a component
   * @param {baja.Component} comp Component to add the property to
   * @param {String} propertyName Name of the property to be added or check for if exists
   * @returns {boolean} If the property is modified or added to a component, return true
   */
  analyticsUtil.setIntegerChoice = function (comp, propertyName, currentValue) {
    var intVal = baja.Integer.make(currentValue),
      modified = true;
    if (!comp.has(propertyName)) {
      comp.add({
        slot: propertyName,
        value: intVal
      });
    } else {
      if (currentValue !== comp.get(propertyName)) {
        comp.set({
          slot: propertyName,
          value: intVal
        });
      } else {
        modified = false;
      }
    }
    comp.setFlags({
      slot: propertyName,
      flags: comp.getFlags(propertyName) & ~baja.Flags.HIDDEN
    });
    return modified;
  };

  /**
   * Make a DynamicEnum based on the tags and possible selection given.
   *
   * @param {Array.<String>} tags
   * @param {Number|String} [selection] Default to 0, can be set to a tag or ordinal
   */
  analyticsUtil.makeRange = function (tags, selected) {
    var ordinal = 0,
      i;
    for (i = 0; i < tags.length; i++) {
      tags[i] = baja.SlotPath.escape(tags[i]);
    }
    if (selected) {
      if (typeof selected === "string") {
        ordinal = tags.indexOf(selected);
      } else {
        ordinal = selected;
      }
    }
    return baja.DynamicEnum.make({
      ordinal: ordinal,
      range: baja.EnumRange.make({
        ordinals: analyticsUtil.getUsualOrdinals(tags.length),
        tags: tags
      })
    });
  };
  analyticsUtil.getChoice = function (comp, propertyName, defaultChoice) {
    var value;
    if (comp && comp.has(propertyName)) {
      value = comp.get(propertyName);
      if (value.getType().is("baja:Boolean")) {
        return value;
      }
      if (value.getType().is("baja:Enum")) {
        return value.getTag();
      } else {
        return value;
      }
    }
    return defaultChoice;
  };

  /**
   * A utility function for providing the usual ordinal array for an baja.EnumRange.
   @example
   *   <caption>
    *     Get the usual ordinal array for  3 items
    *   </caption>
    *  var choicesEnum = baja.DynamicEnum.make({
    *           ordinal : 0,
    *           range : baja.EnumRange.make({
    *             tags : ["one", "two", "three"],
    *             ordinals : choiceUtil.getUsualOrdinals(3)
    *           })
    *         });
   *
   * @param length
   * @returns {Array}
   */
  analyticsUtil.getUsualOrdinals = function (length) {
    var ordinals = [];
    for (var i = 0; i < length; i++) {
      ordinals.push(i);
    }
    return ordinals;
  };
  analyticsUtil.setBooleanChoice = function (comp, propertyName, selected) {
    var modified = true;
    if (!comp.has(propertyName)) {
      comp.add({
        slot: propertyName,
        value: !!selected
      });
    } else if (selected !== undefined) {
      if (selected !== analyticsUtil.getChoice(comp, propertyName)) {
        comp.set({
          slot: propertyName,
          value: selected
        });
      } else {
        modified = false;
      }
    }
    comp.setFlags({
      slot: propertyName,
      flags: comp.getFlags(propertyName) & ~baja.Flags.HIDDEN
    });
    return modified;
  };

  /**
   * Set the displayNames for a component. By default, will use the lexicon, but additional displayName entries can be provided via name/DisplayName
   * key pairs that have matching indexes.
   *
   * @param {baja.Component} component
   * @param {Array.<String>} [names]
   * @param {Array.<String>} [displayNames]
   */
  analyticsUtil.setDisplayNames = function (component, names, displayNames) {
    var nameMap = {};
    component.getSlots().each(function (slot) {
      if (names && names.indexOf(String(slot)) > -1) {
        nameMap[slot] = displayNames[names.indexOf(String(slot))];
      } else {
        var displayName = analyticsUtil.lex.get(slot);
        if (displayName) {
          nameMap[slot] = displayName;
        } else {
          nameMap[slot] = baja.SlotPath.unescape(String(slot)); //fallback is to al least escape the text
        }
      }
    });
    if (!component.has('displayNames')) {
      component.add({
        slot: "displayNames",
        flags: baja.Flags.HIDDEN | baja.Flags.READONLY,
        value: baja.NameMap.make(nameMap)
      });
    } else {
      component.set({
        slot: "displayNames",
        value: baja.NameMap.make(nameMap)
      });
    }
  };

  /**
   * Validate a widget and get the complex in case a ComplexDiff is given
   * @param {Widget} widget
   * @return {Promise}
   */
  analyticsUtil.fullValidate = function (widget) {
    return widget.validate().then(function (diff) {
      if (diff instanceof ComplexDiff) {
        var value = widget.value().newCopy();
        return diff.apply(value);
      }
      return diff;
    });
  };

  /**
   * Read a widget and get the complex in case a ComplexDiff is given
   * @param {Widget} widget
   * @return {Promise}
   */
  analyticsUtil.fullRead = function (widget) {
    return widget.read().then(function (diff) {
      if (diff instanceof ComplexDiff) {
        var value = widget.value().newCopy();
        return diff.apply(value);
      }
      return diff;
    });
  };

  /**
   * IsValidName is a carbon copy of java logic in baja:javax.baja.file.FilePath.isValidName()
   * @param {String} name
   * @param {boolean} [isPath]
   * @returns {boolean}
   */
  analyticsUtil.isValidName = function (name, isPath) {
    try {
      var len = name.length,
        i,
        ch;
      if (len === 0) {
        return false;
      }
      for (i = 0; i < len; ++i) {
        ch = name[i];
        if (isPath && ch === '/') {
          continue;
        }
        if (!isName(ch) || ch === ':') {
          return false;
        }
      }
      return true;
    } catch (err) {
      analyticsUtil.log(err);
      return false; // not ascii?
    }
  };

  /**
   * Log a message.
   * @param {String|Error} message
   */
  analyticsUtil.log = function () {
    var message, i;
    if (logOn) {
      for (i = 0; i < arguments.length; i++) {
        message = arguments[i];
        if (message instanceof Error) {
          baja.error(message);
        } else {
          baja.outln(message);
        }
      }
    }
  };

  /**
   * carbon copy of java logic in baja:javax.baja.file.FilePath.isName() except for additional
   * check needed for NCCB-11874: % not supported by FileServlet.
   * @param {String} c
   * @returns {boolean}
   * @private
   */
  function isName(c) {
    var code = c.charCodeAt(0);
    return !(code <= 31 ||
    // control characters
    code === 127 ||
    // del
    // eslint-disable-next-line no-useless-escape
    c === '\"' || c === '\\' || c === '<' || c === '>' || c === '?' || c === '*' || c === '/' || c === '%' ||
    // TODO: NCCB-11874: % not supported by FileServlet
    c === '|');
  }

  /**
   * IsValidPath is the same as isValidName, but it allows "/" to allow the user to enter sub directories.
   * @param name
   * @returns {boolean}
   */
  analyticsUtil.isValidPath = function (path) {
    return analyticsUtil.isValidName(path, true);
  };

  /**
   *
   * @param ord
   * @param requiredPermissionsMask
   * @returns {Promise<U>}
   */
  analyticsUtil.checkPermissions = function (ord, requiredPermissionsMask) {
    var requiredPermissions = baja.Permissions.make(requiredPermissionsMask);
    return analyticsUtil.rpc("type:webChart:WebChartQueryRpc", "getPermissions", ord).then(function (result) {
      var neededPermissions = baja.Permissions.make(result.permissions);
      if (!neededPermissions.has(requiredPermissions)) {
        return Promise.reject(analyticsUtil.lex.get("webChart.PermissionsException", neededPermissions, requiredPermissions));
      }
    });
  };

  /**
   * Request an webChartUtil.rpc and provide additional debug, including when an rpc takes too long
   *
   * @returns {Promise}
   */
  analyticsUtil.rpc = function () {
    if (analyticsUtil.traceOn) {
      return baja.rpc.apply(this, arguments).timeout(10000, "Rpc is taking more than 10 seconds"); //help diagnose problems by adding timeout
    } else {
      return baja.rpc.apply(this, arguments);
    }
  };

  /**
   * Ensure an ord is safe for a hyperlink by double encoding for now (See double decode in OrdTargetFilter.toOrd()
   * @param {String} unsafe hyperlink url
   * @return {String} safe hyperlink for OrdTargetFilter's double decode.
   */
  analyticsUtil.safeOrd = function (unsafeText) {
    return encodeURIComponent(unsafeText);
  };

  /**
   * Safely show text to a user
   * @param {String} unsafe text
   * @return {String} safe text
   */
  analyticsUtil.safe = function (unsafeText) {
    return $('<span>').text(unsafeText).html();
  };

  /**
   * Convert newlines to breaks
   * @param {String} s
   * @returns {String}
   */
  analyticsUtil.nl2br = function (s) {
    return s.replace(/\n/g, "<br/>");
  };

  /**
   * Simulate a user click on the desired jQuery element.
   * @param {jQuery} jq
   */
  analyticsUtil.click = function (jq) {
    var clickEvent = window.document.createEvent("MouseEvent");
    clickEvent.initEvent("click", true, true);
    if (jq.get(0)) {
      jq.get(0).dispatchEvent(clickEvent);
    }
  };

  /**
   * Attempt to create a blob the normal way; fallback to BlobBuilder for Environments like PhantomJs.
   * @param {Object} parts
   * @param {Object} [properties]
   * @returns {Blob}
   */
  analyticsUtil.createBlob = function (parts, properties) {
    parts = parts || [];
    properties = properties || {};
    try {
      return new Blob(parts, properties);
    } catch (e) {
      if (e.name !== "TypeError") {
        throw e;
      }
      var BlobBuilder = window.BlobBuilder || window.MSBlobBuilder || window.MozBlobBuilder || window.WebKitBlobBuilder;
      var builder = new BlobBuilder();
      for (var i = 0; i < parts.length; i++) {
        builder.append(parts[i]);
      }
      return builder.getBlob(properties.type);
    }
  };
  analyticsUtil.confirmServerFileWrite = function (filePath) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      //TODO: always wrap jquery promise in a Real Promis
      Promise.resolve($.ajax(filePath, {
        type: "GET"
      })).then(function fileExists() {
        return dialogs.showYesNo({
          title: analyticsUtil.lex.get("analytics.ExportCommand.overwrite"),
          text: analyticsUtil.lex.get("analytics.ExportCommand.askOverwrite")
        }).promise();
      }, function doesNotExist() {
        // If the file doesn't exist then we're good and
        // we can write the file to the Server.
        //resolve(true);
        return Promise.resolve([this, "yes"]);
      }).spread(function clickedDlg(dlg, id) {
        // If the user has clicked 'yes' then we can create the file
        // on the Server.
        resolve(id === "yes");
      });
    });
  };

  /**
   * Resolve the current title for this widget and whether or not the title is readonly
   * @param {ChartWidget} widget
   * @returns {Promise} which resolves to an Object {title: (String), readonly: (boolean)}
   */
  analyticsUtil.resolveTitleInfo = function (widget) {
    var propertyTitle = widget.properties().getValue("title", ""),
      widgetTitle = widget.title(),
      title = "";

    //title is readonly when specified as a property
    if (propertyTitle) {
      return analyticsUtil.lex.format(propertyTitle).then(function (result) {
        return {
          title: result,
          readonly: true
        };
      });
    }
    if (widgetTitle) {
      title = widgetTitle;
    } else if (widget.model().seriesList().length > 0) {
      title = widget.model().seriesList()[0].displayName();
    }
    return Promise.resolve({
      title: title,
      readonly: false
    });
  };

  /**
   * Return the file path from the ORD string. If the ORD contains no file
   * ORD then an empty string is returned. File Path will include extension.
   * extension stripped from it.
   *
   * @param  {String} ord The ORD used to work out whether
   * this maps to a file or not.
   * @returns {String} the File Path.
   */
  analyticsUtil.getFilePath = function (ord) {
    var queries = baja.Ord.make(ord).parse(),
      i,
      res;
    for (i = 0; i < queries.size(); ++i) {
      if (queries.get(i).getSchemeName() === "file") {
        res = /\^?(.+)$/.exec(queries.get(i).getBody());
        //window.console.log("res[0]" + res)
        return res && res[1] ? res[1] : "";
      }
    }
    return "";
  };

  /**
   * Exports the json in csv format.
   * @param widget
   * @param optionInfo
   * @returns {Array}
   */
  analyticsUtil.formatForCsvExport = function (widget, optionInfo) {
    var arr = [];
    var nodeNameArray = widget.spectrumChartModel.ord.split("|");
    var nodeName = "";
    for (var i = 0; i < nodeNameArray.length; i++) {
      if (nodeNameArray[i].match("^slot")) {
        nodeName = nodeNameArray[i];
        break;
      }
    }
    nodeName = nodeName.substring(nodeName.lastIndexOf("/") + 1, nodeName.length);
    var obj;
    for (var j = 0; j < widget.analyticTrendArray.length; j++) {
      var analyticTrend = widget.analyticTrendArray[j];
      obj = {};
      obj.Timestamp = analyticTrend.date.toLocaleString();
      if (analyticTrend.unitSymbol !== "") {
        obj[nodeName + " (" + analyticTrend.unitSymbol + ")"] = analyticTrend.value;
      } else {
        obj[nodeName] = analyticTrend.value;
      }
      if (optionInfo.has("statusColumn") && optionInfo.get("statusColumn")) {
        obj[nodeName + " (status)"] = analyticTrend.status;
      }
      arr.push(obj);
    }
    return arr;
  };

  /**
   * Will convert the interval to the step on y axis.
   * @param intervalAsString
   * @returns {number}
   */
  analyticsUtil.decodeIntervalForStep = function (intervalAsString) {
    if (intervalAsString === "second") {
      return 0.01;
    } else if (intervalAsString === "fiveSeconds") {
      return 0.05;
    } else if (intervalAsString === "tenSeconds") {
      return 0.10;
    } else if (intervalAsString === "fifteenSeconds") {
      return 0.15;
    } else if (intervalAsString === "thirtySeconds") {
      return 0.3;
    } else if (intervalAsString === "minute") {
      return 1;
    } else if (intervalAsString === "fiveMinutes") {
      return 5;
    } else if (intervalAsString === "tenMinutes") {
      return 10;
    } else if (intervalAsString === "twentyMinutes") {
      return 20;
    } else if (intervalAsString === "fifteenMinutes") {
      return 15;
    } else if (intervalAsString === "thirtyMinutes") {
      return 30;
    } else if (intervalAsString === "hour") {
      return 60;
    } else if (intervalAsString === "twoHours") {
      return 120;
    } else if (intervalAsString === "threeHours") {
      return 180;
    } else if (intervalAsString === "fourHours") {
      return 240;
    } else if (intervalAsString === "sixHours") {
      return 60 * 6;
    } else if (intervalAsString === "twelveHours") {
      return 60 * 12;
    } else if (intervalAsString === "day") {
      return 60 * 24;
    } else if (intervalAsString === "week") {
      return 60 * 24 * 7;
    } else if (intervalAsString === "month") {
      return 60 * 24 * 30;
    } else if (intervalAsString === "quarter") {
      return 60 * 24 * 90;
    } else if (intervalAsString === "year") {
      return 60 * 24 * 365;
    } else if (intervalAsString === "none") {
      return 60;
    }
  };

  /**
   * Extracts the time range from the input string.
   * @param timeRange
   * @returns {{factor: *}}
   */
  analyticsUtil.extractTimeRange = function (timeRange) {
    if (timeRange.match("^from")) {
      return analyticsUtil.extractTimeRangeForFrom(timeRange.split("To")[0], timeRange.split("To")[1]);
    } else if (timeRange.match("^current") || timeRange.match("^previous")) {
      return analyticsUtil.extractTimeRangeForCurrentOrPrevious(timeRange);
    } else if (timeRange.match("%3B")) {
      return analyticsUtil.extractStartAndEndTR(timeRange);
    } else {
      return {
        factor: timeRange
      };
    }
  };

  /**
   * Extracts time range in case of current or previous time range.
   * @param timeRange
   * @returns {{}}
   */
  analyticsUtil.extractTimeRangeForCurrentOrPrevious = function (timeRange) {
    var obj = {},
      periodFactor = timeRange.match(/(minutes|hours|days|weeks|months|years)$/);
    obj.factor = timeRange.match("^current") ? "current" : "previous";
    obj.fromCount = timeRange.match(/\d+/)[0];
    obj.mainFactor = periodFactor ? periodFactor[0].capitalizeFirstLetter() : null;
    return obj;
  };

  /**
   * Retruns the decodedTImeRange
   * @param timeRange
   */
  analyticsUtil.extractTimeRangeForFrom = function (fromPart, toPart) {
    var obj = {};
    if (fromPart.indexOf("-") !== -1) {
      obj.fromOperation = "-";
    } else if (fromPart.indexOf("+") !== -1) {
      obj.fromOperation = "+";
    }
    obj.fromPart = fromPart;
    if (toPart.indexOf("-") !== -1) {
      obj.toOperation = "-";
    } else if (toPart.indexOf("Now") !== -1) {
      obj.toOperation = "Now";
    } else {
      obj.toOperation = "+";
    }
    obj.factor = "from";
    // obj.mainFactor = analyticsUtil.extractMainFactor(fromPart);
    obj.fromCount = analyticsUtil.extractCount(fromPart);
    obj.fromStepFactor = analyticsUtil.extractStepFactor(fromPart);
    if (!obj.fromCount && !obj.fromStepFactor) {
      obj.isMainFactorSelected = false;
    } else {
      obj.isMainFactorSelected = true;
    }
    obj.toCount = analyticsUtil.extractCount(toPart);
    obj.toStepFactor = analyticsUtil.extractStepFactor(toPart);
    return obj;
  };

  /**
   * Extracts the time range in case of start and end time range is provided.
   * @param timeRange
   * @returns {{}}
   */
  analyticsUtil.extractStartAndEndTR = function (timeRange) {
    var obj = {},
      decodedString = decodeURIComponent(timeRange),
      decodedStrArray = decodedString.split(";");
    obj.factor = "startAndEnd";
    obj.startDate = decodedStrArray[0];
    obj.endDate = decodedStrArray[1];
    return obj;
  };

  /**
   * Extracts the main factor of the time range.
   * @param fromString
   * @returns {*}
   */
  analyticsUtil.extractMainFactor = function (fromString) {
    if (fromString.indexOf("Minute") !== -1) {
      return "This Minute";
    } else if (fromString.indexOf("Hour") !== -1) {
      return "This Hour";
    } else if (fromString.indexOf("Day") !== -1) {
      return "Today";
    } else if (fromString.indexOf("Week") !== -1) {
      return "This Week";
    } else if (fromString.indexOf("Month") !== -1) {
      return "This Month";
    } else if (fromString.indexOf("Year") !== -1) {
      return "This Year";
    } else {
      return null;
    }
  };

  /**
   * Extracts the count of time range.
   * @param inputString
   * @returns {*}
   */
  analyticsUtil.extractCount = function (inputString) {
    var match;
    match = (match = inputString.match(/\d+/)) ? match[0] : null;
    if (match === null) {
      return null;
    } else if (match > 7 && match % 7 === 0) {
      return match / 7;
    } else {
      return match;
    }
  };

  /**
   * Extract the step factor of the time range.
   * @param inputString
   * @returns {*}
   */
  analyticsUtil.extractStepFactor = function (inputString) {
    if (inputString.match("PT") && inputString.match("M$")) {
      return "Minutes";
    } else if (inputString.match("H$")) {
      return "Hours";
    } else if (inputString.match("M$")) {
      return "Months";
    } else if (inputString.match("D$")) {
      var match;
      match = (match = inputString.match(/\d+/)) ? match[0] : null;
      if (match > 7 && match % 7 === 0) {
        return "Weeks";
      }
      return "Days";
    } else if (inputString.match("Y$")) {
      return "Years";
    } else {
      return null;
    }
  };

  /**
   * Get the ordinal number by ordinal name.
   * @param inputString
   * @returns {number}
   */
  analyticsUtil.getOrdinal = function (inputString) {
    if (inputString === "from") {
      return 0;
    } else if (inputString === "current") {
      return 1;
    } else if (inputString === "previous") {
      return 2;
    } else if (inputString === "timeRange") {
      return 3;
    } else if (inputString === "weekToDate") {
      return 4;
    } else if (inputString === "monthToDate") {
      return 5;
    } else if (inputString === "yearToDate") {
      return 6;
    } else if (inputString === "today") {
      return 7;
    } else if (inputString === "yesterday") {
      return 8;
    } else if (inputString === "thisWeek") {
      return 9;
    } else if (inputString === "lastWeek") {
      return 10;
    } else if (inputString === "thisMonth") {
      return 11;
    } else if (inputString === "lastMonth") {
      return 12;
    } else if (inputString === "thisYear") {
      return 13;
    } else if (inputString === "lastYear") {
      return 14;
    } else {
      return 15;
    }
  };

  /**
   * Sets the default values to ord.
   * @param data
   * @returns {*}
   */
  analyticsUtil.setDefaultsToOrd = function (data) {
    var ord = data.ord;
    if (ord.indexOf("|analytictrend:") === -1) {
      ord = ord + "|analytictrend:data=n:history";
    }
    if (ord.indexOf("timeRange=") === -1) {
      ord = ord + "&timeRange=" + data.timeRange;
    }
    data.ord = ord;
    return data;
  };

  /**
   * Returns the Base ord which does not contain the scheme or anything to it.
   * @param ordString
   */
  analyticsUtil.getBaseOrd = function (ordString) {
    if (ordString) {
      var removedPrefixes = ordString.substring(ordString.indexOf("slot:"));
      var analTrendArray;
      _.each(analyticsUtil.ordSchemeList, function (eachOrdScheme) {
        if (removedPrefixes.indexOf(eachOrdScheme) !== -1) {
          analTrendArray = removedPrefixes.split("|" + eachOrdScheme);
        }
      });
      if (!analTrendArray) {
        analTrendArray = [removedPrefixes];
      }
      return analTrendArray[0];
    }
    return [];
  };

  /**
   * Returns the node name of the ord.
   * @param ordString
   * @returns {string}
   */
  analyticsUtil.extractSlotInformation = function (ordString) {
    var maxim = baja.Ord.make(ordString).parse();
    var supportedSchemes = analyticsUtil.supportedSchemes();
    for (var i = 0; i < maxim.size(); i++) {
      var scheme = maxim.get(i);
      if (supportedSchemes[scheme.getSchemeName()] !== undefined) {
        var ordStringArray = scheme.getBody().split("/");
        return ordStringArray[ordStringArray.length - 1];
      }
    }
    return "";
  };

  /**
   * Template object used as input for HBS templates
   * TODO: To be moved into different file.
   * @returns {{mainFactor: string[], isMainFactorSelected: boolean, from: {operation: string[], count: number[], stepFactor: string[]}, to: {operation: string[], count: number[], stepFactor: string[]}}}
   * @constructor
   */
  analyticsUtil.getFromOption = function () {
    return {
      mainFactor: ["This Minute", "This Hour", "Today", "This Week", "This Month", "This Year"],
      isMainFactorSelected: true,
      from: {
        operation: ["+", "-"],
        count: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 15, 20, 24, 28, 30, 36, 45, 48, 60, 72, 90, 96, 180, 365],
        stepFactor: ["Minutes", "Hours", "Days", "Weeks", "Months", "Years"]
      },
      to: {
        operation: ["+", "-", "Now"],
        count: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 15, 20, 24, 28, 30, 36, 45, 48, 60, 72, 90, 96, 180, 365],
        stepFactor: ["Minutes", "Hours", "Days", "Weeks", "Months", "Years"]
      }
    };
  };

  /**
   *
   * @returns {{}}
   */
  analyticsUtil.getRollupAggregationEnum = function () {
    var obj = {};
    obj.Aggregation = ["None", "And", "Avg", "Count", "First", "Last", "Max", "Median", "Min", "Mode", "Or", "Range", "Sum"];
    obj.Rollup = ["None", "And", "Avg", "Count", "First", "Last", "Max", "Median", "Min", "Mode", "Or", "Range", "Sum"];
    obj.Interval = ["None", "Second", "Five Seconds", "Ten Seconds", "Fifteen Seconds", "Thirty Seconds", "Mintue", "Five Minutes", "Ten Minutes", "Fifteen Minutes", "Twenty Minutes", "Thirty Minutes", "Hour", "Two Hours", "Three Hours", "Four Hours", "Day"];
    return obj;
  };

  /**
   * Utility method to extract data from inputOrd.
   * @param inputOrd
   * @returns {Object}
   */
  analyticsUtil.extractDataFromOrd = function (inputOrd) {
    var trend = analyticsUtil.returnTrend(inputOrd);
    var stringArray = inputOrd.split(trend),
      myObj = {};
    if (stringArray.length === 2) {
      var attributesArray = stringArray[1].split("&");
      for (var i = 0; i < attributesArray.length; i++) {
        var attrSplitArray = attributesArray[i].split("=");
        myObj[attrSplitArray[0]] = attrSplitArray[1];
      }
      myObj.ord = inputOrd;
    } else {
      myObj.data = "n:history";
      myObj.timeRange = "today";
      myObj.daysToExclude = "DOW0";
      myObj.interval = "hour";
      myObj.ord = inputOrd + "|" + trend + "data=" + myObj.data + "&" + "timeRange=" + myObj.timeRange + "&" + "interval=" + myObj.interval + "&" + "dow=" + myObj.daysToExclude;
    }
    return myObj;
  };

  /**
   * Changes the interval upon change interval event.
   * @param interval
   * @param inputOrd
   * @returns {*}
   */
  analyticsUtil.getReconstructedOrd = function (model) {
    var inputOrd = model.getOrd(),
      delimiter = analyticsUtil.returnTrend(model.getOrd());
    var ordBase = inputOrd.indexOf(delimiter) > 0 ? inputOrd.split(delimiter)[0] : inputOrd;
    ordBase = ordBase.lastIndexOf("|") === ordBase.length - 1 ? ordBase : ordBase + "|";
    inputOrd = ordBase + delimiter;
    var timeRange = model.getTimeRange();
    if (timeRange) {
      inputOrd += "timeRange=" + timeRange;
    }
    var daysToExclude = model.getDaysToExclude();
    if (daysToExclude) {
      inputOrd += "&dow=" + daysToExclude;
    }
    var interval = model.getInterval();
    if (model.isIntervalSelected() && interval !== undefined) {
      inputOrd = inputOrd + "&interval=" + interval;
    }
    var aggregation = model.getAggregation();
    if (model.isAggregationSelected() && aggregation !== undefined) {
      inputOrd = inputOrd + "&aggregation=" + aggregation;
    }
    var rollup = model.getRollup();
    if (model.isRollupSelected() && rollup !== undefined) {
      inputOrd = inputOrd + "&rollup=" + rollup;
    }
    var unit = model.getUnit();
    if (unit && unit !== "null") {
      inputOrd = inputOrd + "&unit=" + unit.getUnitName();
    }
    var data = model.getData();
    if (data !== "") {
      inputOrd = inputOrd + "&data=" + data;
    }
    var dataFilter = model.getDataFilter();
    if (dataFilter !== "") {
      inputOrd = inputOrd + "&dataFilter=" + dataFilter;
    }
    var seriesName = model.getSeriesNameBFormat();
    if (seriesName !== "") {
      inputOrd = inputOrd + "&seriesName=" + seriesName;
    }
    var mdh = model.getMissingDataConfig();
    if (mdh && mdh.enabled) {
      inputOrd = inputOrd + "&aggStrategy=" + mdh.aggStrategy;
      inputOrd = inputOrd + "&intpAlgorithm=" + mdh.intpAlgorithm;
      inputOrd = inputOrd + "&knnValue=" + mdh.knnValue;
    }
    var baseline = model.getBaseline();
    if (baseline && baseline.baselineEnabled) {
      inputOrd = inputOrd + "&baselineTimeRange=" + baseline.baselineStartTime + ";" + baseline.baselineEndTime;
    }
    inputOrd = inputOrd + "&hisTotEnabled=" + !model.getHisTotEnabled();
    return inputOrd;
  };
  /**
   * Updates Baseline startime and endtime on change of Baseline
   * @param baselineData consists of baseline time and value
   * @param chartData  consists of chart time and value
   */
  analyticsUtil.updateWebChartBaselineData = function (baselineData, chartData) {
    var chartStartTime = chartData[0].date.getMillis();
    var chartEndTime = chartData[chartData.length - 1].date.getMillis();
    var baselineStartTime = baselineData[0].date.getMillis();
    for (var i = 0; i < baselineData.length; i++) {
      var millis = baselineData[i].date.getMillis() - baselineStartTime + chartStartTime;
      if (millis > chartEndTime) {
        baselineData.splice(i, baselineData.length - i);
        break;
      }
      baselineData[i].blDate = baselineData[i].date.getJsDate();
      baselineData[i].date = baja.AbsTime.make({
        jsDate: moment(millis).toDate()
      });
    }
  };
  /**
   * Changes the Range upon a changeRange event.
   * @param range
   * @param inputOrd
   * @returns {*}
   */
  analyticsUtil.changeRange = function (range, spectrumChartModel) {
    var inputOrd = spectrumChartModel.ord;
    if (inputOrd.indexOf("timeRange=") !== -1) {
      inputOrd = inputOrd.replace("timeRange=" + spectrumChartModel.timeRange, "timeRange=" + range);
    } else {
      inputOrd = inputOrd + "&timeRange=" + range;
    }
    spectrumChartModel.ord = inputOrd;
    spectrumChartModel.timeRange = range;
    return inputOrd;
  };
  analyticsUtil.parseDate = d3.timeFormat("%d-%b-%Y").parse;
  analyticsUtil.formatDate = d3.timeFormat("%d %b %y");
  analyticsUtil.parseFullDate = d3.timeFormat("%d-%b-%Y %I:%M:%S.%L %p").parse;
  analyticsUtil.formatTime = d3.timeFormat("%H:%M");
  analyticsUtil.formatMinutes = function (d) {
    return analyticsUtil.formatTime(new Date(2012, 0, 1, 0, d));
  };

  /**
   *
   * @param error
   */
  analyticsUtil.showError = function (error) {
    require(['dialogs'], function (dialogs) {
      var title = analyticsUtil.lex.get("analytics.errorTitle"),
        message = analyticsUtil.safe(error);
      message = analyticsUtil.nl2br(message);
      dialogs.showOk({
        title: title,
        content: message
      });
    });
  };

  /**
   * Returns true if node already exists in the model list.
   * @param ord
   * @param chart
   * @returns {boolean}
   */
  analyticsUtil.isNodeExists = function (ord, chart) {
    var ordNode = analyticsUtil.getBaseOrd(ord);
    var status = false;
    status = _.find(chart.getModel(), function (model) {
      if (ordNode === analyticsUtil.getBaseOrd(model.getOrd())) {
        return true;
      }
    });
    return status;
  };

  /**
   *
   * @param optionArray
   * @returns {*}
   */
  analyticsUtil.getCustomFormattedOptions = function (optionArray) {
    _.each(optionArray, function (option) {
      if (option.value <= 3) {
        // option.classList.add('boldFont');
        option.text = option.text + " >";
      }
      return option;
    });
    return optionArray;
  };

  /**
   * Formats the legend for tooltip.
   * @param ord
   * @returns {string}
   */
  analyticsUtil.formatLegendTooltip = function (model) {
    var propObject = analyticsUtil.extractDataFromOrd(model.getOrd());
    delete propObject.uniqueKey;
    propObject.baseOrd = analyticsUtil.getBaseOrd(propObject.ord);
    propObject.seriesNameBFormat = propObject.seriesName;
    propObject.seriesName = model.getSeriesName();
    delete propObject.ord;
    var hoverText = "";
    var propLength = Object.keys(propObject).length;
    Object.keys(propObject).forEach(function (key, index) {
      hoverText = hoverText + key.capitalizeFirstLetter() + ": " + propObject[key];
      if (index !== propLength - 1) {
        hoverText = hoverText + "&#013";
      }
    });
    return hoverText;
  };

  /**
   * Updates the current array to add the tailing time stamps that overflow to next day.
   * @param inputArray
   */
  analyticsUtil.updateByTailingDate = function (inputArray, interval) {
    var myItem,
      localArray = $.extend(true, [], inputArray);
    _.each(localArray, function (item) {
      if (item.totalMins + interval > 1440) {
        myItem = $.extend(true, {}, item);
        myItem.totalMins = -1;
        myItem.overFlowStep = item.totalMins + interval - 1440;
        myItem.date = analyticsUtil.getAbsTime(moment(item.timestamp).add(1, 'days').minutes(0).hours(0));
        myItem.timestamp = d3.timeFormat("%d-%b-%Y").parse(myItem.date.toString().split(" ")[0]);
        analyticsUtil.getAbsTime(moment(myItem.date.getJsDate()));
        inputArray.push(myItem);
      }
    });
  };

  /**
   *
   * @param timeRange
   */
  analyticsUtil.getDefaultInterval = function (model) {
    var timeRange = model.getTimeRange();
    var timeRangeLimits = analyticsUtil.getIntervalForTR(timeRange);
    var duration = timeRangeLimits.duration;
    // if (duration > analyticsUtil.MILLIS_YEAR) {
    //   return 365 * 24 * 60 * 60 * 1000;
    // }
    // if (duration >= analyticsUtil.MILLIS_YEAR / 2) {
    //   return 30 * 24 * 60 * 60 * 1000;
    // }
    // if (duration >= analyticsUtil.MILLIS_MONTH) {
    //   return 24 * 60 * 60 * 1000;
    // }
    // if (duration >= analyticsUtil.MILLIS_WEEK || duration >= analyticsUtil.MILLIS_WEEK/3) {
    //   return 6 * 60 * 60 * 1000;
    // }
    // if (duration >= analyticsUtil.MILLIS_DAY) {
    //   return 15 * 60 * 1000;
    // }
    // if (duration >= analyticsUtil.MILLIS_TWELVE_HOURS) {
    //   return 5 * 60 * 1000;
    // }

    if (duration) {
      return duration;
    }
    return 60 * 1000;
  };

  /**
   *
   * @param timeRange
   * @returns {number}
   */
  analyticsUtil.getIntervalForTR = function (timeRange) {
    var curDateTime = moment();
    var startTime, endTime, duration;
    endTime = curDateTime;
    var tr = analyticsUtil.extractTimeRange(timeRange);
    var count = tr.fromCount || 1,
      mainFactor = tr.mainFactor;
    var factor = tr.factor;
    if (factor === "today") {
      startTime = moment(new Date(curDateTime.year(), curDateTime.month(), curDateTime.date()));
      endTime = curDateTime;
      duration = 15 * 60 * 1000;
    } else if (factor === "yesterday") {
      startTime = moment(new Date(curDateTime.year(), curDateTime.month(), curDateTime.date() - 1));
      endTime = moment(startTime);
      duration = 15 * 60 * 1000;
    } else if (factor === "monthToDate") {
      startTime = moment(new Date(curDateTime.year(), curDateTime.month(), 1));
      endTime = curDateTime;
      duration = 6 * 60 * 60 * 1000;
    } else if (factor === "thisMonth") {
      startTime = moment(new Date(curDateTime.year(), curDateTime.month(), 1));
      endTime = moment(new Date(curDateTime.year(), curDateTime.month() + 1, 1));
      duration = 24 * 60 * 60 * 1000;
    } else if (factor === "lastMonth") {
      startTime = moment(new Date(curDateTime.year(), curDateTime.month() - 1, 1));
      endTime = moment(new Date(curDateTime.year(), curDateTime.month(), 0));
      duration = 24 * 60 * 60 * 1000;
    } else if (factor === "thisYear") {
      startTime = moment(new Date(curDateTime.year(), 0, 1));
      endTime = curDateTime;
      duration = 30 * 24 * 60 * 60 * 1000;
    } else if (factor === "lastYear") {
      startTime = moment(new Date(curDateTime.year() - 1, 0, 1));
      endTime = moment(new Date(curDateTime.year() - 1, 11, 30));
      duration = 30 * 24 * 60 * 60 * 1000;
    } else if (factor === "all") {
      startTime = moment(new Date(2000, 1, 1));
      endTime = curDateTime;
      duration = 365 * 24 * 60 * 60 * 1000;
    } else if (factor === "lastWeek") {
      endTime = curDateTime.startOf("week");
      startTime = moment(endTime).subtract(1, "weeks");
      duration = 6 * 60 * 60 * 1000;
    } else if (factor === "thisWeek") {
      endTime = curDateTime;
      startTime = moment(endTime).startOf("week");
      duration = 6 * 60 * 60 * 1000;
    } else if (factor === "weekToDate") {
      endTime = curDateTime;
      startTime = moment(endTime).startOf("week");
      duration = 15 * 60 * 1000;
    } else if (factor === "yearToDate") {
      startTime = moment(new Date(curDateTime.year(), 0, 1));
      endTime = curDateTime;
      duration = 24 * 60 * 60 * 1000;
    } else if (factor === "current") {
      if (mainFactor === "years") {
        startTime = moment(new Date(curDateTime.year() - count, 0, 1));
      } else if (mainFactor === "hours") {
        startTime = moment(curDateTime);
        startTime = startTime.subtract(count, "hours");
      } else if (mainFactor === "days") {
        startTime = moment(curDateTime);
        startTime = startTime.subtract(count, "days");
      } else if (mainFactor === "weeks") {
        startTime = moment(curDateTime);
        startTime = startTime.subtract(count, "weeks");
      } else if (mainFactor === "months") {
        startTime = moment(curDateTime);
        startTime = startTime.subtract(count, "months");
      } else if (mainFactor === "minutes") {
        startTime = moment(curDateTime);
        startTime = startTime.subtract(count, "minutes");
      }
      endTime = curDateTime;
      duration = 6 * 60 * 60 * 1000;
    } else if (factor === "previous") {
      if (mainFactor === "years") {
        endTime = moment(new Date(curDateTime.year() - 1, 0, 1));
        startTime = moment(new Date(endTime.year() - count, 0, 1));
      } else if (mainFactor === "hours") {
        endTime = moment(curDateTime);
        endTime = endTime.subtract(1, "hours");
        startTime = moment(endTime).subtract(count, "hours");
      } else if (mainFactor === "days") {
        endTime = moment(curDateTime);
        endTime = endTime.subtract(1, "days");
        startTime = moment(endTime).subtract(count, "days");
      } else if (mainFactor === "weeks") {
        endTime = moment(curDateTime);
        endTime = endTime.subtract(1, "weeks");
        startTime = moment(endTime).subtract(count, "weeks");
      } else if (mainFactor === "months") {
        endTime = moment(curDateTime);
        endTime = endTime.subtract(1, "months");
        startTime = moment(endTime).subtract(count, "months");
      } else if (mainFactor === "minutes") {
        endTime = moment(curDateTime);
        endTime = endTime.subtract(1, "minutes");
        startTime = moment(endTime).subtract(count, "minutes");
      }
      duration = 6 * 60 * 60 * 1000;
    } else if (factor === "from") {
      startTime = moment(curDateTime);
      endTime = moment(curDateTime);
      if (tr.fromPart.startsWith("fromYear")) {
        startTime = startTime.startOf("year");
      } else if (tr.fromPart.startsWith("fromHour")) {
        startTime = startTime.startOf("hour");
      } else if (tr.fromPart.startsWith("fromDay")) {
        startTime = startTime.startOf("day");
      } else if (tr.fromPart.startsWith("fromWeek")) {
        startTime = startTime.startOf("week");
      } else if (tr.fromPart.startsWith("fromMonth")) {
        startTime = startTime.startOf("month");
      } else if (tr.fromPart.startsWith("fromMinute")) {
        startTime = startTime.startOf("minute");
      }
      if (tr.isMainFactorSelected) {
        if (tr.fromOperation === "+") {
          startTime = startTime.add(parseInt(tr.fromCount), tr.fromStepFactor.toString());
        } else if (tr.fromOperation === "-") {
          startTime = startTime.subtract(parseInt(tr.fromCount), tr.fromStepFactor.toString());
        }
      }
      if (tr.toOperation === "+") {
        endTime = endTime.add(parseInt(tr.toCount), tr.toStepFactor.toString());
      } else if (tr.fromOperation === "-") {
        endTime = endTime.subtract(parseInt(tr.toCount), tr.toStepFactor.toString());
      }
      duration = 6 * 60 * 60 * 1000;
    } else if (factor === "startAndEnd") {
      startTime = moment(tr.startDate);
      endTime = moment(tr.endDate);
      duration = 6 * 60 * 60 * 1000;
    }
    switch (timeRange) {
      case "lastMonth":
      case "lastYear":
      case "yesterday":
      case "today":
      case "thisWeek":
        endTime = endTime.add(1, "days").hours(0).minutes(0).seconds(0).milliseconds(0);
        break;
      default:
        break;
    }
    return {
      endTime: endTime,
      startTime: startTime,
      duration: duration
    };
  };
  analyticsUtil.getRndIntervalFrmAllSeries = function (series, baseChart) {
    var barWidth = 0,
      MIN_BAR_WIDTH = 1;
    _.each(series, function (ser) {
      if (ser.data[0] && ser.data[1]) {
        var maxX = ser.data[1].x ? ser.data[1].x : moment(ser.data[0].x).add(baseChart.getRenderInterval(), "ms").toDate();
        barWidth = baseChart.xScale(maxX) - baseChart.xScale(ser.data[0].x);
        barWidth = barWidth < MIN_BAR_WIDTH ? MIN_BAR_WIDTH : barWidth;
        return false;
      }
    });
    return barWidth;
  };
  analyticsUtil.getFirstTimeStampOfSeries = function (series) {
    var firstTimeStamp;
    _.each(series, function (ser) {
      if (ser.data[0]) {
        firstTimeStamp = ser.data[0].x;
        return false;
      }
    });
    return firstTimeStamp;
  };

  /**
   * This method will return the series X's min and max.
   * @param series
   */
  analyticsUtil.getXMinMax = function (series) {
    var value = analyticsUtil.getFirstTimeStampOfSeries(series),
      min = value,
      max = value;
    series.map(function (serData) {
      var extent = d3.extent(serData.data, function (e) {
        return e.x;
      });
      min = d3.min([extent[0], min]);
      max = d3.max([extent[1], max]);
    });
    return {
      "min": min,
      "max": max
    };
  };

  /**
   *
   * @param hours
   * @param minutes
   */
  analyticsUtil.formatHHMM = function (hours, minutes, lexKey) {
    var hoursPart = hours < 10 ? "0" + hours : hours;
    var minutesPart = minutes < 10 ? "0" + minutes : minutes;
    return analyticsUtil.lex.get({
      key: lexKey,
      args: [hoursPart, minutesPart]
    });
  };

  /**
   *
   * @param hours
   * @param minutes
   */
  analyticsUtil.formatHHMMSS = function (hours, minutes, seconds) {
    var hoursPart = hours < 10 ? "0" + hours : hours;
    var minutesPart = minutes < 10 ? "0" + minutes : minutes;
    var secondsPart = seconds < 10 ? "0" + seconds : seconds;
    return analyticsUtil.lex.get({
      key: "chart.avgprofile.xaxis.fmt.sec",
      args: [hoursPart, minutesPart, secondsPart]
    });
  };

  /**
   *
   * @param d
   * @returns {string}
   */
  analyticsUtil.formatAsHoursAndMinutes = function (d) {
    var totalHoursWithMins = d.getTime() / 3600000;
    var hrs = Math.floor(totalHoursWithMins);
    return hrs + "h" + " " + (Math.floor(60 * (totalHoursWithMins - hrs)) + "m");
  };

  /**
   *
   * @param d
   * @returns {string}
   */
  analyticsUtil.formatMillisForRuntime = function (millis) {
    var totalSecs = millis / 1000,
      totalMins = totalSecs / 60,
      hrs = Math.floor(totalMins / 60),
      mins = Math.floor(totalMins % 60),
      secs = Math.floor(totalSecs % 60),
      disp = analyticsUtil.lex.get({
        key: "chart.format.hourminsec",
        args: [hrs, mins, secs]
      });
    return disp;
  };

  /**
   * Method will filter column names and keys if the interpolation status is enabled or disabled.
   * @param table
   * @return {{columnNames: string[], columnKey: string[]}}
   */
  analyticsUtil.filterInterpolationStatus = function (table) {
    var alien = table.alien,
      seriesAnalogy = alien.getSeriesAnalogy(),
      columnNames = seriesAnalogy.columnNames,
      columnKeys = seriesAnalogy.columnKeys,
      exclusionList = table.getTabConfigDataModel().getExclusionList();
    if (!table.showInterpolationStatus) {
      seriesAnalogy.columnNames = _.filter(columnNames, function (colName) {
        var flag = true;
        _.each(exclusionList, function (excl) {
          flag = colName.indexOf(excl) === -1;
          if (!flag) {
            return false;
          }
        });
        return flag;
      });
      seriesAnalogy.columnKeys = _.filter(columnKeys, function (v) {
        return v.indexOf("interpolationStatus") === -1;
      });
    }
    return seriesAnalogy;
  };

  /**
   * Method gets executed for Report data Exchange with Table.
   * @param table
   * @returns {{columns: Array, rows: Array, allColumns: Array}}
   */
  analyticsUtil.understandData = function (table) {
    var returnObj = {
        columns: [],
        rows: [],
        allColumns: []
      },
      alien = setUnitForValue(table.alien),
      alienSeries = alien.series,
      seriesAnalogy = analyticsUtil.filterInterpolationStatus(table),
      columnNames = seriesAnalogy.columnNames,
      columnKeys = seriesAnalogy.columnKeys,
      colorCodedColKeys = alien.getColorCodedColKeys(),
      tableFormatterFunction = alien.getFormattedTooltipValue;
    returnObj.columns.push.apply(returnObj.columns, columnNames);
    returnObj.allColumns = returnObj.columns;

    // Break the series data.
    _.each(alienSeries, function (series, index) {
      if (alien.needsBreakOnOneIteration() && index !== 0) {
        return false;
      } // A very crude fix temporary. Will be addressed while refactoring
      _.each(series[alien.getTableDataStructure()], function (dat) {
        var curArray = [];
        _.each(columnKeys, function (key) {
          var inData;
          if (key.indexOf(".") === -1) {
            inData = dat[key];
          } else {
            var keySplit = key.split(".");
            inData = dat[keySplit[0]][keySplit[1]];
          }
          // Timestamp column is not a number type, d3 formatting wouldn't work, so check for number.
          var inValue = _.isNumber(inData) ? tableFormatterFunction(inData) : inData;
          // Every chart has it's own color coded keys, if passing key is color coded then below logic.
          if (_.contains(colorCodedColKeys, key)) {
            // Used the dat[key], raw value to get the color applied for Spectrum Chart.
            // series.color works for Ranking & alien.zScale works for Spectrum Chart.
            var color = series.color !== undefined ? series.color : alien.zScale ? alien.zScale(inData) : undefined;
            curArray.push(inValue ? JSON.stringify({
              value: inValue,
              color: color
            }) : "-");
          } else {
            curArray.push(inValue || "-");
          }
        });
        returnObj.rows.push(curArray);
      });
    });
    return returnObj;
  };

  /**
   * Sets the Unit text for the Value Column Header.
   * @param alien
   * @returns {*}
   */
  function setUnitForValue(alien) {
    var modelArr = alien.getModel(),
      unit;
    _.each(modelArr, function (model) {
      if (model) {
        unit = model.getUnitDisplay();
        if (unit !== undefined) {
          return false;
        }
      }
    });
    alien.setColumnNames(setUnitForValueColumn(alien.getColumnNames(), unit));
    return alien;
  }
  function setUnitForValueColumn(colKeys, unit) {
    colKeys = _.map(colKeys, function (key) {
      if (key.toLowerCase().indexOf("value") !== -1 && unit) {
        key += "(" + unit + ")";
      }
      return key;
    });
    return colKeys;
  }

  /**
   * Check whether BaselineFlag Enabled and BaselineData Available
   * @param model
   * @returns {*|boolean}
   */
  function hasBaseline(model) {
    var isEnabled = model && model.getBaseline() && model.getBaseline().baselineEnabled,
      hasData = model.getAnalyticChartBaselineTrendArray().length > 0;
    return isEnabled && hasData;
  }
  function groupByTimeStamp(data) {
    var seriesNameArray = [],
      mergedObject = [];
    _.each(data, function (dat, index) {
      seriesNameArray.push({
        seriesName: dat.getSeriesName(),
        unit: dat.getUnit().toString()
      });
      _.map(dat.getAnalyticTrendArray(), function (trend) {
        trend.seriesName = dat.getSeriesName();
      });
      var analyticTrendArray = dat.getAnalyticTrendArray();
      // Merge the analytic baseline trend array with trend array series
      if (hasBaseline(dat)) {
        var baselineTrendArray = _.sortBy(dat.getAnalyticChartBaselineTrendArray(), 'timestamp');
        _.each(analyticTrendArray, function (obj, index) {
          var baselineValues = baselineTrendArray[index];
          if (baselineValues) {
            obj.baselineTimestamp = moment(baselineValues.timestamp).format(baja.getTimeFormatPattern());
            obj.baselineStatus = baselineValues.status;
            obj.baselineValue = baselineValues.value;
            obj.baselineIntpStatus = baselineValues.interpolationStatus;
          }
        });
      }
      mergedObject.push.apply(mergedObject, analyticTrendArray);
    });
    seriesNameArray = _.sortBy(seriesNameArray, "seriesName");
    mergedObject = _.groupBy(mergedObject, function (trend) {
      return trend.timestamp;
    });
    return {
      mergedObject: mergedObject,
      seriesNameArray: seriesNameArray
    };
  }

  /**
   * Returns rows to export csv
   * @param mergedObject
   * @param seriesNameArray
   * @param templateKeys
   * @param exclKeys
   * @returns {string[][]}
   */
  function makeRows(mergedObject, seriesNameArray, templateKeys, exclKeys) {
    var rows = [];
    var keys = _.keys(mergedObject);
    var enterOnce = true;
    if (_.contains(exclKeys, 'status')) {
      exclKeys.push('baselineStatus');
    }
    _.each(keys, function (key) {
      var values = mergedObject[key];
      if (values.length !== seriesNameArray.length) {
        var interimArray = [];
        _.each(values, function (val) {
          interimArray.push(val.seriesName);
        });
        _.each(seriesNameArray, function (ser) {
          if (!interimArray.contains(ser.seriesName)) {
            var interimTrend = new AnalyticTrendRecord();
            interimTrend.seriesName = ser.seriesName;
            delete interimTrend.date;
            values.push(interimTrend);
          }
        });
      }
      values = _.sortBy(values, 'seriesName');
      if (enterOnce) {
        var tempkeys = [];
        _.each(values, function (val) {
          tempkeys = _.difference(_.keys(val), exclKeys);
          tempkeys = _toConsumableArray(tempkeys);
          enterOnce = false;
          templateKeys.push(tempkeys);
        });
      }
      var inRow = [moment(key).format(baja.getTimeFormatPattern())];
      _.each(values, function (val, index) {
        var seriesTempKey = templateKeys[index];
        _.each(seriesTempKey, function (tempKey) {
          inRow.push(val[tempKey] !== undefined ? val[tempKey] : "-");
        });
      });
      mergedObject[key] = values;
      rows.push(inRow);
    });
    return rows;
  }

  /**
   * Return list of columns to export data to csv
   * @param seriesNameArray
   * @param templateKeys
   * @returns {{columns: string[], allColumns: string[]}}
   */
  function makeColumns(seriesNameArray, templateKeys) {
    var columns = ['Timestamp'];
    _.each(seriesNameArray, function (ser, index) {
      var seriesTempKey = templateKeys[index];
      _.each(seriesTempKey, function (tKey) {
        columns.push(ser.seriesName.capitalizeFirstLetter() + " " + (tKey.indexOf("status") !== -1 || tKey.indexOf("interpolationStatus") !== -1 || tKey.indexOf("baselineStatus") !== -1 || tKey.indexOf("baselineIntpStatus") !== -1 ? tKey.capitalizeFirstLetter() : tKey.capitalizeFirstLetter() + (ser.unit !== "null" ? " (" + ser.unit + ")" : "")));
      });
    });
    var columnsBeforeStrip = [];
    columnsBeforeStrip.push.apply(columnsBeforeStrip, columns);
    return {
      columns: columns,
      allColumns: columnsBeforeStrip
    };
  }
  function filterExclusions(exclusionList, columns, rows) {
    var rejIndexes = [];
    columns = _.reject(columns, function (col, index) {
      if (exclusionList.contains(col)) {
        rejIndexes.push(index);
        return true;
      }
      return false;
    });

    // Indices will be available in ascending order, We will splice from last index.
    rejIndexes.sort(function (a, b) {
      return b - a;
    });
    rows = _.map(rows, function (row) {
      _.each(rejIndexes, function (indice) {
        row.splice(indice, 1);
      });
      return row;
    });
    return {
      rows: rows,
      columns: columns
    };
  }
  analyticsUtil.getMultiOrdTableData = function (table, exclKeys) {
    var exclusionList = table.getTabConfigDataModel().getExclusionList();
    exclusionList = _.isArray(exclusionList) ? exclusionList : exclusionList.split(",");
    var data = table.chartModelList,
      groupedObj = groupByTimeStamp(data),
      mergedObject = groupedObj.mergedObject,
      seriesNameArray = groupedObj.seriesNameArray,
      templateKeys = [],
      rows = makeRows(mergedObject, seriesNameArray, templateKeys, exclKeys),
      returnObj = makeColumns(seriesNameArray, templateKeys),
      returnObjAfterExclusion = filterExclusions(exclusionList, returnObj.columns, rows);
    return {
      columns: returnObjAfterExclusion.columns,
      rows: returnObjAfterExclusion.rows,
      allColumns: returnObj.allColumns
    };
  };
  analyticsUtil.getMultiNodeOrdTableData = function (table) {
    var data = table.chartModelList;
    var exclusionList = table.getTabConfigDataModel().getExclusionList();
    exclusionList = _.isArray(exclusionList) ? exclusionList : exclusionList.split(",");
    var cols = [];
    var rowz = [];
    var keyz;
    var rows = function () {
      var rowArray = [];
      _.each(data, function (dat, index) {
        _.each(dat.getAnalyticTrendArray(), function (trend, index) {
          if (index === 0) {
            keyz = Object.keys(trend).sort();
            var ts;
            if ((keyz.contains("timestamp") ? ts = "timestamp" : false) || (keyz.contains("Timestamp") ? ts = "Timestamp" : false)) {
              keyz = _.without(keyz, ts);
              keyz = [ts].concat(keyz);
            }
            cols.push.apply(cols, keyz);
          }
          var ob = {};
          _.each(keyz, function (k, index) {
            ob[k] = trend[k];
          });
          rowz.push(ob);
        });
        dat.setAnalyticTrendArray(rowz);
        rowArray.push.apply(rowArray, rowz);
      });
      return rowArray;
    }();
    var returnObjAfterExclusion = filterExclusions(exclusionList, cols, rows);
    return {
      columns: returnObjAfterExclusion.columns,
      rows: returnObjAfterExclusion.rows,
      allColumns: cols
    };
  };
  analyticsUtil.getRenderableAlienData = function (table) {
    var alien = table.alien;
    var alienName = alien.getName();
    if (alienName === "SpectrumChart") {
      // return analyticsUtil.getRenderableTableData(table);
    }
    var alienSeries = alien.series;
    var tableModelList = alien.getModel();
    var returnObj = {
      columns: [],
      rows: [],
      allColumns: []
    };
    // eslint-disable-next-line no-unused-vars
    var exclusionList = table.getTabConfigDataModel().getExclusionList();
    // eslint-disable-next-line no-unused-vars
    exclusionList = _.isArray(exclusionList) ? exclusionList : exclusionList.split(",");
    var enterOnlyOnce = true;
    var conversionUtil = function conversionUtil(obj) {
      if (alienName === "AverageProfileChart" || alienName === "LoadDurationChart") {
        obj = analyticsUtil.formatAsHoursAndMinutes(new Date(obj));
      }
      return obj;
    };
    var tobeanalyzed = [];
    _.each(alienSeries, function (series, outerIndex) {
      _.each(series.data, function (data) {
        data.name = series.name;
        return data;
      });
      tobeanalyzed.push.apply(tobeanalyzed, series.data);
      if (enterOnlyOnce && !["RankingChart", "RelativeContributionChart"].contains(alienName)) {
        returnObj.columns.push("Date");
        enterOnlyOnce = false;
      }
      returnObj.columns.push(tableModelList[outerIndex].getSeriesName());
    });
    if (["RankingChart", "RelativeContributionChart"].contains(alienName)) {
      var curArr = [];
      _.each(tobeanalyzed, function (data) {
        curArr.push(data.y === undefined ? "-" : data.y);
      });
      returnObj.rows.push(curArr);
    } else {
      tobeanalyzed = _.groupBy(tobeanalyzed, function (data) {
        return data.x;
      });
      _.each(tobeanalyzed, function (data) {
        var curArr = [],
          enter1 = true;
        _.each(data, function (cur) {
          if (enter1) {
            curArr.push(conversionUtil(new Date(cur.x)));
            enter1 = false;
          }
          curArr.push(cur.y === undefined ? "-" : cur.y);
        });
        returnObj.rows.push(curArr);
      });
    }
    return returnObj;
  };
  analyticsUtil.lineChartToolTipHelper = function (minObj, title, xValText, yValText, series) {
    var yList = "";
    var bisectX = d3.bisector(function (d) {
      return d.x;
    }).left;
    var dData = minObj.data;
    yList += title;
    yList += xValText;
    series.map(function (d) {
      var showToolTip = function showToolTip(y) {
        var seriesName = baja.SlotPath.unescape(d.name) || "",
          unit = d.unitSymbol;
        unit = unit !== "null" ? unit : "";
        var marker = "<div class='tooltip-marker'" + " style='background: " + d.color + "'></div>";
        yList += "<div>" + marker + yValText(seriesName, y, unit) + "</div>";
      };
      var cIndex = bisectX(d.data, dData, 0);
      if (cIndex < d.data.length && d.data[cIndex].x === dData) {
        showToolTip(d.data[cIndex][d.name] || d.data[cIndex].y);
      }
    });
    return yList;
  };
  analyticsUtil.formatDataAsColsAndRows = function (parent, exclKeys) {
    var templateKeys = [],
      data = parent.dataModel,
      grpedObject = groupByTimeStamp(data),
      mergedObject = grpedObject.mergedObject,
      seriesNameArray = grpedObject.seriesNameArray,
      rows = makeRows(mergedObject, seriesNameArray, templateKeys, exclKeys),
      returnObj = makeColumns(seriesNameArray, templateKeys);
    return {
      rows: rows,
      columns: returnObj.columns
    };
  };

  /**
   *
   * @param configModel
   * @param cmdBar
   * @returns {*}
   */
  analyticsUtil.buildConfiguration = function (configModel, cmdBar) {
    var configModelType = configModel.getType().toString();
    if (configModelType === "analytics:AnalyticsTabConfigBaseModel" || configModelType === "analytics:AnalyticsTabConfigEqOpModel" || configModelType === "analytics:AnalyticsTableConfigModel" || configModelType === "analytics:AnalyticsC3TabConfigModel") {
      configModel.setFontSize(cmdBar.fontSize);
      if (configModelType === "analytics:AnalyticsTabConfigEqOpModel") {
        configModel.setOffStatus(cmdBar.exportModel.configModel.getOffStatus());
      } else if (configModelType === "analytics:AnalyticsTableConfigModel") {
        configModel.setExclusionList(cmdBar.exportModel.configModel.getExclusionList());
        configModel.setColumnList(cmdBar.exportModel.configModel.getColumnList());
      } else if (configModelType === "analytics:AnalyticsC3TabConfigModel") {
        configModel.setLegendPosition(baja.$("analytics:C3LegendType").make(cmdBar.exportModel.configModel.getLegendPosition()));
      }
    }
    return configModel;
  };

  /**
   *
   * @param model
   * @param settings
   * @returns {*}
   */
  analyticsUtil.buildSettings = function (model, settings) {
    var optionalParam;
    var baselineDetails;
    if (model.getInterval()) {
      // settings.setInterval(baja.$("analytics:Interval").make(model.getInterval()));
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Interval").make(model.getInterval()));
      optionalParam.setSelected(model.isIntervalSelected());
      settings.setInterval(optionalParam);
    }
    if (model.getRollup()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Combination").make(model.getRollup()));
      optionalParam.setSelected(model.isRollupSelected());
      settings.setRollup(optionalParam);
    }
    if (model.getAggregation()) {
      optionalParam = baja.$("analytics:OptionalParam");
      optionalParam.setValue(baja.$("analytics:Combination").make(model.getAggregation()));
      optionalParam.setSelected(model.isAggregationSelected());
      settings.setAggregation(optionalParam);
    }
    if (model.getBaseline()) {
      baselineDetails = baja.$("analytics:AnalyticsChartBaselineDetails");
      baselineDetails.setEnabled(model.getBaseline().baselineEnabled);
      baselineDetails.setBaselineColor(baja.$("gx:Color").make(model.getBaseline().baselineColor));
      baselineDetails.setTimeRange(baja.$("analytics:BaselineTimeRangeEnum").make(model.getBaseline().baselineTimeRangeEnum));
      baselineDetails.setStartTime(baja.$("baja:AbsTime").decodeFromString(model.getBaseline().baselineStartTime));
      baselineDetails.setEndTime(baja.$("baja:AbsTime").decodeFromString(model.getBaseline().baselineEndTime));
      baselineDetails.setEndTimeEnabled(model.getBaseline().baselineEndTimeEnabled);
      baselineDetails.setAlignDOW(model.getBaseline().baselineAlignDOW);
      settings.setBaseline(baselineDetails);
    }
    if (model.getTimeRange()) {
      settings.setDetailedTimeRange(model.getTimeRange());
    }

    // if (model.isIntervalSelected()) {
    //   settings.setIsIntervalSelected(model.isIntervalSelected());
    // }

    if (model.getDaysToExclude()) {
      settings.setDaysToExclude(baja.$("analytics:AnalyticDaysOfWeekBits").make(model.getDaysToExclude()));
    }
    settings.setData(model.getData() || "n:history");
    settings.setDataFilter(model.getDataFilter() || "");
    if (model.getUnit()) {
      settings.setUnit(model.getUnit());
    }
    if (model.getOrd()) {
      settings.setOrd(model.getOrd());
    }
    if (model.getDataSource()) {
      settings.setDataSource(model.getDataSource());
    }
    if (model.getDataSourceName()) {
      settings.setDataSourceName(model.getDataSourceName());
    }
    if (model.getSeriesName()) {
      settings.setSeriesName(model.getSeriesName());
    }
    if (model.getBrush()) {
      settings.setBrush(String(model.getBrush()));
    }
    if (settings.setBrush2 && model.getBrush2()) {
      settings.setBrush2(String(model.getBrush2()));
    }
    if (model.getSeriesNameBFormat()) {
      settings.setSeriesNameBFormat(model.getSeriesNameBFormat());
    }
    if (model.getUniqueKey()) {
      settings.setUniqueKey(model.getUniqueKey());
    }
    if (model.getChartType && model.getChartType()) {
      settings.setChartType(baja.$(settings.getChartType().getType().getTypeSpec()).make(model.getChartType()));
    }
    if (model.getShowOnY2 && model.getShowOnY2()) {
      settings.setShowOnY2(baja.$("baja:Boolean").make(model.getShowOnY2()));
    }
    if (model.getMissingDataConfig && model.getMissingDataConfig()) {
      var missingDataStrategy = model.getMissingDataConfig();
      var aggSt = baja.$("analytics:AggregationStrategy").make(missingDataStrategy.aggStrategy);
      var intpAlgorithm = baja.$("analytics:InterpolationAlgorithm").make(missingDataStrategy.intpAlgorithm);
      var mdStrategy = baja.$("analytics:MissingDataStrategy", {
        enabled: missingDataStrategy.enabled,
        aggregationStrategy: aggSt,
        interpolationAlgorithm: intpAlgorithm,
        kValue: missingDataStrategy.knnValue
      });
      settings.setMissingDataStrategy(mdStrategy);
    }
    settings.setHisTotEnabled(model.getHisTotEnabled());
    return settings;
  };

  /**
   *
   * @param that
   * @param inModel
   * @returns {boolean}
   */
  analyticsUtil.isUniqueOrd = function (that, inModel) {
    var tableData = inModel[0];
    if (_.contains(that.uniqueKeyList, tableData[0].getUniqueKey())) {
      return false;
    } else {
      if (tableData[0].getUniqueKey()) {
        that.uniqueKeyList.push(tableData[0].getUniqueKey());
      }
    }
    return true;
  };

  /**
   *
   * @param input
   */
  analyticsUtil.parseObjectForReport = function (input) {
    if (!input) {
      return {};
    }
    var keys = Object.keys(input);
    _.each(keys, function (key) {
      try {
        input[key] = JSON.parse(input[key].value);
      } catch (err) {
        input[key] = input[key].value;
      }
    });
  };

  /**
   * Get the corresponding service that user has requested for.
   * @param serviceSCheme
   */
  analyticsUtil.getService = function (serviceSCheme) {
    return baja.Ord.make(serviceSCheme).get({
      lease: true,
      leaseTime: baja.RelTime.make({
        minutes: 1
      }),
      limit: -1
    }).then(function (scheme) {
      return Promise.resolve(scheme);
    });
  };

  /**
   * Converts the given object into multi node type ord.
   * @param interimObj
   */
  analyticsUtil.getMultiNodeOrd = function (interimObj, ordScheme) {
    var outputOrd = "station:|slot:|" + ordScheme,
      nodeObj = interimObj.$nodeModel;
    if (interimObj.$data !== undefined) {
      outputOrd = outputOrd + "data=" + interimObj.$data;
    }
    if (interimObj.$dow !== undefined) {
      outputOrd = outputOrd + "&dow=" + interimObj.$dow;
    }
    if (interimObj.$seriesName !== undefined && !_.isEmpty(interimObj.$seriesName)) {
      outputOrd = outputOrd + "&seriesName=" + interimObj.$seriesName;
    }
    if (interimObj.$timeRange !== undefined) {
      outputOrd = outputOrd + "&timeRange=" + interimObj.$timeRange;
    }
    var unit;
    if (unit = interimObj.$unit) {
      if (unit !== "null") {
        outputOrd = outputOrd + "&unit=" + unit.getUnitName();
      }
    }
    if (interimObj.$aggMode !== undefined) {
      outputOrd = outputOrd + "&aggMode=" + interimObj.$aggMode;
    }
    if (interimObj.$rollup !== undefined) {
      outputOrd = outputOrd + "&rollup=" + interimObj.$rollup;
    }
    if (interimObj.$aggregation !== undefined) {
      outputOrd = outputOrd + "&aggregation=" + interimObj.$aggregation;
      outputOrd = outputOrd + "&agg=" + interimObj.$aggregation;
    }
    if (interimObj.$interval !== undefined) {
      outputOrd = outputOrd + "&interval=" + interimObj.$interval;
    }
    if (interimObj.$dataFilter !== undefined) {
      outputOrd = outputOrd + "&dataFilter=" + interimObj.$dataFilter;
    }
    if (interimObj.$hisTotEnabled !== undefined) {
      outputOrd = outputOrd + "&hisTotEnabled=" + interimObj.$hisTotEnabled;
    }
    var mdh = interimObj.$missingDataCfg;
    if (mdh && mdh.enabled) {
      outputOrd = outputOrd + "&aggStrategy=" + mdh.aggStrategy;
      outputOrd = outputOrd + "&intpAlgorithm=" + mdh.intpAlgorithm;
      outputOrd = outputOrd + "&knnValue=" + mdh.knnValue;
    }
    if (nodeObj !== undefined) {
      _.map(_.keys(nodeObj), function (n) {
        var mulGrpStr = "&multiOrd=[";
        _.map(nodeObj[n].nodeList, function (node, index) {
          mulGrpStr += "node="; //adding node
          if (node.ord.indexOf("station:|") >= 0) {
            mulGrpStr = mulGrpStr + node.ord.split("station:|")[1];
          } else {
            mulGrpStr = mulGrpStr + node.ord;
          }
          if (index !== nodeObj[n].nodeList.length - 1) {
            mulGrpStr = mulGrpStr + ",";
          }
          return mulGrpStr;
        });
        nodeObj[n].ord = outputOrd + (mulGrpStr + "]"); //Closing the node=[]
      });
    }
    /**
     * sample degreeday normalization object
     * {
                type :"degreeday",
                selected : true,
                value : 65,
                unit: "${decodeable from string}",
                mapping : [{gn : "AHU-1", ord : "slot:Node1"}, {gn : "AHU-2", ord : "slot:Node2"}]
          }
     */
    if (nodeObj !== undefined && interimObj.getNormalizations() !== undefined) {
      _.each(interimObj.getNormalizations(), function (normOpt) {
        if (normOpt.selected === true && normOpt.type === "degreeday") {
          _.each(normOpt.mapping, function (degreeDayBaseNodeForGroup) {
            if (nodeObj[degreeDayBaseNodeForGroup.gn] !== undefined) {
              nodeObj[degreeDayBaseNodeForGroup.gn].degreeDayCfg = {};
              nodeObj[degreeDayBaseNodeForGroup.gn].degreeDayCfg = {
                ord: degreeDayBaseNodeForGroup.ord,
                baseValue: normOpt.value,
                unit: normOpt.unit,
                timeRange: interimObj.$timeRange,
                interval: interimObj.$interval,
                dow: interimObj.dow,
                ddtype: normOpt.ddtype
              };
            }
          });
        } else if (normOpt.selected && normOpt.type === "area") {
          _.each(normOpt.mapping, function (areaBaseNodeForGroup) {
            if (nodeObj[areaBaseNodeForGroup.gn] !== undefined) {
              nodeObj[areaBaseNodeForGroup.gn].areaCfg = {};
              nodeObj[areaBaseNodeForGroup.gn].areaCfg = {
                ord: areaBaseNodeForGroup.ord
              };
            }
          });
        }
      });
    }
    return nodeObj;
  };
  function trimTrend(chart, origSeries) {
    var renderLimit = chart.chartRenderCapacity ? chart.chartRenderCapacity["get" + chart.getName()]() : chart.getRenderLimit(),
      trendSize = 0,
      series = [];
    _.each(origSeries, function (eSer) {
      trendSize += eSer.data.length;
      var inSer = _.extend({}, eSer); // can use {...eSer} to replace this statement, but jshint doesnt allow as it's
      inSer.data = eSer.data.map(function (a) {
        return _.extend({}, a);
      }); // can use ({...a}) as per es6
      series.push(inSer);
    });
    // eslint-disable-next-line promise/avoid-new
    var maxPromise = new Promise(function (resolve, reject) {
      if (renderLimit !== -1 && trendSize > renderLimit) {
        if (!chart.$isDataLimitReached) {
          dialogs.showOk({
            title: analyticsUtil.lex.get("renderLimit.title"),
            text: analyticsUtil.lex.get({
              key: "renderLimit.message",
              args: [renderLimit]
            })
          });
          chart.$isDataLimitReached = true;
        }
        series = _.map(series, function (ser) {
          var cutCount = ser.data.length / trendSize * renderLimit;
          var takeOutCount = Math.round(ser.data.length - cutCount);
          while (takeOutCount !== 0 && ser.data.length !== 0) {
            ser.data.shift();
            takeOutCount = takeOutCount - 1;
          }
          return ser;
        });
        resolve(series);
      } else {
        resolve(origSeries);
      }
    });
    return maxPromise;
  }
  analyticsUtil.getRenderableC3Data = function (chart, origSeries) {
    var retPromise = trimTrend(chart, origSeries);
    var allPromise = retPromise.then(function (series) {
      var finalArray = [],
        mdcFinArr = [],
        labelObj = chart.getYAxisLabel();
      var returnObj = {
        types: {},
        groups: [],
        xs: {},
        columns: [],
        names: {},
        y2: [],
        colors: {},
        y2Label: [],
        yLabel: []
      };
      returnObj.y2Label = labelObj.y2Label;
      returnObj.yLabel = labelObj.yLabel;
      _.each(series, function (ser, index) {
        var inXColArr,
          inYColArr,
          mdcArray,
          setArr = [],
          key = "",
          grpStr = "";
        if (ser.data.length === 0) {
          key = 'x' + (index + 1) + ";" + ser.name + " (" + analyticsUtil.lex.get("baseChart.nodatafound.message") + ")";
          inXColArr = ['x' + (index + 1)];
          inYColArr = [key];
          mdcArray = [key];
          inXColArr.push(null);
          inYColArr.push(null);
          mdcArray.push(null);
          grpStr = _.isString(ser.chartType) ? _.isEmpty(ser.chartType) ? "bar" : ser.chartType : ser.chartType.getTag();
          returnObj.types[key] = grpStr.replace(/\_/g, "-");
          returnObj.colors[key] = ser.color;
          if (ser.showOnY2) {
            returnObj.y2.push(key);
          }
        } else {
          _.each(ser.data, function (dat, idx) {
            if (idx === 0) {
              key = 'x' + (index + 1) + ";" + ser.name + (ser.unit && ser.unit.length !== 0 && ser.unit !== "null" ? " (" + ser.unit + ")" : "");
              inXColArr = ['x' + (index + 1)];
              inYColArr = [key];
              mdcArray = [key];
              grpStr = _.isString(ser.chartType) ? _.isEmpty(ser.chartType) ? "bar" : ser.chartType : ser.chartType.getTag();
              returnObj.types[key] = grpStr.replace(/\_/g, "-");
              returnObj.colors[key] = ser.color;
              if (ser.showOnY2) {
                returnObj.y2.push(key);
              }
            }
            inXColArr.push(chart.getXData(dat));
            inYColArr.push(chart.getYData(dat));
            mdcArray.push(chart.getMetaData(dat));
          });
        }
        if (inXColArr && inYColArr) {
          setArr.push(inXColArr);
          setArr.push(inYColArr);
          mdcFinArr.push(mdcArray);
          finalArray.push(setArr);
        }
      });
      _.each(finalArray, function (eachAnal) {
        _.each(eachAnal, function (eat, inIdx) {
          returnObj.columns.push(eat);
          if (inIdx !== 0) {
            returnObj.groups.push(eat[0]);
            var inSplit = eat[0].split(";");
            returnObj.xs[eat[0]] = inSplit[0];
            returnObj.names[eat[0]] = baja.SlotPath.unescape(inSplit[1]);
          }
        });
      });
      returnObj.metaData = mdcFinArr;
      return Promise.resolve(returnObj);
    });
    return allPromise;
  };

  /**
   * Returns the renderable c3 data for the RelativeContribution and Ranking charts.
   * @param chart
   * @param origSeries
   * @returns {*}
   */
  analyticsUtil.getSimpleC3Data = function (chart, origSeries) {
    var retPromise = trimTrend(chart, origSeries);
    var allPromise = retPromise.then(function (series) {
      var finalArray = [],
        mdcFinArr = [],
        labelObj = chart.getYAxisLabel();
      var returnObj = {
        columns: [],
        names: {},
        y2: [],
        colors: {},
        y2Label: [],
        yLabel: [],
        types: {},
        groups: []
      };
      returnObj.y2Label = labelObj.y2Label;
      returnObj.yLabel = labelObj.yLabel;
      _.each(series, function (ser, index) {
        var inYColArr,
          mdcArray,
          setArr = [],
          key = "",
          grpStr = "";
        var tempYArr = [];
        _.each(series, function (l) {
          tempYArr.push(null);
        });
        _.each(ser.data, function (dat, idx) {
          if (idx === 0) {
            // In no data case, server will send a number 0.
            if (dat.y === '-' || dat.y === 0) {
              key = ser.name + (ser.unit && ser.unit.length !== 0 && ser.unit !== "null" ? " (" + ser.unit + ")" : "") + " (" + analyticsUtil.lex.get("baseChart.nodatafound.message") + ")" + ";" + index;
            } else {
              key = ser.name + (ser.unit && ser.unit.length !== 0 && ser.unit !== "null" ? " (" + ser.unit + ")" : "") + ";" + index;
            }
            grpStr = _.isString(ser.chartType) ? _.isEmpty(ser.chartType) ? "bar" : ser.chartType : ser.chartType.getTag();
            returnObj.types[key] = grpStr.replace(/\_/g, "-");
            returnObj.colors[key] = ser.color;
            if (ser.showOnY2) {
              returnObj.y2.push(key);
            }
          }
          inYColArr = [key];
          mdcArray = [key];
          tempYArr[index] = chart.getYData(dat);
          mdcArray.push(chart.getMetaData(dat));
          inYColArr.push.apply(inYColArr, tempYArr);
        });
        if (inYColArr) {
          setArr.push(inYColArr);
          mdcFinArr.push(mdcArray);
          finalArray.push(setArr);
        }
      });
      _.each(finalArray, function (eachAnal) {
        _.each(eachAnal, function (eat, inIdx) {
          var inSplit = eat[0].split(";");
          returnObj.columns.push(eat);
          returnObj.groups.push(eat[0]);
          returnObj.names[eat[0]] = baja.SlotPath.unescape(inSplit[0]);
        });
      });
      returnObj.metaData = mdcFinArr;
      return Promise.resolve(returnObj);
    });
    return allPromise;
  };

  /**
   * Get the ord to get the area values
   * @param interimObj
   */
  analyticsUtil.getAreaValueOrd = function (interimObj, areaOrdScheme, areaDataTag) {
    areaOrdScheme = areaOrdScheme || "analyticmultitrend";
    var outputOrd = "station:|slot:|" + areaOrdScheme,
      nodeList = interimObj.nodeList;
    outputOrd = outputOrd + ":data=" + areaDataTag;
    outputOrd = outputOrd + "&timeRange=today";
    outputOrd = outputOrd + "&aggMode=true";
    outputOrd = outputOrd + "&agg=sum";
    outputOrd = outputOrd + "&aggregation=sum";
    outputOrd = outputOrd + "&interval=day";
    outputOrd = outputOrd + "&isHistory=false";
    outputOrd = outputOrd + "&aggStrategy=ignorePoint";
    var configuredOrd = interimObj.areaCfg && interimObj.areaCfg.ord || "slot:";
    configuredOrd = configuredOrd.replace("station:|", "");
    var mulGrpStr = "&multiOrd=[";
    if (configuredOrd.indexOf("slot:/") >= 0 || configuredOrd.indexOf("hierarchy:/") >= 0) {
      mulGrpStr += "node=" + configuredOrd;
    } else {
      for (var i = 0; i < nodeList.length; i++) {
        var node = nodeList[i],
          nodeOrd = "";
        if (i !== 0) {
          mulGrpStr += ",";
        }
        if (node.ord.indexOf("station:|") >= 0) {
          nodeOrd = node.ord.split("station:|")[1];
        } else {
          nodeOrd = node.ord;
        }
        nodeOrd = analyticsUtil.getRelativizedOrd(configuredOrd, nodeOrd);
        mulGrpStr = mulGrpStr + "node=" + nodeOrd;
      }
    }
    outputOrd = outputOrd + (mulGrpStr + "]"); //Closing the node=[]
    return outputOrd;
  };
  analyticsUtil.getRelativizedOrd = function (configuredOrd, nodeOrd) {
    if (configuredOrd && configuredOrd.indexOf("slot:") === 0) {
      var isHierarchyOrd = nodeOrd.indexOf("hierarchy:") === 0;
      if (!isHierarchyOrd) {
        // For slot paths relativization works out of the box
        nodeOrd += "|" + configuredOrd;
        nodeOrd = baja.Ord.make(nodeOrd).normalize().encodeToString();
      } else {
        // For hierarchy ORD, do the relativization
        // Note : This is a crude fix. Needs to be discussed with UX team
        var nodeOrdObj = baja.Ord.make(nodeOrd);
        var relPath = new baja.SlotPath(baja.Ord.make(configuredOrd).parse().get(0).getBody());
        var nodePath = new baja.SlotPath(nodeOrdObj.parse().get(0).getBody());
        var mergedPath = nodePath.merge(relPath);
        nodeOrd = "hierarchy:" + mergedPath;
      }
    }
    return nodeOrd;
  };

  /**
   * Get the ord to get the oat values
   * @param groupConfig
   */
  analyticsUtil.getOatValueOrd = function (groupConfig, oatOrdScheme, oatDataTag, unitOrdinal) {
    if (groupConfig.degreeDayCfg === undefined) {
      groupConfig.degreeDayCfg = {};
    }
    oatOrdScheme = oatOrdScheme || "analyticDegreeDayTrend";
    groupConfig.degreeDayCfg.unit = "fahrenheit;°F;(K);*0.5555555555555556+255.37222222222223;";
    //TODO refactor enum
    var units = "fahrenheit",
      degUnit = "fahrenheit;°F;(K);*0.5555555555555556+255.37222222222223;";
    groupConfig.degreeDayCfg.unit = degUnit;
    switch (unitOrdinal) {
      case 1:
        units = "celsius";
        groupConfig.degreeDayCfg.unit = "celsius;°C;(K);+273.15;";
        break;
      case 2:
        units = "fahrenheit";
        groupConfig.degreeDayCfg.unit = degUnit;
        break;
      case 3:
        units = "kelvin";
        groupConfig.degreeDayCfg.unit = "kelvin;K;(K);;";
        break;
    }
    var ddtype = "heating";
    switch (groupConfig.degreeDayCfg.ddtype) {
      case 0:
        ddtype = "heating";
        break;
      case 1:
        ddtype = "cooling";
        break;
    }
    groupConfig.degreeDayCfg.ddtype = ddtype;
    var configuredOrd = groupConfig.degreeDayCfg && groupConfig.degreeDayCfg.ord || "slot:",
      outputOrd = "station:|";
    configuredOrd = configuredOrd.replace("station:|", "");
    if (configuredOrd.indexOf("slot:/") >= 0 || configuredOrd.indexOf("hierarchy:/") >= 0) {
      outputOrd += configuredOrd;
    } else {
      var nodeList = groupConfig.nodeList,
        firstNode = nodeList[0],
        nodeOrd = "";
      if (firstNode.ord.indexOf("station:|") >= 0) {
        nodeOrd = firstNode.ord.split("station:|")[1];
      } else {
        nodeOrd = firstNode.ord;
      }
      nodeOrd = analyticsUtil.getRelativizedOrd(configuredOrd, nodeOrd);
      outputOrd = outputOrd + nodeOrd;
    }
    outputOrd = outputOrd + "|" + oatOrdScheme;
    outputOrd = outputOrd + ":data=" + oatDataTag;
    outputOrd = outputOrd + "&timeRange=" + (groupConfig.degreeDayCfg.timeRange || "today");
    outputOrd = outputOrd + "&aggregation=avg";
    outputOrd = outputOrd + "&rollup=avg";
    if (groupConfig.degreeDayCfg.dow) {
      outputOrd = outputOrd + "&dow=" + groupConfig.degreeDayCfg.dow;
    }
    if (groupConfig.degreeDayCfg.interval) {
      outputOrd = outputOrd + "&interval=" + groupConfig.degreeDayCfg.interval;
    }
    outputOrd = outputOrd + "&baseTemp=" + (groupConfig.degreeDayCfg.baseValue || reportConstants.DEFAULT_BASELINE_TEMP_VALUE);
    outputOrd = outputOrd + "&baseTempUnit=" + units;
    outputOrd = outputOrd + "&degreeDay=" + ddtype;
    outputOrd = outputOrd + "&isHistory=true";
    return outputOrd;
  };
  analyticsUtil.normalize = function (model, data, rollup) {
    var areaCfg = model.getAreaCfg();
    var degreeDayCfg = model.getDegreeDayCfg();
    var isAreaNormalizationRequired = false;
    var isDegreeDayNormalizationRequired = false;
    if (areaCfg && areaCfg.req && areaCfg.value > 0) {
      isAreaNormalizationRequired = true;
    }
    if (degreeDayCfg && degreeDayCfg.req && degreeDayCfg.oatValues) {
      isDegreeDayNormalizationRequired = true;
    }
    if (isAreaNormalizationRequired || isDegreeDayNormalizationRequired) {
      var oatValues = degreeDayCfg.oatValues;
      var oatValue, getOat;
      if (rollup) {
        oatValue = _.reduce(_.values(oatValues), function (memo, num) {
          return memo + num;
        }, 0);
      } else {
        getOat = function (oatValues) {
          var currentIndex = 0;
          var oatKeys = _.map(_.keys(oatValues), function (key) {
            return parseInt(key, 10);
          });
          return function (time) {
            for (var i = currentIndex; i < oatKeys.length; i++) {
              if (oatKeys[i] > time) {
                currentIndex = i - 1;
                break;
              }
            }
            return oatValues[oatKeys[currentIndex]];
          };
        }(oatValues);
      }
      data = _.map(data, function (rec) {
        if (isAreaNormalizationRequired) {
          rec.value = rec.value / areaCfg.value;
        }
        if (isDegreeDayNormalizationRequired) {
          // if(conversion !== undefined){
          //   oatValue = conversion(oatValue);
          // }
          if (!rollup) {
            oatValue = getOat(rec.timestamp.getTime());
          }
          if (oatValue && oatValue > 0) {
            rec.value = rec.value / oatValue;
          }
        }
        return rec;
      });
    }
    return data;
  };

  /**
   *
   * @param trendFlag
   * @return {*}
   */
  analyticsUtil.decodeTrendFlag = function (trendFlag) {
    if (trendFlag === 0 || _.isNaN(trendFlag)) {
      return analyticsUtil.lex.getSafe("missingdata.appliedmdc.DEFAULT");
    }
    var retArray = [];
    _.each(analyticsUtil.twoPowLimit, function (val, index) {
      if ((trendFlag & val) === val) {
        retArray.push(analyticsUtil.lex.getSafe("missingdata.appliedmdc." + val));
      }
    });
    return "{" + retArray.toString() + "}";
  };
  analyticsUtil.getIntSystemProperty = function (key, fallback) {
    try {
      var result = niagaraSystemProperties[key];
      if (result !== undefined) {
        return parseInt(result);
      }
    } catch (ignore) {}
    return fallback;
  };
  analyticsUtil.standardizeInput = function (value) {
    if (value !== undefined && value.toString().indexOf(".") === -1) {
      return d3.format("s")(value || "");
    } else {
      return d3.format(".4s")(value || "");
    }
  };
  analyticsUtil.supportedTrends = ["analytictrend:", "mAggtrendOrd:", "maggtrendord:"];
  analyticsUtil.MILLIS_MONTH = 2592000000;
  analyticsUtil.MILLIS_YEAR = 31536000000;
  analyticsUtil.MILLIS_WEEK = 604800000;
  analyticsUtil.MILLIS_DAY = 86400000;
  analyticsUtil.MILLIS_TWELVE_HOURS = 43200000;
  return analyticsUtil;
});
