/* eslint-disable promise/no-return-wrap */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/util/AnalyticGroupTreeNode
 */
define(['baja!', 'Promise', 'jquery', 'underscore', 'nmodule/webEditors/rc/wb/tree/JSONTreeNode', 'nmodule/analytics/rc/report/util/reportUtils', 'nmodule/analytics/rc/report/util/AnalyticNodeTreeNode'], function (baja, Promise, $, _, JSONTreeNode, reportUtils, AnalyticNodeTreeNode) {
  'use strict';

  /**
   * @class
   * @alias module:nmodule/analytics/rc/report/util/AnalyticGroupTreeNode
   * @extends module:nmodule/webEditors/rc/wb/tree/JSONTreeNode
   * @param comp
   * @param obj
   * @param name
   */
  var AnalyticGroupTreeNode = function AnalyticGroupTreeNode(comp, obj, name) {
    this.$comp = comp;
    JSONTreeNode.call(this, comp.getName() || name, obj);
  };
  AnalyticGroupTreeNode.prototype = Object.create(JSONTreeNode.prototype);
  AnalyticGroupTreeNode.prototype.constructor = AnalyticGroupTreeNode;
  AnalyticGroupTreeNode.prototype.getComponent = function () {
    return this.$comp;
  };
  /**
   * Set the index for this group
   * @param $index
   */
  AnalyticGroupTreeNode.prototype.setIndex = function ($index) {
    this.$index = $index;
  };
  /**
   * Get the index for group
   * @returns {*}
   */
  AnalyticGroupTreeNode.prototype.getIndex = function () {
    return this.$index;
  };
  /**
   * This is a drop target for "NavNodes"
   * @returns {boolean}
   */
  AnalyticGroupTreeNode.prototype.isDropTarget = function () {
    return true;
  };

  /**
   * Once a node is dropped under this folder it should get added to the folder
   *
   * @param {Array} values the values being dropped onto this node
   * @returns {Promise} promise to be resolved when the drop operation
   * completes, or rejected if the given array does not hold valid data
   * to perform a drop operation.
   */
  AnalyticGroupTreeNode.prototype.doDrop = function (values) {
    var that = this;
    if (!that.$comp) {
      // eslint-disable-next-line prefer-promise-reject-errors
      return Promise.reject("Error: Component value cannot be null");
    }
    var promises = [];
    // Once node is added add it to the Node tree in UI as well.
    var navNodeResolve = function navNodeResolve(propName, displayName, navNodeDisplay, map) {
      var slot = that.$comp.getSlot(propName),
        c = that.$comp.get(slot);
      var aNode = new AnalyticNodeTreeNode(c, {});
      aNode.setNavNodeDisplay(navNodeDisplay);
      map[propName] = displayName || slot.getName();
      return that.add(aNode);
    };

    // If there is only one node under the group, it is most likely hidden. Unhide it now.
    var childNodes = this.$comp.getSlots().properties().is("analytics:AnalyticNode").toValueArray();
    var map = {};
    if (childNodes.length === 1) {
      var currentNode = childNodes[0],
        curNodeName = currentNode.getName();
      if (this.$comp.getFlags(currentNode.getName()) === baja.Flags.HIDDEN) {
        this.$comp.setFlags({
          slot: curNodeName,
          flags: 0
        });
        var dnPromise = that.$getUniqueNodePath(currentNode.getDisplayName(), baja.Ord.make(currentNode.getNodePath()));
        promises.push(dnPromise.then(function (dnPath) {
          return navNodeResolve(curNodeName, currentNode.getDisplayName(), dnPath, map);
        }));
      }
    }
    var duplicateNodes = [];
    _.each(values, function (navNode, vIndex) {
      var navOrd = navNode.getNavOrd();
      var nodeComponent = baja.$("analytics:AnalyticNode", {
        nodePath: baja.Ord.make(navOrd)
      });
      var newNodeName = baja.SlotPath.escape(navNode.getNavDisplayName()),
        existingComponent = null,
        nodeExists = false;
      // If a node with same nav name is already added, check if they point to the same
      // nav ORD in the station tree. If YES, mark it as duplicate node and push it to array of duplicate nodes.
      var cp = that.$getUniqueNodePath(newNodeName, navOrd).then(function (path) {
        if ((existingComponent = that.$comp.get(newNodeName)) !== null) {
          var existingNodePath = baja.Ord.make(existingComponent.getNodePath());
          nodeExists = existingNodePath.equals(navOrd);
        }
        if (!nodeExists) {
          // If its not a duplicate node, simply add it
          promises.push(that.$comp.add({
            slot: newNodeName + "?",
            value: nodeComponent
          }).then(function (prop) {
            return navNodeResolve(prop.getName(), newNodeName, path, map);
          }));
        } else {
          duplicateNodes.push(path);
        }
      });
      promises.push(cp);
    });
    return Promise.all(promises).then(function () {
      var dnObj = that.$comp.get('displayNames'),
        method = "add";
      if (dnObj) {
        var keys = dnObj.list();
        _.each(keys, function (key) {
          if (!map.hasOwnProperty(key)) {
            map[key] = dnObj.get(key).valueOf();
          }
        });
        method = "set";
      }
      return that.$comp[method]({
        slot: "displayNames",
        value: baja.NameMap.make(map),
        flags: baja.Flags.HIDDEN | baja.Flags.READONLY | baja.Flags.TRANSIENT
      }).then(function () {
        return Promise.resolve(that);
      });
      // if(childNodes.length + values.length > 1) {
      //     // TRy to knock off the tooltip on group now, since it is nothing more than
      //     // a container now!!
      // }
    });
  };

  /**
   * Get nav type spec. This node represents analytics:AnalyticNodeGroup
   */
  AnalyticGroupTreeNode.prototype.getNavTypeSpec = function () {
    return "analytics:AnalyticNodeGroup";
  };

  /**
   * Implement 'Add'
   */
  AnalyticGroupTreeNode.prototype.add = function (analyticNode) {
    var that = this;
    if (!this.$kids) {
      this.$kids = [];
    }
    if (!analyticNode.getNavNodeDisplay()) {
      var nodePath = analyticNode.getComponent().getNodePath();
      return that.$getUniqueNodePath(baja.SlotPath.unescape(analyticNode.getComponent().getDisplayName()), baja.Ord.make(nodePath)).then(function (navNodePath) {
        analyticNode.setNavNodeDisplay(navNodePath);
        that.$kids.push(analyticNode);
        return Promise.resolve(true);
      });
    } else {
      this.$kids.push(analyticNode);
      return Promise.resolve(true);
    }
  };
  AnalyticGroupTreeNode.prototype.getKids = function () {
    return Promise.resolve(this.$kids);
  };
  AnalyticGroupTreeNode.prototype.getKid = function (index) {
    return this.$kids[index];
  };
  AnalyticGroupTreeNode.prototype.removeKid = function (name) {
    var kids = this.$kids,
      rIndex = -1;
    for (var kIndex = 0; kIndex < kids.length; kIndex++) {
      if (kids[kIndex].getName() === name) {
        rIndex = kIndex;
        break;
      }
    }
    if (rIndex > -1) {
      this.$kids.splice(rIndex, 1);
    }
  };
  /**
   * Get the unique (qualified) name for both the nav nodes
   * @param existingNodeOrd
   * @param addedNodeOrd
   * @returns {*}
   */
  AnalyticGroupTreeNode.prototype.$getUniqueNodePath = function (nodeName, nodeOrd) {
    return reportUtils.getDisplayNodePath(nodeName, nodeOrd);
  };
  return AnalyticGroupTreeNode;
});
