/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 *
 * Menu agent for analytics nodes. Used to register the 'Delete' and 'Rename' command.
 *
 * @module nmodule/analytics/rc/report/menu/reportFolderMenuAgent
 */
define(['bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (Command, CommandGroup, asyncUtils) {
  'use strict';

  var doRequire = asyncUtils.doRequire;
  /**
   *  Return the meny agent for analytic node and group
   */
  return function analyticReportFolderMenuAgent(ownerWidget, reportFolder) {
    return reportFolder.lease().then(function () {
      return doRequire(['nmodule/analytics/rc/report/command/AnalyticViewReportsCommand', 'nmodule/analytics/rc/report/command/AnalyticNewReportCommand']).spread(function (AnalyticViewReportsCommand, AnalyticNewReportCommand) {
        var group = new CommandGroup();
        var viewReportsCommand = new AnalyticViewReportsCommand(ownerWidget, reportFolder);
        group.add(viewReportsCommand);
        viewReportsCommand.setEnabled(true);
        var newReportsCommand = new AnalyticNewReportCommand(ownerWidget, reportFolder);
        group.add(newReportsCommand);
        newReportsCommand.setEnabled(true);
        return group;
      });
    });
  };
});
