function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Shubham Mallya
 */

/**
 * API Status: **Private**
 * @since Niagara 4.15
 * @module nmodule/analytics/rc/report/fe/OptionalSimpleEditor
 */

/** @jsx spandrel.jsx */

define(['baja!', "baja!analytics:UxAnalyticTimeRangeType,analytics:AnalyticTimeRange", 'bajaux/events', 'bajaux/spandrel', 'bajaux/Widget', 'dialogs', 'jquery', 'lex!analytics', "Promise", 'nmodule/analytics/rc/chart/fe/AnalyticTimeRangeFE', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, types, events, spandrel, Widget, dialogs, $, lexs, Promise, AnalyticTimeRangeFE, StringEditor, fe, feDialogs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-OptionalSimpleEditor'
      }
    };
  };

  /**
   * A field editor for selecting value from the web Browser.
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/analytics/rc/report/fe/OptionalSimpleEditor
   * */
  var OptionalSimpleEditorFe = /*#__PURE__*/function (_spandrel) {
    function OptionalSimpleEditorFe(params) {
      _classCallCheck(this, OptionalSimpleEditorFe);
      return _callSuper(this, OptionalSimpleEditorFe, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @param {module:nmodule/analytics/rc/report/fe/OptionalSimpleEditor} values
     * @param {object} state
     * @returns {object}
     */
    _inherits(OptionalSimpleEditorFe, _spandrel);
    return _createClass(OptionalSimpleEditorFe, [{
      key: "$buildEditor",
      value: function $buildEditor(values, state) {
        var _this = this;
        var value = state.value,
          hasValue = state.hasValue;
        if (this.getFormFactor() === Widget.formfactor.mini) {
          return [spandrel.jsx("td", {
            spandrelKey: "column1"
          }, spandrel.jsx("any", {
            lax: true,
            bind: true,
            spandrelKey: "hasValue",
            value: hasValue,
            properties: {
              displayType: "checkbox",
              trueText: "",
              falseText: ""
            }
          })), spandrel.jsx("td", {
            spandrelKey: "column2",
            value: value
          }, spandrel.jsx(StringEditor, {
            lax: true,
            bind: true,
            spandrelKey: "innerValue",
            value: hasValue ? value.toString() : "",
            readonly: true,
            enabled: hasValue,
            onclick: function onclick() {
              return _this.$popup(state);
            }
          }))];
        }
      }
    }, {
      key: "toState",
      value: function toState(state) {
        return {
          value: state.getValue(),
          hasValue: state.getHasValue()
        };
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        var value = state.value,
          hasValue = state.hasValue;
        return {
          value: value,
          hasValue: hasValue
        };
      }

      /**
       * Reads the value of values and hasValue
       *
       * @returns {object}
       */
    }, {
      key: "doRead",
      value: function doRead() {
        return Promise.all([this.$getColumnWidget().read(), this.$getHasValueWidget().read()]).then(function (states) {
          return {
            value: states[0],
            hasValue: states[1]
          };
        });
      }

      /**
       * Saves the widget values.
       *
       * @param {module:nmodule/analytics/rc/report/fe/OptionalSimpleEditor} state
       * @returns {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave(state) {
        var value = state.value,
          hasValue = state.hasValue;
        if (hasValue === true) {
          this.value().setValue(value);
          this.value().setHasValue(hasValue);
        } else {
          this.value().setHasValue(hasValue);
        }
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getValueWidget",
      value: function $getValueWidget() {
        return this.queryWidget('column2/innerValue');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHasValueWidget",
      value: function $getHasValueWidget() {
        return this.queryWidget('column1/hasValue');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getColumnWidget",
      value: function $getColumnWidget() {
        return this.queryWidget('column2');
      }

      /**
       * @private
       * @returns {String}
       */
    }, {
      key: "$getLabel",
      value: function $getLabel() {
        return this.getComplex().getDisplayName(this.getSlot()) || lex.get("interval");
      }

      /**
       * When String Editor is clicked, Popup Shows up with respective values.
       * If the String Editor is Time Range then it call the AnalyticTimeRangeFE and
       * gives the value AnalyticTimeRange instance.
       *
       * @private
       * @param {module:nmodule/analytics/rc/report/fe/OptionalSimpleEditor} state
       * @returns load the value in Widget.
       */
    }, {
      key: "$popup",
      value: function $popup(state) {
        var value = state.value;
        var that = this;
        if (this.$getLabel() === lex.get("timeRange")) {
          return feDialogs.showFor({
            title: this.$getLabel(),
            value: value,
            type: AnalyticTimeRangeFE
          }).then(function (val) {
            if (val === undefined || val.isNull) {
              return;
            }
            that.$getValueWidget().load(decodeURIComponent(val.toString()));
            that.$getColumnWidget().load(val);
            that.$getValueWidget().trigger(events.MODIFY_EVENT);
          });
        } else {
          return feDialogs.showFor({
            title: this.$getLabel(),
            value: value,
            properties: {
              customEntry: false
            }
          }).then(function (val) {
            if (val === undefined || val.isNull) {
              return;
            }
            that.$getValueWidget().load(val.toString());
            that.$getColumnWidget().load(val);
            that.$getValueWidget().trigger(events.MODIFY_EVENT);
          });
        }
      }
    }]);
  }(spandrel(function (values, state) {
    return this.$buildEditor(values, state);
  }, {
    strategy: 'niagara'
  }));
  return OptionalSimpleEditorFe;
});
