/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file Custom time range field editor for analytic web reports
 * @author Upender Paravastu
 */
define(['baja!', 'bajaux/Widget', 'Promise', 'jquery', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/chart/base/analyticEvents', 'nmodule/analytics/rc/chart/fe/AnalyticTimeRangeFE', 'lex!analytics'], function (baja, Widget, Promise, $, _, fe, feDialogs, analyticEvents, AnalyticTimeRangeFE, lexicon) {
  'use strict';

  /**
   *  <pre> AnalyticReportTimeRangeFE </pre> extends AnalyticTimeRangeFE and slightly modifies
   *  the way "Time Range" option in date time options is handled.
   * @constructor
   */
  var AnalyticReportTimeRangeFE = function AnalyticReportTimeRangeFE() {
    AnalyticTimeRangeFE.apply(this, arguments);
  };
  // Inheriting AnalyticDataEditorFE from AnalyticTimeRangeFE
  AnalyticReportTimeRangeFE.prototype = Object.create(AnalyticTimeRangeFE.prototype);
  // Setting the constructor
  AnalyticReportTimeRangeFE.prototype.constructor = AnalyticReportTimeRangeFE;

  /**
   * This method takes in string format of the time range string and makes additional
   * time range info for 'Time Range' option.
   * @param value
   */
  AnalyticReportTimeRangeFE.prototype.handleCustomTimeRange = function (timeRangeEditor) {
    var that = this;
    that.jq().trigger(analyticEvents.TIME_RANGE_CHANGED, [timeRangeEditor.doRead(), null]);
  };
  AnalyticReportTimeRangeFE.prototype.doRead = function () {
    return AnalyticTimeRangeFE.prototype.encodeToString.apply(this, arguments);
  };
  return AnalyticReportTimeRangeFE;
});
