/* eslint-disable promise/no-return-wrap */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'log!nmodule.analytics.chart.utils.AnalyticsDataUtils', 'jquery', 'Promise', 'd3', 'moment', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel', 'nmodule/analytics/rc/chart/base/AnalyticsMultiNodeDataModel', 'nmodule/analytics/rc/chart/base/AnalyticsMultiOrdDataModel', 'nmodule/analytics/rc/chart/base/AnalyticMultiNodeBaselineModel', 'nmodule/analytics/rc/chart/base/AnalyticTrendRecord', 'nmodule/analytics/rc/report/util/reportUtils', 'nmodule/analytics/rc/util/ModelFactory', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/transform/transformer/TableModelToCsv', 'nmodule/webEditors/rc/wb/table/model/columns/JsonObjectPropertyColumn', 'nmodule/webEditors/rc/util/chunkUtil', 'underscore', 'lex!baja,analytics'], function (baja, log, $, Promise, d3, moment, analyticsUtil, AnalyticsBaseDataModel, AnalyticsMultiNodeDataModel, AnalyticsMultiOrdDataModel, AnalyticMultiNodeBaselineModel, AnalyticTrendRecord, reportUtils, ModelFactory, TableModel, TableModelToCsv, JsonObjectPropertyColumn, chunkUtil, _, lexicon) {
  "use strict";

  var AnalyticsDataUtils = {},
    boxTableTypeSpec = "box:BoxTable",
    analyticsStatusTypeSpec = "analytics:AnalyticsStatusValue",
    boxFileTypeSpec = "box:BoxFile",
    lex = lexicon[1],
    colorIndex = 0,
    colors = d3.scaleOrdinal(d3.schemeCategory10).domain([0, 9]),
    reservedColors = [];
  var logSevere = log.severe.bind(log);

  /**
   * Returns a unique color from the D3 20 colors.
   * @param currentColor
   * @returns {*}
   */
  var getUniqueColor = function getUniqueColor(currentColor, series) {
    // In dashboard case each series will already have a color, first add that to the reserved colors.
    if (series) {
      series.map(function (eachSer) {
        if (!reservedColors.contains(eachSer.color)) {
          reservedColors.push(eachSer.color);
        }
      });
    }
    // If you already have a color then skip the below code.
    if (!currentColor) {
      // If reserved colors are full, empty them to zero.
      if (colors.range().length === reservedColors.length) {
        reservedColors = [];
      }
      // Get the unique color by checking if the color is already existing in the pool.
      var myColorIndex = 0;
      var _containColor = function containColor(index) {
        var resColor = colors(index % 20);
        if (reservedColors.contains(resColor)) {
          myColorIndex = myColorIndex + 1;
          return _containColor(myColorIndex);
        } else {
          return resColor;
        }
      };
      currentColor = _containColor(myColorIndex);
    }
    // If reserved colors does not contain the current color, then add it.
    if (!reservedColors.contains(currentColor)) {
      reservedColors.push(currentColor);
    }
    return currentColor;
  };

  /**
   * Checks if trend has more than one values in it.
   * @param trendArray
   * @returns {number}
   */
  function containsMoreValues(trendArray) {
    var flag = 1;
    trendArray.every(function (trend) {
      var occurObj = _.countBy(_.keys(trend), function (val) {
        return val.indexOf("value") !== -1 ? "yes" : "no";
      });
      if (occurObj.yes > 1) {
        flag = occurObj.yes;
        return false;
      }
      return true;
    });
    return flag;
  }

  /**
   * Will convert one multi model to many base models.
   * @param multiModel
   * @param nodeModel
   * @param group
   * @param valueCount
   * @returns {Array}
   */
  function breakOneModelToMany(report, multiModel, nodeModel, group, valueCount) {
    var returnBaseModelArr = [],
      trendArray = nodeModel[group].analyticTrendArray,
      unit = multiModel.$unit;
    var grpCfg = nodeModel[group],
      areaCfg = grpCfg.areaCfg || false,
      displayName = nodeModel[group].dn,
      degreeDayCfg = grpCfg.degreeDayCfg || false;
    if (multiModel.$aggMode) {
      var model = ModelFactory.newBaseDataModel(report.getChartType(), {
        ord: nodeModel[group].ord,
        seriesName: displayName,
        daysToExclude: multiModel.$dow,
        interval: multiModel.$interval,
        isIntervalSelected: multiModel.$isIntervalSelected,
        rollup: multiModel.$rollup,
        isRollupSelected: multiModel.$isRollupSelected,
        aggregation: multiModel.$aggregation,
        isAggregationSelected: multiModel.$isAggregationSelected,
        brush: nodeModel[group].color || multiModel.$brush,
        brush2: multiModel.$brush2,
        midBrush: multiModel.$midBrush,
        data: multiModel.$data,
        dataFilter: multiModel.$dataFilter,
        timeRange: multiModel.$timeRange,
        unit: unit,
        showOnY2: false,
        chartType: report.getChartType().prototype.getDefaultSettings().chartType
      });
      if (model.getRollup() === "loadFactor") {
        model.setUnit(baja.Unit.NULL);
      } else {
        model.setUnit(unit);
      }
      model.setAnalyticTrendArray(trendArray);
      model.setAreaCfg(areaCfg);
      model.setDegreeDayCfg(degreeDayCfg);
      returnBaseModelArr.push(model);
    } else {
      var newObjArray = [];
      var trendArrayIterator = function trendArrayIterator(trend) {
        var valueObj = _.pick(trend, function (value, key, object) {
          return key.indexOf("value") !== -1;
        });
        var noValueObj = _.omit(trend, function (value, key, object) {
          return key.indexOf("value") !== -1;
        });
        _.each(_.keys(valueObj), function (key, index) {
          newObjArray[index].push(_.extend(_.clone(noValueObj), {
            value: valueObj[key]
          }));
        });
      };
      var newObjBuilder = function newObjBuilder(eachArr, index) {
        var model = new AnalyticsBaseDataModel({
          ord: nodeModel[group].nodeList[index].ord,
          seriesName: nodeModel[group].nodeList[index].name,
          daysToExclude: multiModel.$dow,
          interval: multiModel.$interval,
          isIntervalSelected: multiModel.$isIntervalSelected,
          rollup: multiModel.$rollup,
          isRollupSelected: multiModel.$isRollupSelected,
          aggregation: multiModel.$aggregation,
          isAggregationSelected: multiModel.$isAggregationSelected,
          brush: multiModel.$brush,
          brush2: multiModel.$brush2,
          midBrush: multiModel.$midBrush,
          data: multiModel.$data,
          dataFilter: multiModel.$dataFilter,
          timeRange: multiModel.$timeRange,
          unit: unit
        });
        model.setUnit(unit);
        model.setAnalyticTrendArray(eachArr);
        model.setAreaCfg(areaCfg);
        model.setDegreeDayCfg(degreeDayCfg);
        returnBaseModelArr.push(model);
      };
      for (var i = 0; i < valueCount; i++) {
        newObjArray[i] = [];
        _.each(trendArray, trendArrayIterator);
        _.each(newObjArray, newObjBuilder);
      }
    }
    return returnBaseModelArr;
  }

  /**
   * Get the model for baseline using the datasource configuration.
   * @param chart
   * @param dataSource
   * @param defaults
   */
  AnalyticsDataUtils.getBaselineModel = function (chart, dataSource, defaults) {
    if (dataSource && dataSource.baseline && dataSource.baseline.enabled) {
      var mainTimeRange = dataSource.timeRange.tr || defaults.timeRange;
      var baseline = dataSource.baseline,
        baselineTimeRange = baseline.timeRange;
      var nodeModel = dataSource.node,
        group = baseline.group,
        baselineNode = reportUtils.getBaselineNode(nodeModel, group);
      // baselineNode = nodeModel[baja.SlotPath.escape(group)];
      if (baselineNode) {
        return reportUtils.getDatesFromTimeRange(mainTimeRange).then(function (comp) {
          var st = comp.getStartTime(),
            et = comp.getEndTime();
          var obj = reportUtils.getBaselineDateTimes(st, et, baselineTimeRange, baseline);
          var encodedBlTr = obj.blSt.encodeToString() + ";" + obj.blEt.encodeToString();
          var nodeDetails = {
            color: baseline.color,
            nodeList: baselineNode.nodeList
          };
          var ndObj = {};
          ndObj[baja.SlotPath.unescape(baselineNode.dn)] = nodeDetails;
          var multiNodeBaselineModel = new AnalyticMultiNodeBaselineModel({
            dataSource: dataSource.type,
            seriesName: '',
            seriesNameBFormat: defaults.seriesNameBFormat,
            aggMode: dataSource.aggMode,
            data: dataSource.dataTag,
            nodeModel: ndObj,
            dataFilter: defaults.dataFilter,
            timeRange: encodedBlTr,
            daysToExclude: dataSource.timeRange.dow || defaults.dow,
            interval: dataSource.interval || defaults.interval,
            rollup: dataSource.rollup || defaults.rollup,
            aggregation: dataSource.aggregation || defaults.aggregation,
            brush: baselineNode.color,
            brush2: dataSource.colorRange && dataSource.colorRange.maxColor,
            midBrush: dataSource.colorRange && dataSource.colorRange.avgColor,
            unit: baja.$("baja:Unit").decodeFromString(dataSource.units),
            normalization: dataSource.normalization,
            hisTotEnabled: !dataSource.hisTotEnabled,
            areaTag: dataSource.areaTag,
            chartType: defaults.chartType,
            showOnY2: defaults.showOnY2,
            oatTag: dataSource.oatTag,
            missingDataCfg: dataSource.mdConfig || defaults.missingDataCfg
          });
          multiNodeBaselineModel.rebuildOrd(chart.getOrdScheme());
          multiNodeBaselineModel.setBaselineTimeRange(baselineTimeRange);
          return Promise.resolve(multiNodeBaselineModel);
        });
      }
    }
    return Promise.resolve(false);
  };

  /**
   * Register a drag  drop handler for the chart
   */
  AnalyticsDataUtils.getModel = function (chart, dataSource, defaults) {
    var promiseObj = null;
    // If the obtained data is of type file.
    if (dataSource && dataSource.getType && dataSource.getType().is(boxFileTypeSpec)) {
      var fileOrd = dataSource.getNavOrd().valueOf(); //Ord of the file
      var fileName = dataSource.getFileName();
      chart.$isFile = true;
      chart.$fileName = fileName;
      promiseObj = analyticsUtil.ajax(analyticsUtil.getFileUri(fileOrd), {
        type: "GET",
        contentType: "application/json",
        dataType: "json",
        async: false
      }).then(function (result) {
        // @Todo: Need to validate the JSON file and handle multiple ord binding
        var chartSettings = result.data;
        var configuration = result.settings.configuration;
        var modelArray = $.map(chartSettings, function (item) {
          colorIndex = colorIndex + 1;
          var unit = baja.$("baja:Unit").decodeFromString(item.$unit);
          return ModelFactory.newBaseDataModel(chart, {
            ord: item.$ord,
            seriesName: analyticsUtil.extractSlotInformation(item.$ord),
            daysToExclude: item.$daysToExclude || defaults.dow,
            seriesNameBFormat: item.$seriesNameBFormat,
            data: item.$data || defaults.data,
            dataFilter: item.$dataFilter || defaults.dataFilter,
            timeRange: item.$timeRange || defaults.timeRange,
            interval: item.$interval || defaults.interval,
            isIntervalSelected: item.$isIntervalSelected || false,
            rollup: item.$rollup || defaults.rollup,
            isRollupSelected: item.$isRollupSelected || false,
            aggregation: item.$aggregation || defaults.aggregation,
            isAggregationSelected: item.$isAggregationSelected || false,
            brush: getUniqueColor(item.$brush),
            brush2: item.$brush2 || colors((20 - colorIndex) % 20),
            midBrush: item.midBrush,
            dataSource: "file",
            dataSourceName: fileName,
            unit: unit,
            chartType: item.$chartType || defaults.chartType,
            showOnY2: item.$showOnY2 || defaults.showOnY2,
            hisTotEnabled: item.$hisTotEnabled,
            missingDataCfg: item.$missingDataCfg || defaults.missingDataCfg,
            baseline: item.$baseline || defaults.baseline
          });
        });
        return [modelArray, configuration];
      });
    } else if (dataSource && dataSource.getType && (
    // If the obtained data is of type table.
    dataSource.getType().is(boxTableTypeSpec) || dataSource.getType().is(analyticsStatusTypeSpec))) {
      var slotString;
      if (dataSource.getType().is(boxTableTypeSpec)) {
        slotString = dataSource.$tableData !== undefined ? dataSource.$tableData.req.o : dataSource.ord;
      } else if (dataSource.getType().is(analyticsStatusTypeSpec)) {
        slotString = dataSource.getOrdDisplay();
      }
      chart.isMultiNode = analyticsUtil.multiNodeTypeList.contains(analyticsUtil.returnTrend(slotString));
      if (chart.isMultiNode) {
        chart.isInitCommandBar = false;
        var model = AnalyticsDataUtils.extractDataFromMultiOrd(slotString);
        promiseObj = Promise.resolve([[model], {}]);
      } else {
        var chartSettings = AnalyticsDataUtils.extractDataFromOrd(slotString);
        colorIndex = colorIndex + 1;
        var unit = baja.$("baja:Unit").decodeFromString(chartSettings.$unit);
        // Update Baseline TimeRange based on Current Time if Baseline Enabled
        var mainTimeRange = chartSettings.timeRange || defaults.timeRange;
        promiseObj = reportUtils.getDatesFromTimeRange(mainTimeRange).then(function (comp) {
          if (chartSettings.baseline && chartSettings.baseline.baselineEnabled) {
            var st = comp.getStartTime(),
              et = comp.getEndTime();
            var obj = reportUtils.getChartBaselineDateTimes(st, et, chartSettings.baseline.baselineTimeRangeEnum, chartSettings.baseline);
            chartSettings.baseline.baselineStartTime = obj.blSt.encodeToString();
            chartSettings.baseline.baselineEndTime = obj.blEt.encodeToString();
          }
        }).then(function () {
          var model = ModelFactory.newBaseDataModel(chart, {
            ord: chartSettings.ord,
            seriesName: analyticsUtil.extractSlotInformation(chartSettings.ord),
            daysToExclude: chartSettings.dow || defaults.dow,
            seriesNameBFormat: chartSettings.seriesNameBFormat || defaults.seriesNameBFormat,
            data: chartSettings.data || defaults.data,
            dataFilter: decodeURIComponent(chartSettings.dataFilter || defaults.dataFilter),
            timeRange: chartSettings.timeRange || defaults.timeRange,
            interval: chartSettings.interval || defaults.interval,
            isIntervalSelected: chartSettings.interval !== undefined,
            rollup: chartSettings.rollup || defaults.rollup,
            isRollupSelected: chartSettings.rollup !== undefined,
            aggregation: chartSettings.aggregation || defaults.aggregation,
            isAggregationSelected: chartSettings.aggregation !== undefined,
            brush: getUniqueColor(chartSettings.brush),
            brush2: chartSettings.brush2 || colors((20 - colorIndex) % 20),
            midBrush: chartSettings.midBrush,
            dataSource: "analyticBinding",
            uniqueKey: chartSettings.uniqueKey,
            unit: unit,
            hisTotEnabled: !chartSettings.hisTotEnabled,
            chartType: defaults.chartType,
            showOnY2: defaults.showOnY2,
            missingDataCfg: chartSettings.missingDataCfg || defaults.missingDataCfg,
            baseline: chartSettings.baseline || defaults.baseline
          });
          model.setOrd(analyticsUtil.getReconstructedOrd(model));
          return [[model], {}];
        });
      }
    } else if (dataSource && dataSource.ord !== undefined) {
      // In case of a plain component drop
      colorIndex = colorIndex + 1;
      var ord = dataSource.ord;
      ord = ord + "|" + chart.getDefaultOrdScheme();
      var _model = chart.chartModelList[0];
      var analyticBaseModel = ModelFactory.newBaseDataModel(chart, {
        ord: ord,
        daysToExclude: defaults.dow,
        dataSource: "dragDrop",
        seriesName: analyticsUtil.extractSlotInformation(dataSource.ord),
        seriesNameBFormat: defaults.seriesNameBFormat,
        data: _model.getData(),
        dataFilter: _model.getDataFilter(),
        timeRange: _model.getTimeRange(),
        interval: _model.getInterval(),
        rollup: _model.getRollup(),
        aggregation: _model.getAggregation(),
        brush: getUniqueColor(undefined, chart.series),
        brush2: colors((20 - colorIndex) % 20),
        // midBrush: colors((20 - colorIndex) % 20),
        unit: _model.getUnit(),
        hisTotEnabled: _model.getHisTotEnabled(),
        chartType: defaults.chartType,
        showOnY2: defaults.showOnY2,
        missingDataCfg: defaults.missingDataCfg
      });
      analyticBaseModel.rebuildOrd();
      promiseObj = Promise.resolve([[analyticBaseModel], {}]);
    } else if (dataSource.getNavOrd && dataSource.getNavOrd() !== undefined) {
      var navOrd = dataSource.getNavOrd().encodeToString();
      navOrd = navOrd + "|" + chart.getDefaultOrdScheme();
      colorIndex = colorIndex + 1;
      var _analyticBaseModel = ModelFactory.newBaseDataModel(chart, {
        ord: navOrd,
        dataSource: "webBinding",
        daysToExclude: defaults.dow,
        seriesName: analyticsUtil.extractSlotInformation(navOrd),
        seriesNameBFormat: defaults.seriesNameBFormat,
        data: defaults.data,
        dataFilter: defaults.dataFilter,
        timeRange: defaults.timeRange,
        interval: defaults.interval,
        rollup: defaults.rollup,
        aggregation: defaults.aggregation,
        brush: getUniqueColor(undefined),
        brush2: colors((20 - colorIndex) % 20),
        // midBrush: colors((20 - colorIndex) % 20),
        unit: dataSource.units,
        hisTotEnabled: defaults.hisTotEnabled,
        chartType: defaults.chartType,
        showOnY2: defaults.showOnY2,
        missingDataCfg: defaults.missingDataCfg
      });
      _analyticBaseModel.rebuildOrd();
      promiseObj = Promise.resolve([[_analyticBaseModel], {}]);
    } else if (dataSource.type && dataSource.reportName === "AggregationReport") {
      var combinationMap = dataSource.combinationMap;
      var chartValue = dataSource.chartValue;
      var models = [],
        // Move the chartValue to the first index of the array.
        combinationKeys = AnalyticsDataUtils.moveKeyToFirstIndex(_.keys(combinationMap), chartValue);
      _.each(combinationKeys, function (key) {
        _.each(combinationMap[key], function (value) {
          var units = value.unit;
          units = units instanceof baja.Unit ? units : baja.$("baja:Unit").decodeFromString(units);
          var analyticsMultiNodeDataModel = ModelFactory.newBaseDataModel(chart, {
            dataSource: dataSource.type,
            seriesName: '',
            seriesNameBFormat: defaults.seriesNameBFormat,
            aggMode: dataSource.aggMode,
            data: value.tag,
            nodeModel: JSON.parse(JSON.stringify(dataSource.node)),
            dataFilter: dataSource.dataFilter || defaults.dataFilter,
            timeRange: dataSource.timeRange.tr || defaults.timeRange,
            daysToExclude: dataSource.timeRange.dow || defaults.dow,
            interval: dataSource.interval || defaults.interval,
            rollup: key || defaults.rollup,
            aggregation: dataSource.aggregation || defaults.aggregation,
            brush: dataSource.colorRange && dataSource.colorRange.minColor,
            brush2: dataSource.colorRange && dataSource.colorRange.maxColor,
            midBrush: dataSource.colorRange && dataSource.colorRange.avgColor,
            unit: units,
            normalization: dataSource.normalization,
            hisTotEnabled: !dataSource.hisTotEnabled,
            areaTag: dataSource.areaTag,
            oatTag: dataSource.oatTag,
            chartType: defaults.chartType,
            showOnY2: defaults.showOnY2,
            missingDataCfg: dataSource.mdConfig || defaults.missingDataCfg
          });
          analyticsMultiNodeDataModel.rebuildOrd(chart.getOrdScheme());
          models.push(analyticsMultiNodeDataModel);
        });
      });
      promiseObj = Promise.resolve([models, ModelFactory.newConfigModel(chart.getChartType(), {
        legendPosition: dataSource.legendPosition
      })]);
    } else if (dataSource.type && dataSource.type === "report") {
      var units = dataSource.units;
      units = units instanceof baja.Unit ? units : baja.$("baja:Unit").decodeFromString(units);
      var analyticsMultiNodeDataModel = ModelFactory.newBaseDataModel(chart, {
        dataSource: dataSource.type,
        seriesName: '',
        seriesNameBFormat: defaults.seriesNameBFormat,
        aggMode: dataSource.aggMode,
        data: dataSource.dataTag,
        nodeModel: dataSource.node,
        dataFilter: dataSource.dataFilter || defaults.dataFilter,
        timeRange: dataSource.timeRange.tr || defaults.timeRange,
        daysToExclude: dataSource.timeRange.dow || defaults.dow,
        interval: dataSource.interval || defaults.interval,
        rollup: dataSource.rollup || defaults.rollup,
        aggregation: dataSource.aggregation || defaults.aggregation,
        brush: dataSource.colorRange && dataSource.colorRange.minColor,
        brush2: dataSource.colorRange && dataSource.colorRange.maxColor,
        midBrush: dataSource.colorRange && dataSource.colorRange.avgColor,
        unit: units,
        normalization: dataSource.normalization,
        hisTotEnabled: !dataSource.hisTotEnabled,
        areaTag: dataSource.areaTag,
        oatTag: dataSource.oatTag,
        chartType: defaults.chartType,
        showOnY2: defaults.showOnY2,
        missingDataCfg: dataSource.mdConfig || defaults.missingDataCfg
      });
      analyticsMultiNodeDataModel.rebuildOrd(chart.getOrdScheme());
      promiseObj = Promise.resolve([analyticsMultiNodeDataModel, ModelFactory.newConfigModel(chart.getChartType(), {
        legendPosition: dataSource.legendPosition
      })]);
    } else {
      var analyticBaseModelDef = ModelFactory.newBaseDataModel(chart, {
        ord: '',
        dataSource: "emptyInstantiation",
        seriesName: '',
        seriesNameBFormat: defaults.seriesNameBFormat,
        daysToExclude: defaults.dow,
        data: defaults.data,
        dataFilter: defaults.dataFilter,
        timeRange: defaults.timeRange,
        interval: defaults.interval,
        rollup: defaults.rollup,
        aggregation: defaults.aggregation,
        brush: getUniqueColor(undefined),
        brush2: colors((20 - colorIndex) % 20),
        midBrush: colors((20 - colorIndex) % 20),
        hisTotEnabled: defaults.hisTotEnabled,
        chartType: defaults.chartType,
        showOnY2: defaults.showOnY2,
        missingDataCfg: defaults.missingDataCfg
      });
      analyticBaseModelDef.rebuildOrd();
      promiseObj = Promise.resolve([[analyticBaseModelDef], {}]);
    }
    if (chart.isMultiBindingSupported && !chart.isMultiBindingSupported()) {
      // Don't reassign the model.
      //This model reference is being used by the command bar. Reassigning this to empty array
      //will cause the command bar to not reflect changes.
      //TODO Refactor command bar to remove the dependency.
      chart.chartModelList.splice(0, 1);
    }
    return promiseObj;
  };

  /**
   * Get the Chart data based on the collection of chart settings passed.
   * @param chartSettingsColl
   */
  AnalyticsDataUtils.getMultiOrdTableData = function (chartSettingsModel) {
    var model = chartSettingsModel;
    model.setAnalyticTrendArray([]);
    var analyticTrendArray = model.getAnalyticTrendArray();
    var isFirst = true;
    function getSeriesNames(chunks) {
      var seriesNameList = [];
      if (chunks.length > 0) {
        var firstChunk = JSON.parse(chunks[0]);
        var obj = firstChunk.v;
        _.each(obj, function (inOb, index) {
          var sn = inOb.sn || "Series " + index;
          seriesNameList.push(sn);
        });
      }
      return seriesNameList;
    }
    var seriesNameList = [];
    var progress = function progress(chunks) {
      if (isFirst) {
        seriesNameList = getSeriesNames(chunks);
        isFirst = false;
      }
      handleMultiSeriesChunks(chunks, analyticTrendArray, model, seriesNameList);
    };
    return chunkUtil.ajax("/analytics/aquery/boxTable/" + baja.SlotPath.escape(model.getOrd()), {
      progress: progress
    }).then(progress).then(function () {
      model.setAnalyticTrendArray(analyticTrendArray);
      return model;
    });
  };

  /**
   * Re usable method to handle the chunked data.
   * @param chunks
   * @param enterOnce
   * @param analyticTrendArray
   * @param model
   * @return {*}
   */
  function handleMultiSeriesChunks(chunks, analyticTrendArray, model, seriesNameList) {
    _.each(chunks, function (obj, index) {
      obj = JSON.parse(obj);
      if (!(obj.type && obj.type === "err")) {
        var timestamp,
          timeStampValue,
          trendFlags,
          interpolationStatus,
          units,
          tableRow = {};
        units = baja.$("baja:Unit").decodeFromString(obj.u);
        timeStampValue = baja.$("baja:AbsTime").decodeFromString(obj.t);
        timestamp = timeStampValue.getJsDate();
        tableRow.Timestamp = timestamp;
        _.each(obj.v, function (inOb, index) {
          var seriesName = seriesNameList[index];
          trendFlags = parseInt(inOb.r === undefined ? "0" : inOb.r);
          interpolationStatus = analyticsUtil.decodeTrendFlag(trendFlags);
          tableRow[seriesName + "\n" + "Value" + (units.toString() === "null" ? '' : ' (' + units.toString() + ')')] = inOb.v;
          tableRow[seriesName + "\n" + "InterpolationStatus"] = interpolationStatus;
          tableRow[seriesName + "\n" + "Status"] = baja.$("baja:Status").make(inOb.s).toString();
        });
        analyticTrendArray.push(tableRow);
      }
    });
    return analyticTrendArray;
  }

  /**
   * Re usable method to handle the chunked data.
   * @param chunks
   * @param enterOnce
   * @param analyticTrendArray
   * @param model
   * @return {*}
   */
  function handleChunks(chunks, enterOnce, analyticTrendArray, model) {
    _.each(chunks, function (obj, index) {
      var jsonObj = JSON.parse(obj);
      if (!(jsonObj.type && jsonObj.type === "err")) {
        var timestamp, timeStampValue, trendFlags, interpolationStatus;
        if (enterOnce.value) {
          model.setUnit(baja.$("baja:Unit").decodeFromString(jsonObj.u));
          model.setSeriesName(jsonObj.sn);
          enterOnce.value = false;
        }
        timeStampValue = baja.$("baja:AbsTime").decodeFromString(jsonObj.t);
        timestamp = timeStampValue.getJsDate();
        trendFlags = parseInt(jsonObj.r);
        interpolationStatus = analyticsUtil.decodeTrendFlag(trendFlags);
        var trendRecord = new AnalyticTrendRecord(timestamp, baja.$("baja:Status").make(jsonObj.s).toString(), jsonObj.v, timeStampValue, trendFlags, interpolationStatus);
        analyticTrendArray.push(trendRecord);
      }
    });
    return analyticTrendArray;
  }

  /**
   * Get the Chart data based on the collection of chart settings passed.
   * @param chartSettingsColl
   */
  AnalyticsDataUtils.getTableData = function (chartSettingsModel) {
    var model = chartSettingsModel;
    model.setAnalyticTrendArray([]);
    var analyticTrendArray = model.getAnalyticTrendArray(),
      enterOnce = {
        value: true
      };
    var progress = function progress(chunks) {
      return handleChunks(chunks, enterOnce, analyticTrendArray, model);
    };
    return chunkUtil.ajax("/analytics/aquery/boxTable/" + baja.SlotPath.escape(model.getOrd()), {
      progress: progress
    }).then(progress).then(function () {
      model.setAnalyticTrendArray(analyticTrendArray);
      return model;
    });
  };

  /**
   * Get the chart data based on collection of settings passed.
   * @param multiNodeModel
   */
  AnalyticsDataUtils.getDataForMultiNode = function (multiNodeModel) {
    var model = multiNodeModel,
      groupListModel = multiNodeModel.getNodeModel();

    // Each of the groups is a combination of multiple nodes
    // Iterate over each group and consolidate the trend and
    var groups = _.keys(groupListModel); // Each of the group names
    var promiseList = [],
      appendServletStr = "/analytics/aquery/boxTable/";
    var normalizations = multiNodeModel.getNormalizations();
    var isNormalizationApplicable = multiNodeModel.isUnitBasedCombination();
    var areaNormalizationReq = false;
    var degreeDayNormalizationReq = false;
    var degDayUnits = 1;
    if (isNormalizationApplicable && normalizations && normalizations.length > 0) {
      for (var index = 0; index < normalizations.length; index++) {
        var n = normalizations[index];
        if (n.selected && n.type === "area") {
          areaNormalizationReq = true;
        } else if (n.selected && n.type === "degreeday") {
          degreeDayNormalizationReq = true;
          if (n.unit) {
            degDayUnits = n.unit;
          }
        }
      }
    }
    _.each(groups, function (group) {
      // Get the config for each of the groups
      var groupConfig = groupListModel[group];
      var dataOrd = groupConfig.ord;
      if (areaNormalizationReq) {
        var areaValue = 0,
          areaUnits = baja.Unit.NULL,
          areaOrd = analyticsUtil.getAreaValueOrd(groupConfig, "analyticmultitrend", multiNodeModel.getAreaTag());
        groupConfig.areaCfg = {
          req: false
        };
        var areaRetrievalPromise = baja.Ord.make(areaOrd).get({
          cursor: {
            each: function each(obj, index) {
              var facets = obj.getFacets("value");
              if (facets) {
                areaUnits = facets.get("units") || areaUnits;
              }
              areaValue = obj.getValueOf("value");
            }
          }
        }).then(function () {
          groupConfig.areaCfg = $.extend(groupConfig.areaCfg, {
            req: true,
            value: areaValue,
            units: areaUnits
          });
          return Promise.resolve(groupConfig);
        })["catch"](function (e) {
          groupConfig.areaCfg = {
            req: false
          };
        });
        promiseList.push(areaRetrievalPromise);
      }
      if (degreeDayNormalizationReq) {
        var oatValues = {},
          oatUnits = "",
          oatOrd = analyticsUtil.getOatValueOrd(groupConfig, "analyticDegreeDayTrend", multiNodeModel.getOatTag(), degDayUnits);
        if (oatOrd === undefined || oatOrd.length === 0) {
          groupConfig.degreeDayCfg = {
            req: false
          };
        } else {
          groupConfig.degreeDayCfg.req = true;
          var timestamp, timeStampValue;
          var degreeDayPromise = baja.Ord.make(oatOrd).get({
            cursor: {
              each: function each(obj, index) {
                var facets = obj.getFacets("value");
                if (facets) {
                  var u = facets.get("units");
                  oatUnits = u && u.getUnitName() !== 'null' ? u : oatUnits;
                }
                timeStampValue = obj.getValueOf('timestamp');
                timestamp = timeStampValue.getJsDate();
                oatValues[timestamp.getTime()] = obj.getValueOf("value");
              },
              limit: -1
            }
          }).then(function () {
            groupConfig.degreeDayCfg.req = true;
            groupConfig.degreeDayCfg.oatValues = oatValues;
            groupConfig.degreeDayCfg.oatUnits = oatUnits;
            return Promise.resolve(groupConfig);
          })["catch"](function (e) {
            groupConfig.degreeDayCfg = {
              req: false
            };
            logSevere(e);
          });
          promiseList.push(degreeDayPromise);
        }
      }
      var analyticTrendArray = [],
        enterOnce = {
          value: true
        };
      var progress = function progress(chunks) {
        return handleChunks(chunks, enterOnce, analyticTrendArray, model);
      };
      var dataRetrievalPromise = chunkUtil.ajax(appendServletStr + baja.SlotPath.escape(dataOrd), {
        progress: progress
      }).then(progress).then(function () {
        // The last of the chunks come to then as opposed to each. handle them deftly
        groupConfig.analyticTrendArray = analyticTrendArray;
        return groupConfig;
      })["catch"](logSevere);
      promiseList.push(dataRetrievalPromise);
    });
    return Promise.all(promiseList).then(function () {
      return multiNodeModel;
    });
  };

  /**
   * Get the Chart data based on the collection of chart settings passed.
   * @param chartSettingsModel
   */
  AnalyticsDataUtils.getChartData = function (chartSettingsModel) {
    var model = chartSettingsModel;
    model.setAnalyticTrendArray([]);
    model.setAnalyticChartBaselineTrendArray([]);
    var analyticTrendArray = model.getAnalyticTrendArray(),
      enterOnce = {
        value: true
      };
    var progress = function progress(chunks) {
      return handleChunks(chunks, enterOnce, analyticTrendArray, model);
    };
    return chunkUtil.ajax("/analytics/aquery/boxTable/" + baja.SlotPath.escape(model.getOrd()), {
      progress: progress
    }).then(progress).then(function () {
      doBaselineTrendPartition(analyticTrendArray, model);
      return model;
    })["catch"](logSevere);
  };
  function doBaselineTrendPartition(analyticTrendArray, model) {
    var analyticChartTrendArray = [],
      analyticBaselineTrendArray = [],
      BASELINE_FLAG = 8;
    if (model.getBaseline() && model.getBaseline().baselineEnabled) {
      for (var i = 0; i < analyticTrendArray.length; i++) {
        if ((analyticTrendArray[i].trendFlags & BASELINE_FLAG) === BASELINE_FLAG) {
          analyticBaselineTrendArray.push(analyticTrendArray[i]);
        } else {
          analyticChartTrendArray.push(analyticTrendArray[i]);
        }
      }
      model.setAnalyticChartBaselineTrendArray(analyticBaselineTrendArray);
      model.setAnalyticTrendArray(analyticChartTrendArray);
    } else {
      model.setAnalyticTrendArray(analyticTrendArray);
    }
  }
  AnalyticsDataUtils.extractDataFromMultiOrd = function (inputOrd) {
    var hasTrend = analyticsUtil.returnTrend(inputOrd);
    var stringArray = inputOrd.split(hasTrend),
      multiOrd,
      ob = {},
      secondHalf,
      ob1;
    ob.ord = inputOrd;
    if ((stringArray[1].indexOf('multiOrd=') !== -1 ? multiOrd = "multiOrd" : false) || (stringArray[1].indexOf('multiord=') !== -1 ? multiOrd = "multiord" : false)) {
      ob[multiOrd] = [];
      secondHalf = stringArray[1].replace(multiOrd + "=", "").replace("[", "").replace("]", "");
      var multiOrdArray = secondHalf.split(",");
      ob1 = {};
      _.each(multiOrdArray, function (ea) {
        var attributeArray = ea.split("&");
        _.each(attributeArray, function (attr) {
          var attrSplit = attr.split("=");
          ob1[attrSplit[0]] = attrSplit[1];
          if (attrSplit[0] === "seriesName") {
            ob1.seriesNameBFormat = attrSplit[1];
          }
          if (attrSplit[0] === "dow") {
            ob1.daysToExclude = attrSplit[1].split("dow")[1];
          }
        });
        ob[multiOrd].push(ob1);
      });
      return new AnalyticsMultiOrdDataModel(ob);
    } else {
      var attributesArray = stringArray[1].split("&");
      for (var i = 0; i < attributesArray.length; i++) {
        var attrSplitArray = attributesArray[i].split("=");
        if (attrSplitArray[1].indexOf(",") !== -1) {
          ob[attrSplitArray[0]] = attrSplitArray[1].split(",");
        } else {
          ob[attrSplitArray[0]] = attrSplitArray[1];
        }
        if (attrSplitArray[0] === "seriesName") {
          ob.seriesNameBFormat = attrSplitArray[1];
        }
        if (attrSplitArray[0] === "dow") {
          ob.daysToExclude = attrSplitArray[1].split("dow")[1];
        }
      }
      return new AnalyticsMultiNodeDataModel(ob);
    }
  };

  /**
   * Utility method to extract data from inputOrd.
   * @param inputOrd
   * @returns {Object}
   */
  AnalyticsDataUtils.extractDataFromOrd = function (inputOrd) {
    var hasTrend = analyticsUtil.returnTrend(inputOrd);
    if (hasTrend === undefined) {
      hasTrend = "analytictrend:";
    }
    var stringArray = inputOrd.split(hasTrend);
    var myObj = {};
    myObj.daysToExclude = 0;
    if (stringArray.length >= 2) {
      var attributesArray = stringArray[1].split("&");
      for (var i = 0; i < attributesArray.length; i++) {
        var attrSplitArray = attributesArray[i].split("=");
        switch (attrSplitArray[0]) {
          case "seriesName":
            myObj.seriesNameBFormat = attrSplitArray[1];
            break;
          case "dow":
            myObj.daysToExclude = attrSplitArray[1].split("dow")[1];
            break;
          case "hisTotEnabled":
            var inHist = attrSplitArray[1];
            myObj.hisTotEnabled = inHist === "true";
            break;
          case "aggStrategy":
          case "intpAlgorithm":
          case "knnValue":
            if (!myObj.missingDataCfg) {
              myObj.missingDataCfg = {
                enabled: true
              };
            }
            myObj.missingDataCfg[attrSplitArray[0]] = attrSplitArray[1];
            break;
          case "dataFilter":
            myObj.dataFilter = attributesArray[i].split(/=(.+)/)[1];
            break;
          case "baselineEndTimeEnabled":
          case "baselineAlignDOW":
            if (!myObj.baseline) {
              myObj.baseline = {
                baselineEnabled: true
              };
            }
            myObj.baseline[attrSplitArray[0]] = attrSplitArray[1] === "true";
            break;
          case "baselineTimeRange":
            if (!myObj.baseline) {
              myObj.baseline = {
                baselineEnabled: true
              };
            }
            var startEndArray = decodeURIComponent(attrSplitArray[1]).split(";");
            myObj.baseline.baselineStartTime = startEndArray[0];
            myObj.baseline.baselineEndTime = startEndArray[1];
            break;
          case "baselineTimeRangeEnum":
            if (!myObj.baseline) {
              myObj.baseline = {
                baselineEnabled: true
              };
            }
            if (!myObj.baseline.baselineColor) {
              myObj.baseline.baselineColor = "#000000";
            }
            myObj.baseline[attrSplitArray[0]] = decodeURIComponent(attrSplitArray[1]);
            break;
          default:
            myObj[attrSplitArray[0]] = decodeURIComponent(attrSplitArray[1]);
            break;
        }
      }
      myObj.ord = inputOrd;
    } else {
      myObj.data = "n:history";
      myObj.timeRange = "today";
      myObj.interval = "hour";
      myObj.daysToExclude = "DOW0";
      myObj.seriesNameBFormat = "%node.navDisplayName%-%data.name%";
      myObj.ord = inputOrd + "|" + hasTrend + "data=" + myObj.data + "&" + "timeRange=" + myObj.timeRange + "&" + "interval=" + myObj.interval + "&" + "seriesName=" + myObj.seriesNameBFormat + "&" + "dow=" + myObj.daysToExclude + "&" + "histTotEnabled=" + myObj.hisTotEnabled;
    }
    return myObj;
  };

  /**
   * Exports the analytic data rendered by chart/table.
   * @param {String} type - Specifies the type of export.
   * @param {baja:Component} optionInfo - It is provided as an input from ExportWizardCommand, it has information about the exported type.
   * @param {Object} model - Data and config models.
   * @param {module:nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel[]} model.dataModel - Series of data model(s) of the chart/table.
   * @param {module:nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel} model.configModel - Configuration model of the chart/table
   * @return {(Promise.<string>)} Returns a Promise for a CSV/JSON for chart extensions.
   * @throws Will throw an error if the exported type is unknown.
   */
  AnalyticsDataUtils.getExportData = function (type, optionInfo, model) {
    if (type === "csv") {
      // Pass the delimiter ',' and a true flag to include headers.
      var metaData = {
        delimiter: ",",
        includeHeaders: true,
        precision: optionInfo.get('precision')
      };
      return new TableModelToCsv().transform(AnalyticsDataUtils.formatForCsvExport(optionInfo, model), metaData);
    } else if (type === "achart" || type === "rcchart" || type === "ldchart" || type === "apchart" || type === "rnkchart" || type === "aggchart" || type === "aggchart" || type === "atable" || type === "awchart" || type === "eqopchart") {
      return Promise.resolve(JSON.stringify(AnalyticsDataUtils.makeJson(model)));
    } else {
      throw new Error("Export type unknown:" + type);
    }
  };

  /**
   * Returns the exportable TableModel for the input chart/table data.
   * @param {baja:Component} optionInfo - It is provided as an input from ExportWizardCommand, it has information about the exported type.
   * @param {Object} model - data and config models.
   * @param {module:nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel[]} model.dataModel - Series of data model(s) of the chart/table.
   * @param {module:nmodule/analytics/rc/chart/base/AnalyticsTabConfigBaseModel} model.configModel - Configuration model of the chart/table
   * @return {module:nmodule/webEditors/rc/wb/table/model/TableModel} tableModel - Analytics data and config data encapsulated in a TableModel.
   */
  AnalyticsDataUtils.formatForCsvExport = function (optionInfo, model) {
    var keysToExclude = ['timestamp', 'seriesName', 'date', 'status', 'totalMins', 'ts', 'trendFlags'];

    // Include status if the request has status in it.
    if (optionInfo.get("statusColumn")) {
      keysToExclude = _.without(keysToExclude, 'status');
    }

    // Format the incoming analytic data as columns and rows.
    var tableData = analyticsUtil.formatDataAsColsAndRows(model, keysToExclude);

    // Convert the columns and rows to a JsonObjectPropertyColumn.
    var columns = _.map(tableData.columns, function (colName, index) {
      return new JsonObjectPropertyColumn(index.toString(), {
        displayName: colName
      });
    });

    // Return the table model filled with analytic data.
    return new TableModel({
      columns: columns,
      rows: tableData.rows
    });
  };

  /**
   * Overriden make json method will create a chart json.
   */
  AnalyticsDataUtils.makeJson = function (chart) {
    var chartJson = {
        version: lex.get('spectrumChartVersion'),
        type: lex.get('spectrumChartType'),
        settings: {},
        data: []
      },
      chartSettingsCollection = chart.dataModel;
    chartJson.settings.configuration = chart.configModel;
    for (var ind = 0; ind < chartSettingsCollection.length; ind++) {
      var chartModel = $.extend(true, {}, chartSettingsCollection[ind]);
      chartModel.setUnit(chartModel.getUnit().encodeToString());
      chartModel.setAnalyticTrendArray([]);
      chartModel.setAnalyticChartBaselineTrendArray([]);
      chartJson.data.push(chartModel);
    }
    return chartJson;
  };

  /**
   * Check if time range is valid
   * @param timeRangeStr
   * @returns {boolean}
   */
  AnalyticsDataUtils.isValidTimeRange = function (timeRangeStr) {
    return timeRangeStr !== "from" && timeRangeStr !== "previous" && timeRangeStr !== "current" && timeRangeStr !== "timeRange";
  };

  /**
   *
   * @param chartModelList
   * @param chartModel
   */
  AnalyticsDataUtils.isOrdExists = function (chartModelList, modelArray) {
    var model = modelArray[0];
    var findChart = _.find(chartModelList, function (chartModel) {
      if (chartModel.getUniqueKey() && model.getUniqueKey() && chartModel.getUniqueKey() === model.getUniqueKey()) {
        return true;
      }
    });
    return findChart;
  };

  /**
   * Returns true if file type is found.
   * @param chartModel
   */
  AnalyticsDataUtils.isFile = function (chartModelArray) {
    if (_.isArray(chartModelArray) && !_.isEmpty(chartModelArray)) {
      return chartModelArray[0].getDataSource() === "file";
    }
    return chartModelArray.getDataSource() === "file";
  };

  /**
   * Converts a MultiNodeDataModel to BaseDataModel
   * @param inputObj
   */
  AnalyticsDataUtils.convertMultiNodeToTrendData = function (report, inModel) {
    var returnArr = [];
    var nodeModel = inModel.getNodeModel();
    _.each(_.keys(nodeModel), function (group) {
      var containCount = containsMoreValues(nodeModel[group].analyticTrendArray);
      returnArr.push.apply(returnArr, breakOneModelToMany(report, inModel, nodeModel, group, containCount));
    });
    // Create the configuration model and put in back the returned array.
    return returnArr;
  };

  /**
   *
   * @param modelArray
   */
  AnalyticsDataUtils.convertMultiPartData = function (report, modelArray) {
    var inPromiseArray = [];
    _.each(modelArray, function (multiNode) {
      inPromiseArray.push(AnalyticsDataUtils.getDataForMultiNode(multiNode).then(function (modelArray) {
        return Promise.resolve(AnalyticsDataUtils.convertMultiNodeToTrendData(report, modelArray));
      }));
    });
    return Promise.all(inPromiseArray).then(function (values) {
      var arr = [];
      _.each(values, function (val) {
        arr.push.apply(arr, val);
      });
      return arr;
    });
  };

  /**
   * Preps data for aggregation report.
   * @param chartSettingsCollection
   * @param combinationMap
   * @returns {*}
   */
  AnalyticsDataUtils.wrapDataForAggMultiChart = function (chartSettingsCollection, combinationMap) {
    var grpArray = [];
    _.each(chartSettingsCollection, function (model) {
      var inMemArr = [];
      _.each(model.getAnalyticTrendArray(), function (trend) {
        var inObj = {};
        inObj[model.getRollup()] = trend.value;
        inObj.date = moment(trend.date.getJsDate()).format(baja.getTimeFormatPattern());
        inObj[model.getRollup() + "interpolationStatus"] = trend.interpolationStatus;
        inMemArr.push(inObj);
      });
      grpArray.push.apply(grpArray, inMemArr);
    });
    var wrappedObj = _.groupBy(grpArray, function (trend) {
      return trend.date;
    });

    // This each could be optimized.
    _.each(_.keys(wrappedObj), function (key) {
      var inVal = {};
      _.each(wrappedObj[key], function (inArr) {
        $.extend(inVal, inArr);
      });
      wrappedObj[key] = inVal;
    });
    return _.values(wrappedObj);
  };

  /**
   * Moves the selected key to first index.
   * If the selected key is not found, then actual array would be returned.
   * @param arr
   * @param selKey
   * @returns {Array}
   */
  AnalyticsDataUtils.moveKeyToFirstIndex = function (arr, selKey) {
    var selKeyIndex = _.indexOf(arr, selKey);
    var finArray = [];
    if (selKeyIndex !== -1) {
      finArray.push(arr[selKeyIndex]);
    }
    finArray.push.apply(finArray, _.without(arr, selKey));
    return finArray;
  };
  AnalyticsDataUtils.addInterpolationStatusForKey = function (keys) {
    var retArr = [];
    _.each(keys, function (key) {
      retArr.push(key);
      retArr.push(key + "interpolationStatus");
    });
    return retArr;
  };
  return AnalyticsDataUtils;
});
