/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by e877411 on 10/20/2016.
 */

define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'jquery', 'd3', 'nmodule/analytics/rc/chart/types/AnalyticChartType'], function (baja, Widget, subscriberMixIn, $, d3, AnalyticChartType) {
  "use strict";

  /**
   * @constructor
   * Base view for all web analytics charts
   */
  var AnalyticD3LineChart = function AnalyticD3LineChart(params) {
    AnalyticChartType.apply(this, params);
    //subscriberMixIn(this);
  };
  // Inheriting Analytics Base Chart from AnalyticD3BaseChart
  AnalyticD3LineChart.prototype = Object.create(AnalyticChartType.prototype);
  // Setting the constructor
  AnalyticD3LineChart.prototype.constructor = AnalyticD3LineChart;

  /**
   * Render the pie
   * @param chartSettingsCollection
   */

  AnalyticD3LineChart.prototype.draw = function (baseChart, series) {
    var svg = baseChart.svg();
    function x(d) {
      return baseChart.xScale(d.x);
    }
    function y(d) {
      return baseChart.yScale(d.y);
    }
    var lineGenerator = d3.line().x(x).y(y);
    var wrapper = svg.append("g").attr('class', 'line-container-overlay-group');
    series.map(function (ser) {
      wrapper.append('path').attr('d', lineGenerator(ser.data)).attr('sn', ser.name).attr('unit', ser.unit).attr('stroke', ser.color).attr('stroke-width', 2).attr('fill', 'none');
    });
    series.map(function (ser) {
      if (baseChart.isDebugEnabled) {
        wrapper.append("g").selectAll("circle").data(ser.data).enter().append("circle").attr("cx", x).attr("cy", y).attr("r", 4).attr("fill", "white").attr("stroke", ser.color).attr("stroke-width", 1).attr('debugValue', function (d) {
          return d.x + ";" + d.y + (["null", undefined].contains(ser.unitSymbol) ? "" : ";" + ser.unitSymbol);
        });
      } else {
        wrapper.append("g").selectAll("circle").data(ser.data).enter().append("circle").attr("cx", x).attr("cy", y).attr("r", 4).attr("fill", "white").attr("stroke", ser.color).attr("stroke-width", 1);
      }
    });
    return wrapper;
  };
  AnalyticD3LineChart.prototype.toolTip = function (baseChart, ele) {
    var tooltipDiv = baseChart.getToolTipDiv();
    var width = baseChart.availableWidth();
    var height = baseChart.availableHeight();
    var toolTipInitialized = false;
    /**
     * Draw the line that corresponds to the X value for line chart
     * @param mousePosition
     */
    function drawToolTipPositionIndicator(mousePosition) {
      tooltipDiv.transition().duration(200).style("opacity", 0.9);
      ele.append("path").attr("class", "indicator").attr('d', "M " + mousePosition[0] + " 0" + " L " + mousePosition[0] + " " + height).attr('stroke', "#000000").attr('stroke-width', 2).attr('fill', 'none');
      toolTipInitialized = true;
    }
    ele.on("mouseenter", function (event, d) {
      var mousePosition = d3.pointer(event, this);
      if (!toolTipInitialized) {
        var xValue = baseChart.xScale.invert(mousePosition[0] < 0 ? 0 : mousePosition[0]);
        var minObj = baseChart.getBisectData(xValue) || {
          data: NaN
        };
        if (!isNaN(minObj.data)) {
          drawToolTipPositionIndicator(mousePosition);
        }
      }
    }).on("mousemove", function (event, d) {
      var mousePosition = d3.pointer(event, this);
      if (mousePosition[0] > width) {
        return;
      }

      // If the mouse position is below zero, then return the inverted scale of zero.
      var xValue = baseChart.xScale.invert(mousePosition[0] < 0 ? 0 : mousePosition[0]);
      var minObj = baseChart.getBisectData(xValue) || {
        data: NaN
      };
      if (!isNaN(minObj.data)) {
        if (!toolTipInitialized) {
          drawToolTipPositionIndicator(mousePosition);
        }
      } else {
        return;
      }
      var xValueBisect = baseChart.xScale(minObj.data);
      if (!isNaN(xValueBisect)) {
        ele.select("path.indicator").attr("d", "M " + xValueBisect + " 0" + " L " + xValueBisect + " " + height);
      }

      // Show the tooltip
      if (minObj && minObj.data) {
        tooltipDiv.html(baseChart.getToolTipHtml(minObj)).style("left", mousePosition[0] * 0.9 + "px").style("top", mousePosition[1] + "px");
      }
    }).on("mouseleave", function (d) {
      // attach mouseout events
      tooltipDiv.transition().duration(200).style("opacity", 0);
      d3.selectAll("path.indicator").remove();
      toolTipInitialized = false;
    });
  };
  return AnalyticD3LineChart;
});
