/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by e877411 on 10/20/2016.
 */

define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'jquery', 'd3', 'nmodule/analytics/rc/chart/types/AnalyticChartType', 'lex!analytics'], function (baja, Widget, subscriberMixIn, $, d3, AnalyticChartType, lexicon) {
  "use strict";

  var lex = lexicon[0];

  /**
   * @constructor
   * Base view for all web analytics charts
   */
  var AnalyticD3BarChart = function AnalyticD3BarChart(params) {
    AnalyticChartType.apply(this, params);
    return this;
  };
  AnalyticD3BarChart.prototype = Object.create(AnalyticChartType.prototype);
  AnalyticD3BarChart.prototype.constructor = AnalyticD3BarChart;

  /**
   * Render the pie
   * @param chartSettingsCollection
   */

  AnalyticD3BarChart.prototype.draw = function (baseChart, series) {
    var paddingRatio = 0.25;
    var processedSeries = [];
    series.map(function (ser) {
      processedSeries.push.apply(processedSeries, ser.data);
    });
    var allocationPerBar = baseChart.availableWidth() / processedSeries.length;
    var barWidth = (1 - paddingRatio) * allocationPerBar;
    var svg = baseChart.svg();
    var height = baseChart.availableHeight();
    var bar = svg.selectAll('rect').data(processedSeries).enter().append('rect').attr('x', function (d) {
      // sets the x position of the bar
      return baseChart.xScale(d.x);
    }).attr('y', function (d) {
      // sets the y position of the bar
      if (d.y === lex.get("baseChart.nodatafound.message")) {
        return;
      }
      d.yy = baseChart.yScale(d.y === 0 ? 1 : d.y);
      return d.yy;
    }).attr('width', barWidth) // sets the width of bar
    .attr('height', function (d) {
      // sets the height of bar
      if (d.y === lex.get("baseChart.nodatafound.message")) {
        return;
      }
      return height - d.yy;
    }).attr('fill', function (d, i) {
      return d.color;
    });
    // debugValue to support the sanity testing, should be enabled through analyticService.
    if (baseChart.isDebugEnabled) {
      d3.selectAll('rect').attr('debugValue', function (d) {
        // For Ranking chart, there's no d.x, so have to use recName.
        return (d.recName ? d.recName : d.x) + ";" + d.y + (["null", undefined].contains(d.unit) ? "" : ";" + d.unit);
      });
    }
    return bar;
  };
  return AnalyticD3BarChart;
});
