/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by e877411 on 10/20/2016.
 */

define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'jquery', 'd3'], function (baja, Widget, subscriberMixIn, $, d3) {
  "use strict";

  /**
   * @constructor
   * Base view for all web analytics charts
   */
  var AnalyticChartType = function AnalyticChartType() {
    this.series = undefined;
    return this;
  };
  AnalyticChartType.prototype.constructor = AnalyticChartType;

  /**
   * Render the pie
   * @param chartSettingsCollection
   */
  AnalyticChartType.prototype.draw = function (baseChart, series) {
    throw new Error("Unsupported Operation");
  };
  AnalyticChartType.prototype.toolTip = function (baseChart, ele, series) {
    var tooltipDiv = baseChart.getToolTipDiv();
    ele.on("mouseenter", function (event, d) {
      var mousePosition = d3.pointer(event, this);
      tooltipDiv.transition().duration(200).style("opacity", 0.9);
      var transform = baseChart.getTransformation();
      // Show the tooltip
      tooltipDiv.html(baseChart.getToolTipHtml(d)).style("left", mousePosition[0] * 0.9 + transform[0] + "px").style("top", mousePosition[1] + transform[1] + "px");
    }).on("mouseleave", function (d) {
      tooltipDiv.transition().duration(200).style("opacity", 0);
    });
  };
  return AnalyticChartType;
});
