/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

require.config({
  shim: {
    'nmodule/analytics/ext/billboard/billboard': {
      deps: ['d3']
    }
  }
});

/**
 * Created by E845876 on 3/30/2017.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'jquery', 'dialogs', 'd3', 'nmodule/analytics/ext/billboard/billboard', 'underscore', 'nmodule/analytics/rc/chart/types/AnalyticChartType', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/util/ModelFactory', 'lex!analytics', 'css!nmodule/analytics/ext/billboard/billboard'], function (baja, Widget, subscriberMixIn, $, dialogs, d3, billboard, _, AnalyticChartType, analyticsUtil, ModelFactory, lexicon) {
  "use strict";

  /**
   * @constructor
   * Base view for all web analytics charts
   */
  var AnalyticC3TypeChart = function AnalyticC3TypeChart(params) {
    AnalyticChartType.apply(this, params);
    return this;
  };
  // Inheriting Analytics Base Chart from AnalyticD3BaseChart
  AnalyticC3TypeChart.prototype = Object.create(AnalyticChartType.prototype);
  // Setting the constructor
  AnalyticC3TypeChart.prototype.constructor = AnalyticC3TypeChart;
  function getLabels(yStrArray) {
    var yStr = "";
    _.each(yStrArray, function (y2L, index) {
      yStr += y2L;
      if (index !== yStrArray.length - 1) {
        yStr += " & ";
      }
    });
    return yStr;
  }
  function addDebugValues() {
    function addAttr(node, d) {
      var valueX = d.x ? d.x : undefined,
        valueY = d.value ? d.value : undefined;
      var finalStr = '';
      if (valueX) {
        finalStr += valueX + (valueY ? ";" : '');
      }
      if (valueY) {
        finalStr += valueY;
      }
      if (finalStr) {
        try {
          finalStr += ';' + (d.id ? d.id.split(';')[1] : d.data.id ? d.data.id.split(';')[0] : function () {
            throw Error();
          }());
        } catch (err) {} finally {
          d3.select(node).attr('debugValue', finalStr);
        }
      }
    }
    d3.selectAll('svg g path').each(function (d) {
      addAttr(this, d);
    });
    d3.selectAll('svg g circle').each(function (d) {
      addAttr(this, d);
    });
  }

  /**
   *
   * @param baseChart
   * @param series
   * @param inputObj
   * @returns {*}
   */
  AnalyticC3TypeChart.prototype.draw = function (baseChart, series, inputObj) {
    inputObj.y2Label = getLabels(inputObj.y2Label);
    inputObj.yLabel = getLabels(inputObj.yLabel);
    var model = ModelFactory.getC3RenderObj(baseChart, series, inputObj);
    var chart = billboard.bb.generate(model);
    d3.selectAll("svg .bb-axis-y-label").append("title").text(function () {
      return inputObj.yLabel;
    });
    d3.selectAll("svg .bb-axis-y2-label").append("title").text(function () {
      return inputObj.y2Label;
    });
    if (baseChart.getName() === "RankingChart") {
      _.each(inputObj.groups, function (name) {
        var nodes = d3.selectAll(".bb-chart-bar path");
        _.each(nodes[0], function (node, index) {
          var inOb = d3.select(node).data()[0];
          if (inOb.value === null) {
            d3.select(node).remove();
          }
        });
      });
    }
    if (baseChart.isDebugEnabled) {
      addDebugValues();
    }
    return chart;
  };

  /**
   *
   * @param baseChart
   * @param ele
   * @param series
   */
  AnalyticC3TypeChart.prototype.toolTip = function (baseChart, ele, series) {};
  return AnalyticC3TypeChart;
});
