/* eslint-disable no-unused-vars */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * SpectrumChart.js
 * This javascript creates a SpectrumChart/HeatMap using d3 javascript.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'underscore', 'd3', 'nmodule/analytics/rc/chart/base/AnalyticC3BaseChart', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/webEditors/rc/wb/util/ICollectionSupport', 'lex!analytics', 'css!nmodule/analytics/rc/chart/ranking/rankingChart', "baja!analytics:C3UxSpecificAxisWebChartParams"], function (baja, Widget, subscriberMixIn, Promise, $, _, d3, AnalyticC3BaseChart, analyticsUtil, ICollectionSupport, lexicon) {
  "use strict";

  var lex = lexicon[0];
  var minValue, maxValue;

  /**
   * @class
   * @alias module:nmodule/analytics/rc/chart/ranking/RankingChart
   * @extends module:nmodule/analytics/rc/chart/base/AnalyticC3BaseChart
   * @mixes module:nmodule/webEditors/rc/wb/util/ICollectionSupport
   * @param {Object} [params]
   */
  var RankingChart = function RankingChart(params) {
    AnalyticC3BaseChart.call(this, $.extend({}, params));
    var that = this;
    ICollectionSupport(that);
    that.columnKeys = ['recName', 'y', 'metaData.interpolationStatus'];
    that.columnNames = [lex.get('report.headerText.groupName'), lex.get('report.headerText.value'), lex.get("table.interpolationStatus.columnText")];
    minValue = baja.Float.MAX_VALUE.valueOf();
    maxValue = baja.Float.MIN_VALUE.valueOf();
  };
  RankingChart.prototype = Object.create(AnalyticC3BaseChart.prototype);
  RankingChart.prototype.constructor = RankingChart;
  RankingChart.prototype.processData = function (chartSettingsCollection, isRedrawRequest) {
    var that = this;
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      var seriesList = [];
      _.each(chartSettingsCollection, function (model) {
        var trendArray = model.getAnalyticTrendArray();
        if (!isRedrawRequest) {
          trendArray = analyticsUtil.normalize(model, trendArray, true);
        }
        var series = {
          name: model.getSeriesName(),
          data: trendArray,
          color: model.getBrush(),
          unit: model.getUnitDisplay(),
          ord: model.getOrd(),
          chartType: model.getChartType(),
          showOnY2: model.getShowOnY2()
        };
        seriesList.push(series);
      });
      that.series = that.processSeries(seriesList); // each series now has only one record
      resolve(analyticsUtil.getSimpleC3Data(that, that.series));
    });
  };
  RankingChart.prototype.getXAxisType = function () {
    return 'category';
  };
  RankingChart.prototype.getXAxisLabel = function () {
    return "";
  };

  /**
   * Process the series in ordet to deteremine the X and Y axis Min and Max.
   * Also determines the interval for load duration calculations.
   * @param series
   */
  RankingChart.prototype.processSeries = function (allSeries) {
    // Sort the first record of each series
    var baseSeries = $.map(allSeries, function (eachSeries) {
      var series = eachSeries.data,
        inOb = {};
      if (series.length > 0) {
        var item = series[0];
        inOb = {
          data: [{
            x: Math.random(),
            recName: eachSeries.name,
            y: $.isNumeric(item.value) ? item.value : item.value ? 1 : 0,
            color: eachSeries.color,
            unit: eachSeries.unit,
            random: Math.random(),
            metaData: {
              interpolationStatus: item.interpolationStatus
            }
          }],
          color: eachSeries.color,
          unit: eachSeries.unit,
          name: eachSeries.name,
          ord: eachSeries.ord
        };
      } else {
        inOb = {
          data: [{
            x: eachSeries.name,
            recName: eachSeries.name,
            y: lex.get("time.operation.minus"),
            metaData: {
              interpolationStatus: "{None}"
            }
          }],
          color: eachSeries.color,
          unit: eachSeries.unit,
          name: eachSeries.name,
          ord: eachSeries.ord
        };
      }
      inOb.chartType = eachSeries.chartType;
      inOb.showOnY2 = eachSeries.showOnY2;
      return inOb;
    });
    var sortedSeries = _.sortBy(baseSeries, function (rec) {
      return rec.data[0].y;
    });
    return sortedSeries;
  };
  /**
   * This needs a clean slate
   * @returns {boolean}
   */
  RankingChart.prototype.needsCleanSlate = function () {
    return true;
  };

  /**
   * This method should be overridden by subclasses to return respective chart types.
   * The default implementation retruns "none".
   * @returns {string}
   */
  RankingChart.prototype.getSupportedExportTypes = function () {
    return ["rnkchart", "csv"];
  };
  /**
   * Get the chart margins
   * @type {{top: number, right: number, bottom: number, left: number}}
   */
  RankingChart.prototype.chartMargins = function () {
    return {
      top: 20,
      right: 50,
      bottom: 60,
      left: 70
    };
  };
  RankingChart.prototype.getDefaultOrdScheme = function () {
    return "webanalyticsrollup:";
  };
  RankingChart.prototype.isClrToBeDisplayedInRpt = function () {
    return true;
  };
  RankingChart.prototype.getXData = function (data) {
    return data.recName;
  };
  RankingChart.prototype.getYData = function (data) {
    return data.y;
  };
  RankingChart.prototype.getColorCodedColKeys = function () {
    return ['recName'];
  };
  RankingChart.prototype.getDefaultSettings = function () {
    var defObj = AnalyticC3BaseChart.prototype.getDefaultSettings.apply(this, arguments);
    defObj.chartType = "bar";
    return defObj;
  };

  /**
   * Get Chart Params
   * @returns {*}
   */
  RankingChart.prototype.getTabParamType = function () {
    return baja.$("analytics:C3UxSpecificAxisWebChartParams");
  };

  /**
   *
   * @param data
   * @param timeRange
   * @returns {*}
   */
  RankingChart.prototype.buildModel = function (data, timeRange) {
    var model = AnalyticC3BaseChart.prototype.buildModel.apply(this, arguments);
    model.setShowOnY2(data.getShowOnY2());
    return model;
  };
  RankingChart.prototype.getName = function () {
    return "RankingChart";
  };
  return RankingChart;
});
