/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * @file: This file represents the settings window for the Web analytic charts
 * @author Upender Paravastu & Sai Komaravolu
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'bajaux/events', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/chart/fe/AnalyticDataEditorFE', 'nmodule/analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticWebChartSettings', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticC3RankingChartSettings', 'lex!baja,analytics', 'baja!webEditors:FrozenEnumEditor,webEditors:UnitEditor,webEditors:StringEditor,analytics:AnalyticDataEditor', 'nmodule/webChart/rc/fe/color/ColorEditor', 'nmodule/webEditors/rc/fe/baja/DaysOfWeekBitsEditor'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, events, fe, feDialogs, BaseEditor, AnalyticDataEditor, AnalyticUxWebChartSettingsFE, analyticWebChartSettings, analyticC3RankingChartSettings, lexicon, types, ColorEditor, DaysOfWeekBitsEditor) {
  'use strict';

  /**
   * A field editor for working with Settings of chart widget.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:analytics/rc/chart/fe/AnalyticUxWebChartSettingsFE
   */
  var AnalyticRankingChartUXSettingsFE = function AnalyticRankingChartUXSettingsFE() {
    AnalyticUxWebChartSettingsFE.apply(this, arguments);
  };
  // Inheriting AnalyticUxWebChartSettingsFE from BaseEditor
  AnalyticRankingChartUXSettingsFE.prototype = Object.create(AnalyticUxWebChartSettingsFE.prototype);
  //Setting the constructor
  AnalyticRankingChartUXSettingsFE.prototype.constructor = AnalyticRankingChartUXSettingsFE;
  AnalyticRankingChartUXSettingsFE.prototype.doInitialize = function (dom) {
    AnalyticUxWebChartSettingsFE.prototype.doInitialize.apply(this, arguments);
    return dom;
  };
  AnalyticRankingChartUXSettingsFE.prototype.initParams = function () {
    var retObj = AnalyticUxWebChartSettingsFE.prototype.initParams.apply(this, arguments);
    retObj.include = analyticC3RankingChartSettings({
      chartType: "Chart Type"
    });
    return retObj;
  };

  /**
   * Build Field Editors
   * @param settingsObj
   * @returns {Array.<module:bajaux/lifecycle/WidgetManager~BuildParams>}
   */
  AnalyticRankingChartUXSettingsFE.prototype.initFieldEditors = function (settingsObj) {
    var that = this;
    var fes = AnalyticUxWebChartSettingsFE.prototype.initFieldEditors.apply(that, arguments);
    fes.push({
      dom: $(".chartType", that.jq()),
      value: settingsObj.getChartType(),
      formFactor: 'mini',
      keyName: "chartType"
    });
    return fes;
  };
  return AnalyticRankingChartUXSettingsFE;
});
