/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E491819 on 6/27/2016.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/util/ExportWizardCommand', 'nmodule/analytics/rc/util/GridEditor', 'bajaux/commands/Command', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/utils/AnalyticsDataUtils', 'bajaux/events', 'nmodule/analytics/rc/chart/base/analyticEvents', 'dialogs', 'nmodule/analytics/rc/chart/fe/AnalyticTimeRangeFE', 'hbs!nmodule/analytics/rc/chart/templates/fe/analyticBaseChartMasterTabTemplate', 'lex!analytics', "baja!analytics:AnalyticChartTimeRange,analytics:TimeRangeStringLabel,analytics:UxAnalyticTimeRangeType", 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, _, fe, feDialogs, ExportWizardCommand, GridEditor, Command, analyticsUtil, AnalyticsDataUtils, events, analyticEvents, dialogs, analyticTimeRangeEditor, analyticBaseChartMasterTabTemplate, lexicon, types) {
  "use strict";

  var lex = lexicon[0],
    INACTIVE_CLASS = 'inactive';
  var AnalyticsCommandBar = function AnalyticsCommandBar() {
    Widget.apply(this, arguments);
    subscriberMixIn(this);
    this.supportedExportTypes = [];
    this.exportModel = {};
    this.exportFileName = "Export";
  };

  // Inheriting Analytics Command Bar from Widget
  AnalyticsCommandBar.prototype = Object.create(Widget.prototype);
  // Setting the constructor
  AnalyticsCommandBar.prototype.constructor = AnalyticsCommandBar;

  /**
   *
   * @param element
   */
  AnalyticsCommandBar.prototype.doInitialize = function (element) {
    var params = this.properties();
    var that = this,
      commandBar = new GridEditor(),
      timeRange = params.getValue('timeRange');
    timeRange = timeRange || baja.$("analytics:UxAnalyticTimeRangeType").make(7).getTag();

    // Set the necessary instantiation params.
    that.supportedExportTypes = params.getValue('supportedExportTypes');
    that.exportModel = params.getValue('model');
    that.exportFileName = params.getValue('fileName');
    that.isFile = params.getValue('isFile');
    that.tabParamType = params.getValue('tabParamType');
    that.settingsEditorType = params.getValue('settingsEditorType');
    that.configurationTabParamType = params.getValue('configurationTabParamType');
    that.configurationTabType = params.getValue('configurationTabType');
    that.fontSize = params.getValue('fontSize');
    that.isOnDashboard = params.getValue("isOnDashboard");
    that.clearCmd = params.getValue("clearCmd");
    that.parent = params.getValue("parent");

    // If the datasource is a File, Add Save Command.
    that.saveCommand = new Command({
      module: "analytics",
      lex: "analytics.SaveCommand",
      func: function func() {
        return that.parent.save();
      }
    });

    //register the events for settings icon
    that.initSettings(element);

    // Update data model, when model gets changed
    that.jq().off(analyticEvents.MODEL_CHANGED);
    that.jq().on(analyticEvents.MODEL_CHANGED, function (event, dataModel, tabConfigModel, fontSize) {
      that.exportModel.dataModel = dataModel;
      that.exportModel.configModel = tabConfigModel;
      that.fontSize = fontSize;
      // Enable the save command when the model is changed.
      that.enableSaveCommand(true);
    });

    // If the timeRange is changed then enable the save command.
    that.jq().off(analyticEvents.TIME_RANGE_CHANGED);
    that.jq().on(analyticEvents.TIME_RANGE_CHANGED, function () {
      that.enableSaveCommand(true);
    });

    // If the timeRange is changed then enable the save command.
    that.jq().off(analyticEvents.DROP_ACTION_PERFORMED);
    that.jq().on(analyticEvents.DROP_ACTION_PERFORMED, function () {
      that.enableSaveCommand(true);
    });
    if (that.clearCmd) {
      commandBar.addCommand(that.clearCmd);
    }

    // Add the save command in the initial run and disable it.
    that.enableSaveCommand(false);
    if (that.isFile || that.isOnDashboard) {
      commandBar.addCommand(that.saveCommand);
    }

    // After click of save, this event will be called and there by we set the enabled status to false.
    this.jq().off(events.UNMODIFY_EVENT);
    this.jq().on(events.UNMODIFY_EVENT, function () {
      that.enableSaveCommand(false);
    });

    // Add ExportWizardCommand
    that.exportWizardCommand = new ExportWizardCommand(that);
    commandBar.addCommand(this.exportWizardCommand);

    // Initialize the time range field editor.
    return fe.buildFor({
      dom: $(".timeRangeElem", element),
      type: analyticTimeRangeEditor,
      value: timeRange
    }).then(function () {
      commandBar.initialize($('.exportElem', element)).then(function () {
        return commandBar.load();
      })["catch"](function (err) {
        baja.error(err);
      });
    });
  };

  /**
   * Register an event on the 'gear icon' to open the settings dialog.
   * This will have the filter parameters for the data.
   */
  AnalyticsCommandBar.prototype.initSettings = function (element) {
    var that = this;
    // Add settings to the command bar.
    $('.analyticsSettings-grid', element).append('<div class="CommandButton" title=' + lex.get('settings') + '> ' + '<span class="icon-icons-x16-gear chartSettings" title=' + lex.get('settings') + '></span> ' + '</div>');
    var commandButton = element.find(".CommandButton");
    commandButton.off("click");
    commandButton.on("click", function () {
      that.launchSettingsEditor();
    });
  };

  /**
   * Launch the settings dialog
   */
  AnalyticsCommandBar.prototype.launchSettingsEditor = function () {
    var that = this;
    var chartModel = that.exportModel.dataModel;
    return Promise.resolve(dialogs.showOkCancel({
      title: lex.get("title.settings"),
      content: function content(dlg, jq) {
        // make the settings object to initialize the fe.
        var interimObj;
        var comp = that.$getBajaCastedSettings();
        var params = comp.getSlots().properties().dynamic().toValueArray();
        var tabConfigInArray = [];
        _.map(params, function (param, index) {
          interimObj = {};
          if (param.getType().toString() === that.tabParamType().getType().toString()) {
            interimObj[chartModel[index] ? chartModel[index].getSeriesName() : "Node " + index] = param;
          } else if (param.getType().toString() === that.configurationTabParamType().getType().toString()) {
            interimObj.Configuration = param;
          }
          tabConfigInArray.push(interimObj);
        });
        var baseChartMasterTabTemplate = analyticBaseChartMasterTabTemplate({
          interimArray: tabConfigInArray
        });
        jq.html(baseChartMasterTabTemplate);
        var root = jq.find(".settingsDiv");
        var promiseList = [];
        for (var i = 0; i < params.length; i++) {
          var param = params[i];
          promiseList[i] = fe.buildFor({
            value: param,
            formFactor: 'mini',
            type: param.getType().toString() === that.tabParamType().getType().toString() ? that.settingsEditorType : that.configurationTabType,
            dom: root.find(".container.tab" + i + "C")
          });
        }
        //Do tab registration
        $('.tabs li a:not(:first)', jq).addClass(INACTIVE_CLASS);
        $('.tabs li div.seriesNameHolder:not(:first)', jq).addClass(INACTIVE_CLASS);
        $('.tabs li div.imageHolder:not(:first)', jq).addClass(INACTIVE_CLASS);
        $('.container', jq).hide();
        $('.container:first', jq).show();
        $('.tabs li a', jq).click(function () {
          if ($(this).hasClass(INACTIVE_CLASS)) {
            //this is the start of our condition
            $('.tabs li a', jq).addClass(INACTIVE_CLASS);
            $(".tabs li .seriesNameHolder", jq).addClass(INACTIVE_CLASS);
            $(".tabs li .imageHolder", jq).addClass(INACTIVE_CLASS);
            $(this).removeClass(INACTIVE_CLASS);
            var parentLi = $(this).parent().parent().parent('li');
            parentLi.find("div.seriesNameHolder").removeClass(INACTIVE_CLASS);
            parentLi.find("div.imageHolder").removeClass(INACTIVE_CLASS);
            parentLi.find("div.a").removeClass(INACTIVE_CLASS);
            $('.container', jq).hide();
            $('.' + $(this).attr('class') + 'C', jq).fadeIn('slow');
          }
        });
        // Delete handler for settings
        $('.tabs li .removeTab', jq).click(function () {
          var parentLi = $(this).parent().parent().parent('li');
          parentLi.find("a").removeClass(INACTIVE_CLASS);
          var t = parentLi.find("a").attr("class");
          parentLi.remove();
          $('.' + t + 'C', jq).remove();
          $('.tabs li a:first', jq).removeClass(INACTIVE_CLASS);
          $('.tabs li .seriesNameHolder:first', jq).removeClass(INACTIVE_CLASS);
          $('.tabs li .imageHolder:first', jq).removeClass(INACTIVE_CLASS);
          parentLi.find("div.seriesNameHolder").removeClass(INACTIVE_CLASS);
          parentLi.find("div.imageHolder").removeClass(INACTIVE_CLASS);
          $('.tabs li a:not(:first)', jq).addClass(INACTIVE_CLASS);
          $('.container', jq).hide();
          $('.container:first', jq).show();
          // If that's the last tab, then hide the remove button.
          if ($('.tabs li').length === 1) {
            $('.tabs li .removeTab').hide();
          }
        });
        return Promise.all(promiseList).then(function () {
          // eslint-disable-next-line promise/no-return-wrap
          return Promise.resolve(jq);
        });
      }
    }).ok(function (obj) {
      that.jq().trigger(analyticEvents.SETTINGS_CHANGED, [obj]);
    }));
  };

  /**
   * Make chart settings from the loaded settings configuration.
   */
  AnalyticsCommandBar.prototype.$getBajaCastedSettings = function () {
    var that = this,
      dataModelArray = that.exportModel.dataModel,
      settingList = baja.$("baja:Component");
    _.each(dataModelArray, function (model) {
      settingList.add(analyticsUtil.buildSettings(model, that.tabParamType()));
    });

    //Add chart configurations.
    settingList.add(analyticsUtil.buildConfiguration(that.configurationTabParamType(), that));
    return settingList;
  };

  /**
   *
   * @param element
   */
  AnalyticsCommandBar.prototype.doLoad = function (model) {
    var that = this;
    that.exportModel = model;
    return Promise.resolve(that.exportModel);
  };
  /**
   * Overloaded title method.
   * @returns {string}
   */
  AnalyticsCommandBar.prototype.title = function () {
    return lex.get("chart.export");
  };

  /**
   * Overloaded makeExport method.
   * @param type
   * @param optionInfo
   */
  AnalyticsCommandBar.prototype.makeExport = function (type, optionInfo) {
    return AnalyticsDataUtils.getExportData(type, optionInfo, this.exportModel);
  };

  /**
   * Will enable the save command checking for it's a file or not.
   * @param flag
   */
  AnalyticsCommandBar.prototype.enableSaveCommand = function (flag) {
    var that = this;
    if (that.isFile || that.isOnDashboard) {
      that.saveCommand.setEnabled(flag);
    }
  };
  AnalyticsCommandBar.prototype.getSaveCommand = function () {
    return this.saveCommand;
  };
  return AnalyticsCommandBar;
});
