/* eslint-disable promise/no-return-wrap */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'jquery', 'd3', 'underscore', 'dialogs', 'Promise', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/chart/base/AnalyticsBaseChart', 'nmodule/analytics/rc/chart/utils/AnalyticsDataUtils', 'nmodule/analytics/rc/chart/analyticwebchart/AnalyticsTabConfigC3Model', 'nmodule/analytics/rc/chart/base/AnalyticsC3DataModel', 'nmodule/analytics/rc/chart/types/AnalyticC3TypeChart', 'nmodule/analytics/rc/chart/fe/AnalyticUxC3WebChartSettingsFE', 'nmodule/analytics/rc/chart/fe/C3ConfigurationSettingsFE', 'hbs!nmodule/analytics/rc/chart/templates/table/analyticsBaseTemplate', 'lex!baja,analytics', "baja!analytics:C3UxAxisWebChartParams,analytics:Interval,analytics:Combination,analytics:AnalyticsC3TabConfigModel"], function (baja, Widget, subscriberMixIn, $, d3, _, dialogs, Promise, analyticsUtil, AnalyticsBaseChart, AnalyticsDataUtils, AnalyticsTabConfigC3Model, AnalyticsC3DataModel, AnalyticC3TypeChart, AnalyticUxC3WebChartSettingsFE, C3ConfigurationSettingsFE, baseTemplate, lexicon) {
  "use strict";

  var lex = lexicon[1];
  /**
   * @constructor
   * Base view for all web analytics charts
   */
  var AnalyticC3BaseChart = function AnalyticC3BaseChart(params) {
    AnalyticsBaseChart.call(this, $.extend({}, params));
    subscriberMixIn(this);
    this.minValue = baja.Float.MAX_VALUE.valueOf();
    this.maxValue = baja.Float.MIN_VALUE.valueOf();
    this.minDuration = baja.Float.MAX_VALUE.valueOf();
    this.maxDuration = baja.Float.MIN_VALUE.valueOf();
    this.$svg = undefined;
    this.textSize = 0;
    this.legendIconSize = 0;
    this.generalIconSize = 0;
    this.supportedResolutions = [100, 300, 500, 700, 900, 1100, 1300];
    this.supportedTickCounts = [1, 2, 3, 4, 5, 6, 10];
    this.resolutionScale = d3.scaleThreshold().domain(this.supportedResolutions).range(this.supportedTickCounts);
    this.textScale = d3.scaleLinear().domain([100, 1300]).range([6, 20]);
    this.legendIconScale = d3.scaleLinear().domain([100, 1300]).range([8, 30]);
    this.generalIconScale = d3.scaleLinear().domain([100, 1300]).range([8, 30]);
    this.$textLengthLimit = 20;
  };
  // Inheriting Analytics Base Chart from AnalyticsBaseChart
  AnalyticC3BaseChart.prototype = Object.create(AnalyticsBaseChart.prototype);
  // Setting the constructor
  AnalyticC3BaseChart.prototype.constructor = AnalyticC3BaseChart;

  /**
   * Get Chart Params
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getTabParamType = function () {
    return baja.$("analytics:C3UxAxisWebChartParams");
  };

  /**
   * Will draw the chart, children can override this method to do extra processing before the draw of chart.
   * @param chartSettingsCollection
   */
  AnalyticC3BaseChart.prototype.reDraw = function (chartSettingsCollection) {
    return this.draw(chartSettingsCollection);
  };

  /**
   * Will actually draw the chart.
   * @param {Array.<Object>} chartSettingsCollection
   * @param {boolean} isRedrawRequest
   */
  AnalyticC3BaseChart.prototype.draw = function (chartSettingsCollection, isRedrawRequest) {
    if (chartSettingsCollection.length <= 0) {
      return Promise.resolve();
    }
    var that = this;
    that.series = [];
    return that.processData(chartSettingsCollection, isRedrawRequest).then(function (inputObj) {
      that.initXAxis();
      that.initYAxis();
      if (that.getSelectedChartType() === undefined) {
        that.setSelectedChartType(that.supportedCharts()[0]);
      }
      var chartType = new (that.getSelectedChartType())();
      that.$chart = chartType.draw(that, that.series, inputObj);
      return that.$chart;
    });
  };

  /**
   *
   * @returns {undefined|*}
   */
  AnalyticC3BaseChart.prototype.initSvg = function () {};

  /**
   * Returns the chart div for the tool tip.
   */
  AnalyticC3BaseChart.prototype.getToolTipDiv = function () {};

  /**
   * Returns the SVG element defined for the chart.
   * @returns {undefined|*}
   */
  AnalyticC3BaseChart.prototype.svg = function () {
    return this.$svg;
  };

  /**
   * Instantiates the X Axis for the chart and returns the svg element of the x axis.
   */
  AnalyticC3BaseChart.prototype.initXAxis = function () {};

  /**
   * Instantiates the Y axis and returns the svg element of the y axis.
   */
  AnalyticC3BaseChart.prototype.initYAxis = function () {};

  /**
   * Returns the position for the X Axis label.
   * @returns {number}
   */
  AnalyticC3BaseChart.prototype.getLabelPositionX = function () {
    return this.availableWidth() / 2;
  };

  /**
   * Open for the children to override.
   * Should return the X axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getXAxisLabel = function (text) {
    return "Time";
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getYAxisLabel = function (text) {
    var that = this,
      series = that.series,
      returnObj = {
        yLabel: [],
        y2Label: []
      },
      valText = lex.get("chart.yAxis.text");
    _.each(series, function (ser) {
      // var labelName = ser.name + ((ser.unit && ser.unit.length !== 0) ? " (" + ser.unit + ")" : "");
      if (ser.showOnY2) {
        if (_.isEmpty(returnObj.y2Label)) {
          returnObj.y2Label.push(valText);
        }
      } else {
        if (_.isEmpty(returnObj.yLabel)) {
          returnObj.yLabel.push(valText);
        }
      }
    });
    return returnObj;
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getY2AxisLabel = function (text) {
    return 'Value';
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getXAxisType = function () {
    return 'timeseries';
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getYAxisType = function () {};

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getY2AxisType = function () {};

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getDefaultChartType = function () {
    return "bar";
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getXAxisLabelPosition = function () {
    return "outer-center";
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getYAxisLabelPosition = function () {
    return "outer-middle";
  };
  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticC3BaseChart.prototype.getY2AxisLabelPosition = function () {
    return "outer-middle";
  };

  /**
   * Will draw the chart, children can override this method to do extra processing before the draw of chart.
   * @param chartSettingsCollection
   */
  AnalyticC3BaseChart.prototype.reDrawChart = function (chartSettingsCollection) {
    this.drawChart(chartSettingsCollection);
  };

  /**
   * Will actually draw the chart.
   * @param chartSettingsCollection
   */
  AnalyticC3BaseChart.prototype.drawChart = function (chartSettingsCollection) {
    var that = this,
      returnObj;
    that.series = [];
    if (chartSettingsCollection.length > 0) {
      // eslint-disable-next-line promise/catch-or-return
      that.processData(chartSettingsCollection).then(function (retOb) {
        returnObj = retOb;
        if (that.getSelectedChartType() === undefined) {
          that.setSelectedChartType(that.supportedCharts()[0]);
        }
        var chartType = new (that.getSelectedChartType())();
        chartType.draw(this, that.series, returnObj);
      });
    } else {}
  };

  /**
   * Get the transformation coordinates for the tooltip.
   * @returns {number[]}
   */
  AnalyticC3BaseChart.prototype.getTransformation = function () {
    return this.svg().attr("transform").replace(/(translate\()(\d+.?\d+,\d+.?\d+)(\))$/, "$2").split(",").map(function (e) {
      return isNaN(parseFloat(e)) ? 0 : parseFloat(e);
    }) || [0, 0];
  };

  /**
   * Builds the Y Axis at the last stage, appends the format and other final things.
   * @param yScale
   * @returns {*|Number|{}}
   */
  AnalyticC3BaseChart.prototype.buildYAxis = function (yScale) {};

  /**
   * Builds the X Axis at the last stage, appends the format and other final things.
   * @param xScale
   * @returns {*|Number|{}}
   */
  AnalyticC3BaseChart.prototype.buildXAxis = function (xScale) {};

  /**
   * Return the tick count for X Axis.
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getTickCountForXAxis = function () {};

  /**
   * Returns the tick count for Y Axis.
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getTickCountForYAxis = function () {};

  /**
   * Applies the Axis tick's text size.
   */
  AnalyticC3BaseChart.prototype.applyAxisTickTextSize = function () {
    this.jq().find("text").attr("style", "font-size:" + this.getTextSize());
    this.jq().find("text").attr("style", "font-size:" + this.getTextSize());
  };

  /**
   * Returns the text size set for the chart.
   * @returns {number|*}
   */
  AnalyticC3BaseChart.prototype.getTextSize = function () {
    return this.textSize;
  };

  /**
   * Setter for text size.
   * @param textSize
   */
  AnalyticC3BaseChart.prototype.setTextSize = function (textSize) {
    this.textSize = textSize;
  };

  /**
   * Returns the legend's icon size.
   * @returns {*|number}
   */
  AnalyticC3BaseChart.prototype.getLegendIconSize = function () {
    return this.legendIconSize;
  };

  /**
   * Setter for legend icon size.
   * @param legendIconSize
   */
  AnalyticC3BaseChart.prototype.setLegendIconSize = function (legendIconSize) {
    this.legendIconSize = legendIconSize;
  };

  /**
   * Returns the general icon size.
   * @returns {*|number}
   */
  AnalyticC3BaseChart.prototype.getGeneralIconSize = function () {
    return this.generalIconSize;
  };

  /**
   * Returns the general icon size applicable for all charts.
   * @param generalIconSize
   */
  AnalyticC3BaseChart.prototype.setGeneralIconSize = function (generalIconSize) {
    this.generalIconSize = generalIconSize;
  };

  /**
   * Returns the set text scale for the base chart.
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getTextScale = function () {
    return this.textScale;
  };

  /**
   * Returns the legend icon scale for the base chart.
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getLegendIconScale = function () {
    return this.legendIconScale;
  };

  /**
   * Returns the general icon scale applied on the base chart.
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getGeneralIconScale = function () {
    return this.generalIconScale;
  };

  /**
   * Returns true if the trimmed width and height is greater than 300.
   * @returns {boolean}
   */
  AnalyticC3BaseChart.prototype.showCommandBar = function () {
    if (this.availableHeight() > 300 && this.availableWidth() > 300) {
      return true;
    }
    return false;
  };
  AnalyticC3BaseChart.prototype.$doLoad = function () {
    var that = this;
    var coll = that.chartModelList;
    var promiseList = [];
    for (var i = 0; i < coll.length; i++) {
      promiseList.push(AnalyticsDataUtils.getChartData(coll[i]));
    }
    var retPromise = Promise.all(promiseList).then(function (values) {
      if (_.every(that.chartModelList, function (m) {
        return _.isEmpty(m.getAnalyticTrendArray());
      })) {
        var message = that.renderEmpty();
        that.renderCommandBar();
        return Promise.reject(message);
      }
      return that.render(that.chartModelList);
    }).then(function () {
      that.renderCommandBar();
      return Promise.resolve();
    })["catch"](function (msg) {
      return Promise.resolve(msg);
    });
    // if(that.source !== "report") {
    //   dialogs.showLoading(200, retPromise);
    // }
    return retPromise;
  };

  /**
   * Returns the text length limit for the chart. Used by relative contribution chart.
   * @returns {number}
   */
  AnalyticC3BaseChart.prototype.getTextLengthLimit = function () {
    return this.$textLengthLimit;
  };

  /**
   * Base model for configuration.
   * Children should override this method and define their tab model. Then only their configuration will be seen.
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getTabModelType = function () {
    return AnalyticsTabConfigC3Model;
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getConfigurationTabType = function () {
    return C3ConfigurationSettingsFE;
  };

  /**
   * Base model java class for configuration.
   * Child classes should override this method and mention their configuration class.
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getConfigTabParamType = function () {
    return baja.$("analytics:AnalyticsC3TabConfigModel");
  };
  AnalyticC3BaseChart.prototype.supportedCharts = function () {
    return [AnalyticC3TypeChart];
  };
  AnalyticC3BaseChart.prototype.availableWidth = function () {
    return parseInt(this.getChartPaneWidth());
  };
  AnalyticC3BaseChart.prototype.availableHeight = function () {
    return parseInt(this.getChartPaneHeight());
  };
  AnalyticC3BaseChart.prototype.getXData = function (data) {
    return data.date.getJsDate();
  };
  AnalyticC3BaseChart.prototype.getYData = function (data) {
    return data.value;
  };
  AnalyticC3BaseChart.prototype.getMetaData = function (data) {
    return data.metaData;
  };

  /**
   * Will finish the tasks before doLoad finishes.
   */
  AnalyticC3BaseChart.prototype.finishTasks = function () {
    var that = this;
    // Set the d3 perspective to the current selected svg.
    d3.selectAll(that.jq().find('svg text')).style("font-size", that.getTabConfigDataModel().getFontSize() + "px");
    //Set the text size for time range element text.
    that.jq().find(".timeRangeElem, .trCmdBar, .ux-chart-legend-text").attr("style", "font-size:" + that.getTabConfigDataModel().getFontSize() + "px");
    // If the available height is greater than zero then set the icon sizes.
    if (this.availableHeight() > 0) {
      this.legendIconSize = this.legendIconSize === 0 ? this.getLegendIconScale()(this.availableHeight()).toFixed(0) : this.legendIconSize;
      this.generalIconSize = this.generalIconSize === 0 ? this.getGeneralIconScale()(this.availableHeight()).toFixed(0) : this.generalIconSize;
    }
    if (that.showLegend) {
      that.updateLegend(that.chartModelList);
    }
  };

  /**
   *
   * @param data
   * @param timeRange
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.buildModel = function (data, timeRange) {
    var model = AnalyticsBaseChart.prototype.buildModel.apply(this, arguments);
    model.setChartType(data.getChartType().getTag());
    return model;
  };
  AnalyticC3BaseChart.prototype.processData = function (chartSettingsCollection) {
    return Promise.resolve(chartSettingsCollection);
  };

  /**
   * Returns the base data model
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getDataModel = function () {
    return AnalyticsC3DataModel;
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  AnalyticC3BaseChart.prototype.getSettingsEditorType = function () {
    return AnalyticUxC3WebChartSettingsFE;
  };
  /**
   * Update the chart info
   * @param chartSource
   */
  AnalyticC3BaseChart.prototype.updateLegend = function (chartSettingsCollection) {};
  AnalyticC3BaseChart.prototype.getFormattedTooltipValue = function (value) {
    return analyticsUtil.standardizeInput(value);
  };

  /**
   * This method can to be overriden by subclasses to get specific
   * settings
   * @returns {object}
   */
  AnalyticC3BaseChart.prototype.getDefaultSettings = function () {
    var defSettings = AnalyticsBaseChart.prototype.getDefaultSettings.apply(this, arguments);
    _.extend(defSettings, {
      chartType: "bar",
      showOnY2: false
    });
    return defSettings;
  };

  /**
   * Abstract method allows the child class to implement the logic to update their tab model based on the web object.
   * @param chartObj
   */
  AnalyticC3BaseChart.prototype.updateChartConfiguration = function (data) {
    var that = this;
    that.getTabConfigDataModel().setLegendPosition(data.getLegendPosition().getTag());
  };
  AnalyticC3BaseChart.prototype.doDestroy = function () {
    this.jq().find('.chartArea').removeData();
    this.jq().find('.chartContainer').removeData();
    return Promise.all([d3.select('.chartArea').selectAll('svg').remove(), d3.select('.chartContainer').selectAll('svg').remove()]);
  };
  return AnalyticC3BaseChart;
});
