/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/DayOfMonthScheduleEnumSetEditor
 */
define(['baja!', 'underscore', 'nmodule/schedule/rc/baja/fe/ScheduleEnumSetEditor', 'nmodule/schedule/rc/util/scheduleUtils'], function (baja, _, ScheduleEnumSetEditor, scheduleUtils) {
  'use strict';

  var toDayOfMonthTags = scheduleUtils.toDayOfMonthTags;

  /**
   * Editor for a `schedule:DayOfMonthSchedule`. Set the `includeGroups`
   * property to `true` to allow the user to select `Last Day` and `Last 7 Days`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/DayOfMonthScheduleEnumSetEditor
   * @extends module:nmodule/schedule/rc/baja/fe/ScheduleEnumSetEditor
   */
  var DayOfMonthScheduleEnumSetEditor = function DayOfMonthScheduleEnumSetEditor() {
    ScheduleEnumSetEditor.apply(this, arguments);
  };
  DayOfMonthScheduleEnumSetEditor.prototype = Object.create(ScheduleEnumSetEditor.prototype);
  DayOfMonthScheduleEnumSetEditor.prototype.constructor = DayOfMonthScheduleEnumSetEditor;

  /**
   * Return true if the user should be able to select `Last Day` and
   * `Last 7 Days`.
   *
   * @private
   * @returns {boolean}
   */
  DayOfMonthScheduleEnumSetEditor.prototype.$isIncludeGroups = function () {
    return !!this.properties().getValue('includeGroups');
  };

  /**
   * `EnumRange` range to include `Any Day`, days 1 through 31, and
   * (optionally) `Last Day` and `Last 7 Days`.
   *
   * @private
   * @returns {Promise} promise to be resolved with a `baja.EnumRange`
   */
  DayOfMonthScheduleEnumSetEditor.prototype.getEnumRange = function () {
    return toDayOfMonthTags(this.$isIncludeGroups()).then(function (tags) {
      return baja.EnumRange.make({
        ordinals: [-1].concat(_.range(1, tags.length)),
        tags: tags
      });
    });
  };
  DayOfMonthScheduleEnumSetEditor.prototype.isExclusiveSelection = function (idx) {
    return idx === 0 || idx > 31;
  };
  return DayOfMonthScheduleEnumSetEditor;
});
