function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/* eslint-env browser */

define(['baja!', 'lex!tagdictionary', 'visNetwork', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/model/UxModel', 'bajaux/Widget', 'nmodule/tagdictionary/rc/model/RelationRow', 'nmodule/tagdictionary/rc/util/relationUtil', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'css!visNetworkCss'], function (baja, lex, vis, Command, CommandGroup, UxModel, Widget, RelationRow, relationUtil, compUtils, feDialogs, CommandGroupContextMenu, mgrUtils) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
    tagdictionaryLex = _lex[0],
    toDisplaySlotPathString = compUtils.toDisplaySlotPathString,
    getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects,
    getMainTableSelection = mgrUtils.getMainTableSelection,
    VIS_NETWORK = '$visNewwork',
    MAX_VISUALIZATION_ROWS = 150,
    DEFAULT_FONT_SIZE = 16,
    LIMIT_EXCEEDED_STYLE_CLASS = '-t-RelationManager-modelView-limit-exceeded',
    INBOUND_PATH = relationUtil.INBOUND_PATH,
    INBOUND_PATH_HOVER_TEXT = relationUtil.INBOUND_PATH_HOVER_TEXT,
    OUTBOUND_PATH = relationUtil.OUTBOUND_PATH,
    OUTBOUND_PATH_HOVER_TEXT = relationUtil.OUTBOUND_PATH_HOVER_TEXT,
    RELATION_IN = relationUtil.RELATION_IN,
    RELATION_OUT = relationUtil.RELATION_OUT,
    RELATION_MANAGER_MODEL_VIEW_SELECTOR = relationUtil.RELATION_MANAGER_MODEL_VIEW_SELECTOR,
    RELATION_TYPE = relationUtil.RELATION_TYPE,
    RELATION_TYPE_IMPLIED = relationUtil.RELATION_TYPE_IMPLIED,
    RELATION_TYPE_LINK = relationUtil.RELATION_TYPE_LINK,
    RELATION_TYPE_KNOB = relationUtil.RELATION_TYPE_KNOB,
    RELATION_TYPE_RELATION_KNOB = relationUtil.RELATION_TYPE_RELATION_KNOB,
    RELATION_TYPE_DIRECT = relationUtil.RELATION_TYPE_DIRECT;

  /**
   * Removes 'px' from a string representing pixels and returns the value as a number
   *
   * @param {String} str
   * @returns {Number}
   */
  var pixelStringToNumber = function pixelStringToNumber(str) {
    // remove trailing 'px' and return string as a number
    var parsed = parseFloat(str.replace('px', ''));
    return isNaN(parsed) ? DEFAULT_FONT_SIZE : parsed;
  };

  /**
   * Returns the color to be used for an edge (relation/link)
   *
   * @private
   * @param {baja.DynamicEnum} relationType (specifically RELATION_TYPE_ENUM in relationUtil)
   * @returns {String}
   */
  var $getLinkColor = function $getLinkColor(relationType) {
    var themeCssStyleValues = $getThemeCssStyleValues();

    // mid for implied relations
    return relationType === RELATION_TYPE_IMPLIED ? themeCssStyleValues.mid : themeCssStyleValues.dark;
  };

  /**
   * Whether to use dashes for an edge (relation/link)
   *
   * @private
   * @param {baja.DynamicEnum} relationType (specifically RELATION_TYPE_ENUM in relationUtil)
   * @returns {boolean}
   */
  var $useDashes = function $useDashes(relationType) {
    // dashed lines for Direct Relations, Implied Relations and RelationKnobs, otherwise solid
    return relationType === RELATION_TYPE_DIRECT || relationType === RELATION_TYPE_IMPLIED || relationType === RELATION_TYPE_RELATION_KNOB;
  };

  /**
   * Return the vis Network stored on the Relation Manager
   *
   * @private
   * @param {module:nmodule/tagdictionary/rc/RelationManager} relationManager
   * @returns {visNetwork.Network}
   */
  var $getVisNetwork = function $getVisNetwork(relationManager) {
    return relationManager[VIS_NETWORK];
  };
  var $themeCssStyleValues;
  var $getThemeCssStyleValues = function $getThemeCssStyleValues() {
    if (!$themeCssStyleValues) {
      var temp = document.createElement('div');
      var rootDiv = document.createElement('div');
      var midDiv = document.createElement('div');
      var lightDiv = document.createElement('div');
      rootDiv.className = 'ux-root';
      midDiv.className = 'ux-btn ux-disabled';
      lightDiv.className = 'ux-tb';
      temp.append(rootDiv);
      temp.append(midDiv);
      temp.append(lightDiv);
      document.body.appendChild(temp);
      var fontSizeCss = getComputedStyle(rootDiv).getPropertyValue('font-size'),
        fontSize = pixelStringToNumber(fontSizeCss),
        // #css returns a string but vis-network needs a number
        fontSizeSmall = fontSize * 0.8,
        darkColor = getComputedStyle(rootDiv).getPropertyValue('color'),
        // @fg-color
        midColor = getComputedStyle(midDiv).getPropertyValue('color'),
        // @neutral-4
        lightColor = getComputedStyle(lightDiv).getPropertyValue('background-color'); // @neutral-2

      temp.remove();
      $themeCssStyleValues = {
        fontSize: fontSize,
        fontSizeSmall: fontSizeSmall,
        dark: darkColor,
        mid: midColor,
        light: lightColor
      };
    }
    return $themeCssStyleValues;
  };

  /**
   * Return the hovertext for a link.
   * @private
   * @param {String} sourceSlotName
   * @param {String} targetSlotName
   * @returns {String}
   */
  var $getLinkHoverText = function $getLinkHoverText(sourceSlotName, targetSlotName) {
    return tagdictionaryLex.getSafe({
      key: 'visnetwork.relation.description',
      args: [sourceSlotName, targetSlotName]
    });
  };

  /**
   * A utility class for dealing with the vis-network library
   *
   * API Status: **Private**
   * @exports nmodule/tagdictionary/rc/util/visNetworkUtil
   * @since Niagara 4.15
   */
  var exports = {};
  exports.LIMIT_EXCEEDED_STYLE_CLASS = LIMIT_EXCEEDED_STYLE_CLASS;
  exports.pixelStringToNumber = pixelStringToNumber;
  exports.$getVisNetwork = $getVisNetwork;
  exports.$getThemeCssStyleValues = $getThemeCssStyleValues;
  exports.$getLinkColor = $getLinkColor;
  exports.$useDashes = $useDashes;
  exports.$getLinkHoverText = $getLinkHoverText;

  /**
   * Uses the Relation Manager to generate vis-network visualization
   *
   * @see {@link https://visjs.github.io/vis-data/data/dataset.html}
   * @see {@link https://visjs.github.io/vis-network/docs/network/}
   *
   * @param {module:nmodule/tagdictionary/rc/RelationManager} relationManager
   */
  exports.makeVisualizationModelView = function (relationManager) {
    var managerJq = relationManager.jq(),
      containerJq = managerJq.find(RELATION_MANAGER_MODEL_VIEW_SELECTOR),
      complex = relationManager.value(),
      model = relationManager.getModel(),
      rowsIn = model.getRows(),
      jq = relationManager.jq(),
      warningElement = jq.find('.' + LIMIT_EXCEEDED_STYLE_CLASS),
      nodes = [],
      nodeIds = [],
      links = [],
      themeCssStyleValues = $getThemeCssStyleValues();
    if (rowsIn.length > MAX_VISUALIZATION_ROWS) {
      // limit the number of rows shown - the visualization does not resolve if there are too many
      rowsIn.length = MAX_VISUALIZATION_ROWS;
      warningElement.show();
    } else {
      warningElement.hide();
    }
    var complexSlotPathDisp = toDisplaySlotPathString(complex);
    var compNode = {
      id: complexSlotPathDisp,
      label: '',
      // no label on the central node
      borderWidth: 2,
      title: complexSlotPathDisp,
      image: complex.getIcon().getImageUris()[0].toString(),
      // see comment below about icons
      imagePadding: 10,
      size: 25,
      ord: '' // this would only navigate back to itself
    };
    nodes.push(compNode);
    nodeIds.push(compNode.id);
    var relNode, relLink;
    rowsIn.forEach(function (ri) {
      var subject = ri.getSubject(),
        isInbound = subject.getInbound(),
        relation = subject.relation(),
        relNodeId = isInbound ? subject[INBOUND_PATH_HOVER_TEXT] : subject[OUTBOUND_PATH_HOVER_TEXT],
        relNodeTitle = relNodeId;
      var relNodeLabel = isInbound ? subject[INBOUND_PATH] : subject[OUTBOUND_PATH];

      // remove the slot name from the label
      var idx = relNodeLabel.indexOf(' / ');
      if (idx >= 0) {
        relNodeLabel = relNodeLabel.substring(0, idx);
      }
      if (subject.otherComponent() && !nodeIds.contains(relNodeId)) {
        relNode = {
          id: relNodeId,
          label: relNodeLabel,
          title: relNodeTitle,
          ord: subject.otherComponent().getNavOrd(),
          image: subject.otherComponent().getIcon().getImageUris()[0].toString() // for the moment just use the first image
          //image: subject.otherComponent().getIcon().getImageUris().toString() // TODO can vis.js deal with multiple images?
          //  Could not load image: /module/icons/x16/deviceFolder.png,/module/icons/x16/badges/nodeLibrary.png  vis-network.js:13883
        };
        nodes.push(relNode);
        nodeIds.push(relNode.id);
      }
      var relLinkTo = isInbound ? relNodeId : complexSlotPathDisp,
        relLinkFrom = isInbound ? complexSlotPathDisp : relNodeId,
        relLinkLabel = isInbound ? subject[RELATION_IN] : subject[RELATION_OUT],
        relType = subject[RELATION_TYPE];
      var relLinkHoverText;
      if (relType === RELATION_TYPE_LINK || relType === RELATION_TYPE_KNOB) {
        // add the slotnames as hovertext
        relLinkHoverText = document.createElement('span');
        relLinkHoverText.innerHTML = $getLinkHoverText(relation.getSourceSlotName(), relation.getTargetSlotName());
      }
      relLink = {
        label: relLinkLabel,
        title: relLinkHoverText,
        from: relLinkFrom,
        to: relLinkTo,
        rowId: ri.getRowId(),
        color: $getLinkColor(relType),
        dashes: $useDashes(relType)
      };
      links.push(relLink);
    });
    var data = {
      nodes: nodes,
      edges: links
    };
    var options = {
      nodes: {
        font: {
          color: themeCssStyleValues.dark,
          size: themeCssStyleValues.fontSize,
          background: '#ffffff99'
        },
        color: {
          background: themeCssStyleValues.light,
          border: themeCssStyleValues.mid,
          hover: {
            border: themeCssStyleValues.mid
          }
        },
        borderWidth: 2,
        borderWidthSelected: 1,
        imagePadding: 7,
        shape: 'circularImage',
        size: 17
      },
      edges: {
        arrows: {
          from: {
            enabled: true,
            scaleFactor: 0.5
          }
        },
        font: {
          size: themeCssStyleValues.fontSizeSmall
        },
        width: 2
      },
      interaction: {
        hover: true
      },
      layout: {
        // Giving this a value makes the visualization layout consistent (the layout will vary according to the seed value)
        randomSeed: 'a'
      }
    };

    // create a network
    var containerElement = containerJq[0],
      network = relationManager[VIS_NETWORK] = new vis.Network(containerElement, data, options);
    network.$edges = data.edges;
    var $setEdgeAsSelectedInModel = function $setEdgeAsSelectedInModel(edgeId) {
      var edgeIndex = links.findIndex(function (lk) {
          return lk.id === edgeId;
        }),
        edge = links[edgeIndex],
        selectedRow = RelationRow.findRelationRowFromId(model, edge.rowId),
        rowIndexInModel = model.getRowIndex(selectedRow),
        selection = getMainTableSelection(relationManager);
      selection.select(rowIndexInModel);
    };
    network.on('selectNode', function (params) {
      if (params.nodes.length === 1) {
        var nodeId = params.nodes[0],
          nodeIndex = nodes.findIndex(function (n) {
            return n.id === nodeId;
          }),
          node = nodes[nodeIndex];
        if (node.ord) {
          var ord = baja.Ord.make(node.ord + '|view:tagdictionary:RelationManager').relativizeToSession();
          var webWidgetAncestor = Widget["in"](relationManager.jq().closest('.ux-WebWidget'));
          if (webWidgetAncestor) {
            // if we have a webWidget ancestor, assume we're in a UxMedia page and update the first WbViewBinding found
            var _model = UxModel["in"](webWidgetAncestor);
            if (_model) {
              var bindingList = _model.getBindingList(),
                bindings = bindingList.getBindings();
              var binding;
              for (var i = 0; i < bindings.length; i++) {
                binding = bindings[i];
                if (baja.hasType(binding, 'workbench:WbViewBinding')) {
                  break;
                }
              }
              if (binding) {
                binding.setOrd(ord);
                binding.requestRefresh();
                binding.requestRebind();
              }
            }
            return;
          }
          window.niagara.env.hyperlink(ord)["catch"](feDialogs.error);
        }
      }
    });
    network.on('selectEdge', function (params) {
      if (params.edges.length === 1) {
        $setEdgeAsSelectedInModel(params.edges[0]);
      }
    });
    network.on('oncontext', function (params) {
      params.event.preventDefault();
      var event = params.event,
        selectedEdge = network.getEdgeAt(params.pointer.DOM);
      if (!(event instanceof PointerEvent)) {
        return;
      }
      if (selectedEdge) {
        network.selectEdges([selectedEdge]);
        $setEdgeAsSelectedInModel(selectedEdge);
        var subjects = getMainTableSelectedSubjects(relationManager);

        // should have been selected by the single click handler
        if (subjects.length === 1 && subjects[0].isEditable()) {
          var group = new CommandGroup({
            commands: [relationManager.$getEditCommand(), relationManager.$getDeleteCommand()]
          });
          return CommandGroupContextMenu.show({
            event: event,
            group: group
          });
        }
      }
      var webWidgetAncestor = Widget["in"](relationManager.jq().closest('.ux-WebWidget'));
      if (webWidgetAncestor) {
        var selectedNode = network.getNodeAt(params.pointer.DOM);
        if (selectedNode) {
          network.selectNodes([selectedNode]);
          var found = nodes.find(function (n) {
              return n.id === selectedNode;
            }),
            ord = baja.Ord.make({
              child: selectedNode,
              base: baja.Ord.make('station:')
            }),
            cmdDisplayName = tagdictionaryLex.get({
              key: 'commands.visnetwork.GoToCommand.displayName',
              args: [found.title]
            }),
            _group = new CommandGroup({
              commands: [new Command({
                displayName: cmdDisplayName,
                func: function func() {
                  return window.niagara.env.hyperlink(String(ord));
                }
              })]
            });
          return CommandGroupContextMenu.show({
            event: event,
            group: _group
          });
        }
      }
    });
    network.on('hoverNode', function (params) {
      network.canvas.body.container.style.cursor = 'pointer';
    });
    network.on('blurNode', function (params) {
      network.canvas.body.container.style.cursor = 'default';
    });
    network.once('stabilized', function () {
      var yOffset = Math.round(containerJq.height() * -0.035);
      network.moveTo({
        offset: {
          x: 0,
          y: yOffset
        }
      });
    });
  };

  /**
   * Return the on screen message to show if there are too many relations to visualize.
   * @returns {String}
   */
  exports.getLimitExceededMessage = function () {
    return tagdictionaryLex.get({
      key: 'visnetwork.limit.exceeded',
      args: [MAX_VISUALIZATION_ROWS]
    });
  };

  /**
   * Highlight the edge (relation/link) that is equivalent to the row that has been clicked in the main table
   *
   * @param {Event} event
   * @param {module:nmodule/tagdictionary/rc/RelationManager}  relationManager
   */
  exports.mainTableClickHandler = function (event, relationManager) {
    var table = relationManager.getMainTable(),
      selectedRows = table.getSelectedRows(),
      visNetwork = $getVisNetwork(relationManager);

    // If we have clicked somewhere in the main table remove the selection in the visualization
    if (visNetwork) {
      visNetwork.selectionHandler.selectEdges([]);

      // if one item is now selected in the table, highlight it in the visualization
      if (selectedRows.length === 1) {
        var rowIdToMatch = selectedRows[0].getRowId();
        var edges = visNetwork.$edges;
        var edge, edgeId;
        for (var i = 0; i < edges.length; i++) {
          edge = edges[i];
          if (rowIdToMatch === edge.rowId) {
            edgeId = edge.id;
            break;
          }
        }
        if (edgeId) {
          visNetwork.selectionHandler.selectEdges([edgeId]);
        }
      }
    }
  };
  return exports;
});
