function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

define(['baja!', 'lex!webEditors', 'log!nmodule.tagdictionary.rc.model.RelationModel', 'Promise', 'underscore', 'nmodule/tagdictionary/rc/util/relationUtil', 'nmodule/tagdictionary/rc/column/RelationIconColumn', 'nmodule/tagdictionary/rc/column/RelationPropertyColumn', 'nmodule/tagdictionary/rc/column/RelationTagsColumn', 'nmodule/tagdictionary/rc/column/RelationTypeEnumColumn', 'nmodule/tagdictionary/rc/model/RelationRow', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/TableModel'], function (baja, lex, log, Promise, _, relationUtil, RelationIconColumn, RelationPropertyColumn, RelationTagsColumn, RelationTypeEnumColumn, RelationRow, Column, Row, TableModel) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
    webEditorsLex = _lex[0],
    logSevere = log.severe.bind(log),
    TAG_GROUP_ID = 'n:tagGroup',
    NO_COLUMN_HEADING = ' ',
    RELATION_TYPE = relationUtil.RELATION_TYPE,
    RELATION_TYPE_DIRECT = relationUtil.RELATION_TYPE_DIRECT,
    RELATION_TYPE_IMPLIED = relationUtil.RELATION_TYPE_IMPLIED,
    RELATION_TYPE_LINK = relationUtil.RELATION_TYPE_LINK,
    RELATION_TYPE_KNOB = relationUtil.RELATION_TYPE_KNOB,
    RELATION_TYPE_RELATION_KNOB = relationUtil.RELATION_TYPE_RELATION_KNOB,
    INBOUND_PATH = relationUtil.INBOUND_PATH,
    RELATION_IN = relationUtil.RELATION_IN,
    THIS_COMP = relationUtil.THIS_COMP,
    RELATION_OUT = relationUtil.RELATION_OUT,
    OUTBOUND_PATH = relationUtil.OUTBOUND_PATH,
    RELATION_TAGS_HOVER_TEXT = relationUtil.RELATION_TAGS_HOVER_TEXT,
    makeRelationSubject = relationUtil.makeRelationSubject,
    makeRelationKnobSubject = relationUtil.makeRelationKnobSubject,
    makeKnobSubject = relationUtil.makeKnobSubject;
  var COLUMNS = [new RelationPropertyColumn(INBOUND_PATH), new RelationPropertyColumn(RELATION_IN), new RelationIconColumn({
    showIconFunc: function showIconFunc(row) {
      return row.getSubject().getInbound();
    }
  }), new RelationPropertyColumn(THIS_COMP, {
    displayName: NO_COLUMN_HEADING
  }), new RelationIconColumn({
    showIconFunc: function showIconFunc(row) {
      return !row.getSubject().getInbound();
    }
  }), new RelationPropertyColumn(RELATION_OUT), new RelationPropertyColumn(OUTBOUND_PATH), new RelationTagsColumn(), new RelationTypeEnumColumn(RELATION_TYPE, {
    flags: Column.flags.UNSEEN
  })];

  /**
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {String} searchText
   * @param {Boolean} showDirect
   * @param {Boolean} showImplied
   * @param {Boolean} showLinks
   * @returns {Boolean} whether to include this row
   */
  var relationModelRowFilter = function relationModelRowFilter(row, searchText, showDirect, showImplied, showLinks) {
    var subject = row.getSubject(),
      isInbound = subject.getInbound(),
      rowType = subject[RELATION_TYPE];
    if (searchText) {
      var regExp = new RegExp(searchText, 'gi'),
        relationText = isInbound ? subject[RELATION_IN] : subject[RELATION_OUT],
        pathText = isInbound ? subject[INBOUND_PATH] : subject[OUTBOUND_PATH],
        tagText = subject[RELATION_TAGS_HOVER_TEXT];
      var matches = !!relationText.match(regExp);
      matches = matches || !!pathText.match(regExp);
      if (tagText) {
        matches = matches || !!tagText.match(regExp);
      }
      if (!matches) {
        return false;
      }
    }
    switch (rowType) {
      case RELATION_TYPE_DIRECT:
      case RELATION_TYPE_RELATION_KNOB:
        return showDirect;
      case RELATION_TYPE_IMPLIED:
        return showImplied;
      case RELATION_TYPE_LINK:
      case RELATION_TYPE_KNOB:
        return showLinks;
      default:
        logSevere('Unknown row type: ' + rowType);
        return false;
    }
  };

  /**
   * Update the object count on the table
   * @param {module:nmodule/tagdictionary/rc/RelationManager} mgr
   */

  var updateObjectCount = function updateObjectCount(mgr) {
    var jq = mgr.jq(),
      model = mgr.getModel(),
      objectCount = jq.find('.main-table-object-count'),
      availableWidth = jq.width();

    // hide object count and showHide on the basis of pane width
    if (availableWidth < 1050) {
      objectCount.hide();
    } else {
      objectCount.show();
      objectCount.text(webEditorsLex.get({
        key: 'mgr.titlePane.objects',
        args: [model.getRows().length]
      }));
    }
  };

  /**
   * API Status: **Private**
   * @exports nmodule/tagdictionary/rc/model/RelationModel
   * @since Niagara 4.15
   */
  var exports = {};

  /**
   * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
   */
  exports.make = function () {
    var model = new TableModel({
      columns: COLUMNS
    });
    model.relationModelRowFilter = relationModelRowFilter;
    model.updateObjectCount = updateObjectCount;
    return model;
  };

  /**
   * @param {module:nmodule/tagdictionary/rc/RelationManager} mgr
   * @returns {Promise}
   */
  exports.populateRelations = function (mgr) {
    var complex = mgr.value(),
      model = mgr.getModel(),
      knobs = complex.getKnobs(),
      relationKnobs = complex.getRelationKnobs();
    var rows = [];
    return Promise.resolve(complex.relations && complex.relations()).then(function (relations) {
      if (!relations && knobs.length === 0 && relationKnobs.length === 0) {
        return;
      }
      var directRelations = [],
        impliedRelations = [];
      if (relations instanceof baja.SmartRelations) {
        directRelations = relations.getDirectRelations().getAll();
        impliedRelations = relations.getImpliedRelations().getAll();
      } else if (relations instanceof baja.ComponentRelations) {
        // no implied relations, only direct
        directRelations = relations.getAll();
      }
      var relationId = 0;
      function processRelations(relations, implied, component) {
        // ignore tag groups as we deal with those in the Tag Manager.
        var withoutTagGroups = relations.filter(function (r) {
          return r.getId().getQName() !== TAG_GROUP_ID;
        });
        return Promise.all(withoutTagGroups.map(function (relation) {
          // directRelations is a ComponentRelations object and #getAll returns Array<module:baja/tag/BRelation>
          // impliedRelations is a RelationSet and #getAll returns Array<module:baja/tag/Relation>
          return makeRelationSubject(relation, implied, component).then(function (subject) {
            return new RelationRow(subject, relationId++);
          });
        }));
      }
      function processKnobs(knobs, component) {
        return Promise.all(knobs.map(function (knob) {
          return makeKnobSubject(knob, component).then(function (subject) {
            return subject && new RelationRow(subject, relationId++);
          });
        }));
      }
      function processRelationKnobs(relationKnobs, component) {
        return Promise.all(relationKnobs.map(function (relationKnob) {
          return makeRelationKnobSubject(relationKnob, component).then(function (subject) {
            return subject && new RelationRow(subject, relationId++);
          });
        }));
      }
      return Promise.all([processRelations(directRelations, false, complex), processRelations(impliedRelations, true, complex), processKnobs(knobs, complex), processRelationKnobs(relationKnobs, complex)]);
    }).then(function (returnedRows) {
      if (returnedRows) {
        rows = returnedRows[0] // direct relations
        .concat(returnedRows[1]) // implied relations
        .concat(returnedRows[2]) // knobs
        .concat(returnedRows[3]) // relation knobs
        .filter(Boolean); // remove null, undefined or any other falsy values.
      }
      return model.clearRows();
    }).then(function () {
      return model.insertRows(rows, 0);
    });
  };

  /**
   * @param {module:nmodule/tagdictionary/rc/RelationManager} mgr
   * @returns {Promise}
   */
  exports.updateFilter = function (mgr) {
    var relationFilter = mgr.getRelationFilter(),
      model = mgr.getModel();
    return relationFilter.getSearchText().then(function (searchText) {
      var showDirect = relationFilter.getShowDirect(),
        showImplied = relationFilter.getShowImplied(),
        showLinks = relationFilter.getShowLinks();
      return model.setRowFilter(function (row) {
        return model.relationModelRowFilter(row, searchText, showDirect, showImplied, showLinks);
      });
    }).then(function () {
      updateObjectCount(mgr);
    });
  };
  return exports;
});
