function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/filter/RelationFilter
 * @since Niagara 4.15
 */
define(['baja!', 'jquery', 'lex!tagdictionary', 'log!nmodule.tagdictionary.rc.RelationFilter', 'Promise', 'bajaux/commands/CommandGroup', 'bajaux/commands/ToggleCommand', 'bajaux/events', 'bajaux/util/CommandButtonGroup', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/fe'], function (baja, $, lex, log, Promise, CommandGroup, ToggleCommand, events, CommandButtonGroup, taggingUtil, BaseEditor, IconEditor, StringEditor, fe) {
  'use strict';

  var SELECTION_EVENT = events.command.SELECTION_EVENT,
    _lex = _slicedToArray(lex, 1),
    tagdictionaryLex = _lex[0],
    SEARCH_ICON = taggingUtil.SEARCH_ICON,
    logError = log.severe.bind(log),
    TEXT_SEARCH_HOVER_TEXT = tagdictionaryLex.getSafe('RelationFilter.searchText.hoverText');

  /**
   * @class
   * @alias module:nmodule/tagdictionary/rc/filter/RelationFilter
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  return /*#__PURE__*/function (_BaseEditor) {
    function RelationFilter(relationManager, params) {
      var _this;
      _classCallCheck(this, RelationFilter);
      _this = _callSuper(this, RelationFilter, [params]);
      _this.$relationManager = relationManager;
      return _this;
    }

    /*
     * @param {JQuery} dom.
     * @returns {Promise}
     */
    _inherits(RelationFilter, _BaseEditor);
    return _createClass(RelationFilter, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;
        var relationManager = this.$relationManager;
        var props = relationManager.properties(),
          showFilterBar = props.getValue('showFilterBar'),
          showDirect = props.getValue('showDirect'),
          showImplied = props.getValue('showImplied'),
          showLinks = props.getValue('showLinks'),
          showModel = props.getValue('showModel'),
          showTable = props.getValue('showTable');
        dom.toggle(showFilterBar);
        dom.on('keyup', '.-t-RelationFilter-searchText', function (e) {
          relationManager.updateViewContent()["catch"](logError);
          return false;
        });
        var showDirectCmd = new ToggleCommand({
          module: 'tagdictionary',
          lex: 'commands.RelationFilter.showDirect',
          selected: showDirect,
          jq: $('<span/>').appendTo(dom)
        });
        var showImpliedCmd = new ToggleCommand({
          module: 'tagdictionary',
          lex: 'commands.RelationFilter.showImplied',
          selected: showImplied,
          jq: $('<span/>').appendTo(dom)
        });
        var showLinksCmd = new ToggleCommand({
          module: 'tagdictionary',
          lex: 'commands.RelationFilter.showLinks',
          selected: showLinks,
          jq: $('<span/>').appendTo(dom)
        });
        var showModelCmd = new ToggleCommand({
          module: 'tagdictionary',
          lex: 'commands.RelationFilter.showModel',
          selected: showModel,
          jq: $('<span/>').appendTo(dom)
        });
        var showTableCmd = new ToggleCommand({
          module: 'tagdictionary',
          lex: 'commands.RelationFilter.showTable',
          selected: showTable,
          jq: $('<span/>').appendTo(dom)
        });
        this.$showDirectCmd = showDirectCmd;
        this.$showImpliedCmd = showImpliedCmd;
        this.$showLinksCmd = showLinksCmd;
        this.$showModelCmd = showModelCmd;
        this.$showTableCmd = showTableCmd;
        return Promise.all([fe.buildFor({
          dom: $('<span/>').appendTo(dom),
          type: IconEditor,
          value: SEARCH_ICON
        }), fe.buildFor({
          dom: $('<span class="-t-RelationFilter-searchText"/>').appendTo(dom),
          type: StringEditor,
          value: ''
        }), fe.buildFor({
          dom: $('<span class="-t-RelationFilter-commandGroup"/>').appendTo(dom),
          value: new CommandGroup({
            commands: [showDirectCmd, showImpliedCmd, showLinksCmd, showModelCmd, showTableCmd]
          }),
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          }
        })]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 3),
            searchIconEd = _ref2[0],
            searchTextEditor = _ref2[1],
            commandGroup = _ref2[2];
          dom.find('.-t-RelationFilter-searchText').attr('title', TEXT_SEARCH_HOVER_TEXT);
          _this2.$searchTextEditor = searchTextEditor;
          _this2.$showModelCmd.on(SELECTION_EVENT, function () {
            _this2.updateSplitPane();
            relationManager.doLayout();
          });
          _this2.$showTableCmd.on(SELECTION_EVENT, function () {
            _this2.updateSplitPane();
            relationManager.doLayout();
          });
          _this2.$showDirectCmd.on(SELECTION_EVENT, function () {
            relationManager.updateViewContent()["catch"](logError);
          });
          _this2.$showImpliedCmd.on(SELECTION_EVENT, function () {
            relationManager.updateViewContent()["catch"](logError);
          });
          _this2.$showLinksCmd.on(SELECTION_EVENT, function () {
            relationManager.updateViewContent()["catch"](logError);
          });
        });
      }

      /**
       * Whether to show direct relations
       * @returns {Boolean}
       */
    }, {
      key: "getShowDirect",
      value: function getShowDirect() {
        return this.$showDirectCmd.isSelected();
      }

      /**
       * Whether to show implied relations
       * @returns {Boolean}
       */
    }, {
      key: "getShowImplied",
      value: function getShowImplied() {
        return this.$showImpliedCmd.isSelected();
      }

      /**
       * Whether to show links
       * @returns {Boolean}
       */
    }, {
      key: "getShowLinks",
      value: function getShowLinks() {
        return this.$showLinksCmd.isSelected();
      }

      /**
       * Whether to show the node model
       * @returns {Boolean}
       */
    }, {
      key: "getShowModel",
      value: function getShowModel() {
        return this.$showModelCmd.isSelected();
      }

      /**
       * Whether to show the relation table
       * @returns {Boolean}
       */
    }, {
      key: "getShowTable",
      value: function getShowTable() {
        return this.$showTableCmd.isSelected();
      }

      /**
       * Returns the text string to filter on
       * @returns {Promise.<String>}
       */
    }, {
      key: "getSearchText",
      value: function getSearchText() {
        return this.$searchTextEditor.read();
      }

      /**
       * Update the split pane to show/hide the model/table
       */
    }, {
      key: "updateSplitPane",
      value: function updateSplitPane() {
        var relationManager = this.$relationManager,
          container = relationManager.jq().find('.mgr-pane-container'),
          upperPane = relationManager.jq().find('.mgr-pane-top'),
          lowerPane = relationManager.jq().find('.mgr-pane-bottom'),
          splitPane = relationManager.jq().find('.split-pane'),
          splitPaneDivider = relationManager.jq().find('.split-pane-divider.mgr-split-pane-divider'),
          tableDecorationElement = relationManager.jq().find('.-t-RelationManager-table-decoration'),
          lowerCommandGroupElement = relationManager.jq().find('.commandContainer'),
          showModel = this.getShowModel(),
          showTable = this.getShowTable(),
          containerHeight = container.height(),
          lowerCommandGroupHeight = lowerCommandGroupElement.height();

        // model view
        upperPane.toggle(showModel);

        // table view
        lowerPane.toggle(showTable);
        lowerCommandGroupElement.toggle(showTable);
        tableDecorationElement.toggle(showTable);

        // divider
        splitPaneDivider.toggle(showModel && showTable);

        // allocate height to the split pane elements depending on whether the table and/or model are shown
        if (showModel) {
          splitPane.splitPane('firstComponentSize', showTable ? containerHeight / 2 : containerHeight + lowerCommandGroupHeight);
        } else if (showTable) {
          splitPane.splitPane('lastComponentSize', containerHeight);
        }
      }
    }]);
  }(BaseEditor);
});
