function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * Widget to show the filter options for the Available Tags pane.
 *
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/filter/AvailableTagFilter
 */
define(['baja!', 'baja!tagdictionary:TagDictionary', 'log!nmodule.tagdictionary.rc.filter.AvailableTagFilter', 'jquery', 'underscore', 'Promise', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/tagdictionary/rc/util/rpcUtil', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'bajaux/events'], function (baja, types, log, $, _, Promise, switchboard, taggingUtil, rpcUtil, fe, BaseEditor, IconEditor, StringEditor, FrozenEnumEditor, events) {
  'use strict';

  var DICTIONARY_ICON = taggingUtil.DICTIONARY_ICON,
    SEARCH_ICON = taggingUtil.SEARCH_ICON,
    FILTER_ICON = taggingUtil.FILTER_ICON,
    TAG_FILTER_ENUM = taggingUtil.TAG_FILTER_ENUM,
    TAG_FILTER_SHOW_ALL = taggingUtil.TAG_FILTER_SHOW_ALL,
    MODIFY_EVENT = events.MODIFY_EVENT,
    logError = log.severe.bind(log);

  /**
   * Widget to show the filter options for the Available Tags pane.
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/tagdictionary/rc/filter/AvailableTagFilter
   *
   * @param {Object} [params]
   * @param {Function} [params.updateFunction] function called when values in the editor change
   */
  var AvailableTagFilter = function AvailableTagFilter(params) {
    this.$updateFunction = params && params.updateFunction ? params.updateFunction : _.noop;
    BaseEditor.apply(this, arguments);
    switchboard(this, {
      '$applyFilterChanges': {
        allow: 'oneAtATime',
        onRepeat: 'preempt'
      }
    });
  };
  AvailableTagFilter.prototype = Object.create(BaseEditor.prototype);
  AvailableTagFilter.prototype.constructor = AvailableTagFilter;

  /**
   * Initialize the widget.
   *
   * @param {JQuery} dom the DOM element to load the widget into.
   */
  AvailableTagFilter.prototype.doInitialize = function (dom) {
    var that = this;
    dom.addClass('AvailableTagFilter');
    dom.html('<span class="AvailableTagFilter-icon dictionaryIcon" />' + '<span class="AvailableTagFilter-item dictionarySelect"><select class="ux-select" /></span>' + '<span class="AvailableTagFilter-icon searchIcon" />' + '<span class="AvailableTagFilter-item searchText" />' + '<span class="AvailableTagFilter-icon filterIcon" />' + '<span class="AvailableTagFilter-item filterTypeSelect" />');
    dom.on('change', '.dictionarySelect, .filterTypeSelect', function () {
      that.$applyFilterChanges()["catch"](logError);
    });
    dom.on('keyup', '.searchText', function () {
      that.$applyFilterChanges()["catch"](logError);
    });
    var dictionaryIcon = fe.buildFor({
      dom: dom.find('.dictionaryIcon'),
      type: IconEditor,
      value: DICTIONARY_ICON
    });
    var searchIcon = fe.buildFor({
      dom: dom.find('.searchIcon'),
      type: IconEditor,
      value: SEARCH_ICON
    });
    var filterIcon = fe.buildFor({
      dom: dom.find('.filterIcon'),
      type: IconEditor,
      value: FILTER_ICON
    });
    var searchTextBox = fe.buildFor({
      dom: dom.find('.searchText'),
      type: StringEditor,
      value: ''
    }).then(function (ed) {
      that.$searchTextEditor = ed;
    });
    var filterTypeSelect = fe.buildFor({
      dom: dom.find('.filterTypeSelect'),
      type: FrozenEnumEditor,
      value: TAG_FILTER_ENUM
    }).then(function (ed) {
      that.$filterTypeSelectEditor = ed;
      return ed.load(TAG_FILTER_SHOW_ALL);
    });
    return Promise.all([dictionaryIcon, searchIcon, filterIcon, searchTextBox, filterTypeSelect]).then(function () {
      // stop wb thinking something needs to be saved
      dom.on(MODIFY_EVENT, '*', false);
      return that.$populateTagDictionarySelectItems();
    });
  };

  /**
   * Apply changes made to the filter.
   *
   * @private
   * @returns {Promise}
   */
  AvailableTagFilter.prototype.$applyFilterChanges = function () {
    var that = this;
    return Promise.all([Promise.resolve(that.jq().find('.dictionarySelect option:selected').val()), that.$searchTextEditor.read(), that.$filterTypeSelectEditor.read()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        dictionary = _ref2[0],
        textFilter = _ref2[1],
        showAllValidBest = _ref2[2];
      that.$updateFunction({
        dictionary: dictionary,
        textFilter: textFilter,
        showAllValidBest: showAllValidBest.getOrdinal()
      });
    });
  };

  /**
   * Save the filter settings.
   *
   * @returns {Object} an object with the state to be persisted
   */
  AvailableTagFilter.prototype.saveState = function () {
    // Cannot read the field editors as this function is not expected to return a promise.
    // see MgrStateHandler#doSave = specifically the call to #saveForKey
    var jq = this.jq();
    return {
      dictionary: jq.find('.dictionarySelect > select').val(),
      textFilter: jq.find('.searchText > input').val(),
      showAllValidBest: Number(jq.find('.filterTypeSelect select').val()) // the TAG_FILTER_ENUM ordinal
    };
  };

  /**
   * Restore any saved state.
   *
   * @param {Object} savedState - an object containing the saved state.
    */
  AvailableTagFilter.prototype.restoreState = function (savedState) {
    var jq = this.jq();
    jq.find('.dictionarySelect > select').val(savedState.dictionary);
    jq.find('.searchText > input').val(savedState.textFilter);
    jq.find('.filterTypeSelect select').val(savedState.showAllValidBest);
  };

  /**
   * Populate the Tag Dictionary dropdown.
   *
   * @private
   * @returns {Promise}
   */
  AvailableTagFilter.prototype.$populateTagDictionarySelectItems = function () {
    var that = this,
      selectElement = that.jq().find('.dictionarySelect > select');

    // clear out the dropdown options
    selectElement.empty();

    // Using an rpc call to look up dictionaries.
    // There could be dictionaries are not implementations of BTagDictionary.
    // A Tag Dictionary can also be a BComponents that implement the
    // TagDictionary interface.
    return rpcUtil.getTagDictionariesInfo().then(function (dictionaries) {
      var optionVal,
        optionDisplay,
        setSelected = true;
      if (dictionaries.length > 1) {
        // more than one dictionary, add an All Dictionaries option.
        selectElement.append('<option class="ux-option" value="' + taggingUtil.ALL_DICTIONARIES_KEY + '">' + taggingUtil.ALL_DICTIONARIES_TEXT + '</option>');
      }
      _.each(dictionaries, function (dictionary) {
        optionVal = _.escape(dictionary[rpcUtil.DICTIONARY_KEY]);
        optionDisplay = _.escape(dictionary[rpcUtil.DICTIONARY_NAME_KEY]);
        selectElement.append('<option class="ux-option" value="' + optionVal + '">' + optionDisplay + '</option>');
        if (setSelected) {
          selectElement.val(optionVal);
          setSelected = false;
        }
      });
      that.$validDictionaries = _.map(dictionaries, function (d) {
        return d[rpcUtil.DICTIONARY_KEY];
      });
    });
  };

  /**
   * Make the Filter Type drop down read only.
   *
   * @returns {Promise}
   */
  AvailableTagFilter.prototype.setFilterTypeReadonly = function () {
    return this.$filterTypeSelectEditor.setReadonly(true);
  };

  /**
   * @returns {Array.<String>} an array of dictionaries (namespaces)
   */
  AvailableTagFilter.prototype.getValidDictionaries = function () {
    return this.$validDictionaries || [];
  };

  /**
   * Checks whether the provided tag dictionary namespace exists.
   * The function returns the provided namespace if valid, and the default ('n' - the Niagara Tag Dictionary) if not.
   * @param {String} dictionary
   * @returns {String}
   */
  AvailableTagFilter.prototype.checkDictionary = function (dictionary) {
    return this.getValidDictionaries().includes(dictionary) ? dictionary : taggingUtil.DEFAULT_DISCOVERY_TABLE_FILTER_PARAMS.dictionary;
  };

  /**
   * Destroy the widget.
   *
   * @returns {Promise|*}
   */
  AvailableTagFilter.prototype.doDestroy = function () {
    this.jq().removeClass('AvailableTagFilter');
    return this.getChildWidgets().destroyAll();
  };
  return AvailableTagFilter;
});
