function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/commands/TagManagerCommand
 */
define(['baja!', 'lex!webEditors', 'jquery', 'underscore', 'bajaux/events', 'bajaux/commands/Command', 'bajaux/util/CommandButtonGroup', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/tagdictionary/rc/util/taggingUtil', 'nmodule/tagdictionary/rc/TagUxManager'], function (baja, lexs, $, _, events, Command, CommandButtonGroup, fe, feDialogs, mgrUtils, taggingUtil, TagUxManager) {
  'use strict';

  var LOAD_EVENT = events.LOAD_EVENT,
    isShownInActionBar = mgrUtils.isShownInActionBar,
    webEditorsLex = lexs[0],
    defaultLexiconParams = {
      lex: 'commands.tagManager'
    };

  /**
   * Command for popping up a TagManager.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/tagdictionary/rc/commands/TagManagerCommand
   * @param {baja.Component} component
   * @param {Object} altParams parameter(s) to use instead of the default 'lex'
   */
  var TagManagerCommand = function TagManagerCommand(component, altParams) {
    var lexParams = altParams || defaultLexiconParams;
    var otherParams = {
      module: 'tagdictionary',
      func: function func() {
        return feDialogs.showFor({
          type: TagUxManager,
          singleComponentMode: true,
          properties: {
            showHeader: false
          },
          value: component,
          formFactor: 'max',
          buttons: [{
            name: 'ok',
            displayName: webEditorsLex.get('close')
          }],
          on: _defineProperty({}, LOAD_EVENT, function (dlg, e, manager) {
            // After the dialog has initialized, do a bit of reformatting/rearranging

            var dialogJq = dlg.$dialogJq; // This is dialog container ('.js-dialog-container'),
            // it includes the dialog buttons that we're interested in here.
            // manager.jq() ('.js-dialog-content > .Manager') just provides
            // the dialog content and does not include the dialog buttons.

            var actionCommandsElement = manager.jq().find('.mgr-action-bar'),
              dialogCommandContainer = dialogJq.find('ul.js-dialog-button-content');

            // empty the original commands element and reduce its size to zero
            // we need to keep the element itself as MgrLearnTableSupport uses the element to calculate sizes
            actionCommandsElement.empty();
            actionCommandsElement.css({
              padding: '0px'
            }); // This makes discovery and database tables size
            // size correctly, weirdly doesn't work if placed
            // in tagdictionary.css

            // create a new set of commands and insert them into the dialog before the (renamed) OK button
            return fe.buildFor({
              dom: $('<div/>').prependTo(dialogCommandContainer),
              type: CommandButtonGroup,
              value: manager.getCommandGroup().filter({
                include: isShownInActionBar
              })
            }).then(function () {
              manager.$getAddCommand().setEnabled(true);
            });
          })
        });
      }
    };
    Command.call(this, _.extend(otherParams, lexParams));
  };
  TagManagerCommand.prototype = Object.create(Command.prototype);
  TagManagerCommand.prototype.constructor = TagManagerCommand;

  /**
   * @param {baja.Component} component
   * @param {boolean} [enabled=true]
   * @returns {Promise.<module:nmodule/tagdictionary/rc/commands/TagManagerCommand|null>} a TagManagerCommand,
   * or null if the TagDictionaryService is not installed
   */
  TagManagerCommand.make = function (component) {
    var enabled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    return taggingUtil.getTagDictionaryService().then(function (service) {
      if (!service) {
        return null;
      }
      var cmd = new TagManagerCommand(component);
      cmd.setEnabled(enabled);
      return cmd;
    });
  };
  return TagManagerCommand;
});
