function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/commands/EditRelationCommand
 * @since Niagara 4.15
 */
define(['baja!', 'lex!tagdictionary,webEditors', 'Promise', 'bajaux/commands/Command', 'nmodule/tagdictionary/rc/util/relationUtil', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/PropertySheet'], function (baja, lexs, Promise, Command, relationUtil, spaceUtils, feDialogs, PropertySheet) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    tagdictionaryLex = _lexs[0],
    webEditorsLex = _lexs[1],
    resolveStation = spaceUtils.resolveStation,
    findRelationAndComponentToEdit = relationUtil.findRelationAndComponentToEdit,
    makeDisplayName = relationUtil.makeDisplayName,
    EDIT_RELATION_HEADER = tagdictionaryLex.get('commands.EditRelationCommand.editRelation.displayName'),
    EDIT_LINK_HEADER = tagdictionaryLex.get('commands.EditRelationCommand.editLink.displayName');

  /**
   * Edits a relation or a link
   *
   * @class
   * @alias module:nmodule/tagdictionary/rc/commands/EditRelationCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    function EditRelationCommand(mgr) {
      var _this;
      _classCallCheck(this, EditRelationCommand);
      _this = _callSuper(this, EditRelationCommand, [{
        module: 'tagdictionary',
        lex: 'commands.EditRelationCommand',
        undoable: function undoable() {
          return _this.$makeUndoable();
        }
      }]);
      _this.$mgr = mgr;
      return _this;
    }

    /**
     * @private
     * @returns {Promise.<module:bajaux/commands/Command~Undoable>}  an undoable that will edit a relation or link and undo the edit.
     */
    _inherits(EditRelationCommand, _Command);
    return _createClass(EditRelationCommand, [{
      key: "$makeUndoable",
      value: function $makeUndoable() {
        var mgr = this.$mgr;
        var relation = mgr.getMainTable().getSelectedRows()[0].getSubject().relation(),
          managedComponent = mgr.value(),
          parentComponent,
          slotOnParent;
        return findRelationAndComponentToEdit(relation, managedComponent).then(function (result) {
          relation = result.relation;
          slotOnParent = result.slotOnParent;
          parentComponent = result.parent;
          return resolveStation();
        }).then(function (station) {
          var title = relation.getType().is('baja:Link') ? EDIT_LINK_HEADER : EDIT_RELATION_HEADER,
            editedTypeStr = relation.getType().getTypeName(),
            oldRelation = relation.newCopy(),
            componentDisplayName = makeDisplayName(managedComponent);
          var newRelation;
          return {
            redo: function redo() {
              if (newRelation) {
                return parentComponent.set({
                  slot: slotOnParent,
                  value: newRelation
                });
              }
              return feDialogs.showFor({
                title: title,
                value: relation,
                properties: {
                  ordBase: station,
                  showHeader: false,
                  showControls: false,
                  allowHyperlink: false
                },
                formFactor: 'max',
                type: PropertySheet,
                onSaveError: function onSaveError(err) {
                  var errorMsg = webEditorsLex.get('command.error', title);
                  var params = {
                    title: title,
                    messageSummary: errorMsg
                  };
                  return feDialogs.error(err, params);
                }
              }).then(function () {
                newRelation = relation.newCopy();
              });
            },
            undo: function undo() {
              return parentComponent.set({
                slot: slotOnParent,
                value: oldRelation
              });
            },
            redoText: tagdictionaryLex.get({
              key: 'commands.EditRelationCommand.redo',
              args: [editedTypeStr, componentDisplayName]
            }),
            undoText: tagdictionaryLex.get({
              key: 'commands.EditRelationCommand.undo',
              args: [editedTypeStr, componentDisplayName]
            })
          };
        });
      }
    }]);
  }(Command);
});
