function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/commands/DeleteRelationCommand
 * @since Niagara 4.15
 */
define(['baja!', 'dialogs', 'lex!tagdictionary,webEditors', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/tagdictionary/rc/util/relationUtil', 'nmodule/webEditors/rc/fe/baja/util/typeUtils'], function (baja, dialogs, lexs, Promise, _, Command, relationUtil, typeUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    tagdictionaryLex = _lexs[0],
    webEditorsLex = _lexs[1],
    findRelationAndComponentToEdit = relationUtil.findRelationAndComponentToEdit,
    makeDisplayName = relationUtil.makeDisplayName,
    isComponent = typeUtils.isComponent,
    every = _.every;

  /**
   * Deletes relations and/or links
   *
   * @class
   * @alias module:nmodule/tagdictionary/rc/commands/DeleteRelationCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    function DeleteRelationCommand(mgr) {
      var _this;
      _classCallCheck(this, DeleteRelationCommand);
      _this = _callSuper(this, DeleteRelationCommand, [{
        module: 'tagdictionary',
        lex: 'commands.DeleteRelationCommand',
        undoable: function undoable() {
          return _this.$makeUndoable();
        }
      }]);
      _this.$mgr = mgr;
      return _this;
    }

    /**
     * Require ADMIN_WRITE permissions.
     *
     * @private
     * @param {baja.Component} comp
     * @returns {Boolean} true if I have admin write permissions on this component
     */
    _inherits(DeleteRelationCommand, _Command);
    return _createClass(DeleteRelationCommand, [{
      key: "$canPerformDelete",
      value: function $canPerformDelete(comp) {
        return isComponent(comp) && comp.getPermissions().hasAdminWrite();
      }

      /**
       * @private
       * @returns {Promise.<module:bajaux/commands/Command~Undoable>}  an undoable that will delete relations and/or links and reinstate them.
       */
    }, {
      key: "$makeUndoable",
      value: function $makeUndoable() {
        var _this2 = this;
        var mgr = this.$mgr,
          component = mgr.value(),
          selectedRows = mgr.getMainTable().getSelectedRows();
        if (selectedRows.length === 0) {
          return Promise.resolve();
        }
        return Promise.all(selectedRows.map(function (row) {
          var relation = row.getSubject().relation();
          return findRelationAndComponentToEdit(relation, component).then(function (result) {
            return [result.slotOnParent, result.relation, result.parent];
          });
        })).then(function (toDelete) {
          var canDeleteSlots = every(toDelete, function (_ref) {
            var _ref2 = _slicedToArray(_ref, 3),
              slotName = _ref2[0],
              relation = _ref2[1],
              component = _ref2[2];
            return _this2.$canPerformDelete(component);
          });
          if (!canDeleteSlots) {
            return;
          }
          var numberOfDeletes = toDelete.length,
            numberOfDeletesDisplay = numberOfDeletes === 1 ? '' : numberOfDeletes + ' ',
            deleteTypesStr = numberOfDeletes === 1 ? toDelete[0][1].getType().getTypeName() : 'Relations/Links',
            managedComponent = mgr.value(),
            componentDisplayName = makeDisplayName(managedComponent),
            performCmd = _this2.$performDeletes,
            reinstate = _this2.$reinstateDeletes;
          var redoDeletes;
          return {
            redo: function redo() {
              if (redoDeletes) {
                return performCmd(toDelete);
              }
              return dialogs.showOkCancel({
                title: webEditorsLex.get('commands.delete.confirm.title'),
                text: webEditorsLex.get('commands.delete.confirm.content')
              }).ok(function () {
                return performCmd(toDelete).then(function () {
                  redoDeletes = true;
                });
              }).promise();
            },
            undo: function undo() {
              return reinstate(toDelete);
            },
            redoText: tagdictionaryLex.get({
              key: 'commands.DeleteRelationCommand.redo',
              args: [numberOfDeletesDisplay, deleteTypesStr, componentDisplayName]
            }),
            undoText: tagdictionaryLex.get({
              key: 'commands.DeleteRelationCommand.undo',
              args: [numberOfDeletesDisplay, deleteTypesStr, componentDisplayName]
            })
          };
        });
      }

      /**
       * Do the deletes
       *
       * @private
       * @param {Array.<Array>} deletes, an array of arrays containing the slotName, slotValue and the component to remove from
       * @returns {Promise}
       */
    }, {
      key: "$performDeletes",
      value: function $performDeletes(deletes) {
        return Promise.all(deletes.map(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 3),
            slotName = _ref4[0],
            slotValue = _ref4[1],
            parent = _ref4[2];
          return parent.remove(slotName);
        }));
      }

      /**
       * reinstate the deletes
       *
       * @private
       * @param {Array.<Array>} deletes, an array of arrays containing the slotName, slotValue and the component to reinstate to
       * @returns {Promise}
       */
    }, {
      key: "$reinstateDeletes",
      value: function $reinstateDeletes(deletes) {
        return Promise.all(deletes.map(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 3),
            slotName = _ref6[0],
            relation = _ref6[1],
            component = _ref6[2];
          return component.add({
            slot: slotName,
            value: relation
          });
        }));
      }
    }]);
  }(Command);
});
