function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/commands/AddRelationCommand
 * @since Niagara 4.15
 */
define(['baja!', 'baja!baja:Relation,baja:Link', 'lex!tagdictionary,webEditors', 'bajaux/commands/Command', 'nmodule/tagdictionary/rc/util/relationUtil', 'nmodule/webEditors/rc/fe/baja/DynamicEnumEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/PropertySheet'], function (baja, types, lexs, Command, relationUtil, DynamicEnumEditor, spaceUtils, feDialogs, PropertySheet) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 2),
    tagdictionaryLex = _lexs[0],
    webEditorsLex = _lexs[1],
    resolveStation = spaceUtils.resolveStation,
    makeDisplayName = relationUtil.makeDisplayName,
    RELATION_SLOT = relationUtil.RELATION_SLOT,
    LINK_SLOT = relationUtil.LINK_SLOT,
    ENUM_SELECTION_TAGS = ['Relation', 'Link'],
    enumSelection = baja.DynamicEnum.make({
      ordinal: 0,
      range: baja.EnumRange.make({
        options: baja.Facets.make({
          lexicon: 'tagdictionary'
        }),
        ordinals: [0, 1],
        tags: ENUM_SELECTION_TAGS
      })
    }),
    TITLE = tagdictionaryLex.get('commands.AddRelationCommand.dialog.title'),
    ADD_RELATION_HEADER = tagdictionaryLex.get('commands.AddRelationCommand.addRelation.displayName'),
    ADD_LINK_HEADER = tagdictionaryLex.get('commands.AddRelationCommand.addLink.displayName');

  /**
   * Adds a relation or a link
   *
   * @class
   * @alias module:nmodule/tagdictionary/rc/commands/AddRelationCommand
   * @extends module:bajaux/commands/Command
   */
  return /*#__PURE__*/function (_Command) {
    function AddRelationCommand(mgr) {
      var _this;
      _classCallCheck(this, AddRelationCommand);
      _this = _callSuper(this, AddRelationCommand, [{
        module: 'tagdictionary',
        lex: 'commands.AddRelationCommand',
        undoable: function undoable(draggedComponent) {
          return _this.$makeUndoable(draggedComponent);
        }
      }]);
      _this.$mgr = mgr;
      return _this;
    }

    /**
     * Prevent the relation id from being blank before saving.
     *
     * @private
     * @param {baja.Relation} valueToValidate the relation or link to validate
     * @returns {Boolean} whether the input is valid
     */
    _inherits(AddRelationCommand, _Command);
    return _createClass(AddRelationCommand, [{
      key: "$validateInput",
      value: function $validateInput(valueToValidate) {
        return !!valueToValidate.getRelationId();
      }

      /**
       * @private
       * @param {baja.Component|null} draggedComponent a component dragged from the nav tree
       * @returns {Promise.<module:bajaux/commands/Command~Undoable>}  an undoable that will add a relation or link and remove it.
       */
    }, {
      key: "$makeUndoable",
      value: function $makeUndoable(draggedComponent) {
        var _this2 = this;
        var mgr = this.$mgr,
          managedComponent = mgr.value();
        var newValue;
        return feDialogs.showFor({
          title: TITLE,
          value: enumSelection,
          properties: {
            customEntry: false
          },
          formFactor: 'max',
          type: DynamicEnumEditor
        }).then(function (selected) {
          if (!selected) {
            return;
          }
          newValue = baja.$('baja:' + selected.getTag());
          return resolveStation();
        }).then(function (station) {
          if (!station) {
            return;
          }
          if (draggedComponent) {
            newValue.setSourceOrd(draggedComponent.getNavOrd().relativizeToSession());
          }
          var title = newValue.getType().is('baja:Link') ? ADD_LINK_HEADER : ADD_RELATION_HEADER;
          return feDialogs.showFor({
            title: title,
            value: newValue,
            properties: {
              ordBase: station,
              showHeader: false,
              showControls: false,
              readBehavior: 'copy',
              allowHyperlink: false
            },
            formFactor: 'max',
            type: PropertySheet,
            onSaveError: function onSaveError(err) {
              var errorMsg = webEditorsLex.get('command.error', title);
              var params = {
                title: title,
                messageSummary: errorMsg
              };
              return feDialogs.error(err, params);
            },
            validate: _this2.$validateInput
          });
        }).then(function (valueToAdd) {
          // should be null if the dialog is cancelled
          if (valueToAdd) {
            var addedType = newValue.getType().getTypeName(),
              componentDisplayName = makeDisplayName(managedComponent);
            var addedRelationOrLink;
            return {
              redo: function redo() {
                return managedComponent.add({
                  slot: valueToAdd.getType().is('baja:Link') ? LINK_SLOT : RELATION_SLOT,
                  value: valueToAdd
                }).then(function (added) {
                  addedRelationOrLink = added;
                });
              },
              undo: function undo() {
                return managedComponent.remove(addedRelationOrLink.getName());
              },
              redoText: tagdictionaryLex.get({
                key: 'commands.AddRelationCommand.redo',
                args: [addedType, componentDisplayName]
              }),
              undoText: tagdictionaryLex.get({
                key: 'commands.AddRelationCommand.undo',
                args: [addedType, componentDisplayName]
              })
            };
          }
        });
      }
    }]);
  }(Command);
});
