function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/column/RelationIconColumn
 * @since Niagara 4.15
 */
define(['baja!', 'jquery', 'lex!tagdictionary', 'Promise', 'bajaux/util/CommandButton', 'nmodule/tagdictionary/rc/commands/TagManagerCommand', 'nmodule/tagdictionary/rc/util/relationUtil', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn'], function (baja, $, lex, Promise, CommandButton, TagManagerCommand, relationUtil, fe, MgrColumn) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
    tagdictionaryLex = _lex[0],
    findRelationAndComponentToEdit = relationUtil.findRelationAndComponentToEdit,
    RELATION_TYPE = relationUtil.RELATION_TYPE,
    RELATION_TAGS = relationUtil.RELATION_TAGS,
    RELATION_TAGS_HOVER_TEXT = relationUtil.RELATION_TAGS_HOVER_TEXT,
    RELATION_TYPE_DIRECT = relationUtil.RELATION_TYPE_DIRECT,
    RELATION_TYPE_LINK = relationUtil.RELATION_TYPE_LINK,
    RELATION_TYPE_KNOB = relationUtil.RELATION_TYPE_KNOB,
    RELATION_TYPE_RELATION_KNOB = relationUtil.RELATION_TYPE_RELATION_KNOB;

  /**
   * @class
   * @alias module:nmodule/tagdictionary/rc/column/RelationTagsColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
   */
  return /*#__PURE__*/function (_MgrColumn) {
    /**
     * @class
     * @alias module:nmodule/tagdictionary/rc/column/RelationTagsColumn
     * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrColumn
     */
    function RelationTagsColumn() {
      _classCallCheck(this, RelationTagsColumn);
      return _callSuper(this, RelationTagsColumn, ['relationTags', {
        displayName: tagdictionaryLex.get('columns.RelationTagsColumn.displayName')
      }]);
    }

    /**
     * Creates the cell's contents with a button that pops up a tag editor.
     * Also adds hovertext to show the relation's current tags
     *
     * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
     * @param {JQuery} dom
     * @returns {Promise}
     */
    _inherits(RelationTagsColumn, _MgrColumn);
    return _createClass(RelationTagsColumn, [{
      key: "buildCell",
      value: function buildCell(row, dom) {
        var subject = row.getSubject(),
          relationType = subject[RELATION_TYPE],
          mgr = this.getManager(),
          relationTags = subject[RELATION_TAGS];
        var tagsEditable = false;
        switch (relationType) {
          case RELATION_TYPE_LINK:
          case RELATION_TYPE_DIRECT:
          case RELATION_TYPE_KNOB:
          case RELATION_TYPE_RELATION_KNOB:
            tagsEditable = true;
            break;
        }
        tagsEditable &= !!relationTags;
        if (!tagsEditable) {
          return Promise.resolve();
        }
        var lexParams = {
          lex: 'commands.RelationManger.tagManagerCmd',
          description: row.getSubject()[RELATION_TAGS_HOVER_TEXT]
        };
        return findRelationAndComponentToEdit(subject.relation(), mgr.value()).then(function (result) {
          var relationToEdit = result.relation;
          return relationToEdit && fe.buildFor({
            dom: dom,
            type: CommandButton,
            value: new TagManagerCommand(result.relation, lexParams)
          });
        });
      }

      /**
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @returns {baja.Value}
       */
    }, {
      key: "getValueFor",
      value: function getValueFor(row) {
        return row.getSubject()[RELATION_TAGS_HOVER_TEXT];
      }
    }]);
  }(MgrColumn);
});
