function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/RelationManager
 * @since Niagara 4.15
 */
define(['baja!', 'baja!baja:Relation,baja:Link', 'log!nmodule.tagdictionary.rc.RelationManager', 'Promise', 'jquery', 'underscore', 'bajaux/commands/CommandGroup', 'bajaux/dragdrop/dragDropUtils', 'bajaux/mixin/subscriberMixIn', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/tagdictionary/rc/commands/AddRelationCommand', 'nmodule/tagdictionary/rc/commands/DeleteRelationCommand', 'nmodule/tagdictionary/rc/commands/EditRelationCommand', 'nmodule/tagdictionary/rc/filter/RelationFilter', 'nmodule/tagdictionary/rc/model/RelationModel', 'nmodule/tagdictionary/rc/util/relationUtil', 'nmodule/tagdictionary/rc/util/visNetworkUtil', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'hbs!nmodule/tagdictionary/rc/template/RelationManager', 'css!nmodule/tagdictionary/rc/tagdictionary'], function (baja, types, log, Promise, $, _, CommandGroup, dragDropUtils, subscriberMixIn, switchboard, AddRelationCommand, DeleteRelationCommand, EditRelationCommand, RelationFilter, RelationModel, relationUtil, visNetworkUtil, Manager, mgrUtils, tplRelationManager) {
  'use strict';

  var logError = log.severe.bind(log),
    findCommand = mgrUtils.findCommand,
    LIMIT_EXCEEDED_STYLE_CLASS = visNetworkUtil.LIMIT_EXCEEDED_STYLE_CLASS,
    INBOUND_PATH = relationUtil.INBOUND_PATH,
    INBOUND_PATH_HOVER_TEXT = relationUtil.INBOUND_PATH_HOVER_TEXT,
    THIS_COMP = relationUtil.THIS_COMP,
    THIS_COMP_HOVER_TEXT = relationUtil.THIS_COMP_HOVER_TEXT,
    OUTBOUND_PATH = relationUtil.OUTBOUND_PATH,
    OUTBOUND_PATH_HOVER_TEXT = relationUtil.OUTBOUND_PATH_HOVER_TEXT,
    IMPLIED_ROW_STYLE_CLASS = relationUtil.IMPLIED_ROW_STYLE_CLASS,
    RELATION_MANAGER_MODEL_VIEW_STYLE_CLASS = relationUtil.RELATION_MANAGER_MODEL_VIEW_STYLE_CLASS;
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'tagdictionary',
      keyName: 'RelationManager',
      properties: {
        rootCssClass: '-t-RelationManager',
        hideCommandBar: {
          value: true,
          hidden: true,
          "transient": true,
          readonly: true
        },
        showFilterBar: true,
        showDirect: true,
        showImplied: true,
        showLinks: true,
        showModel: true,
        showTable: true
      }
    };
  };

  /**
   * RelationManager
   *
   * @class
   * @alias module:nmodule/tagdictionary/rc/RelationManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   * @param {Object} [params]
   */
  return /*#__PURE__*/function (_Manager) {
    function RelationManager(params) {
      var _this;
      _classCallCheck(this, RelationManager);
      _this = _callSuper(this, RelationManager, [{
        params: _.extend({
          moduleName: 'tagdictionary',
          keyName: 'RelationManager'
        }, params),
        defaults: widgetDefaults()
      }]);
      subscriberMixIn(_this);
      switchboard(_this, {
        'updateViewContent': {
          allow: 'oneAtATime',
          onRepeat: 'preempt'
        }
      });
      return _this;
    }

    /*
     * @param {JQuery} dom
     * @param {Object} [params] the initialization parameters
     * @returns {Promise}
     */
    _inherits(RelationManager, _Manager);
    return _createClass(RelationManager, [{
      key: "doInitialize",
      value: function doInitialize(dom, params) {
        var _this2 = this;
        return _superPropGet(RelationManager, "doInitialize", this, 3)([dom, _.extend(params || {}, {
          html: tplRelationManager({
            modelViewStyleClass: RELATION_MANAGER_MODEL_VIEW_STYLE_CLASS,
            limitExceededStyleClass: LIMIT_EXCEEDED_STYLE_CLASS,
            limitExceededMessage: visNetworkUtil.getLimitExceededMessage()
          })
        })]).then(function () {
          var lowerPane = dom.find('.mgr-pane-bottom'),
            relationFilterElement = dom.find('.-t-RelationManager-filter'),
            container = dom.find('.mgr-pane-container'),
            splitPane = dom.find('.split-pane');
          splitPane.splitPane(); // initialize the split pane
          splitPane.splitPane('firstComponentSize', container.height() / 2);
          lowerPane.on('dragover', function (e) {
            // this has the effect of allowing drag and drop on a readonly input
            e.preventDefault();
          });
          lowerPane.on('drop', function (e) {
            _this2.$processDropFromNavTree(e)["catch"](logError);
          });
          lowerPane.on('click', '.mainTable tr', function (event) {
            return visNetworkUtil.mainTableClickHandler(event, _this2);
          });
          _this2.$relationFilter = new RelationFilter(_this2);
          return _this2.$relationFilter.initialize(relationFilterElement);
        }).then(function () {
          var sub = _this2.getSubscriber();
          sub.attach('added changed', function (prop, cx) {
            var value = _this2.value();
            if (!value) {
              return;
            }
            var propValue = value.get(prop),
              propValueType = propValue.getType();
            if (propValueType.is('baja:Relation')) {
              return _this2.updateViewContent()["catch"](logError);
            }
          });
          sub.attach('removed', function (prop, value, cx) {
            var propValueType = value.getType();
            if (propValueType.is('baja:Relation')) {
              return _this2.updateViewContent()["catch"](logError);
            }
          });
          sub.attach('addKnob removeKnob', function (prop, relation, cx) {
            return _this2.updateViewContent()["catch"](logError);
          });
          sub.attach('addRelationKnob removeRelationKnob', function (relation, cx) {
            return _this2.updateViewContent()["catch"](logError);
          });
        });
      }

      /**
       * Calls super.doLoad to initialize and load the main table with the model,
       * populates it with relations (including links), knobs and relationKnobs,
       * and arms change handlers.
       *
       * @param {baja.Component} component
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(component) {
        var that = this;
        return _superPropGet(RelationManager, "doLoad", this, 3)(arguments).then(function () {
          return that.updateViewContent();
        });
      }

      /**
       * Set the height of the model view
       * @returns {*|Promise}
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.isDesignTime() && this.updateViewContent();
      }

      /**
       * Create the relation model
       *
       * @override
       * @returns {Promise.<module:nmodule/tagdictionary/rc/model/RelationModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel() {
        return Promise.resolve(RelationModel.make());
      }

      /**
       * Override to update manager row styling
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {JQuery} dom
       * @returns {Promise.<JQuery>} resolves to a dom element with updated styling
       */
    }, {
      key: "finishMainTableRow",
      value: function finishMainTableRow(row, dom) {
        return _superPropGet(RelationManager, "finishMainTableRow", this, 3)([row, dom]).then(function (superDom) {
          dom.toggleClass(IMPLIED_ROW_STYLE_CLASS, row.getSubject().isImplied());
          var inboundCol = superDom.find('.js-col-' + INBOUND_PATH),
            outboundCol = superDom.find('.js-col-' + OUTBOUND_PATH),
            thisCompCol = superDom.find('.js-col-' + THIS_COMP),
            inboundHoverText = row.getSubject()[INBOUND_PATH_HOVER_TEXT],
            outboundHoverText = row.getSubject()[OUTBOUND_PATH_HOVER_TEXT],
            thisCompHoverText = row.getSubject()[THIS_COMP_HOVER_TEXT];
          if (inboundHoverText) {
            inboundCol.attr('title', inboundHoverText);
          }
          if (outboundHoverText) {
            outboundCol.attr('title', outboundHoverText);
          }
          thisCompCol.attr('title', thisCompHoverText);
          return superDom;
        });
      }

      /**
       * update the view
       *
       * @returns {Promise}
       */
    }, {
      key: "updateViewContent",
      value: function updateViewContent() {
        var _this3 = this;
        // don't do anything if the value hasn't been set up yet
        if (!this.value()) {
          return Promise.resolve();
        }
        return RelationModel.populateRelations(this).then(function () {
          return RelationModel.updateFilter(_this3);
        }).then(function () {
          var relationFilter = _this3.getRelationFilter();
          relationFilter.updateSplitPane();
          return relationFilter.getShowModel() && visNetworkUtil.makeVisualizationModelView(_this3);
        });
      }

      /**
       * Overrides the default onMainTableDblClicked handler and invokes the EditCommand
       * @inheritDoc
       */
    }, {
      key: "onMainTableDblClicked",
      value: function onMainTableDblClicked(event, subjects) {
        if (subjects.length === 1 && subjects[0].isEditable()) {
          return this.$getEditCommand().invoke();
        }
      }

      /**
       * Overrides the default logic and enables/disables the Edit and Delete commands
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var mainTableSelection = selectedSubjects.mainTableSelection,
          hasAdminWrite = this.value().getPermissions().hasAdminWrite();
        this.$getNewCommand().setEnabled(hasAdminWrite);
        var editEnabled = hasAdminWrite && mainTableSelection.length === 1 && mainTableSelection[0].isEditable();
        this.$getEditCommand().setEnabled(editEnabled);
        var deleteEnabled = hasAdminWrite && mainTableSelection.length > 0 && _.every(mainTableSelection, function (selected) {
          return selected.isEditable();
        });
        this.$getDeleteCommand().setEnabled(deleteEnabled);
        return Promise.resolve();
      }

      /**
       * Takes the existing command group commands and add them to the context menu if they are enabled
       *
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "toContextMenuCommandGroup",
      value: function toContextMenuCommandGroup() {
        var cmds = this.getCommandGroup().flatten().filter(function (cmd) {
          return !(cmd instanceof AddRelationCommand) && _.result(cmd, 'isEnabled');
        });
        return new CommandGroup({
          commands: cmds
        });
      }

      /**
       * Return the 'AddRelationCommand' instance from the command group.
       *
       * @private
       * @override
       * @returns  {module:nmodule/tagdictionary/rc/commands/AddRelationCommand}
       */
    }, {
      key: "$getNewCommand",
      value: function $getNewCommand() {
        return findCommand(this, AddRelationCommand);
      }

      /**
       * Return the 'EditRelationCommand' instance from the command group.
       *
       * @private
       * @override
       * @returns  {module:nmodule/tagdictionary/rc/commands/EditRelationCommand}
       */
    }, {
      key: "$getEditCommand",
      value: function $getEditCommand() {
        return findCommand(this, EditRelationCommand);
      }

      /**
       * Return the 'DeleteCommand' instance from the command group.
       *
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/commands/DeleteCommand}
       */
    }, {
      key: "$getDeleteCommand",
      value: function $getDeleteCommand() {
        return findCommand(this, DeleteRelationCommand);
      }

      /**
       * Calls the AddRelationCommand populating sourceOrd with ord of the dropped component.
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$processDropFromNavTree",
      value: function $processDropFromNavTree(event) {
        var _this4 = this;
        var dataTransfer = event.originalEvent.dataTransfer,
          json = dataTransfer.getData('Text');
        var dropped;
        if (json && (dropped = JSON.parse(json)) && dropped.mime !== 'niagara/navnodes') {
          // ignore if the mime type is not 'niagara/navnodes'
          return Promise.resolve();
        }
        return dragDropUtils.fromClipboard(event.originalEvent.dataTransfer).then(function (envelope) {
          return envelope.toValues();
        }).then(function (values) {
          // only deal with one dragged component
          if (values.length !== 1) {
            return;
          }
          return findCommand(_this4, AddRelationCommand).invoke(values[0]);
        });
      }

      /**
       * Returns the default set of Relation Manager commands.
       *
       * @returns {Array.<module:bajaux/commands/Command>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        return [new AddRelationCommand(this), new EditRelationCommand(this), new DeleteRelationCommand(this)];
      }

      /**
       * @returns {module:nmodule/tagdictionary/rc/filter/RelationFilter}
       */
    }, {
      key: "getRelationFilter",
      value: function getRelationFilter() {
        return this.$relationFilter;
      }
    }]);
  }(Manager);
});
