function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx UxModel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/converters/rc/fe/IStatusToSimpleEditor
 */
define(['baja!', 'baja!converters:IStatusToSimple', 'lex!baja,converters,pxEditor', 'bajaux/model/UxModel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'bajaux/spandrel', 'jquery', 'nmodule/bajaui/rc/baja/Border', 'nmodule/bajaui/rc/ux/BorderPane', 'nmodule/bajaui/rc/ux/Label', 'nmodule/gx/rc/baja/Insets', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils', 'nmodule/webEditors/rc/wb/table/EditTable'], function (baja, types, lexs, UxModel, Command, CommandButton, spandrel, _, Border, BorderPane, Label, Insets, compUtils, componentStatusUtils, EditTable) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 3),
    bajaLex = _lexs[0],
    convertersLex = _lexs[1],
    pxEditorLex = _lexs[2];
  var _EditTable$columns = EditTable.columns,
    display = _EditTable$columns.display,
    edit = _EditTable$columns.edit;
  var statusSlotNames = ['alarm', 'disabled', 'fault', 'down', 'stale', 'overridden', 'nullStatus', 'unackedAlarm', 'ok'];
  function makeColumns(properties) {
    return [display('status', {
      displayName: convertersLex.get('IStatusToSimpleEditor.status'),
      properties: properties
    }), edit('value', {
      displayName: convertersLex.get('IStatusToSimpleEditor.value'),
      properties: properties
    })];
  }
  function isBrush(val) {
    return baja.hasType(val, 'gx:Brush');
  }

  /**
   * Editor for `converters:IStatusToSimple` instances.
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/converters/rc/fe/IStatusToSimpleEditor
   */
  return /*#__PURE__*/function (_spandrel) {
    function IStatusToSimpleEditor(params) {
      var _this;
      _classCallCheck(this, IStatusToSimpleEditor);
      _this = _callSuper(this, IStatusToSimpleEditor, [{
        params: params
      }]);
      _this.$backgroundCmd = new Command({
        module: "converters",
        lex: "IStatusToSimpleEditor.commands.background",
        func: function func() {
          return _this.$applyBackgroundValues();
        }
      });
      _this.$foregroundCmd = new Command({
        module: "converters",
        lex: "IStatusToSimpleEditor.commands.foreground",
        func: function func() {
          return _this.$applyForegroundValues();
        }
      });
      return _this;
    }

    /**
     * @private
     * @param {String} type of selected button
     * @returns {Object} object containing status and default brush color
     */
    _inherits(IStatusToSimpleEditor, _spandrel);
    return _createClass(IStatusToSimpleEditor, [{
      key: "doRead",
      value: function doRead() {
        return this.$getEditTable().read().then(function (rows) {
          return fromRows(rows);
        });
      }
    }, {
      key: "$getObj",
      value: function $getObj(type) {
        var _this2 = this;
        var obj = {},
          defaultStatuses = ['disabled', 'fault', 'down', 'alarm', 'stale', 'overridden'],
          nullStatuses = ['nullStatus', 'unackedAlarm', 'ok'];
        _.each(defaultStatuses, function (status) {
          var statusStr = defaultStatuses[status];
          obj[statusStr] = baja.$('gx:Brush', type === 'bg' ? _this2.$getBackgroundColor(statusStr) : _this2.$getForegroundColor(statusStr));
        });
        _.each(nullStatuses, function (status) {
          var statusStr = nullStatuses[status];
          obj[statusStr] = baja.$('gx:Brush', null);
        });
        return obj;
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$applyBackgroundValues",
      value: function $applyBackgroundValues() {
        var newComponentWithBrushValuesApplied = baja.$('converters:IStatusToSimple', this.$getObj('bg'));
        return this.loadAndModify(newComponentWithBrushValuesApplied);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$applyForegroundValues",
      value: function $applyForegroundValues() {
        var newComponentWithBrushValuesApplied = baja.$('converters:IStatusToSimple', this.$getObj('fg'));
        return this.loadAndModify(newComponentWithBrushValuesApplied);
      }

      /**
       * @private
       * @param {string} statusTag
       * @returns {string|undefined}
       */
    }, {
      key: "$getBackgroundColor",
      value: function $getBackgroundColor(statusTag) {
        return componentStatusUtils.getBackground(statusTag);
      }

      /**
       * @private
       * @param {string} statusTag
       * @returns {string|undefined}
       */
    }, {
      key: "$getForegroundColor",
      value: function $getForegroundColor(statusTag) {
        return componentStatusUtils.getForeground(statusTag);
      }

      /**
       * @private
       * @returns {module:bajaux/util/Command}
       */
    }, {
      key: "$getBackgroundCommandButton",
      value: function $getBackgroundCommandButton() {
        return this.queryWidget('**/applyBackground');
      }

      /**
       * @private
       * @returns {module:bajaux/util/Command}
       */
    }, {
      key: "$getForegroundCommandButton",
      value: function $getForegroundCommandButton() {
        return this.queryWidget('**/applyForeground');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/EditTable}
       */
    }, {
      key: "$getEditTable",
      value: function $getEditTable() {
        return this.queryWidget('table');
      }
    }]);
  }(spandrel(function (iStatusToSimple, _ref) {
    var self = _ref.self;
    //all facets should be set the same for each status type
    var properties = iStatusToSimple.getFacets('disabled').toObject();
    var columns = makeColumns(properties);
    var text = pxEditorLex.get('statusToSimpleFE.applyStatusColors');
    return [UxModel.jsx(EditTable, {
      spandrelKey: "table",
      value: toRows(iStatusToSimple),
      properties: {
        columns: columns
      }
    }), isBrush(iStatusToSimple.get('alarm')) && UxModel.jsx(BorderPane, {
      name: "border",
      properties: {
        border: Border.make('2 groove black'),
        padding: Insets.make(8, 5, 5, 5)
      }
    }, UxModel.jsx(Label, {
      name: "label",
      properties: {
        text: text
      }
    }), UxModel.jsx("div", {
      name: "content",
      className: "-t-command-wrapper"
    }, UxModel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn",
      value: self.$foregroundCmd,
      spandrelKey: "applyForeground"
    }), UxModel.jsx(CommandButton, {
      tagName: "button",
      type: "button",
      className: "ux-btn",
      value: self.$backgroundCmd,
      spandrelKey: "applyBackground"
    })))];
  }));

  /**
   * @param {baja.Struct} iStatusToSimple a `converters:IStatusToSimple`
   * @returns {Array.<object>} rows to load into the `EditTable` with its slot values
   */
  function toRows(iStatusToSimple) {
    return statusSlotNames.map(function (status) {
      return {
        status: {
          value: bajaLex.get('Status.' + (status === 'nullStatus' ? 'null' : status))
        },
        value: {
          value: iStatusToSimple.get(status)
        }
      };
    });
  }

  /**
   * @param {Array.<object>} rows current rows in the `EditTable`
   * @returns {baja.Struct} a `converters:IStatusToSimple` with the current entered values
   */
  function fromRows(rows) {
    var obj = {};
    rows.forEach(function (row, idx) {
      obj[statusSlotNames[idx]] = row.value.value;
    });
    return baja.$('converters:IStatusToSimple', obj);
  }
});
