function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/converters/rc/fe/INumericToSimpleEditor
 */

define(['baja!', 'baja!converters:INumericToSimple', 'bajaux/spandrel', 'lex!converters', 'Promise', 'nmodule/converters/rc/NumericToSimpleMap', 'nmodule/webEditors/rc/fe/ValueWithPopoutWidget', 'nmodule/webEditors/rc/wb/table/EditTable'], function (baja, types, spandrel, lexs, Promise, NumericToSimpleMap, ValueWithPopoutWidget, EditTable) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    convertersLex = _lexs[0];
  var edit = EditTable.columns.edit;
  var CELL_MODIFIED_EVENT = EditTable.CELL_MODIFIED_EVENT;
  var syncRangesDisplayText = convertersLex.get('INumericToSimpleEditor.commands.syncRanges');
  function makeColumns(properties) {
    return [edit('min', {
      displayName: convertersLex.get('INumericToSimpleEditor.min')
    }), edit('max', {
      displayName: convertersLex.get('INumericToSimpleEditor.max')
    }), edit('value', {
      displayName: convertersLex.get('INumericToSimpleEditor.value'),
      properties: properties
    })];
  }

  /**
   * 
   * @param {Array.<module:nmodule/converters/rc/fe/INumericToSimpleEditor~MapObj>} mapObjs
   * @returns {Array.<object>}
   */
  function toRows(mapObjs) {
    return mapObjs.map(function (_ref) {
      var min = _ref.min,
        max = _ref.max,
        value = _ref.value;
      return {
        min: {
          value: min
        },
        max: {
          value: max
        },
        value: {
          value: value
        }
      };
    });
  }
  function fromRows(rows) {
    return rows.map(function (_ref2) {
      var min = _ref2.min,
        max = _ref2.max,
        value = _ref2.value;
      return {
        min: min.value,
        max: max.value,
        value: value.value
      };
    });
  }
  function canSyncRanges(map) {
    var mins = map.getMinimums(),
      maxs = map.getMaximums();
    var canSync = true;
    for (var i = 0; i < mins.length - 1; i++) {
      if (maxs[i] !== mins[i + 1]) {
        canSync = false;
        break;
      }
    }
    return canSync;
  }

  /**
   * INumericToSimpleEditor allows viewing and editing of a BINumericToSimple
   * 
   * @class
   * @alias module:nmodule/converters/rc/fe/INumericToSimpleEditor
   * @extends module:bajaux/spandrel
   */
  return /*#__PURE__*/function (_spandrel) {
    function INumericToSimpleEditor() {
      _classCallCheck(this, INumericToSimpleEditor);
      return _callSuper(this, INumericToSimpleEditor, arguments);
    }
    _inherits(INumericToSimpleEditor, _spandrel);
    return _createClass(INumericToSimpleEditor, [{
      key: "toState",
      value:
      /**
       * 
       * @param {module:nmodule/converters/rc/INumericToSimple} iNumericToSimple 
       * @returns {Promise.<object>}
       */
      function toState(iNumericToSimple) {
        var iNumericToSimpleMap = iNumericToSimple.getMap(),
          rows = toRows(iNumericToSimpleMap.$items),
          valueType = iNumericToSimpleMap.getValueType(),
          defaultVal = iNumericToSimpleMap.getDefault(),
          syncRanges = canSyncRanges(iNumericToSimpleMap);
        if (!valueType) {
          return {
            def: null,
            rows: rows,
            syncRanges: syncRanges
          };
        }
        return baja.importTypes([String(valueType)]).then(function () {
          return {
            def: defaultVal || baja.$(valueType),
            rows: rows,
            syncRanges: syncRanges
          };
        });
      }

      /**
       * 
       * @param {object} state 
       * @returns {module:nmodule/converters/rc/INumericoSimple}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var def = state.def,
          rows = state.rows;
        var numericToSimpleMap = new NumericToSimpleMap(fromRows(rows), def);
        var iNumericToSimple = baja.$('converters:INumericToSimple');
        iNumericToSimple.setMap(numericToSimpleMap);
        return iNumericToSimple;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/EditTable}
       */
    }, {
      key: "$getEditTable",
      value: function $getEditTable() {
        return this.queryWidget('table');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDefaultValueEditor",
      value: function $getDefaultValueEditor() {
        return this.queryWidget('defContainer/defEditor');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getSyncRangesEditor",
      value: function $getSyncRangesEditor() {
        return this.queryWidget('syncRanges');
      }

      /**
       * @private
       * @returns {object}
       */
    }, {
      key: "$getNew",
      value: function $getNew() {
        var _this$state = this.state(),
          def = _this$state.def,
          syncRanges = _this$state.syncRanges,
          rows = _this$state.rows;
        var table = this.$getEditTable().$getTable(),
          tableModel = table.value(),
          rowCount = tableModel.getRowCount(),
          provisionalRowCount = rowCount + 1;
        if (syncRanges && provisionalRowCount > 1) {
          var max = rows[provisionalRowCount - 2].max;
          return {
            min: {
              value: max.value
            },
            max: {
              value: 0
            },
            value: {
              value: def
            }
          };
        } else {
          return {
            min: {
              value: 0
            },
            max: {
              value: 0
            },
            value: {
              value: def
            }
          };
        }
      }

      /**
       * @private
       */
    }, {
      key: "$updateMaxEditorEnabled",
      value: function $updateMaxEditorEnabled() {
        var _this$state2 = this.state(),
          syncRanges = _this$state2.syncRanges;
        var allMaxEditors = this.$getEditTable().findEditors('max'),
          allMaxEditorsExceptLast = allMaxEditors.slice(0, allMaxEditors.length - 1);
        allMaxEditorsExceptLast.forEach(function (ed) {
          ed && ed.setEnabled(!syncRanges);
        });
      }

      /**
       * @private
       * @param {Array.<module:nmodule/converters/rc/fe/INumericToSimpleEditor~MapObj>} newRows 
       * @returns {Promise}
       */
    }, {
      key: "$tableEventHandler",
      value: function $tableEventHandler(newRows) {
        var _this = this;
        var _this$state3 = this.state(),
          syncRanges = _this$state3.syncRanges;
        return this.state({
          rows: newRows
        }).then(function () {
          return _this.$checkSync(syncRanges);
        });
      }

      /**
       * @private
       * @param {boolean} syncRanges
       * @returns {Promise}
       */
    }, {
      key: "$checkSync",
      value: function $checkSync(syncRanges) {
        var _this$state4 = this.state(),
          rows = _this$state4.rows;
        if (!syncRanges) {
          return Promise.resolve();
        }
        var newRows = rows.slice();
        rows.forEach(function (item, i) {
          // Get the min value of the next row
          var _ref3 = rows[i + 1] || {},
            min = _ref3.min;
          if (min) {
            newRows[i].max = {
              value: min.value
            };
          }
        });
        return this.state({
          rows: newRows
        });
      }
    }]);
  }(spandrel(function (iNumericToSimple, _ref4) {
    var def = _ref4.def,
      rows = _ref4.rows,
      syncRanges = _ref4.syncRanges,
      self = _ref4.self,
      properties = _ref4.properties;
    return [spandrel.jsx(EditTable, {
      spandrelKey: "table",
      lax: true,
      bindKey: "rows",
      value: rows,
      properties: {
        columns: makeColumns(properties),
        showControls: true,
        getNew: function getNew() {
          return self.$getNew();
        }
      },
      onUxLoad: function onUxLoad(e, editTable) {
        return self.$updateMaxEditorEnabled();
      },
      onUxModifiedValue: function onUxModifiedValue(rows) {
        return self.$tableEventHandler(rows);
      },
      on: _defineProperty({}, CELL_MODIFIED_EVENT, function (e, editTable, _ref5) {
        var column = _ref5.column,
          row = _ref5.row,
          index = _ref5.index;
        if (column === 'min' && syncRanges) {
          var newMin = row.min.value;
          var prevMaxEditor = editTable.findEditor('max', function (row, i) {
            return i === index - 1;
          });
          return prevMaxEditor && prevMaxEditor.loadAndModify(newMin);
        }
      })
    }), spandrel.jsx("any", {
      className: "-t-INumericToSimpleEditor-syncRanges",
      spandrelKey: "syncRanges",
      bind: true,
      value: syncRanges,
      properties: {
        displayType: 'checkbox',
        trueText: syncRangesDisplayText,
        falseText: syncRangesDisplayText
      },
      onUxModifiedValue: function onUxModifiedValue(syncRanges) {
        return self.$checkSync(syncRanges);
      }
    }), spandrel.jsx("div", {
      className: "-t-INumericToSimpleEditor-default-container",
      spandrelKey: "defContainer"
    }, spandrel.jsx("label", null, convertersLex.get('converterEditor.label.default')), spandrel.jsx(ValueWithPopoutWidget, {
      value: def,
      properties: properties,
      spandrelKey: "defEditor",
      bindKey: "def"
    }))];
  }, {
    strategy: 'niagara'
  }));

  /**
   * @typedef {object} module:nmodule/converters/rc/fe/INumericToSimpleEditor~MapObj
   * @property {number} min
   * @property {number} max
   * @property {*} value
   */
});
