function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/converters/rc/fe/IEnumToSimpleEditor
 */
define(['baja!', 'baja!converters:IEnumToSimple', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButtonGroup', 'lex!converters', 'nmodule/converters/rc/EnumToSimpleMap', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/table/EditTable', 'nmodule/webEditors/rc/wb/table/Table', 'css!nmodule/converters/rc/converters'], function (baja, types, spandrel, Command, CommandButtonGroup, lexs, EnumToSimpleMap, feDialogs, EditTable, Table) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    convertersLex = _lexs[0];
  var _EditTable$columns = EditTable.columns,
    display = _EditTable$columns.display,
    edit = _EditTable$columns.edit;
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var showFor = feDialogs.showFor;
  function makeColumns(properties) {
    return [display('ordinal', {
      displayName: convertersLex.get('IEnumToSimpleEditor.ordinal')
    }), display('name', {
      displayName: convertersLex.get('IEnumToSimpleEditor.name')
    }), edit('value', {
      displayName: convertersLex.get('INumericToSimpleEditor.value'),
      properties: properties
    })];
  }

  /**
   *
   * @param {Array.<module:nmodule/converters/rc/fe/IEnumToSimpleEditor~MapObj>} mapObjs
   * @param {baja.EnumRange} enumRange
   * @returns {Array.<object>}
   */
  function toRows(mapObjs, enumRange) {
    return enumRange.getOrdinals().map(function (ordinal) {
      var _ref = mapObjs.find(function (obj) {
          return obj.ordinal === ordinal;
        }) || {},
        value = _ref.value;
      return {
        ordinal: {
          value: ordinal
        },
        name: {
          value: enumRange.getDisplayTag(ordinal)
        },
        value: {
          value: value,
          readonly: true //for the EditColumns which requires a Set command to actually change
        }
      };
    });
  }

  /**
   * @class
   * @alias module:nmodule/converters/rc/fe/IEnumToSimpleEditor
   * @extends module:bajaux/spandrel
   */
  return /*#__PURE__*/function (_spandrel) {
    function IEnumToSimpleEditor() {
      var _this;
      _classCallCheck(this, IEnumToSimpleEditor);
      _this = _callSuper(this, IEnumToSimpleEditor, arguments);
      var cmdGrp = _this.getCommandGroup();
      cmdGrp.add(new Command({
        module: 'converters',
        lex: 'IEnumToSimpleEditor.commands.set',
        enabled: false,
        func: function func() {
          var table = _this.$getEditTable().$getTable(),
            rows = table.getSelectedRows(),
            value = rows[0].getSubject().value.value;
          return _this.$getDefaultValueEditor().read().then(function (defaultValue) {
            return showFor({
              value: value || defaultValue,
              formFactor: 'mini'
              //Note: BIEnumToSimpleFE.java uses BWbFieldEditor.dialog here (not a BWbCellEditor), so newLines are as-is here.
              //properties: this.properties().toObject()
            }).then(function (val) {
              if (val !== null) {
                return _this.$updateStateWithValue(rows, val);
              }
            });
          });
        }
      }));
      cmdGrp.add(new Command({
        module: 'converters',
        lex: 'IEnumToSimpleEditor.commands.clear',
        enabled: false,
        func: function func() {
          var table = _this.$getEditTable().$getTable(),
            rows = table.getSelectedRows();
          return _this.$updateStateWithValue(rows);
        }
      }));
      return _this;
    }

    /**
     *
     * @param {module:nmodule/converters/rc/IEnumToSimple} iEnumToSimple
     * @returns {Promise.<object>}
     */
    _inherits(IEnumToSimpleEditor, _spandrel);
    return _createClass(IEnumToSimpleEditor, [{
      key: "toState",
      value: function toState(iEnumToSimple) {
        var iEnumToSimpleMap = iEnumToSimple.getMap(),
          items = iEnumToSimpleMap.getOrdinals().map(function (ordinal) {
            return {
              ordinal: ordinal,
              value: iEnumToSimpleMap.get(ordinal)
            };
          }),
          valueType = iEnumToSimpleMap.getValueType(),
          defaultVal = iEnumToSimpleMap.getDefault();
        if (!valueType) {
          return {
            def: null,
            items: items
          };
        }
        return baja.importTypes([String(valueType)]).then(function () {
          return {
            def: defaultVal || baja.$(valueType),
            items: items
          };
        });
      }

      /**
       *
       * @param {object} state
       * @returns {module:nmodule/converters/rc/IEnumToSimple}
       */
    }, {
      key: "fromState",
      value: function fromState(state) {
        var def = state.def,
          items = state.items;
        var enumToSimpleMap = EnumToSimpleMap.make({
          items: items,
          def: def
        });
        var iEnumToSimple = baja.$('converters:IEnumToSimple');
        iEnumToSimple.setMap(enumToSimpleMap);
        return iEnumToSimple;
      }

      /**
       * @private
       * @param {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} rows
       * @param {*} [value]
       * @returns {Promise}
       */
    }, {
      key: "$updateStateWithValue",
      value: function $updateStateWithValue(rows, value) {
        var _this$state = this.state(),
          items = _this$state.items;
        rows.forEach(function (row) {
          var _row$getSubject = row.getSubject(),
            ordinal = _row$getSubject.ordinal;
          var existing = items.find(function (obj) {
            return obj.ordinal === ordinal.value;
          });
          if (existing) {
            existing.value = value;
          } else {
            items.push({
              ordinal: ordinal.value,
              value: value
            });
          }
        });
        return this.state({
          items: items
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/EditTable}
       */
    }, {
      key: "$getEditTable",
      value: function $getEditTable() {
        return this.queryWidget('table');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getCommandButtonGroup",
      value: function $getCommandButtonGroup() {
        return this.queryWidget('commands');
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getSetCommand",
      value: function $getSetCommand() {
        return this.$getCommandButtonGroup().value().get(0);
      }

      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */
    }, {
      key: "$getClearCommand",
      value: function $getClearCommand() {
        return this.$getCommandButtonGroup().value().get(1);
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getDefaultValueEditor",
      value: function $getDefaultValueEditor() {
        return this.queryWidget('defContainer/defEditor');
      }

      /**
       * @param {module:nmodule/webEditors/rc/wb/table/Table}
       * @private
       */
    }, {
      key: "$updateCommands",
      value: function $updateCommands(table) {
        var selectedRows = table.getSelectedRows(),
          enabled = selectedRows.length > 0;
        this.$getSetCommand().setEnabled(enabled);
        this.$getClearCommand().setEnabled(enabled);
      }
    }]);
  }(spandrel(function (iEnumToSimple, _ref2) {
    var items = _ref2.items,
      def = _ref2.def,
      properties = _ref2.properties,
      self = _ref2.self;
    var _ref3 = properties || {},
      range = _ref3.range;
    return [spandrel.jsx(EditTable, {
      spandrelKey: "table",
      lax: true,
      value: toRows(items, range),
      properties: {
        columns: makeColumns(properties),
        showControls: false
      },
      on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (e, table) {
        return self.$updateCommands(table);
      })
    }), spandrel.jsx(CommandButtonGroup, {
      className: "-t-IEnumToSimpleEditor-commands",
      spandrelKey: "commands",
      value: self.getCommandGroup()
    }), spandrel.jsx("div", {
      className: "-t-IEnumToSimpleEditor-default-container",
      spandrelKey: "defContainer"
    }, spandrel.jsx("label", null, convertersLex.get('converterEditor.label.default')), spandrel.jsx("any", {
      value: def,
      properties: properties,
      spandrelKey: "defEditor",
      bindKey: "def"
    }))];
  }, {
    strategy: 'niagara'
  }));

  /**
   * @typedef {object} module:nmodule/converters/rc/fe/IEnumToSimpleEditor~MapObj
   * @property {number} ordinal
   * @property {*} value
   */
});
