/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/hvac/RaiseLower
 */
define(['baja!', 'nmodule/kitControl/rc/baja/KitNumeric', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, KitNumeric, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:RaiseLower` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/KitNumeric}
   * @alias {module:nmodule/kitControl/rc/baja/hvac/RaiseLower}
   */
  var RaiseLower = function RaiseLower() {
    KitNumeric.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };
  RaiseLower.prototype = Object.create(KitNumeric.prototype);
  RaiseLower.prototype.constructor = RaiseLower;
  return RaiseLower;
});
