/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/hvac/LeadLagRuntime
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:LeadLagRuntime` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/hvac/LeadLagRuntime}
   */
  var LeadLagRuntime = function LeadLagRuntime() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out[A-J]$': 'facets'
    });
  };
  LeadLagRuntime.prototype = Object.create(Component.prototype);
  LeadLagRuntime.prototype.constructor = LeadLagRuntime;
  return LeadLagRuntime;
});
