/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/energy/SetpointOffset
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:SetpointOffset` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/energy/SetpointOffset}
   */
  var SetpointOffset = function SetpointOffset() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^((clg|htg)Offset|setpoint(In|Out))$': 'facets'
    });
  };
  SetpointOffset.prototype = Object.create(Component.prototype);
  SetpointOffset.prototype.constructor = SetpointOffset;
  return SetpointOffset;
});
