/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusNumericToInt
 */
define(['baja!', 'nmodule/kitControl/rc/baja/conversion/StatusValueToValue', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, StatusValueToValue, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation of a `kitControl:StatusNumericToInt` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/conversion/StatusValueToValue}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusNumericToInt}
   */
  var StatusNumericToInt = function StatusNumericToInt() {
    StatusValueToValue.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };
  StatusNumericToInt.prototype = Object.create(StatusValueToValue.prototype);
  StatusNumericToInt.prototype.constructor = StatusNumericToInt;

  /**
   * Return the value of the `facets` slot.
   *
   * @returns {baja.Facets}
   */
  StatusNumericToInt.prototype.getOutFacets = function () {
    return this.get('facets');
  };
  return StatusNumericToInt;
});
