/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/constants/Const
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
    proxySlotFacets = bajaUtils.proxySlotFacets;

  /**
   * BajaScript representation kitControl Constants Components
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/constants/Const}
   * @since Niagara 4.11
   */
  var Const = function Const() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^(out|set)$': 'facets'
    });
  };
  Const.prototype = Object.create(Component.prototype);
  Const.prototype.constructor = Const;

  /**
   * Returns a promise that resolves with the string value of the out `StatusValue`
   *
   * @param {Object} [cx] a context object
   * @returns {Promise.<string>|string}
   */
  Const.prototype.toString = function (cx) {
    if (!cx) {
      return Component.prototype.toString.apply(this, arguments);
    }
    return this.propertyValueToString('out', cx);
  };
  return Const;
});
