/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/mgr/EmailAccountColumn
 */
define(['baja!', 'Promise', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, Promise, PropertyMgrColumn) {
  'use strict';

  /**
   * Manager column for the `account` property.
   *
   * @class
   * @alias module:nmodule/email/rc/mgr/EmailAccountColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */
  var EmailAccountColumn = function EmailAccountColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };
  EmailAccountColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  EmailAccountColumn.prototype.constructor = EmailAccountColumn;

  /**
   * Override to return the value of the 'account' property of the email account's authenticator, if present.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {baja.Value} the 'account' Property value read from the email authenticator.
   */
  EmailAccountColumn.prototype.getValueFor = function (row) {
    var emailAccount = row.getSubject();
    var emailAuthenticator = emailAccount.get('emailAuthenticator');
    return emailAuthenticator.get('account') || '';
  };
  return EmailAccountColumn;
});
