/**
 * @copyright 2016, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 * @since Niagara 4.2
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/fe/EmailEditor
 */
define(['baja!', 'baja!email:Email,email:TextPart', 'lex!email', 'jquery', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/email/rc/fe/TextPartEditor', 'hbs!nmodule/email/rc/fe/templates/EmailEditor', 'css!nmodule/email/rc/email'], function (baja, types, lexs, $, ComplexCompositeEditor, TextPartEditor, template) {
  'use strict';

  var lex = lexs[0],
    FROM_LABEL = lex.get('email.from'),
    TO_LABEL = lex.get('email.to'),
    CC_LABEL = lex.get('email.cc'),
    BCC_LABEL = lex.get('email.bcc'),
    SUBJECT_LABEL = lex.get('email.subject'),
    FROM_EDITOR_CLASS = 'js-from',
    TO_EDITOR_CLASS = 'js-to',
    CC_EDITOR_CLASS = 'js-cc',
    BCC_EDITOR_CLASS = 'js-bcc',
    SUBJECT_EDITOR_CLASS = 'js-subject',
    BODY_EDITOR_CLASS = 'js-body';

  /**
   * EmailEditor is a field editor for an email:Email type
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/email/rc/fe/EmailEditor
   */
  var EmailEditor = function EmailEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  EmailEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  EmailEditor.prototype.constructor = EmailEditor;
  EmailEditor.prototype.doInitialize = function (dom) {
    dom.addClass('EmailEditor').html(template({
      fromLabel: FROM_LABEL,
      toLabel: TO_LABEL,
      ccLabel: CC_LABEL,
      bccLabel: BCC_LABEL,
      subjectLabel: SUBJECT_LABEL,
      from: FROM_EDITOR_CLASS,
      to: TO_EDITOR_CLASS,
      cc: CC_EDITOR_CLASS,
      bcc: BCC_EDITOR_CLASS,
      subject: SUBJECT_EDITOR_CLASS,
      body: BODY_EDITOR_CLASS
    }));
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Returns the editor for a given key
   * @private
   * @param {String} key key corresponding to an email:Email property
   * @returns {BaseEditor} Editor for the key
   */
  EmailEditor.prototype.$getEditor = function (key) {
    return this.getBuilder().getEditorFor(key);
  };

  /**
   * Loads the editor with a value of type 'email:EmailEditor
   *
   * @param email instance of type email:EmailEditor to load
   * @returns {Promise} Promise resolved when editor is loaded or rejected when value
   * of an incorrect type is loaded
   */
  EmailEditor.prototype.doLoad = function (email) {
    if (!baja.hasType(email, 'email:Email')) {
      throw new Error('Expected type email:Email');
    }
    return ComplexCompositeEditor.prototype.doLoad.apply(this, arguments);
  };

  ///////////////////////////////////////////////////////////////////
  //ComplexCompositeEditor overrides
  //////////////////////////////////////////////////////////////////
  EmailEditor.prototype.getSlotFilter = function () {
    return ['from', 'to', 'cc', 'bcc', 'body', 'subject'];
  };
  EmailEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = ComplexCompositeEditor.prototype.makeBuilder.apply(this, arguments),
      configFor = builder.getConfigFor;
    builder.getDomFor = function (key) {
      return that.jq().find('.js-' + key);
    };
    builder.getConfigFor = function (key) {
      return key === 'body' ? {
        type: TextPartEditor
      } : configFor.apply(this, arguments);
    };
    return builder;
  };
  return EmailEditor;
});
