function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016, Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 * @since Niagara 4.2
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/fe/EmailAddressEditor
 */
define(['baja!', 'baja!email:EmailAddress', 'lex!email', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'hbs!nmodule/email/rc/fe/templates/EmailAddressEditor', 'css!nmodule/email/rc/email'], function (baja, types, lexs, $, Promise, _, CompositeEditor, CompositeBuilder, fe, events, template) {
  'use strict';

  var lex = lexs[0],
    DEFAULT_INSTANCE = baja.$('email:EmailAddress'),
    PERSONAL_LABEL_CLASS = 'js-personalLabel',
    ADDRESS_LABEL_CLASS = 'js-addressLabel',
    PERSONAL_EDITOR_CLASS = 'js-personal',
    ADDRESS_EDITOR_CLASS = 'js-address',
    PERSONAL_LABEL_SELECTOR = '.' + PERSONAL_LABEL_CLASS,
    ADDRESS_LABEL_SELECTOR = '.' + ADDRESS_LABEL_CLASS,
    PERSONAL_EDITOR_SELECTOR = '.' + PERSONAL_EDITOR_CLASS,
    ADDRESS_EDITOR_SELECTOR = '.' + ADDRESS_EDITOR_CLASS;

  /**
   * EmailAddressEditor is a field editor for an email:EmailAddress type
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/email/rc/fe/EmailAddressEditor
   */

  var EmailAddressEditor = function EmailAddressEditor() {
    CompositeEditor.apply(this, arguments);
  };

  //extend and set up prototype chain
  EmailAddressEditor.prototype = Object.create(CompositeEditor.prototype);
  EmailAddressEditor.prototype.constructor = EmailAddressEditor;
  EmailAddressEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder(),
      keys = [PERSONAL_EDITOR_CLASS, ADDRESS_EDITOR_CLASS];
    builder.getKeys = function () {
      return Promise.resolve(keys);
    };
    builder.getValueFor = function (key) {
      var ds = this.getDataSource(),
        pair = ds.encodeToString().split('|'),
        address = pair.length && pair[0] || '',
        personal = pair.length > 1 && pair[1] || '';
      return key === ADDRESS_EDITOR_CLASS ? address : personal;
    };
    builder.getDomFor = function (key) {
      return that.jq().find('.' + key);
    };
    builder.readAll = function () {
      var addressEd = that.$getAddressEditor(),
        personalEd = that.$getPersonalEditor();
      return Promise.all([personalEd.read(), addressEd.read()]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          personal = _ref2[0],
          address = _ref2[1];
        return DEFAULT_INSTANCE.decodeFromString(address + '|' + personal);
      });
    };
    builder.getConfigFor = function () {
      return {
        formFactor: 'mini'
      };
    };
    return builder;
  };

  /**
   * Returns the label for the Personal field
   * @private
   * @returns {String}
   */
  EmailAddressEditor.prototype.$getPersonalLabel = function () {
    return this.jq().find(PERSONAL_LABEL_SELECTOR).text();
  };

  /**
   * Returns the label for the Address field
   * @private
   * @returns {String}
   */
  EmailAddressEditor.prototype.$getAddressLabel = function () {
    return this.jq().find(ADDRESS_LABEL_SELECTOR).text();
  };

  /**
   * Returns the StringEditor for the Personal field
   * @private
   * @returns {StringEditor}
   */
  EmailAddressEditor.prototype.$getPersonalEditor = function () {
    return this.jq().find(PERSONAL_EDITOR_SELECTOR).data('widget');
  };

  /**
   * Returns the StringEditor for the Address field
   * @private
   * @returns {StringEditor}
   */
  EmailAddressEditor.prototype.$getAddressEditor = function () {
    return this.jq().find(ADDRESS_EDITOR_SELECTOR).data('widget');
  };

  /**
   * Initializes the editor DOM
   *
   * @param {JQuery} dom element in which the widget will be initialized
   * @returns {Promise} Promise resolved when editor is initialized
   */

  EmailAddressEditor.prototype.doInitialize = function (dom) {
    dom.addClass('EmailAddressEditor').html(template({
      personalLabel: PERSONAL_LABEL_CLASS,
      personal: lex.get('emailAddress.personal'),
      personalEditor: PERSONAL_EDITOR_CLASS,
      addressLabel: ADDRESS_LABEL_CLASS,
      address: lex.get('emailAddress.address'),
      addressEditor: ADDRESS_EDITOR_CLASS
    }));
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Loads the editor with a value of type 'email:EmailAddress
   *
   * @param value instance of type email:EmailAddress to load
   * @returns {Promise} Promise resolved when editor is loaded or rejected when value
   * of an incorrect type is loaded
   */

  EmailAddressEditor.prototype.doLoad = function (value) {
    if (!baja.hasType(value, 'email:EmailAddress')) {
      return Promise.reject(new Error('Expected type email:EmailAddress'));
    }
    return CompositeEditor.prototype.doLoad.apply(this, arguments);
  };
  return EmailAddressEditor;
});
