/**
 * @copyright 2013, Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/* eslint-env browser */
/* exported checkFail */
/* exported openLicense */
/* exported closeLicense */
/* exported checkSecure */

/**
 * Niagara's core Log In screen.
 */
function checkFail() {
  "use strict";
  
  /**
   * Return the parameter value for the key in the URI's query.
   * 
   * @param  {String} key The parameter key to search for.
   * @return {String} The parameter value or null if nothing can be found.
   */
  function querySearch(key) {
    var match,
        value;

    // eslint-disable-next-line no-useless-escape
    key = key.replace(/[*+?^$.\[\]{}()|\\\/]/g, "\\$&"); // escape RegEx control chars
    match = location.search.match(new RegExp("[?&]" + key + "=([^&]+)(&|$)"));

    if (match) {
      value = decodeURIComponent(match[1].replace(/\+/g, " "));
    }

    return value || null;
  }

  // Show authentication failed if listed as a query parameter
  var auth = querySearch("auth");
  if (auth && auth === "fail") {
    document.getElementById("login-failed").setAttribute("style", "display: block");
  }
}
 
/**
 * Since IE doesn't appy style sheets to iframes, add the login style sheet 
 * to the license file's iframe after the iframe is loaded
 */
function fixStyle() {  
  "use strict";
  // create stylesheet  
  var iframe = document.getElementById("licenseFile");
  
  var innerDoc = iframe.contentWindow.document;
  if (innerDoc) {
    var ss  = innerDoc.createElement("link");
    ss.type = "text/css";
    ss.rel  = "stylesheet";
    ss.href = "/login/loginN4.css";
    
    // apply to iframe's head
    if (document.all) {
      innerDoc.createStyleSheet(ss.href);
    } else {
      var head = innerDoc.getElementsByTagName("head")[0];
      head.appendChild(ss);
    }
  }
}

/** 
 * Open a license file with the given title and login/ file name
 */
function openLicense(title, fileUrl) {
  "use strict";
  var blanket = document.getElementById("blanket");
  var lf = document.getElementById("licenseFile");
  var lt = document.getElementById("licenseFileName");
  
  if (lf.attachEvent) {
    lf.attachEvent("onload", function () {
      fixStyle();
    });
  } else {
    lf.onload = function () {
      fixStyle();
    };
  }
  
  lt.textContent = title;
  lf.src = "/login/" + fileUrl;
  blanket.style.display = 'block';
}

/**
 * Close the license file popup
 */
function closeLicense() {
  "use strict";
  var blanket = document.getElementById("blanket");
  var licFile = document.getElementById("licenseFile");
  licFile.innerHTML = "";
  blanket.style.display = 'none';
}

function checkSecure() {
  "use strict";
  if (location.protocol === 'https:') {
    return true;
  }

  // not using https, redirect to failed login and show error
  var absPathElement = document.getElementById("absPathBase");
  var absPathBase = "/";
  if (absPathElement !== null) {
    absPathBase = absPathElement.value;
  }

  window.location.replace(absPathBase + "login?auth=fail&loginFailureCause=SECURE_CONNECTION_REQUIRED");
  return false;
}
