function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * @module nmodule/batchJob/rc/baja/UxJobStepFactory
 */
define(['baja!', 'lex!', 'Promise'], function (baja, lex, Promise) {
  'use strict';

  /**
   * API Status: **Development**
   *
   * You must implement this interface to create 'batchJob:UxJobStepFactory'.
   * Properties must have 'module' and 'lex' to derive 'displayName', 'description',
   * and 'icon' for the job step factory, also, one must implement method 'makeStep' to make the job step,
   * and may implement method 'editStep' to edit the job step.
   *
   * @since Niagara 4.14
   * @interface
   * @alias module:nmodule/batchJob/rc/baja/UxJobStepFactory
   */
  var UxJobStepFactory = /*#__PURE__*/function () {
    /**
     * @param {Object} params
     * @param {String} params.module Module name
     * @param {String} params.lex Prefix of the lexicon key
     *
     * @example
     * //module:lex will be used to resolve description, icon and displayName of the UxJobStepFactory.
     * //myFactory.description in the 'myModule' lexicon will be used as description for the job step factory.
     * //myFactory.icon in the 'myModule' lexicon will be used as an icon for the job step factory.
     * //myFactory.displayName in the 'myModule' lexicon will be used as displayName for the job step factory.
     *
     * new UxJobStepFactory({
     *   module: 'myModule',
     *   lex: 'myFactory'
     * });
     */
    function UxJobStepFactory(params) {
      _classCallCheck(this, UxJobStepFactory);
      this.$displayName = '';
      this.$description = '';
      this.$icon = '';
      if (params && params.module && params.lex) {
        var moduleWithPrefix = "".concat(params.module, ":").concat(params.lex);
        this.$displayName = "%lexicon(".concat(moduleWithPrefix, ".displayName)%");
        this.$description = "%lexicon(".concat(moduleWithPrefix, ".description)%");
        this.$icon = "%lexicon(".concat(moduleWithPrefix, ".icon)%");
      }
    }

    /**
     * Returns fully configured JobStep or an array of JobStep or null.
     *
     * @param {Object} params
     * @param {baja.Component} params.deviceContainer
     * @returns {Promise.<baja.Component|Array.<baja.Component>>} resolves to a singular or array of JobStep.
     * @throws {Error} throws Error if abstract makeStep is invoked
     */
    return _createClass(UxJobStepFactory, [{
      key: "makeStep",
      value: function makeStep(params) {
        throw new Error('Must override method');
      }

      /**
       * Takes an existing JobStep as input, allows the user to edit it, and returns or resolves a
       * new copy of that JobStep. The new copy will be used to replace the existing one.
       *
       * @function editStep
       * @memberOf module:nmodule/batchJob/rc/baja/UxJobStepFactory
       * @param {Object} params
       * @param {baja.Component} params.step an instance of `batchJob:JobStep`.
       * @param {baja.Component} params.deviceContainer
       * @returns {Promise.<baja.Component|undefined>|baja.Component|undefined}
       */

      /**
       * @returns {Promise.<string>} Description of the UxJobStep
       */
    }, {
      key: "toDescription",
      value: function toDescription() {
        return lex.format(this.$description);
      }

      /**
       * @returns {Promise.<baja.Icon>} Icon of the UxJobStep
       */
    }, {
      key: "toIcon",
      value: function toIcon() {
        return lex.format(this.$icon).then(function (iconString) {
          return baja.Icon.make(iconString);
        });
      }

      /**
       * @returns {Promise.<string>} DisplayName of the UxJobStep
       */
    }, {
      key: "toDisplayName",
      value: function toDisplayName() {
        return lex.format(this.$displayName);
      }

      /**
       * Returns the value to true which means the step is added in the step list by default.
       * If return value is false then the step is not added in the step list.
       * Can be overridden by a subclass to provide its own value.
       *
       * @private
       * @returns {boolean} returns true by default
       */
    }, {
      key: "$isValidFor",
      value: function $isValidFor() {
        return true;
      }
    }]);
  }();
  return UxJobStepFactory;
});
