function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 *  Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/JobStepDetailsUxView
 */

define(['baja!', 'lex!', 'lex!batchJob', 'Promise', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/mixin/subscriberMixIn', 'bajaux/spandrel', 'bajaux/util/CommandButtonGroup', 'nmodule/batchJob/rc/util/batchJobUtils', 'nmodule/batchJob/rc/util/LogContentWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/servlets/registry', 'css!nmodule/batchJob/rc/batchJob'], function (baja, lex, lexs, Promise, Command, CommandGroup, subscriberMixIn, spandrel, CommandButtonGroup, batchJobUtils, LogContentWidget, asyncUtils, DepthSubscriber, registry) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-JobStepDetailsUxView'
      }
    };
  };
  var getDisplayTz = batchJobUtils.getDisplayTz,
    hyperlinkToJob = batchJobUtils.hyperlinkToJob;
  var _lexs = _slicedToArray(lexs, 1),
    BATCH_JOB_LEX = _lexs[0];
  var doRequire = asyncUtils.doRequire;
  var getAgentOnInfo = registry.getAgentOnInfo;

  /**
   * @class
   * @inner
   * @extends module:bajaux/Widget
   */
  var StepDetailsWidget = /*#__PURE__*/function (_spandrel) {
    function StepDetailsWidget(params) {
      var _this;
      _classCallCheck(this, StepDetailsWidget);
      _this = _callSuper(this, StepDetailsWidget, [{
        params: params
      }]);
      _this.$subscriber = new DepthSubscriber(Number.MAX_VALUE);
      _this.$subscriber.attach('changed added removed', function () {
        return _this.rerender();
      });
      subscriberMixIn(_this);
      return _this;
    }
    _inherits(StepDetailsWidget, _spandrel);
    return _createClass(StepDetailsWidget);
  }(spandrel(function (stepDetails, _ref) {
    var properties = _ref.properties;
    var running = baja.$('baja:JobState').get('running');
    var deviceInfo = properties.deviceInfo,
      extraDetails = properties.extraDetails,
      timezone = properties.timezone;
    var state = stepDetails.get('state');
    var endTime = state !== running ? stepDetails.get('endTime').toDateTimeStringSync({
      timezone: timezone
    }) : stepDetails.get('startTime').toDateTimeStringSync({
      timezone: timezone
    });
    return spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-container",
      spandrelKey: "container"
    }, spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-grid",
      spandrelKey: "jobDetails"
    }, deviceInfo, spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.type')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item"
    }, stepDetails.get('stepDescription')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.started')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item"
    }, stepDetails.get('startTime').toDateTimeStringSync({
      timezone: timezone
    })), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.ended')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item"
    }, endTime), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.state')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item"
    }, String(state)), extraDetails));
  }));
  /**
   * @class
   * @alias module:nmodule/batchJob/rc/JobStepDetailsUxView
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_spandrel2) {
    function JobStepDetailsUxView(params) {
      var _this2;
      _classCallCheck(this, JobStepDetailsUxView);
      _this2 = _callSuper(this, JobStepDetailsUxView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this2.$subscriber = new DepthSubscriber(Number.MAX_VALUE);
      _this2.$subscriber.attach('changed added removed', function () {
        return _this2.rerender();
      });
      subscriberMixIn(_this2);
      return _this2;
    }

    /**
     * Creates the
     * @private
     * @param {Object} params the parameters necessary to make the container
     * @param {module:bajaux/commands/CommandGroup} params.commandGroup the command group for the
     * container
     * @param {String} params.logContents the encode contents of the log for the job step
     * @param {Object} params.stepDetails the step details of the type 'batchJob:JobStepDetails'
     * @param {baja.TimeZone} params.timezone the local time zone
     * @returns {module:bajaux/spandrel~SpandrelData}
     */
    _inherits(JobStepDetailsUxView, _spandrel2);
    return _createClass(JobStepDetailsUxView, [{
      key: "$makeViewContainer",
      value: function $makeViewContainer(params) {
        var commandGroup = params.commandGroup;
        var logContents = params.logContents;
        var stepDetails = params.stepDetails;
        var timezone = params.timezone;
        var deviceInfo = this.$getDeviceInfo(stepDetails);
        var extraDetails = this.$getExtraDetails(stepDetails);
        return spandrel.jsx("div", {
          className: "jobStepDetails-container",
          spandrelKey: "container"
        }, spandrel.jsx(StepDetailsWidget, {
          lax: true,
          value: stepDetails,
          spandrelKey: "stepDetails",
          properties: {
            deviceInfo: deviceInfo,
            extraDetails: extraDetails,
            timezone: timezone
          }
        }), spandrel.jsx(LogContentWidget, {
          value: logContents,
          spandrelKey: "logContent"
        }), spandrel.jsx("div", {
          className: "jobStepDetails-commands"
        }, spandrel.jsx(CommandButtonGroup, {
          value: commandGroup,
          spandrelKey: "commandGroup"
        })));
      }

      /**
       * Overridable method that returns additional information about the device for the
       * StepDetailWidget
       * @private
       * @param {Object} stepDetails the step details of the type 'batchJob:JobStepDetails'
       * @returns {Array.<module:bajaux/spandrel~SpandrelData>}
       */
    }, {
      key: "$getDeviceInfo",
      value: function $getDeviceInfo(stepDetails) {
        return [];
      }

      /**
       * Overridable method that returns additional details for the StepDetailWidget
       * @private
       * @param {Object} stepDetails the step details of the type 'batchJob:JobStepDetails'
       * @returns {Array.<module:bajaux/spandrel~SpandrelData>}
       */
    }, {
      key: "$getExtraDetails",
      value: function $getExtraDetails(stepDetails) {
        return [];
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStepDetailsWidget",
      value: function $getStepDetailsWidget() {
        return this.queryWidget('container/stepDetails');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLogContentWidget",
      value: function $getLogContentWidget() {
        return this.queryWidget('container/logContent');
      }

      /**
       * @private
       * @return {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$getViewCommandGroup",
      value: function $getViewCommandGroup() {
        return this.queryWidget('container/2/commandGroup').value();
      }

      /**
       * returns the job for the step
       * @private
       * @param {baja.Component} stepDetails of type batchJob:JobStepDetails
       * @returns {baja.Component|undefined}
       */
    }, {
      key: "$getJob",
      value: function $getJob(stepDetails) {
        var parent = stepDetails.getParent();
        while (parent) {
          if (baja.hasType(parent, 'batchJob:BatchJob')) {
            return parent;
          }
          parent = parent.getParent();
        }
        return undefined;
      }
      /**
       *
       * @private
       * @param {baja.Component} stepDetails of type batchJob:JobStepDetails
       * @param {baja.AbsTime} jobStartTime
       * @param {baja.TimeZone} timezone
       * @return {Promise.<module:bajaux/commands/CommandGroup>}
       */
    }, {
      key: "$makeViewCommandGroup",
      value: function $makeViewCommandGroup(stepDetails, jobStartTime, timezone) {
        var _this3 = this;
        var that = this;
        var job = this.$getJob(stepDetails);
        var state = stepDetails.get('state');
        var running = baja.$('baja:JobState').get('running');
        var commands = [];
        if (job) {
          commands.push(new Command({
            module: 'batchJob',
            lex: 'JobStepDetailsView.goJobCommand',
            func: function func() {
              var navOrd = that.$getNavOrd(job);
              return hyperlinkToJob(navOrd);
            }
          }));
        }
        commands.push(new Command({
          module: 'batchJob',
          lex: 'JobStepDetailsView.refreshLogCommand',
          enabled: state === running,
          func: function func() {
            return stepDetails.invoke({
              slot: 'readLog'
            }).then(function (result) {
              return _this3.$getLogContentWidget().load(result);
            });
          }
        }));
        var commandGroup = new CommandGroup({
          commands: commands
        });
        return this.$addViewCommands(stepDetails, commandGroup);
      }

      /**
       * Returns a navOrd for the job that the Workbench can resolve.  Really hear to make testing
       * easier
       * @param {baja.Component} job the job from the stepDetails
       * @returns {baja.Ord}
       */
    }, {
      key: "$getNavOrd",
      value: function $getNavOrd(job) {
        var navOrd = job.getNavOrd();
        var navOrdStr = navOrd.relativizeToSession();
        return baja.Ord.make({
          base: 'station:',
          child: navOrdStr
        });
      }
      /**
       * Adds any additional commands to the command group
       * @private
       * @param {baja.Component} stepDetails of type batchJob:JobStepDetails
       * @param {module:bajaux/commands/CommandGroup} commandGroup the current command groups
       * @returns {Promise}
       */
    }, {
      key: "$addViewCommands",
      value: function $addViewCommands(stepDetails, commandGroup) {
        var viewName = this.$viewName;
        return getAgentOnInfo(stepDetails.getType().getTypeSpec(), {
          is: 'batchJob:IUxJobStepDetails'
        }).then(function (agents) {
          if (agents.length > 0) {
            var agent = agents[0];
            return doRequire(agent.js.id, agent.js.deps);
          }
        }).then(function (UxJobStepDetails) {
          if (UxJobStepDetails) {
            var uxJobStepDetails = new UxJobStepDetails();
            var commands = uxJobStepDetails.makeCommands({
              stepDetails: stepDetails,
              viewName: viewName
            });
            commandGroup.add.apply(commandGroup, _toConsumableArray(commands));
          }
          return commandGroup;
        });
      }
    }]);
  }(spandrel(function (stepDetails, _ref2) {
    var self = _ref2.self;
    var timezone;
    var logContents;
    return Promise.all([getDisplayTz(), stepDetails.readLog()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        timezoneResults = _ref4[0],
        log = _ref4[1];
      timezone = timezoneResults;
      logContents = log;
      return self.$makeViewCommandGroup(stepDetails);
    }).then(function (commandGroup) {
      return self.$makeViewContainer({
        commandGroup: commandGroup,
        logContents: logContents,
        stepDetails: stepDetails,
        timezone: timezone
      });
    });
  }));
});
