/**************************************************************************
Copyright 2015 Honeywell International Sàrl
**************************************************************************/

const protocolFormater = function(option){
  this.sequence = 1;
  this.getSequence = function() { return sequence++ };
  const controlMessage = "CONTROL";
  const protocolVersion = "1.0";
  const reverseDirection = "REVERSE";
  const forwardDirection = "FORWARD";

  this.getPauseControlCommand = function(pause) {
    const pauseCommand = {
      "MessageType": controlMessage,
      "Version": protocolVersion,
      "Sequence": getSequence(),
      "Request": {
        "Paused": pause,
        "CameraID": option.cameraId && option.cameraId.toString() || option.videoElement.id,
        "OpenStream": false
      }
    };
    return JSON.stringify(pauseCommand);
  };

  this.getSeekCommand = function(secondsOffset, baseTime) {
    const dateTime = (baseTime !== undefined && baseTime !== null) 
      ? new Date(baseTime) 
      : new Date();
    dateTime.setTime(dateTime.getTime() + secondsOffset * 1000);
    const playbackTime = dateTime.toISOString();
          
    const seekCommand = {
      "MessageType": controlMessage,
      "Version": protocolVersion,
      "Sequence": getSequence(),
      "Request": {
        "CameraID": option.cameraId && option.cameraId.toString() || option.videoElement.id,
        "OpenStream": false,
        "TimePosition": playbackTime
      }
    };
  
    return JSON.stringify(seekCommand);
  };

  this.getDirectionChangingCommand = function(isRewind) {
    const rewindCommand = {
      "MessageType": controlMessage,
      "Version": protocolVersion,
      "Sequence": getSequence(),
      "Request": {
        "Paused": false,
        "CameraID": option.cameraId && option.cameraId.toString() || option.videoElement.id,
        "OpenStream": false,
        "Direction": isRewind ? reverseDirection : forwardDirection
      }
    };

    return JSON.stringify(rewindCommand);
  };

  this.getSpeedCommand = function(speed) {
    const isReverse = speed.startsWith("-");
    const direction = isReverse ? reverseDirection : forwardDirection;
    const unsignedSpeed = isReverse ? speed.slice(1) : speed;
    const speedCommand = {
      "MessageType": controlMessage,
      "Version": protocolVersion,
      "Sequence": getSequence(),
      "Request": {
        "Paused": false,
        "CameraID": option.cameraId && option.cameraId.toString() || option.videoElement.id,
        "OpenStream": false,
        "Direction": direction,
        "Speed": unsignedSpeed
      }
    };
    return JSON.stringify(speedCommand);
  };

  this.getPlaybackUrlParameter = function(url, playerOption) {
	  //playerOption.playbackSecondsOffset = 0;
    if (playerOption.videoPlayMode === 'playback' && Number.isInteger(playerOption.playbackSecondsOffset)) {
      var dateTime = new Date();
	  console.log(dateTime.getTime());
      dateTime.setTime(
        dateTime.getTime() + playerOption.playbackSecondsOffset * 1000
      );
      const playbackTime = dateTime.toISOString();
      return url.concat("&time=", playbackTime, "&rewind=false&speed=",playerOption.playbackSpeed, "&paused=false");
    }
    return url;
  };

  return this;
};