function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/SpectrumBinding
 */
define(['baja!', 'baja!gx:Brush', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/gx/rc/baja/Color', 'nmodule/gx/rc/util/colorUtils'], function (baja, types, Binding, Color, colorUtils) {
  'use strict';

  var interpolateColors = colorUtils.interpolateColors;

  /**
   * BajaScript implementation of a `kitPx:SpectrumBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/SpectrumBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */
  return /*#__PURE__*/function (_Binding) {
    function SpectrumBinding() {
      _classCallCheck(this, SpectrumBinding);
      return _callSuper(this, SpectrumBinding, arguments);
    }
    _inherits(SpectrumBinding, _Binding);
    return _createClass(SpectrumBinding, [{
      key: "provide",
      value:
      /**
       * If the requested property equals the `widgetProperty` property of this
       * binding and it is bound to a `baja:INumeric`, then this will provide a
       * `Brush` or `Color` (depending on the bound property), interpolated
       * between `lowColor`/`midColor`/`highColor` based on the bound object's
       * current numeric value.
       *
       * @param {string} prop
       * @returns {baja.Simple|null}
       */
      function provide(prop) {
        var widget = this.getWidget();
        var widgetProp = widget && widget.properties().getValue(prop);
        var numeric = this.isBound() && this.getOrdTarget().getObject();
        if (prop !== this.get('widgetProperty') || !isColorOrBrush(widgetProp) || !isINumeric(numeric)) {
          return _superPropGet(SpectrumBinding, "provide", this, 3)([prop]);
        }
        var number = baja.Double.getNumberFromINumeric(numeric);
        var color = this.$solveColor(number);
        return isColor(widgetProp) ? color : baja.$('gx:Brush', color.encodeToString());
      }

      /**
       * @private
       * @param {number} value - current bound numeric value
       * @returns {module:nmodule/gx/rc/baja/Color}
       */
    }, {
      key: "$solveColor",
      value: function $solveColor(value) {
        var delta = this.get('extent') / 2;
        var setpoint = this.get('setpoint');
        var lowColor, highColor, bottom, top;
        if (value < setpoint) {
          lowColor = this.get('lowColor');
          highColor = this.get('midColor');
          bottom = setpoint - delta;
          top = setpoint;
        } else {
          lowColor = this.get('midColor');
          highColor = this.get('highColor');
          bottom = setpoint;
          top = setpoint + delta;
        }
        return solveColor(value, lowColor, highColor, bottom, top);
      }
    }]);
  }(Binding);

  /**
   * @param {number} value - current bound numeric value
   * @param {module:nmodule/gx/rc/baja/Color} lowColor
   * @param {module:nmodule/gx/rc/baja/Color} highColor
   * @param {number} bottom - bottom of range
   * @param {number} top - top of range
   * @returns {module:nmodule/gx/rc/baja/Color}
   */
  function solveColor(value, lowColor, highColor, bottom, top) {
    var ratio = (value - bottom) / (top - bottom);
    return Color.make(interpolateColors(lowColor.getRgba(), highColor.getRgba(), ratio));
  }
  function isColor(val) {
    return baja.hasType(val, 'gx:Color');
  }
  function isBrush(val) {
    return baja.hasType(val, 'gx:Brush');
  }
  function isColorOrBrush(val) {
    return isColor(val) || isBrush(val);
  }
  function isINumeric(val) {
    return baja.hasType(val, 'baja:INumeric');
  }
});
