function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/ButtonGroupBinding
 */
define(['baja!', 'baja!bajaui:DegradeBehavior', 'lex!baja,kitPx', 'bajaux/Widget', 'bajaux/model/UxModel', 'underscore', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/ux/bajauiEvents', 'nmodule/bajaui/rc/ux/RadioButton', 'nmodule/bajaui/rc/ux/ToggleButton', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/rangeUtils', 'log!nmodule.kitPx.rc.binding.ButtonGroupBinding', 'css!nmodule/kitPx/rc/kitPx'], function (baja, types, lexs, Widget, UxModel, _, Promise, asyncUtils, Binding, bajauiEvents, RadioButton, ToggleButton, feDialogs, rangeUtils, log) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var _lexs = _slicedToArray(lexs, 2),
    bajaLex = _lexs[0],
    kitPxLex = _lexs[1];
  var ACTION_PERFORMED_EVENT = bajauiEvents.ACTION_PERFORMED_EVENT;

  /**
   * BajaScript implementation of a `kitPx:ButtonGroupBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/ButtonGroupBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */
  var ButtonGroupBinding = /*#__PURE__*/function (_Binding) {
    function ButtonGroupBinding() {
      var _this;
      _classCallCheck(this, ButtonGroupBinding);
      _this = _callSuper(this, ButtonGroupBinding);
      _this.$isInitialized = false;
      return _this;
    }
    /**
     * Determines whether or not this binding is degraded
     * @returns {boolean} true if degraded, false if not.
     */
    _inherits(ButtonGroupBinding, _Binding);
    return _createClass(ButtonGroupBinding, [{
      key: "isDegraded",
      value: function isDegraded() {
        var target = this.getOrdTarget();
        return !this.isBound() || !target.canInvoke();
      }

      /**
       * Updates the bound widget if target has changed.
       *
       * @returns {Promise}
       */
    }, {
      key: "targetChanged",
      value: function targetChanged() {
        if (!this.isBound()) {
          return Promise.resolve();
        }
        var widget = this.getWidget();
        var model = UxModel["in"](widget);
        if (!model) {
          return Promise.resolve();
        }
        if (model && model.getKids().length === 0 || !this.$isInitialized) {
          this.$isInitialized = true;
          return this.$resolveKids().then(function (kids) {
            var modelParams = {
              bindings: model.getBindingList().getBindings(),
              name: model.getName(),
              type: model.getType(),
              properties: model.getProperties(),
              kids: kids
            };
            var existingKids = model.getKids();
            if (existingKids.length > 0) {
              _.map(kids, function (kid, index) {
                //copy all the properties except the selected value which is set correctly
                var selected = kid.properties.selected;
                if (index < existingKids.length && kid.properties.text === existingKids[index].getProperties().text) {
                  kid.properties = existingKids[index].getProperties();
                  kid.properties.selected = selected;
                }
              });
            }
            return UxModel.make(modelParams).then(function (newModel) {
              return widget.load(newModel);
            });
          });
        } else {
          var target = this.getOrdTarget();
          var obj = target.getObject();
          var kidDom = widget.jq().find(".ux-ToggleButton").filter(function () {
            return Widget["in"](this) instanceof ToggleButton; //skip spandrel inner Widgets that have the same class as ToggleButton
          });
          if (!kidDom.length) {
            return Promise.resolve();
          }
          var value = obj.getOut().getValue();
          if (baja.hasType(obj, 'control:BooleanWritable')) {
            var trueWidget = Widget["in"](kidDom[0]);
            var falseWidget = Widget["in"](kidDom[1]);
            trueWidget.properties().setValue("selected", value);
            falseWidget.properties().setValue("selected", !value);
          } else if (baja.hasType(obj, 'control:EnumWritable')) {
            var range = getRange(obj);
            _.map(range.getOrdinals(), function (ordinal, index) {
              var toggleWidget = Widget["in"](kidDom[index]);
              toggleWidget.properties().setValue("selected", value.getOrdinal() === ordinal);
            });
          }
        }
      }

      /**
       * Generate the information to build the child widgets.
       * @return {Promise}
       */
    }, {
      key: "$resolveKids",
      value: function $resolveKids() {
        var _this2 = this;
        var target = this.getOrdTarget();
        var obj = target.getObject();
        var type = this.get('style').getTag() === "radio" ? RadioButton : ToggleButton;
        if (baja.hasType(obj, 'control:BooleanWritable')) {
          var isTrue = obj.getOut().getValue();
          return resolveTrueFalseText(obj.get('facets')).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
              trueText = _ref2[0],
              falseText = _ref2[1];
            var trueBinding = new ActionPerformedBinding(_this2, true);
            var falseBinding = new ActionPerformedBinding(_this2, false);
            return [{
              type: type,
              properties: {
                text: trueText,
                selected: isTrue,
                keepSelected: true
              },
              bindings: [trueBinding]
            }, {
              type: type,
              properties: {
                text: falseText,
                selected: !isTrue,
                keepSelected: true
              },
              bindings: [falseBinding]
            }];
          });
        } else if (baja.hasType(obj, 'control:EnumWritable')) {
          var enums = obj.getOut().getValue();
          var range = getRange(obj);
          return resolveDisplayNames(range).then(function (displayNames) {
            return _.map(displayNames, function (displayName, index) {
              var tagIndex = range.getOrdinals()[index];
              var selected = enums.getOrdinal() === tagIndex;
              var value = baja.DynamicEnum.make({
                ordinal: tagIndex,
                range: range
              });
              var binding = new ActionPerformedBinding(_this2, value);
              return {
                type: type,
                properties: {
                  text: displayName,
                  selected: selected,
                  unselectable: true
                },
                bindings: [binding]
              };
            });
          });
        } else {
          logSevere("Unknown type:" + obj.getType());
          return Promise.resolve();
        }
      }
    }]);
  }(Binding);
  /**
   * @inner
   * @param {baja.Component} enumWritable a `control:EnumWritable` instance
   * @return {baja.EnumRange}
   */
  function getRange(enumWritable) {
    var enums = enumWritable.getOut().getValue();
    var facets = enumWritable.get('facets');
    var range = enums.getRange();
    if (facets) {
      var facetsRange = facets.get('range');
      if (facetsRange) {
        range = facetsRange;
      }
    }
    return range;
  }

  /*
   * @inner
   * @param {baja.EnumRange} range
   * @return {Promise.<String>}
   */
  function resolveDisplayNames(range) {
    return Promise.all(_.map(range.getOrdinals(), function (o) {
      return rangeUtils.getEnumRangeDisplay(o, range);
    }));
  }

  /**
   * Compute the true/false display text to use from the `trueText` /
   * `falseText` facets.
   *
   * @inner
   * @returns {Promise} promise to be resolved with an array containing two
   * strings for trueText/falseText
   */
  function resolveTrueFalseText(facets) {
    var trueText = facets.get('trueText', bajaLex.get('true')),
      falseText = facets.get('falseText', bajaLex.get('false'));
    return Promise.all([doFormat(trueText), doFormat(falseText)]);
  }

  /**
   * @inner
   * @returns {Promise}
   */
  function doFormat(pattern) {
    return baja.Format.format({
      pattern: pattern
    });
  }

  /**
   * @private
   * @class
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   * @memberOf module:nmodule/kitPx/rc/binding/ButtonGroupBinding
   * @param {module:nmodule/kitPx/rc/binding/ButtonGroupBinding} mainBinding
   * @param {baja.Value} value
   */
  var ActionPerformedBinding = /*#__PURE__*/function (_Binding2) {
    function ActionPerformedBinding(mainBinding, value) {
      var _this3;
      _classCallCheck(this, ActionPerformedBinding);
      _this3 = _callSuper(this, ActionPerformedBinding);
      _this3.$mainBinding = mainBinding;
      _this3.$value = value;

      //Workaround for https://acsjira.honeywell.com/browse/NCCB-47402
      _this3.add({
        slot: 'ord',
        value: baja.Ord.DEFAULT
      });
      _this3.add({
        slot: 'degradeBehavior',
        value: baja.$('bajaui:DegradeBehavior')
      });
      return _this3;
    }
    _inherits(ActionPerformedBinding, _Binding2);
    return _createClass(ActionPerformedBinding, [{
      key: "addListeners",
      value: function addListeners(widget) {
        var _this4 = this;
        this.addWidgetEvents(widget, _defineProperty({}, ACTION_PERFORMED_EVENT, function () {
          var ordTarget = _this4.$mainBinding.getOrdTarget();
          if (!ordTarget.canInvoke()) {
            feDialogs.error(new Error(kitPxLex.get('buttonGroupBinding.stateChangeErrorForInvoke')));
            //bring back the original value;
            return _this4.$mainBinding.targetChanged();
          }
          var component = ordTarget.getComponent();
          return component.invoke({
            slot: 'set',
            value: _this4.$value
          }).then(function () {
            //give the station a few seconds to complete the change. Call `targetChange` to potentially deselect the newly selected value if
            //there was another higher priority input slot that prevented the value change from changing value.
            asyncUtils.waitInterval(2000).then(function () {
              return _this4.$mainBinding.targetChanged();
            })["catch"](logSevere);
          });
        }));
      }
    }]);
  }(Binding);
  return ButtonGroupBinding;
});
