function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/binding/BoundLabelBinding
 */
define(['baja!', 'baja!kitPx:StatusEffect', 'nmodule/bajaui/rc/baja/binding/ValueBinding', 'nmodule/gx/rc/baja/Brush', 'nmodule/webEditors/rc/wb/mgr/componentStatusUtils'], function (baja, types, ValueBinding, Brush, componentStatusUtils) {
  'use strict';

  var getBackground = componentStatusUtils.getBackground,
    getForeground = componentStatusUtils.getForeground;

  /**
   * BajaScript implementation of `kitPx:BoundLabelBinding`.
   * @class
   * @alias module:nmodule/kitPx/rc/binding/BoundLabelBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/ValueBinding
   */
  return /*#__PURE__*/function (_ValueBinding) {
    function BoundLabelBinding() {
      _classCallCheck(this, BoundLabelBinding);
      return _callSuper(this, BoundLabelBinding, arguments);
    }
    _inherits(BoundLabelBinding, _ValueBinding);
    return _createClass(BoundLabelBinding, [{
      key: "provide",
      value:
      /**
       * If the bound point is an instance of `baja:IStatus` and effects enabled,
       * provides the following overrides:
       *
       * - `blink`: is the point in unackedAlarm status?
       * - `foreground`: the foreground color for the status configured in the lexicon
       * - `background`: the background color for the status configured in the lexicon
       * - `border`: special border behavior for `baja:StatusBoolean`s
       *
       * @param {string} name
       * @param {object} [cx]
       */
      function provide(name, cx) {
        var ordTarget = this.isBound() && this.getOrdTarget();
        var obj = ordTarget && ordTarget.getObject();
        var statusEffect = this.get('statusEffect').getTag();
        if (!ordTarget || !baja.hasType(obj, 'baja:IStatus') || statusEffect === 'none') {
          return _superPropGet(BoundLabelBinding, "provide", this, 3)(arguments);
        }
        var status = baja.Status.getStatusFromIStatus(obj);
        switch (name) {
          case 'blink':
            if (status.isUnackedAlarm() && statusEffect === 'colorAndBlink') {
              return true;
            }
            break;
          case 'foreground':
            var fg = getForeground(status);
            if (fg) {
              return Brush.make(fg);
            }
            break;
          case 'background':
            var bg = getBackground(status);
            if (bg) {
              return Brush.make(bg);
            }
            break;
          case 'border':
            if (!baja.hasType(obj, 'baja:StatusBoolean')) {
              break;
            }
            var converter = this.get(name);
            if (baja.hasType(converter, 'converters:FixedSimple')) {
              return converter.get('value');
            }
            if (baja.hasType(converter, 'converters:PassThrough')) {
              return converter.convert(obj, this.getWidget().properties().getValue(name));
            }
            if (baja.hasType(converter, 'converters:INumericToSimple')) {
              var map = converter.get('map');
              var num = obj.get('value') ? getHighest(map) : getLowest(map);
              return map.get(num);
            }
            break;
        }
        return _superPropGet(BoundLabelBinding, "provide", this, 3)(arguments);
      }
    }]);
  }(ValueBinding);
  function getHighest(map) {
    return Math.max.apply(Math, _toConsumableArray(map.getMaximums()));
  }
  function getLowest(map) {
    return Math.min.apply(Math, _toConsumableArray(map.getMinimums()));
  }
});
