/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

import com.tridium.gradle.plugins.module.util.ModulePart.RuntimeProfile.*

plugins {
  // The Niagara Module plugin configures the "moduleManifest" extension and the
  // "jar" and "moduleTestJar" tasks.
  id("com.tridium.niagara-module")

  // The signing plugin configures the correct signing of modules. It requires
  // that the plugin also be applied to the root project.
  id("com.tridium.niagara-signing")

  // The bajadoc plugin configures the generation of Bajadoc for a module.
  id("com.tridium.bajadoc")

  // Configures JaCoCo for the "niagaraTest" task of this module.
  id("com.tridium.niagara-jacoco")

  // The Annotation processors plugin adds default dependencies on ":nre"
  // for the "annotationProcessor" and "moduleTestAnnotationProcessor"
  // configurations by creating a single "niagaraAnnotationProcessor"
  // configuration they extend from. This value can be overridden by explicitly
  // declaring a dependency for the "niagaraAnnotationProcessor" configuration.
  id("com.tridium.niagara-annotation-processors")

  // The niagara_home repositories convention plugin configures !bin/ext and
  // !modules as flat-file Maven repositories so that projects in this build can
  // depend on already-installed Niagara modules.
  id("com.tridium.convention.niagara-home-repositories")

  // The niagara-doc plugin configures tasks to generate indexes and process any
  // HTML docs to include in a doc module
  id("com.tridium.niagara-doc")

  // The bajadoc-module plugin configures the 'bajadoc' configuration
  // and tasks to aggregate docs from other modules
  id("com.tridium.bajadoc-module")
}

description = "envCtrlDriver"

moduleManifest {
  moduleName.set("envCtrlDriver")
  runtimeProfile.set(doc)
}

// See documentation at module://docDeveloper/doc/build.html#dependencies for the supported
// dependency types
dependencies {
  // 'indexJars' are the Niagara modules required to build the search index for
  // a doc module
  indexJars(":nre")
  indexJars(":baja")
  indexJars(":html-wb")
  indexJars(":help-wb")

  // 'bajadocs' are the modules produced by your build whose API documentation this module
  // should include
  bajadocs(project(":envCtrlDriver-rt"))
  bajadocs(project(":envCtrlDriver-wb"))
}

tasks.named<Copy>("docCopy") {
  from("src") {
    include("doc/**/*.*")
  }
}

