function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/export/rc/TransformOperation
 */
define(['Promise'], function (Promise) {
  'use strict';

  /**
   * API Status: **Development**
   *
   * A TransformOperation encapsulates the lifecycle of transforming an object
   * into data, and sending that data to a destination.
   *
   * @class
   * @alias module:nmodule/export/rc/TransformOperation
   */
  var TransformOperation = /*#__PURE__*/function () {
    /**
     * @param {module:nmodule/export/rc/Transformer} transformer the transformer that will perform the transform operation
     * @param {*} object the object to be transformed
     */
    function TransformOperation(transformer, object) {
      _classCallCheck(this, TransformOperation);
      this.$transformer = transformer;
      this.$transformedObject = object;
    }

    /**
     * @returns {module:nmodule/export/rc/Transformer} the transformer that will perform the transform operation
     */
    return _createClass(TransformOperation, [{
      key: "getTransformer",
      value: function getTransformer() {
        return this.$transformer;
      }

      /**
       * @returns {*} the object to be transformed
       */
    }, {
      key: "getTransformedObject",
      value: function getTransformedObject() {
        return this.$transformedObject;
      }

      /**
       * @param {object} cx transform context. This will be passed to the {@link module:nmodule/export/rc/Transformer#transform transform()} method.
       * @returns {Promise}
       */
    }, {
      key: "doTransform",
      value: function doTransform(cx) {
        return Promise.resolve(this.getTransformer().transform(this.getTransformedObject(), cx));
      }

      /**
       * @returns {String} the display name to be shown to the user to allow him or her to choose to perform this transform operation
       */
    }, {
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$transformer.getDisplayName();
      }
    }]);
  }();
  return TransformOperation;
});
