function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

define(['baja!', 'Promise', 'nmodule/webEditors/rc/wb/menu/menuUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/wiresheet/rc/wb/baja/bajaUtils', 'nmodule/wiresheet/rc/wb/commands/ArrangeCommand', 'nmodule/wiresheet/rc/wb/WbConstants'], function (baja, Promise, menuUtils, typeUtils, bajaUtils, ArrangeCommand, WbConstants) {
  'use strict';

  var isLink = bajaUtils.isLink,
    isRelation = bajaUtils.isRelation,
    resolveEntityId = bajaUtils.resolveEntityId;
  var isKnob = typeUtils.isKnob,
    isRelationKnob = typeUtils.isRelationKnob;
  var NAV_SOURCE_HANDLE = WbConstants.NAV_SOURCE_HANDLE,
    NAV_SOURCE_SLOT = WbConstants.NAV_SOURCE_SLOT,
    NAV_TARGET_HANDLE = WbConstants.NAV_TARGET_HANDLE,
    NAV_TARGET_SLOT = WbConstants.NAV_TARGET_SLOT;
  var SELECTED_TYPE = 'selectedType';
  var resolveBestViewId = menuUtils.resolveBestViewId;

  /**
   * API Status: **Private**
   *
   * Miscellaneous wiresheet menu utility functions.
   *
   * @exports nmodule/wiresheet/rc/wb/util/wsMenuUtils
   */
  var exports = {};

  /**
   * Given a Link value, Relation value, Knob object or RelationKnob object
   * get the Ord to navigate on hyperlinking.
   *
   * @param {baja.Struct|Object} value the baja:Link value, baja:Relation value
   * or object representing a Knob
   * @returns {baja.Ord|null}
   */
  exports.getGotoOrd = function (value) {
    var gotoOrd = null;
    if (isKnob(value)) {
      gotoOrd = value.getTargetOrd();
    } else if (isRelationKnob(value)) {
      gotoOrd = value.getRelationOrd();
    } else if (isLink(value)) {
      gotoOrd = value.getSourceOrd();
    } else if (isRelation(value)) {
      gotoOrd = value.getEndpointOrd();
    }
    return gotoOrd;
  };

  /**
   * Given a Link value, Relation value, Knob object or RelationKnob object
   * get the wiresheet view.
   *
   * @param {baja.Struct|Object} value the baja:Link value, baja:Relation value
   * or object representing a Knob
   * @returns {Promise<baja.Ord|null>}
   */
  exports.getViewOrd = function (value) {
    var gotoOrd = exports.getGotoOrd(value);
    var parentComp, h;
    if (gotoOrd) {
      return gotoOrd.get({
        base: baja.station
      }).then(function (c) {
        parentComp = c.getParent();
        h = String(c.getHandle());
        return resolveBestViewId(parentComp, 'wiresheet:WebWiresheet');
      }).then(function (viewId) {
        var navSrcHandle, navSrcSlot, navTrgHandle, navTrgSlot, selectedType;
        if (isLink(value)) {
          navSrcHandle = h;
          navSrcSlot = value.getSourceSlotName();
          navTrgHandle = value.getParentComponent().getHandle();
          navTrgSlot = value.getTargetSlotName();
          selectedType = 'knob';
        } else if (isKnob(value)) {
          navSrcHandle = value.getSourceComponent().getHandle();
          navSrcSlot = value.getSourceSlotName();
          navTrgHandle = h;
          navTrgSlot = value.getTargetSlotName();
          selectedType = 'link';
        } else if (isRelationKnob(value)) {
          navSrcHandle = h;
          navSrcSlot = value.getRelationId();
          navTrgHandle = value.getEndpointComponent().getHandle();
          navTrgSlot = value.getRelationId();
          selectedType = 'relation';
        } else if (isRelation(value)) {
          navSrcHandle = value.getParentComponent().getHandle();
          navSrcSlot = value.getRelationId();
          navTrgHandle = h;
          navTrgSlot = value.getRelationId();
          selectedType = 'relationKnob';
        }
        var viewParams = _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({}, NAV_SOURCE_HANDLE, navSrcHandle), NAV_SOURCE_SLOT, navSrcSlot), NAV_TARGET_HANDLE, navTrgHandle), NAV_TARGET_SLOT, navTrgSlot), SELECTED_TYPE, selectedType),
          viewQuery = new baja.ViewQuery({
            id: viewId,
            params: viewParams
          });
        return baja.Ord.make({
          base: parentComp.getNavOrd(),
          child: viewQuery
        });
      });
    }
    return Promise.resolve(null);
  };

  /**
   * 
   * @param {string} stubId the entityId of the stub
   * @param {baja.Component} base
   * @return {Promise<baja.Ord|null>}
   */
  exports.stubToOrd = function (stubId) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      base = _ref.base;
    if (!stubId) {
      return Promise.resolve(null);
    }
    return resolveEntityId(stubId, {
      base: base
    }).then(function (value) {
      return exports.getViewOrd(value);
    });
  };

  /**
   *
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
   * @param {module:nmodule/wiresheet/rc/core/controller/Selection} selection
   * @returns {module:nmodule/wiresheet/rc/wb/commands/ArrangeCommand.ArrangeAllCommand}
   */
  exports.getArrangeAllCommand = function (viewModel, mask, selection) {
    return new ArrangeCommand(viewModel, mask, selection).getArrangeAllCommand();
  };

  /**
   *
   * @param {module:nmodule/wiresheet/rc/core/ViewModel} viewModel
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} mask
   * @param {module:nmodule/wiresheet/rc/core/controller/Selection} selection
   * @returns {module:nmodule/wiresheet/rc/wb/commands/ArrangeCommand.ArrangeSelectedCommand}
   */
  exports.getArrangeSelectedCommand = function (viewModel, mask, selection) {
    return new ArrangeCommand(viewModel, mask, selection).getArrangeSelectedCommand();
  };
  return exports;
});
