function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/render/canvas/CanvasRenderer
 */
define(['log!nmodule.wiresheet.rc.wb.render.canvas.CanvasRenderer', 'bajaux/icon/iconUtils', 'underscore', 'Promise', 'nmodule/wiresheet/rc/wb/WbConstants', 'nmodule/wiresheet/rc/wb/render/canvas/CanvasContextProvider', 'nmodule/wiresheet/rc/wb/render/canvas/CanvasThumb', 'nmodule/wiresheet/rc/wb/render/canvas/canvasUtils', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (log, iconUtils, _, Promise, WbConstants, CanvasContextProvider, CanvasThumb, canvasUtils, wsUtils) {
  'use strict';

  var partition = _.partition,
    throttle = _.throttle,
    isEqual = _.isEqual;
  var trimText = canvasUtils.trimText,
    extractLinearGradientStyleFromCss = canvasUtils.extractLinearGradientStyleFromCss,
    calcLinearGradientRect = canvasUtils.calcLinearGradientRect;
  var toImageMetrics = iconUtils.toImageMetrics;
  var layoutsIntersect = wsUtils.layoutsIntersect,
    toDirection = wsUtils.toDirection,
    translate = wsUtils.translate;
  var LINK_COLOR_LON = WbConstants.LINK_COLOR_LON,
    LINK_COLOR_RELATION = WbConstants.LINK_COLOR_RELATION,
    WIXEL = WbConstants.WIXEL;
  var logSevere = log.severe.bind(log);
  var EMPTY_PADDING = 10;
  var GLYPH_RADIUS = WIXEL / 2;
  var HATCH_DISTANCE = 5;
  var RELATION_DASH = [0, 2, 8, 2];
  var SLOT_NAME_VALUE_GAP = 5;
  var TEXT_BLOCK_PADDING = 3;
  var UNDERLINE_GAP = 3;
  var TO_NORTH = {
    x: 0.5,
    y: 0
  };
  var TO_EAST = {
    x: 1,
    y: 0.5
  };
  var TO_SOUTH = {
    x: 0.5,
    y: 1
  };
  var TO_WEST = {
    x: 0,
    y: 0.5
  };
  var THUMBNAIL_PAINT_INTERVAL = 500; //ms

  var CURSOR_IN = "/module/bajaui/com/tridium/ui/cursors/linkRight.png";
  var CURSOR_OUT = "/module/bajaui/com/tridium/ui/cursors/linkLeft.png";
  function goesOnOverlay(entity) {
    if (entity.glyph) {
      var type = entity.glyph.type;
      switch (type) {
        case 'DropperGlyph':
        case 'DropperInGlyph':
        case 'DropperOutGlyph':
        case 'RubberBandGlyph':
        case 'LinkGlyph':
          return true;
      }
    }
  }

  /**
   * @param {function} func
   * @returns {Promise} to be resolved after the function has been run on the
   * next animation frame
   */
  function raf(func) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve) {
      requestAnimationFrame(function () {
        Promise.resolve().then(func)["catch"](logSevere)["finally"](resolve);
      });
    });
  }
  var goesOnCanvas = _.negate(goesOnOverlay);
  var imagePromises = {};

  /**
   * This module's job is to paint glyphs in the WB style using an HTML5 canvas.
   *
   * It uses two canvases. The main one paints components and links (because
   * these update infrequently, but may be slower to paint). The "overlay"
   * canvas paints glyphs that track user interaction, like links and rubber
   * bands, as the user drags around.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/render/canvas/CanvasRenderer
   */
  var CanvasRenderer = /*#__PURE__*/function () {
    /**
     * @param {object} params
     * @param {module:nmodule/wiresheet/rc/core/ViewModel} params.viewModel
     * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} params.mask
     * @param {module:nmodule/wiresheet/rc/wb/render/themes/WiresheetTheme} params.theme
     * @param {number} [zoom=1] params.zoom initial zoom level
     * @param {module:nmodule/wiresheet/rc/wb/WsOptions} params.options
     */

    function CanvasRenderer(_ref) {
      var _this = this;
      var theme = _ref.theme,
        mask = _ref.mask,
        viewModel = _ref.viewModel,
        _ref$zoom = _ref.zoom,
        zoom = _ref$zoom === void 0 ? 1 : _ref$zoom,
        _ref$options = _ref.options,
        options = _ref$options === void 0 ? {} : _ref$options;
      _classCallCheck(this, CanvasRenderer);
      this.$mask = mask;
      this.$viewModel = viewModel;
      this.$zoom = zoom;
      this.$theme = theme;
      this.$thumb = new CanvasThumb(theme.getThumbnail());
      this.$options = options;
      this.paintThumbnail = throttle(function () {
        return _this.$doPaintThumbnail();
      }, THUMBNAIL_PAINT_INTERVAL, {
        leading: false
      });
    }

    /**
     * Initializes the renderer
     *
     * @returns {Promise}
     */
    return _createClass(CanvasRenderer, [{
      key: "initialize",
      value: function initialize(renderContext, thumbContainer) {
        var _this2 = this;
        var viewModel = this.$viewModel;
        var width = this.$mask.getWidth();
        var height = this.$mask.getHeight();
        renderContext.html("\n        <div class=\"ws-glyph-container\" />\n        <canvas class=\"ws-canvas-grid\" width=\"".concat(width * WIXEL, "\" height=\"").concat(height * WIXEL, "\" />\n        <canvas class=\"ws-canvas-overlay ws-overlay\" width=\"").concat(width * WIXEL, "\" height=\"").concat(height * WIXEL, "\" />\n      "));
        var _renderContext$childr = renderContext.children(),
          _renderContext$childr2 = _slicedToArray(_renderContext$childr, 3),
          glyphContainer = _renderContext$childr2[0],
          grid = _renderContext$childr2[1],
          overlay = _renderContext$childr2[2];
        var gridCtx = grid.getContext('2d');
        var overlayCtx = overlay.getContext('2d');
        var el = renderContext.parent()[0];
        this.$innerEl = renderContext;
        this.$glyphContainer = glyphContainer;
        this.$el = el;
        this.$grid = grid;
        this.$gridCtx = gridCtx;
        this.$overlay = overlay;
        this.$overlayCtx = overlayCtx;
        this.$ctxProvider = new CanvasContextProvider(glyphContainer, viewModel);
        this.$setupCanvas();
        this.$propBarBg = makePropBarBg(overlayCtx);
        this.$actionBarBg = makeActionBarBg(overlayCtx);
        this.$topicBarBg = makeTopicBarBg(overlayCtx);
        this.release = function () {};
        return this.$thumb.initialize(thumbContainer, this.$mask).then(function () {
          return _this2.$repaintContents();
        });
      }

      /**
       * @param {Number} zoomLevel
       * @returns {Promise}
       */
    }, {
      key: "zoom",
      value: function zoom(zoomLevel) {
        this.$zoom = zoomLevel;
        this.$ctxProvider.zoom(zoomLevel);
        return this.$repaintEverything();
      }

      /**
       * @param {object} params
       */
    }, {
      key: "options",
      value: function options(_options) {
        this.$options = _options;
        this.$resetMask();
      }

      /**
       * Paint all the glyphs that go on the overlay.
       */
    }, {
      key: "paintOverlay",
      value: function paintOverlay() {
        var _this3 = this;
        return raf(function () {
          return _this3.$repaintOverlay();
        });
      }
    }, {
      key: "paintThumbnailOverlay",
      value: function paintThumbnailOverlay() {
        var renderBounds = this.$getRenderBounds();
        this.$thumb.paintOverlay(this.$mask, renderBounds);
      }

      /**
       * This is called when the viewport to the wiresheet is changed.
       *
       * This will perform any necessary repaints of the canvas.
       *
       * @param {object} params
       * @param {number} params.width the width of the viewport in wixels
       * @param {number} params.height the height of the viewport in wixels
       * @returns {Promise}
       */
    }, {
      key: "viewportChanged",
      value: function viewportChanged(_ref2) {
        var width = _ref2.width,
          height = _ref2.height;
        var widthBefore = this.$mask.getWidth(),
          heightBefore = this.$mask.getHeight();
        this.$mask.setMinWidth(width + EMPTY_PADDING);
        this.$mask.setMinHeight(height + EMPTY_PADDING);
        var widthAfter = this.$mask.getWidth(),
          heightAfter = this.$mask.getHeight();
        if (widthBefore !== widthAfter || heightBefore !== heightAfter) {
          return this.$repaintEverything();
        } else {
          return Promise.resolve(this.paintThumbnailOverlay());
        }
      }

      /**
       * @private
       */
    }, {
      key: "$repaintEverything",
      value: function $repaintEverything() {
        return Promise.all([this.$repaintContents(), this.$repaintOverlay()]);
      }

      /**
       * @private
       */
    }, {
      key: "$resetMask",
      value: function $resetMask() {
        var _this$$options = this.$options,
          maxWidth = _this$$options.maxWidth,
          maxHeight = _this$$options.maxHeight;
        this.$mask.setMaxWidth(maxWidth);
        this.$mask.setMaxHeight(maxHeight);
        this.$resize();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$doPaintThumbnail",
      value: function $doPaintThumbnail() {
        var _this4 = this;
        return log.timing(function () {
          return _this4.$thumb.paint(_this4.$mask, _this4.$getRenderBounds());
        }, 'FINE', 'rendered thumbnail in {}ms');
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$repaintContents",
      value: function $repaintContents() {
        var _this5 = this;
        var viewModel = this.$viewModel;
        return log.timing(function () {
          return viewModel.getAllEntities();
        }, 'FINE', 'retrieved entities for paint in {}ms').then(function (entities) {
          var renderNow = [];
          var renderLater = [];
          return log.timing(function () {
            var bounds = _this5.$getRenderBounds();
            var inView = function inView(entity) {
              return entity.layout && layoutsIntersect(entity.layout, bounds);
            };
            var canvasEntities = entities.filter(goesOnCanvas).sort(wbSort);
            for (var i = 0, len = canvasEntities.length; i < len; ++i) {
              var entity = canvasEntities[i];
              (inView(entity) ? renderNow : renderLater).push(entity);
            }
          }, 'FINE', 'sorted entities into on- and off-screen piles in {}ms').then(function () {
            return log.timing(function () {
              return raf(function () {
                return Promise.all([_this5.$doPaintThumbnail(), log.timing(function () {
                  return _this5.paintEntities(renderNow);
                }, 'FINE', 'rendered {} onscreen entities in {}ms', renderNow.length)]);
              }).then(function () {
                return raf(function () {
                  return log.timing(function () {
                    return _this5.paintEntities(renderLater);
                  }, 'FINE', 'rendered {} offscreen entities in {}ms', renderLater.length);
                });
              });
            }, 'FINE', 'rendered {} total canvas entities in {}ms', entities.length);
          });
        });
      }

      /**
       * @private
       * @returns {module:nmodule/wiresheet/rc/typedefs~Layout} section of the
       * wiresheet currently scrolled into view
       */
    }, {
      key: "$getRenderBounds",
      value: function $getRenderBounds() {
        var el = this.$el;
        var w = WIXEL * this.$zoom;
        return {
          x: Math.floor(el.scrollLeft / w) - 1,
          y: Math.floor(el.scrollTop / w) - 1,
          width: Math.ceil(el.clientWidth / w) + 1,
          height: Math.ceil(el.clientHeight / w) + 1
        };
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$repaintOverlay",
      value: function $repaintOverlay() {
        var _this6 = this;
        var viewModel = this.$viewModel;
        var ctx = this.$overlayCtx;
        return viewModel.getAllEntities().then(function (entities) {
          var overlayEntities = entities.filter(goesOnOverlay);
          return log.timing(function () {
            _this6.$clearOverlay();
            ctx.save();
            ctx.scale(_this6.$zoom, _this6.$zoom);
            return Promise.all(overlayEntities.map(function (entity) {
              return _this6.$paintEntity(entity);
            }))["finally"](function () {
              return ctx.restore();
            });
          }, 'FINEST', 'rendered {} overlay entities in {}ms', overlayEntities.length);
        });
      }

      /**
       * @private
       */
    }, {
      key: "$clearOverlay",
      value: function $clearOverlay() {
        clear(this.$overlayCtx, this.$mask.getWidth(), this.$mask.getHeight());
      }

      /**
       * @param {Array.<module:nmodule/wiresheet/rc/typedefs~WiresheetEntity>} entities
       * @returns {Promise}
       */
    }, {
      key: "paintEntities",
      value: function paintEntities(entities) {
        var _this7 = this;
        return log.timing(function () {
          _this7.$resize(); // ensure the size of the canvas is correct for NCCB-55149
          var _partition = partition(entities, goesOnOverlay),
            _partition2 = _slicedToArray(_partition, 2),
            overlays = _partition2[0],
            nonOverlays = _partition2[1];
          return Promise.all(nonOverlays.map(function (entity) {
            return _this7.$prepEntity(entity);
          })).then(function (prepResults) {
            return Promise.all([overlays.length && _this7.paintOverlay(), Promise.all(nonOverlays.map(function (entity, i) {
              return _this7.$paintEntity(entity.predicate || entity, prepResults[i]);
            }))]);
          });
        }, 'FINE', 'painted {} entities in {}ms', entities.length);
      }

      /**
       * @param {Array.<module:nmodule/wiresheet/rc/typedefs~WiresheetEntity>} entities
       * @returns {Promise}
       */
    }, {
      key: "removeEntities",
      value: function removeEntities(entities) {
        var _this8 = this;
        return log.timing(function () {
          _this8.$resize();
          var _partition3 = partition(entities, goesOnOverlay),
            _partition4 = _slicedToArray(_partition3, 2),
            overlays = _partition4[0],
            nonOverlays = _partition4[1];
          return Promise.all([overlays.length && _this8.paintOverlay(), Promise.all(nonOverlays.map(function (entity) {
            return _this8.$ctxProvider.removeCanvas(entity.predicate || entity);
          }))]);
        }, 'FINE', 'removed {} entities in {}ms', entities.length);
      }

      /**
       * @private
       */
    }, {
      key: "$resize",
      value: function $resize() {
        var width = this.$mask.getWidth(),
          height = this.$mask.getHeight(),
          widthPx = width * WIXEL * this.$zoom,
          heightPx = height * WIXEL * this.$zoom;
        resizeCanvas(this.$overlay, widthPx, heightPx);
        resizeCanvas(this.$grid, widthPx, heightPx);
        this.$innerEl.css("width", widthPx);
        this.$innerEl.css("height", heightPx);
        this.$setupCanvas();
        if (this.$options.showGrid) {
          this.$paintGrid();
        }
      }

      /**
       * @private
       */
    }, {
      key: "$paintGrid",
      value: function $paintGrid() {
        var wixel = WIXEL * this.$zoom;
        var gridCtx = this.$gridCtx;
        var pixelWidth = this.$mask.getWidth() * wixel;
        var pixelHeight = this.$mask.getHeight() * wixel;
        gridCtx.strokeStyle = this.$theme.getCanvas().getGridColor();
        gridCtx.clearRect(0, 0, pixelWidth, pixelHeight);
        for (var i = 0; i < pixelWidth; i += wixel) {
          gridCtx.beginPath();
          gridCtx.moveTo(i, 0);
          gridCtx.lineTo(i, pixelHeight);
          gridCtx.stroke();
        }
        for (var _i = 0; _i < pixelHeight; _i += wixel) {
          gridCtx.beginPath();
          gridCtx.moveTo(0, _i);
          gridCtx.lineTo(pixelWidth, _i);
          gridCtx.stroke();
        }
      }

      /**
       * @private
       */
    }, {
      key: "$prepEntity",
      value: function $prepEntity(params) {
        if (!params) {
          return;
        }
        var glyph = params.glyph,
          layout = params.layout;
        if (!layout) {
          return;
        }
        switch (glyph.type) {
          case 'ComponentGlyph':
            return this.$prepComponentGlyph(glyph, layout);
        }
      }

      /**
       * @private
       * @param {object} entity
       * @param {*} prepResults
       * @returns {Promise|void}
       */
    }, {
      key: "$paintEntity",
      value: function $paintEntity(entity, prepResults) {
        if (!entity) {
          return;
        }
        var glyph = entity.glyph,
          layout = entity.layout;
        if (!layout) {
          return;
        }
        var overlayCtx = this.$overlayCtx;
        // painting an overlay glyph?
        switch (glyph.type) {
          // Note: ensure any additions to this paint logic are also referenced in the goesOnOverlay call
          case 'LinkGlyph':
            return this.$paintLinkGlyph(overlayCtx, glyph, layout);
          case 'RubberBandGlyph':
            return this.$paintRubberBandGlyph(overlayCtx, glyph, layout);
          case 'DropperGlyph':
            return this.$paintDropperGlyph(overlayCtx, glyph, layout);
          case 'DropperInGlyph':
            return this.$paintDropperLinkGlyph(overlayCtx, glyph, layout, 'in');
          case 'DropperOutGlyph':
            return this.$paintDropperLinkGlyph(overlayCtx, glyph, layout, 'out');
        }
        var ctx = this.$ctxProvider.getContext(entity);
        var _toPixels = toPixels(layout),
          width = _toPixels.width,
          height = _toPixels.height;
        ctx.clearRect(0, 0, width, height);
        var _glyph$uiStatus = glyph.uiStatus,
          selected = _glyph$uiStatus.selected,
          highlighted = _glyph$uiStatus.highlighted;
        ctx.canvas.style.zIndex = selected || highlighted ? '1' : '';

        // painting a content glyph
        switch (glyph.type) {
          case 'ComponentGlyph':
            return this.$paintComponentGlyph(ctx, glyph, layout, prepResults);
          case 'SnakeGlyph':
            return this.$paintSnakeGlyph(ctx, glyph, layout);
          case 'StubGlyph':
            return this.$paintStub(ctx, layout.x, layout.y, glyph.direction, glyph);
          case 'TextBlockGlyph':
            return this.$paintTextBlockGlyph(ctx, glyph, layout);
        }
      }

      /**
       * @private
       * @param {object} glyph
       * @param {object} layout
       */
    }, {
      key: "$prepComponentGlyph",
      value: function $prepComponentGlyph(glyph, layout) {
        var icon = glyph.header.icon;
        return toImageMetrics(icon).then(function (metricses) {
          return Promise.all(metricses.map(function (m) {
            return preloadImage(m.uri);
          })).then(function (imgs) {
            return metricses.map(function (metrics, i) {
              return {
                metrics: metrics,
                img: imgs[i]
              };
            });
          });
        });
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {object} glyph
       * @param {object} layout
       * @param {object} prepResults
       */
    }, {
      key: "$paintComponentGlyph",
      value: function $paintComponentGlyph(ctx, glyph, layout, prepResults) {
        var _this9 = this;
        var theme = this.$theme.getGlyph();
        var padding = 3;
        var header = glyph.header,
          bars = glyph.bars,
          uiStatus = glyph.uiStatus;
        var _toPixels2 = toPixels(layout),
          width = _toPixels2.width,
          height = _toPixels2.height;
        var title = header.title,
          subtitle = header.subtitle;
        var selected = uiStatus.selected;
        var textWidth = width - padding * 2;
        var headerTextWidth = textWidth - WIXEL * 2;
        var CONNECTOR_IN_HIGHLIGHT_FILL = theme.getInLinkHighlightBackground(),
          CONNECTOR_OUT_HIGHLIGHT_FILL = theme.getOutLinkHighlightBackground(),
          CONNECTOR_HIGHLIGHT_MIN_WIDTH = WIXEL * 3;
        ctx.textBaseline = 'middle';

        // last tile appears white if showRelations is false
        ctx.fillStyle = !this.$options.showRelations ? 'rgb(255, 255, 255)' : 'rgb(255, 255, 204)';
        ctx.strokeStyle = 'black';
        roundedRect(ctx, 0, 0, width, height, GLYPH_RADIUS);
        ctx.fill();

        //header
        ctx.lineWidth = 1;
        roundedRect(ctx, 0, 0, width, WIXEL * 2, GLYPH_RADIUS, GLYPH_RADIUS, 0, 0);
        var cssFill = theme.getComponentTitleBackground();
        fillRect(ctx, 0, 0, width, WIXEL * 2, cssFill);
        ctx.stroke();
        ctx.fillStyle = theme.getComponentFontColor(); // title and subtitle
        ctx.font = theme.getComponentTitleFont();
        clipText(ctx, title, padding, 0, headerTextWidth, WIXEL);
        ctx.font = theme.getComponentSubtitleFont();
        clipText(ctx, subtitle, padding, WIXEL, headerTextWidth, WIXEL);

        //translate to bars
        var headerWixels = 2;
        bars.forEach(function (bar, i) {
          translated(ctx, 0, WIXEL * (headerWixels + i), function () {
            ctx.strokeStyle = 'black';
            var id = bar.id,
              display = bar.display,
              type = bar.type,
              value = bar.value,
              highlightedStartConnector = uiStatus.highlightedStartConnector,
              highlightedEndConnector = uiStatus.highlightedEndConnector;
            ctx.fillStyle = _this9.$options.showStatusColors && bar.background || _this9.$getSlotBarBg(ctx, type);
            ctx.fillRect(0, 0, width, WIXEL);
            ctx.strokeRect(0, 0, width, WIXEL);
            var displayWidth = ctx.measureText(display).width;
            var fillInHighlight = function fillInHighlight() {
              var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
                connectorDirection = _ref3.connectorDirection,
                connectorId = _ref3.connectorId;
              if (connectorDirection === 'in' && connectorId === id) {
                ctx.fillStyle = CONNECTOR_IN_HIGHLIGHT_FILL;
                ctx.fillRect(0, 0, displayWidth + padding, WIXEL);
              }
            };

            // Mouse over highlight for display part of the bar
            fillInHighlight(highlightedStartConnector);
            if (!isEqual(highlightedStartConnector, highlightedEndConnector)) {
              fillInHighlight(highlightedEndConnector);
            }
            ctx.font = theme.getComponentBarFont();
            ctx.fillStyle = _this9.$options.showStatusColors && bar.foreground || theme.getComponentFontColor();
            ctx.textAlign = 'left';
            clipText(ctx, display, padding, 0, width - padding, WIXEL);
            var effectiveDisplayWidth = padding + displayWidth + SLOT_NAME_VALUE_GAP;
            var highlighterWidth = CONNECTOR_HIGHLIGHT_MIN_WIDTH,
              valueTextLeft = Math.max(effectiveDisplayWidth, width - highlighterWidth);
            if (value) {
              // fit the value into the space left over from the display
              var valueTextWidth = ctx.measureText(value).width;
              valueTextLeft = Math.max(effectiveDisplayWidth, width - padding - valueTextWidth);
              clipText(ctx, value, valueTextLeft, 0, width - valueTextLeft, WIXEL);
              highlighterWidth = width - valueTextLeft;
            }
            var fillOutHighlight = function fillOutHighlight() {
              var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
                connectorDirection = _ref4.connectorDirection,
                connectorId = _ref4.connectorId;
              if (connectorDirection === 'out' && connectorId === id) {
                ctx.fillStyle = CONNECTOR_OUT_HIGHLIGHT_FILL;
                ctx.fillRect(valueTextLeft, 0, highlighterWidth, WIXEL);
              }
            };
            // Mouse over highlight for value part of the bar
            fillOutHighlight(highlightedStartConnector);
            if (!isEqual(highlightedStartConnector, highlightedEndConnector)) {
              fillOutHighlight(highlightedEndConnector);
            }
          });
        });

        //outline
        if (selected && this.$options.linkHighlighting) {
          ctx.lineWidth = 2;
          ctx.strokeStyle = theme.getComponentSelectionOutline();
          roundedRect(ctx, -0.5, -0.5, width + 1, height + 1, GLYPH_RADIUS);
          ctx.stroke();
        } else {
          ctx.lineWidth = 1;
          ctx.strokeStyle = theme.getComponentOutline();
          roundedRect(ctx, 0, 0, width, height, GLYPH_RADIUS);
          ctx.stroke();
        }

        // handles
        if (selected) {
          this.$paintHandle(ctx, -0.25 * WIXEL, 0.75 * WIXEL, WIXEL / 2, WIXEL / 2);
          this.$paintHandle(ctx, width - 0.25 * WIXEL, 0.75 * WIXEL, WIXEL / 2, WIXEL / 2);
        }

        // undo the global 0.5px offset bc drawImage does not work with subpixels
        var destX = width - WIXEL * (1 + 2 / 3) - 0.5;
        var destY = WIXEL / 3 - 0.5;
        prepResults.forEach(function (_ref5) {
          var img = _ref5.img,
            metrics = _ref5.metrics;
          var x = metrics.x,
            y = metrics.y,
            width = metrics.width,
            height = metrics.height;
          ctx.drawImage(img, x, y, width, height, destX, destY, width, height);
        });
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {string} type slot bar type
       */
    }, {
      key: "$getSlotBarBg",
      value: function $getSlotBarBg(ctx, type) {
        switch (type) {
          case 'property':
            return this.$propBarBg;
          case 'action':
            return this.$actionBarBg;
          case 'relation':
          case 'topic':
            return this.$topicBarBg;
        }
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param x
       * @param y
       * @param width
       * @param height
       */
    }, {
      key: "$paintHandle",
      value: function $paintHandle(ctx, x, y, width, height) {
        ctx.fillStyle = 'rgb(234, 235, 216)';
        ctx.fillRect(x, y, width, height);
        ctx.lineWidth = 1;
        ctx.strokeStyle = 'black';
        ctx.strokeRect(x, y, width, height);
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {object} glyph
       * @param {object} layout
       */
    }, {
      key: "$paintLinkGlyph",
      value: function $paintLinkGlyph(ctx, glyph, layout) {
        var start = glyph.start,
          end = glyph.end;
        ctx.save();
        ctx.translate(layout.x * WIXEL, layout.y * WIXEL);
        ctx.lineWidth = 1;
        ctx.strokeStyle = 'black';
        ctx.beginPath();
        ctx.moveTo(start.x * WIXEL, start.y * WIXEL);
        ctx.lineTo(end.x * WIXEL, end.y * WIXEL);
        ctx.stroke();
        ctx.restore();
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {object} glyph
       * @param {object} layout
       */
    }, {
      key: "$paintRubberBandGlyph",
      value: function $paintRubberBandGlyph(ctx, glyph, layout) {
        var x = layout.x,
          y = layout.y,
          width = layout.width,
          height = layout.height;
        ctx.strokeStyle = 'black';
        ctx.strokeRect(x * WIXEL, y * WIXEL, width * WIXEL, height * WIXEL);
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {object} glyph 
       * @param {object} layout 
       */
    }, {
      key: "$paintDropperGlyph",
      value: function $paintDropperGlyph(ctx, glyph, layout) {
        var _this10 = this;
        translated(ctx, 0.5, 0.5, function () {
          var theme = _this10.$theme.getGlyph(),
            xWidth = 8 * WIXEL,
            // Standard component length
            yWidth = 6 * WIXEL; // Standard component height
          var x = layout.x * WIXEL,
            y = layout.y * WIXEL;
          ctx.beginPath();
          ctx.moveTo(x, y);
          ctx.lineWidth = 2;
          ctx.lineTo(x + xWidth, y);
          ctx.moveTo(x, y);
          ctx.lineTo(x - 15, y);
          ctx.moveTo(x, y);
          ctx.lineTo(x, y + yWidth);
          ctx.moveTo(x, y);
          ctx.lineTo(x, y - 15);
          ctx.strokeStyle = theme.getDropOkBackground();
          _this10.$clearOverlay();
          ctx.stroke();
        });
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {object} glyph
       * @param {object} layout
       * @param {string} direction `in` or `out`
       */
    }, {
      key: "$paintDropperLinkGlyph",
      value: function $paintDropperLinkGlyph(ctx, glyph, layout, direction) {
        this.$clearOverlay();
        var x = layout.x * WIXEL - 8;
        var y = layout.y * WIXEL + 22;
        return preloadImage(direction === 'in' ? CURSOR_IN : CURSOR_OUT).then(function (image) {
          return ctx.drawImage(image, x, y, 32, 32);
        });
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {object} glyph
       * @param {object} layout
       * @param {number} wixel
       */
    }, {
      key: "$paintSnakeGlyph",
      value: function $paintSnakeGlyph(ctx, glyph, layout, wixel) {
        var _this11 = this;
        var stubs = glyph.stubs;
        if (stubs) {
          var _stubs = _slicedToArray(stubs, 2),
            _stubs$ = _stubs[0],
            x0 = _stubs$.x,
            y0 = _stubs$.y,
            _stubs$2 = _stubs[1],
            x1 = _stubs$2.x,
            y1 = _stubs$2.y;
          translated(ctx, x0 * WIXEL, y0 * WIXEL, function () {
            return _this11.$paintStub(ctx, x0, y0, 'out', glyph);
          });
          translated(ctx, x1 * WIXEL, y1 * WIXEL, function () {
            return _this11.$paintStub(ctx, x1, y1, 'in', glyph);
          });
          return;
        }
        snakePath(ctx, glyph, wixel);
        strokeWireLine(ctx, glyph, {
          linkHighlighting: this.$options.linkHighlighting,
          theme: this.$theme.getGlyph()
        });
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {number} x
       * @param {number} y
       * @param {string} direction
       * @param {object} glyph
       */
    }, {
      key: "$paintStub",
      value: function $paintStub(ctx, x, y, direction, glyph) {
        var theme = this.$theme.getGlyph();
        var linkColorCode = glyph.linkColorCode,
          uiStatus = glyph.uiStatus;
        var highlighted = uiStatus.highlighted,
          selected = uiStatus.selected;

        // paint circle
        ctx.beginPath();
        ctx.arc(WIXEL / 2, WIXEL / 2, WIXEL / 4, 0, Math.PI * 2);
        if (highlighted && this.$options.linkHighlighting) {
          ctx.lineWidth = 5;
          ctx.strokeStyle = theme.getLinkHighlightBackground();
          ctx.stroke();
          ctx.lineWidth = 3;
          ctx.strokeStyle = theme.getLinkHighlightForeground();
          ctx.stroke();
        }
        ctx.lineWidth = 1;
        ctx.fillStyle = getWireFill(linkColorCode, selected, theme);
        ctx.fill();
        ctx.strokeStyle = getWireOutline(linkColorCode, selected, theme);
        ctx.stroke();

        // paint stem
        ctx.beginPath();
        if (direction === 'in') {
          ctx.moveTo(WIXEL * 3 / 4 - 1, WIXEL / 2);
          ctx.lineTo(WIXEL, WIXEL / 2);
        } else {
          ctx.moveTo(0, WIXEL / 2);
          ctx.lineTo(WIXEL / 4 + 1, WIXEL / 2);
        }
        strokeWireLine(ctx, glyph, {
          isStub: true,
          theme: this.$theme.getGlyph(),
          linkHighlighting: this.$options.linkHighlighting
        });
      }

      /**
       * @private
       * @param {CanvasRenderingContext2D} ctx
       * @param {object} glyph
       * @param {object} layout
       */
    }, {
      key: "$paintTextBlockGlyph",
      value: function $paintTextBlockGlyph(ctx, glyph, layout) {
        var background = glyph.background,
          border = glyph.border,
          font = glyph.font,
          foreground = glyph.foreground,
          text = glyph.text,
          uiStatus = glyph.uiStatus,
          underline = glyph.underline;
        var selected = uiStatus.selected;
        var _toPixels3 = toPixels(layout),
          width = _toPixels3.width,
          height = _toPixels3.height;
        var padding = TEXT_BLOCK_PADDING;
        var textWidth = width - padding * 2;
        if (background === 'rgba(0, 0, 0, 0)' && !text) {
          paintHatch(ctx, {
            x: 0,
            y: 0,
            width: width,
            height: height
          });
        } else {
          ctx.font = font;
          //const lines = wrapText({ ctx, text, width: textWidth }); TODO: this enables word wrap
          var lines = text.split('\n').map(function (text) {
            return trimText({
              ctx: ctx,
              text: text,
              width: textWidth
            });
          });
          ctx.fillStyle = background;
          ctx.fillRect(0, 0, width, height);
          if (border) {
            ctx.strokeStyle = foreground;
            ctx.strokeRect(0, 0, width, height);
          }
          var _ctx$measureText = ctx.measureText(text),
            actualBoundingBoxAscent = _ctx$measureText.actualBoundingBoxAscent,
            actualBoundingBoxDescent = _ctx$measureText.actualBoundingBoxDescent;
          var fontHeight = actualBoundingBoxAscent + actualBoundingBoxDescent;
          var fontGap = calculateFontGap(fontHeight, height, lines.length);
          var textHeight = (fontHeight + fontGap) * lines.length - fontGap;
          var i = 0;
          var fontY = Math.max(height / 2 - textHeight / 2, padding) + actualBoundingBoxAscent;
          ctx.fillStyle = foreground;
          ctx.strokeStyle = foreground;
          while (i < lines.length && fontY < height) {
            var line = lines[i++];
            ctx.fillText(line, padding, fontY, textWidth);
            if (underline) {
              ctx.beginPath();
              ctx.moveTo(padding, fontY + UNDERLINE_GAP);
              ctx.lineTo(padding + ctx.measureText(line).width, fontY + UNDERLINE_GAP);
              ctx.stroke();
            }
            fontY += fontHeight + fontGap;
          }
        }

        // handles
        if (selected) {
          var hw = WIXEL / 2;
          var qw = hw / 2;
          this.$paintHandle(ctx, -qw, -qw, hw, hw);
          this.$paintHandle(ctx, width - qw, -qw, hw, hw);
          this.$paintHandle(ctx, width - qw, height - qw, hw, hw);
          this.$paintHandle(ctx, -qw, height - qw, hw, hw);
        }
      }

      /**
       * Applies needed settings to the context of each canvas.
       *
       * @private
       */
    }, {
      key: "$setupCanvas",
      value: function $setupCanvas() {
        this.$gridCtx.translate(0.5, 0.5);
        this.$overlayCtx.translate(0.5, 0.5);
      }
    }]);
  }();
  function translated(ctx, x, y, func) {
    ctx.save();
    ctx.translate(x, y);
    try {
      func();
    } finally {
      ctx.restore();
    }
  }
  function clipText(ctx, text, x, y, width, height) {
    ctx.save();
    ctx.translate(x, y);
    ctx.beginPath();
    ctx.rect(0, 0, width, height);
    ctx.closePath();
    ctx.clip();
    ctx.fillText(text, 0, height / 2 + 1);
    ctx.restore();
  }
  function makePropBarBg(ctx) {
    return linearGradient(ctx, 'rgb(210,210,234)', 'rgb(167,167,213)');
  }
  function makeActionBarBg(ctx) {
    return linearGradient(ctx, 'rgb(210, 254, 210)', 'rgb(30, 211, 30)');
  }
  function makeTopicBarBg(ctx) {
    return linearGradient(ctx, 'rgb(227, 227, 193)', 'rgb(181, 182, 59)');
  }
  function linearGradient(ctx, stop1, stop2) {
    var g = ctx.createLinearGradient(0, 0, 100, 0);
    g.addColorStop(0, stop1);
    g.addColorStop(1, stop2);
    return g;
  }
  function strokeWireLine(ctx, glyph) {
    var _ref6 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      isStub = _ref6.isStub,
      linkHighlighting = _ref6.linkHighlighting,
      theme = _ref6.theme;
    var connectorType = glyph.connectorType,
      linkColorCode = glyph.linkColorCode,
      uiStatus = glyph.uiStatus;
    var selected = uiStatus.selected,
      highlighted = uiStatus.highlighted;
    var isRelation = connectorType === 'relation';
    if (highlighted && linkHighlighting) {
      ctx.strokeStyle = theme.getLinkHighlightBackground();
      ctx.lineWidth = 7;
      ctx.stroke();
      ctx.strokeStyle = theme.getLinkHighlightForeground();
      ctx.lineWidth = 5;
      ctx.stroke();
    }
    if (isRelation && !selected && !isStub) {
      ctx.setLineDash(RELATION_DASH);
    }
    ctx.strokeStyle = getWireOutline(linkColorCode, selected, theme);
    ctx.lineWidth = 3;
    ctx.stroke();
    ctx.strokeStyle = getWireFill(linkColorCode, selected, theme);
    ctx.lineWidth = 1;
    ctx.stroke();
  }
  function getWireOutline(linkColorCode, selected, theme) {
    if (selected) {
      return theme.getLinkSelectionBackground();
    }
    switch (linkColorCode) {
      case LINK_COLOR_LON:
        return '#008000';
      case LINK_COLOR_RELATION:
        return '#004040';
      default:
        return '#444';
    }
  }
  function getWireFill(linkColorCode, selected, theme) {
    if (selected) {
      return theme.getLinkSelectionForeground();
    }
    switch (linkColorCode) {
      case LINK_COLOR_LON:
        return '#00C800';
      case LINK_COLOR_RELATION:
        return '#008080';
      default:
        return '#888';
    }
  }
  function toPixels(layout) {
    var x = layout.x,
      y = layout.y,
      width = layout.width,
      height = layout.height;
    return {
      x: x * WIXEL,
      y: y * WIXEL,
      width: width * WIXEL,
      height: height * WIXEL
    };
  }

  /**
   * How much space to leave between lines of a text block? In Workbench this is
   * FontMetrics#getLeading(), which we don't have in canvas world, so take a
   * guess while trying not to overflow the text block.
   * @param fontHeight actual font height in pixels
   * @param height text block height in pixels
   * @param lineCount how many lines of text
   * @returns {number} font gap in pixels
   */
  function calculateFontGap(fontHeight, height, lineCount) {
    var emptySpace = height - fontHeight * lineCount;
    return Math.max(0, Math.min(fontHeight * 0.2, emptySpace / (lineCount - 1)));
  }
  function clear(ctx, width, height) {
    ctx.clearRect(-0.5, -0.5, width * WIXEL + 1, height * WIXEL + 1);
  }

  // vertices paint over edges. a selected vertex paints over a non-selected one.
  function wbSort(e1, e2) {
    if (isEdge(e1)) {
      return isEdge(e2) ? compareSelected(e1, e2) : -1;
    } else if (isEdge(e2)) {
      return 1;
    } else {
      return compareSelected(e1, e2);
    }
  }
  function compareSelected(e1, e2) {
    var s1 = e1.glyph.uiStatus.selected;
    var s2 = e2.glyph.uiStatus.selected;
    return s1 ? s2 ? 0 : 1 : s2 ? -1 : 0;
  }
  function isEdge(entity) {
    switch (entity.glyph.type) {
      case 'SnakeGlyph':
      case 'StubGlyph':
        return true;
    }
  }
  function paintHatch(ctx, _ref7) {
    var x = _ref7.x,
      y = _ref7.y,
      width = _ref7.width,
      height = _ref7.height;
    ctx.save();
    try {
      ctx.strokeStyle = '#808080';
      ctx.beginPath();
      ctx.rect(x, y, width, height);
      ctx.closePath();
      ctx.stroke();
      ctx.clip();
      var max = Math.max(width, height) * 2;
      var n = HATCH_DISTANCE;
      while (n < max) {
        ctx.beginPath();
        ctx.moveTo(x, y + n);
        ctx.lineTo(x + n, y);
        ctx.stroke();
        ctx.closePath();
        n += HATCH_DISTANCE;
      }
    } finally {
      ctx.restore();
    }
  }
  function roundedRect(ctx, x, y, width, height, nw) {
    var ne = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : nw;
    var se = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : nw;
    var sw = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : ne;
    translated(ctx, x, y, function () {
      ctx.beginPath();
      ctx.moveTo(nw, 0);
      ctx.lineTo(width - ne, 0);
      ctx.arcTo(width, 0, width, ne, ne);
      ctx.lineTo(width, height - se);
      ctx.arcTo(width, height, width - se, height, se);
      ctx.lineTo(sw, height);
      ctx.arcTo(0, height, 0, height - sw, sw);
      ctx.lineTo(0, ne);
      ctx.arcTo(0, 0, ne, 0, ne);
      ctx.closePath();
    });
  }
  function fillRect(ctx, x, y, width, height, cssText) {
    if (cssText.indexOf("linear-gradient") !== -1) {
      var _extractLinearGradien = extractLinearGradientStyleFromCss(cssText),
        angle = _extractLinearGradien.angle,
        stops = _extractLinearGradien.stops;
      var _calcLinearGradientRe = calcLinearGradientRect(angle, width, height),
        startX = _calcLinearGradientRe.startX,
        startY = _calcLinearGradientRe.startY,
        endX = _calcLinearGradientRe.endX,
        endY = _calcLinearGradientRe.endY;
      var gradient = ctx.createLinearGradient(startX, startY, endX, endY);
      stops.forEach(function (stop) {
        gradient.addColorStop(stop.offset, stop.color);
      });
      ctx.fillStyle = gradient;
      ctx.fill();
    } else {
      ctx.fillStyle = cssText;
      ctx.fill();
    }
  }
  function snakePath(ctx, glyph) {
    var segments = glyph.segments;
    var HW = 0.5 * WIXEL;
    var len = segments.length;
    ctx.beginPath();
    segments.forEach(function (point, i) {
      var x = point.x,
        y = point.y;

      // starting point
      if (i === 0) {
        return ctx.moveTo(x * WIXEL, (y + 0.5) * WIXEL);
      }

      // end point
      if (i === len - 1) {
        return ctx.lineTo((x + 1) * WIXEL, (y + 0.5) * WIXEL);
      }

      // junction point within the snake
      var lastPoint = segments[i - 1];
      var nextPoint = segments[i + 1];
      if (i === 1) {
        lastPoint = {
          x: lastPoint.x - 1,
          y: lastPoint.y
        };
      }
      if (i === len - 2) {
        nextPoint = {
          x: nextPoint.x + 1,
          y: nextPoint.y
        };
      }
      var inDirection = toDirection(lastPoint, point);
      var outDirection = toDirection(point, nextPoint);

      // what spot does the snake enter this junction square?
      var inPoint = {
        x: x,
        y: y
      };
      switch (inDirection) {
        case 'R':
          inPoint = translate(inPoint, TO_WEST);
          break;
        case 'D':
          inPoint = translate(inPoint, TO_NORTH);
          break;
        case 'L':
          inPoint = translate(inPoint, TO_EAST);
          break;
        case 'U':
          inPoint = translate(inPoint, TO_SOUTH);
          break;
      }

      // what spot does the snake exit this junction square?
      var outPoint = {
        x: x,
        y: y
      };
      switch (outDirection) {
        case 'R':
          outPoint = translate(outPoint, TO_EAST);
          break;
        case 'D':
          outPoint = translate(outPoint, TO_SOUTH);
          break;
        case 'L':
          outPoint = translate(outPoint, TO_WEST);
          break;
        case 'U':
          outPoint = translate(outPoint, TO_NORTH);
          break;
      }
      ctx.lineTo(inPoint.x * WIXEL, inPoint.y * WIXEL);
      ctx.arcTo((x + 0.5) * WIXEL, (y + 0.5) * WIXEL, outPoint.x * WIXEL, outPoint.y * WIXEL, HW);
    });
  }
  function preloadImage(uri) {
    var prom = imagePromises[uri];
    if (!prom) {
      // eslint-disable-next-line promise/avoid-new
      prom = new Promise(function (resolve, reject) {
        var img = new Image();
        img.onload = function () {
          return resolve(img);
        };
        img.onerror = reject;
        img.onabort = reject;
        img.src = uri;
      });
      imagePromises[uri] = prom;
    }
    return prom;
  }
  function resizeCanvas(el, widthPx, heightPx) {
    el.width = widthPx;
    el.height = heightPx;
    el.style.width = "".concat(widthPx, "px");
    el.style.height = "".concat(heightPx, "px");
  }
  return CanvasRenderer;
});
