function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/*eslint-env browser */ /*jshint browser: true */

/**
 * API Status: **Private**
 * @module nmodule/wiresheet/rc/wb/controller/ops/ResizeSelectionOp
 */
define(['baja!', 'Promise', 'jquery', 'underscore', 'nmodule/webEditors/rc/wb/commands/SetCommand', 'nmodule/wiresheet/rc/wb/util/wsUtils'], function (baja, Promise, $, _, SetCommand, wsUtils) {
  'use strict';

  var RUBBER_BAND_PREFIX = 'rubberBand',
    entityToOrd = wsUtils.entityToOrd,
    range = _.range;

  /**
   * This op allows the user to select a set of entities (or just one entity)
   * and resize them on the wiresheet as a group.
   *
   * This op has a BajaScript dependency.
   *
   * @class
   * @alias module:nmodule/wiresheet/rc/wb/controller/ops/ResizeSelectionOp
   * @implements module:nmodule/wiresheet/rc/typedefs~DragOp
   * @param {Object} params
   * @param {number} params.x x coordinate of the start of the resize, in wixels
   * @param {number} params.y y coordinate of the start of the resize, in wixels
   * @param {string} params.entityId the entity we're starting the resize from
   * @param {string} params.direction the direction of the resize (ns or ew)
   * @param {module:nmodule/wiresheet/rc/wb/WbViewModel} params.viewModel
   * @param {module:nmodule/wiresheet/rc/wb/layout/Mask} params.mask
   * @param {module:nmodule/wiresheet/rc/core/controller/Selection} params.selection
   * @param {function} params.cancelToolTip a function to cancel the ToolTip if
   * it is currently displayed
   */
  var ResizeSelectionOp = function ResizeSelectionOp(_ref) {
    var origX = _ref.x,
      origY = _ref.y,
      entityId = _ref.entityId,
      direction = _ref.direction,
      viewModel = _ref.viewModel,
      mask = _ref.mask,
      selection = _ref.selection,
      cancelToolTip = _ref.cancelToolTip;
    var rubberBandCount = 0;

    /**
     * When the user drags around, move the rubber band appropriately.
     * @param {module:nmodule/wiresheet/rc/typedefs~DragOpState} dragOpState
     * @returns {Promise}
     */
    this.update = function (_ref2) {
      var x = _ref2.x,
        y = _ref2.y,
        setCursor = _ref2.setCursor;
      cancelToolTip();
      setCursor(direction + '-resize');
      var deltaX = Math.round(x - origX);
      var deltaY = Math.round(y - origY);
      return viewModel.get(entityId).then(function (entity) {
        if (entity && !selection.contains(entity)) {
          selection.setSelectedEntities([entity]);
        }
        var rubberBands = [];
        selection.getSelectedVertices().forEach(function (entity) {
          var layout = entity.layout;
          var originalX = layout.x,
            originalWidth = layout.width,
            originalY = layout.y,
            originalHeight = layout.height;
          var x = layout.x,
            y = layout.y,
            width = layout.width,
            height = layout.height;
          if (direction.includes("w")) {
            x = clamp(x + deltaX, 0, x + width - 2);
            width = clamp(width - deltaX, 2, originalWidth + originalX);
          }
          if (direction.includes("e")) {
            width = clamp(width + deltaX, 2, mask.getWidth() - originalX);
          }
          if (direction.includes("n")) {
            y = clamp(y + deltaY, 0, y + height - 2);
            height = clamp(height - deltaY, 2, originalHeight + originalY);
          }
          if (direction.includes("s")) {
            height = clamp(height + deltaY, 2, mask.getHeight() - originalY);
          }
          var rubberBand = {
            glyph: {
              type: 'RubberBandGlyph'
            },
            layout: {
              x: x,
              y: y,
              width: width,
              height: height
            }
          };
          rubberBands.push(rubberBand);
        });
        rubberBandCount = rubberBands.length;
        return putRubberBands(viewModel, rubberBands);
      });
    };

    /**
     * When the user commits the move, update the `wsAnnotation` slots of all
     * selected components so they move in concordance with the rubber band.
     * @returns {Promise}
     */
    this.commit = function () {
      var base = viewModel.getContainer();
      var entities = selection.getSelectedVertices();
      var componentEntities = entities.filter(function (e) {
        return viewModel.getId(e).match(/^component:/);
      });
      var ords = componentEntities.map(function (e) {
        return entityToOrd(e, viewModel);
      });
      return Promise.all([baja.BatchResolve.resolve({
        ords: ords,
        base: base
      }), resolveRubberBands(viewModel, rubberBandCount)]).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          br = _ref4[0],
          rubberBands = _ref4[1];
        var components = br.getTargetObjects();
        var subject = [];
        var annotations = [];
        selection.getSelectedVertices().forEach(function (entity, index) {
          var rubberBand = rubberBands[index];
          var deltaX = rubberBand.layout.x - entity.layout.x;
          var deltaWidth = rubberBand.layout.width - entity.layout.width;
          var deltaY = rubberBand.layout.y - entity.layout.y;
          var deltaHeight = rubberBand.layout.height - entity.layout.height;
          if (!deltaX && !deltaWidth && !deltaY && !deltaHeight) {
            return;
          }
          var layout = entity.layout;
          subject.push(components[index]);
          annotations.push(baja.$('baja:WsAnnotation', layout.x + deltaX, layout.y + deltaY, layout.width + deltaWidth, layout.height + deltaHeight));
        });
        if (subject.length) {
          return new SetCommand({
            subject: subject,
            slot: 'wsAnnotation'
          }).invoke(annotations);
        }
      });
    };

    /**
     * Delete any existing rubber bands from the view model.
     * @returns {Promise}
     */
    this.destroy = function () {
      return deleteRubberBands(viewModel, rubberBandCount);
    };
  };
  function resolveRubberBands(viewModel, count) {
    return Promise.all(range(0, count).map(function (i) {
      return viewModel.get(rubberBandId(i));
    }));
  }
  function putRubberBands(viewModel, rubberBands) {
    return Promise.all(rubberBands.map(function (band, i) {
      return viewModel.put(band, rubberBandId(i));
    }));
  }
  function deleteRubberBands(viewModel, count) {
    return Promise.all(range(0, count).map(function (i) {
      return viewModel.del(rubberBandId(i));
    }));
  }
  function rubberBandId(i) {
    return RUBBER_BAND_PREFIX + '_' + i;
  }
  function clamp(value, min, max) {
    return Math.min(Math.max(min, value), max);
  }
  return ResizeSelectionOp;
});
